#ifndef __util_h__
#define __util_h__


#include <stdbool.h>
#include <stdio.h>


extern const char* program;

void count_lines_columns( int* line, int* column, char c);
char unescape( char c);
void print_char( char c);
void print_escaped_char( char c, const char* escapes);
void print_string( const char* string);
void print_escaped_string( const char* string, const char* escapes);
char read_char( FILE* file);
char* read_string( FILE* file, const char* delimeters);
int within( int x, int low, int hi);
void print_error( const char* format, ...);
void die( const char* format, ...) __attribute__((noreturn));
void assume( bool assumption, const char* format, ...);
void assumex( bool assumption, const char* format, ...);
void assume_near( bool assumption, FILE* file, const char* format, ...);
FILE* open_file( const char* file_name);
void* allocate_memory( size_t size);
void* reallocate_memory( void* ptr, size_t size);


#endif
