/**
 * Compile regular expressions to NFA.
 * @author Shaun Jackman <sdj@sfu.ca>
 * @copyright Copyright 2004 Shaun Jackman
 */


#include <stdio.h>
#include "nfa.h"
#include "regex.h"


/** Maximum length of a token name. */
#define TOKEN_LENGTH 32


/** Name of this program. */
const char* program = "regexc";


/** Reads token definitions from the specified file. */
static void
read_definitions( FILE* file)
{
	int count = 0;
	char token[TOKEN_LENGTH];
	NFA nfa;
	clear_nfa( &nfa);
	while( fscanf( file, "%s ", token) == 1) {
		RegEx* regex = parse_regex( file);
		compile_regex( &nfa, regex, ++count);
		destroy_regex( regex);
		puts(token);
	}
	print_nfa( &nfa);
}


/** Compiles the regular expressions on stdin to NFA. */
int
main()
{
	read_definitions( stdin);
	return 0;
}
