#ifndef __grammar_h__
#define __grammar_h__


#include "dfa.h"


/** Maximum length of a token name. */
#define TOKEN_LENGTH 100

/** Maximum number of definitions. */
#define DEFINITIONS 100


/** Regular grammar definition. */
typedef struct {
	/** DFA */
	DFA dfa;

	/** Number of tokens. */
	int count;

	/** Tokens. */
	char tokens[TOKEN_LENGTH][DEFINITIONS];
} Grammar;


void print_grammar( Grammar* grammar);
void read_grammar( Grammar* grammar, FILE* file);


#endif
