<?php
	/*
	 * $Id: navbar.php,v 1.1.2.10 2003/12/12 04:57:55 mdean Exp $
	 *
	 * Double Choco Latte - Source Configuration Management System
	 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
	 *
	 * This program is free software; you can redistribute it and/or
	 * modify it under the terms of the GNU General Public License
	 * as published by the Free Software Foundation; either version 2
	 * of the License, or (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program; if not, write to the Free Software
	 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	 *
	 * Select License Info from the Help menu to view the terms and conditions of this license.
	 */

LoadStringResource('wo');
LoadStringResource('tck');
LoadStringResource('menu');
class DCLNavBar
{
	var $t;
	var $_class;
	var $_method;

	function DCLNavBar()
	{
		global $dcl_info;

		$this->t = CreateTemplate(array('hForm' => 'navbar.tpl'));
		$this->t->set_block('hForm', 'items', 'hItems');
		$this->t->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$this->t->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$this->t->set_var('DIR_IMAGES', 'templates/' . GetDefaultTemplateSet() . '/img');

		if (IsSet($GLOBALS['menuAction']) && $GLOBALS['menuAction'] != 'clearScreen')
			list($this->_class, $this->_method) = explode('.', $GLOBALS['menuAction']);
	}

	function createGlobal()
	{
		global $g_oSec, $dcl_info;
		$aItems = array();

		$this->t->set_var('hItems', '');

		if ($g_oSec->HasSecLvl($dcl_info['DCL_ADD_WO']))
		{
			$aItems[] = array(DCL_MENU_NEWWORKORDER, 'boWorkorders.newjcn', 'new-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
				$aItems[] = array(DCL_MENU_NEWPROJECT, 'boProjects.newproject', 'new-16.png');

			$aItems[] = array(DCL_MENU_NEWTICKET, 'boTickets.add', 'new-16.png');
		}

		if ($dcl_info['DCL_WIKI_ENABLED'] == 'Y' && $g_oSec->HasSecLvl($dcl_info['DCL_WIKI_VIEW']))
			$aItems[] = array(DCL_MENU_MAINWIKI, 'htmlWiki.show&type=0&name=FrontPage', 'book-16.png');
			
		$aItems[] = array(DCL_MENU_PRINTERFRIENDLY, 'javascript:printer_friendly();', 'print-16.png');

		$this->t->set_var('VAL_TITLE', STR_CMMN_OPTIONS);

		return $this->renderItems($aItems);
	}

	function createGroupContext()
	{
		global $g_oSec, $dcl_info;
		$aItems = array();

		$this->t->set_var('hItems', '');

		if ($this->_isWorkorderGroup())
		{
			if ($g_oSec->HasSecLvl($dcl_info['DCL_ADD_WO']))
			{
				$aItems[] = array(DCL_MENU_MYWOS, 'htmlWorkorders.show&filterReportto=' . $GLOBALS['DCLID'], 'home-16.png');
				$aItems[] = array(DCL_MENU_NEW, 'boWorkorders.newjcn', 'new-16.png');
				$aItems[] = array(DCL_MENU_IMPORT, 'boWorkorders.csvupload', 'import-16.png');
				$aItems[] = array(DCL_MENU_ACTIVITY, 'reportPersonnelActivity.getparameters', 'exec-16.png');
				$aItems[] = array(DCL_MENU_GRAPH, 'boWorkorders.graph', 'exec-16.png');
				$aItems[] = array(DCL_MENU_STATISTICS, 'htmlWOStatistics.ShowUserVsProductStatusForm', 'exec-16.png');
				$aItems[] = array(DCL_MENU_SCHEDULE, 'scheduleByPerson.SelectPersonToSchedule', 'exec-16.png');
				$aItems[] = array(DCL_MENU_SEARCH, 'htmlWOSearches.Show', 'exec-16.png');
				$aItems[] = array(DCL_MENU_BROWSE, 'htmlWorkorders.show', 'exec-16.png');
			}

			$this->t->set_var('VAL_TITLE', DCL_MENU_WORKORDERS);
		}
		else if ($this->_isTicketGroup())
		{
			if ($g_oSec->HasSecLvl($dcl_info['DCL_ADD_WO']))
			{
				$aItems[] = array(DCL_MENU_MYTICKETS, 'htmlTickets.show&filterReportto=' . $GLOBALS['DCLID'], 'home-16.png');
				$aItems[] = array(DCL_MENU_NEW, 'boTickets.add', 'new-16.png');
				$aItems[] = array(DCL_MENU_ACTIVITY, 'reportTicketActivity.getparameters', 'exec-16.png');
				$aItems[] = array(DCL_MENU_GRAPH, 'boTickets.graph', 'exec-16.png');
				$aItems[] = array(DCL_MENU_STATISTICS, 'htmlTicketStatistics.ShowUserVsProductStatusForm', 'exec-16.png');
				$aItems[] = array(DCL_MENU_SEARCH, 'htmlTicketSearches.Show', 'exec-16.png');
				$aItems[] = array(DCL_MENU_BROWSE, 'htmlTickets.show', 'exec-16.png');
			}

			$this->t->set_var('VAL_TITLE', DCL_MENU_TICKETS);
		}
		else if ($this->_isProjectGroup())
		{
			if ($g_oSec->HasSecLvl($dcl_info['DCL_ADD_WO']))
			{
				$aItems[] = array(DCL_MENU_MYPROJECTS, 'htmlProjects.show&filterReportto=' . $GLOBALS['DCLID'], 'home-16.png');

				if ($g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
					$aItems[] = array(DCL_MENU_NEW, 'boProjects.newproject', 'new-16.png');

				$aItems[] = array(DCL_MENU_BROWSE, 'htmlProjects.show', 'exec-16.png');
			}

			$this->t->set_var('VAL_TITLE', DCL_MENU_PROJECTS);
		}
		else
			return;

		return $this->renderItems($aItems);
	}

	function createItemContext()
	{
		global $g_oSec, $dcl_info, $menuAction, $jcn, $seq, $ticketid;
		$aItems = array();

		$this->t->set_var('hItems', '');

		if ($this->_isWorkorderItem())
		{
			$oDB = CreateObject('dcl.dbWorkorders');
			$oDB->Connect();
			if ($oDB->Load($jcn, $seq) == -1)
				return;

			if ($g_oSec->HasSecLvl($dcl_info['DCL_HAVE_WO']))
				$aItems[] = array(STR_WO_ADDTC, 'boTimecards.add&jcn=' . $jcn . '&seq=' . $seq, 'exec-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
				$aItems[] = array(STR_WO_ADDPRJ, 'boProjects.addtoproject&jcn=' . $jcn . '&seq=' . $seq, 'open-16.png');

			$aItems[] = array(STR_WO_WATCHES, 'boWatches.add&typeid=3&whatid1=' . $jcn . '&whatid2=' . $seq, 'search-16.png');

			if ($dcl_info['DCL_MAX_UPLOAD_FILE_SIZE'] > 0)
				$aItems[] = array(STR_WO_UPLOAD, 'boWorkorders.upload&jcn=' . $jcn . '&seq=' . $seq, 'attach-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
				$aItems[] = array(STR_WO_REASSIGN, 'boWorkorders.reassign&jcn=' . $jcn . '&seq=' . $seq, 'convert-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_ADD_WO']))
				$aItems[] = array(STR_WO_NEWSEQ, 'boWorkorders.newseq&jcn=' . $jcn . '&seq=' . $seq, 'redo-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_MOD_WO']))
				$aItems[] = array(STR_WO_MODIFY, 'boWorkorders.modifyjcn&jcn=' . $jcn . '&seq=' . $seq, 'edit-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_DEL_WO']))
				$aItems[] = array(STR_WO_DELETE, 'boWorkorders.delete&jcn=' . $jcn . '&seq=' . $seq, 'delete-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
				$aItems[] = array(STR_WO_UNMAP, 'boProjects.unmap&jcn=' . $jcn . '&seq=' . $seq, 'undelete-16.png');

			if ($dcl_info['DCL_WIKI_ENABLED'] == 'Y' && $g_oSec->HasSecLvl($dcl_info['DCL_WIKI_VIEW']))
				$aItems[] = array(STR_CMMN_WIKI, 'htmlWiki.show&name=FrontPage&type=2&id=' . $jcn . '&id2=' . $seq, 'book-16.png');

			$this->t->set_var('VAL_TITLE', DCL_MENU_WORKORDEROPTIONS);
		}
		else if ($this->_isTicketItem())
		{
			$oDB = CreateObject('dcl.dbTickets');
			$oDB->Connect();
			if ($oDB->Load($ticketid) == -1)
				return;

			if ($g_oSec->HasSecLvl($dcl_info['DCL_HAVE_WO']))
				$aItems[] = array(STR_TCK_OPTADDRESOLUTION, 'boTicketresolutions.add&ticketid=' . $ticketid, 'exec-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
				$aItems[] = array(STR_TCK_OPTREASSIGN, 'boTickets.reassign&ticketid=' . $ticketid, 'convert-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_MOD_WO']))
				$aItems[] = array(STR_TCK_OPTMODIFY, 'boTickets.modify&ticketid=' . $ticketid, 'edit-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_DEL_WO']))
				$aItems[] = array(STR_TCK_OPTDELETE, 'boTickets.delete&ticketid=' . $ticketid, 'delete-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_MOD_WO']))
				$aItems[] = array(STR_TCK_OPTCOPYTOWO, 'boTickets.copyToWO&ticketid=' . $ticketid, 'copy-16.png');

			if ($dcl_info['DCL_MAX_UPLOAD_FILE_SIZE'] > 0)
				$aItems[] = array(STR_TCK_OPTUPLOADFILE, 'boTickets.upload&ticketid=' . $ticketid, 'attach-16.png');

			$aItems[] = array(STR_TCK_OPTWATCH, 'boWatches.add&typeid=5&whatid1=' . $ticketid, 'search-16.png');
			if ($dcl_info['DCL_WIKI_ENABLED'] == 'Y' && $g_oSec->HasSecLvl($dcl_info['DCL_WIKI_VIEW']))
				$aItems[] = array(STR_CMMN_WIKI, 'htmlWiki.show&name=FrontPage&type=3&id=' . $ticketid, 'book-16.png');

			$this->t->set_var('VAL_TITLE', DCL_MENU_TICKETOPTIONS);
		}
		else if ($this->_isProjectItem())
		{
			$projectid = isset($GLOBALS[GetSourceArray()]['project']) ? $GLOBALS[GetSourceArray()]['project'] : $GLOBALS[GetSourceArray()]['projectid'];

			$oDB = CreateObject('dcl.dbProjects');
			$oDB->Connect();
			if ($oDB->Load($projectid) == -1)
				return;

			if ($g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
				$aItems[] = array(STR_PRJ_ADDWOTOTHISPROJECT, 'boWorkorders.newjcn&projectid=' . $projectid, 'new-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_MOD_WO']))
				$aItems[] = array(STR_PRJ_MODIFY, 'boProjects.modify&projectid=' . $projectid, 'edit-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_DEL_WO']))
				$aItems[] = array(STR_PRJ_DELETE, 'boProjects.delete&projectid=' . $projectid, 'delete-16.png');

			if ($dcl_info['DCL_MAX_UPLOAD_FILE_SIZE'] > 0)
				$aItems[] = array(STR_PRJ_FILEUPLOAD, 'boProjects.upload&projectid=' . $projectid, 'attach-16.png');

			if ($g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
			{
				$aItems[] = array(STR_PRJ_BATCHDETAIL, "javascript:forceSubmit('boWorkorders.batchdetail');", 'exec-16.png');
				$aItems[] = array(STR_PRJ_BATCHTIMECARD, "javascript:forceSubmit('boTimecards.batchadd');", 'exec-16.png');
				$aItems[] = array(STR_PRJ_BATCHASSIGN, "javascript:forceSubmit('boWorkorders.batchassign');", 'exec-16.png');
				$aItems[] = array(STR_PRJ_BATCHMOVE, "javascript:forceSubmit('htmlProjectmap.batchMove');", 'exec-16.png');
			}

			$aItems[] = array(STR_PRJ_ADDWATCH, 'boWatches.add&typeid=2&whatid1=' . $projectid, 'search-16.png');
			if ($dcl_info['DCL_WIKI_ENABLED'] == 'Y' && $g_oSec->HasSecLvl($dcl_info['DCL_WIKI_VIEW']))
				$aItems[] = array(STR_CMMN_WIKI, 'htmlWiki.show&name=FrontPage&type=1&id=' . $projectid, 'book-16.png');

			$this->t->set_var('VAL_TITLE', DCL_MENU_PROJECTOPTIONS);
		}
		else
			return;

		return $this->renderItems($aItems);
	}

	function renderItems(&$aItems)
	{
		reset($aItems);
		while (list($idx, $aItem) = each($aItems))
		{
			if (substr($aItem[1], 0, 11) == 'javascript:')
			{
				$this->t->set_var('VAL_ONCLICK', $aItem[1]);
				$this->t->set_var('VAL_LINK', '#');
				$this->t->set_var('VAL_JSLINK', $aItem[1]);
			}
			else
			{
				$this->t->set_var('VAL_ONCLICK', '');
				$this->t->set_var('VAL_LINK', menuLink('', 'menuAction=' . $aItem[1]));
				$this->t->set_var('VAL_JSLINK', "location.href='" . menuLink('', 'menuAction=' . $aItem[1]) . "';");
			}

			$this->t->set_var('VAL_TEXT', $aItem[0]);
			$this->t->set_var('VAL_IMAGE', $aItem[2]);

			$this->t->parse('hItems', 'items', true);
		}

		return $this->t->parse('out', 'hForm');
	}

	function getHtml()
	{
		$retVal = $this->createItemContext();
		$retVal .= $this->createGroupContext();
		$retVal .= $this->createGlobal();

		return $retVal;
	}

	function _isWorkorderGroup()
	{
		return ($this->_class == 'htmlWorkorders' ||
				$this->_class == 'boWorkorders' ||
				$this->_class == 'reportPersonnelActivity' ||
				$this->_class == 'htmlWOSearches' ||
				$this->_class == 'htmlWOStatistics' ||
				$this->_class == 'scheduleByPerson' ||
				$this->_class == 'boTimecards' ||
				($this->_class == 'htmlSearchBox' && $GLOBALS[GetSourceArray()]['which'] == 'workorders')
			);
	}

	function _isWorkorderItem()
	{
		global $menuAction;
		
		if (!IsSet($GLOBALS['jcn']) || $GLOBALS['jcn'] == '' || !IsSet($GLOBALS['seq']) || $GLOBALS['seq'] == '')
			return false;

		$bSearchBox = ($this->_class == 'htmlSearchBox' &&
				$GLOBALS[GetSourceArray()]['which'] == 'workorders' &&
				ereg('^([0-9]+)[-]([0-9]*)$', $GLOBALS['HTTP_POST_VARS']['search_text'], $reg)
			);

		if ($bSearchBox)
		{
			$GLOBALS['jcn'] = $reg[1];
			$GLOBALS['seq'] = $reg[2];
		}

		return ($bSearchBox ||
				$menuAction == 'boWorkorders.viewjcn' ||
				$menuAction == 'boTimecards.add' ||
				$menuAction == 'boWorkorders.upload' ||
				$menuAction == 'boWorkorders.reassign' ||
				$menuAction == 'boWorkorders.modifyjcn'
			);
	}

	function _isAdminGroup()
	{
	}

	function _isTicketGroup()
	{
		return ($this->_class == 'htmlTickets' ||
				$this->_class == 'boTickets' ||
				$this->_class == 'boTicketresolutions' ||
				$this->_class == 'reportTicketActivity' ||
				$this->_class == 'htmlTicketStatistics' ||
				($this->_class == 'htmlSearchBox' && $GLOBALS[GetSourceArray()]['which'] == 'tickets')
			);
	}

	function _isTicketItem()
	{
		global $menuAction;

		$bSearchBox = ($this->_class == 'htmlSearchBox' &&
				$GLOBALS[GetSourceArray()]['which'] == 'tickets' &&
				ereg('^([0-9]+)$', $GLOBALS['HTTP_POST_VARS']['search_text'], $reg)
			);

		if ($bSearchBox)
			$GLOBALS['ticketid'] = $reg[1];

		return ($bSearchBox ||
				$menuAction == 'boTicketresolutions.add' ||
				$menuAction == 'boTickets.reassign' ||
				$menuAction == 'boTickets.modify' ||
				$menuAction == 'boTickets.delete' ||
				$menuAction == 'boTickets.copyToWO' ||
				$menuAction == 'boTickets.upload' ||
				$menuAction == 'boTickets.view'
			);
	}

	function _isProjectGroup()
	{
		return ($this->_class == 'htmlProjects' ||
				$this->_class == 'htmlProjectsform' ||
				$this->_class == 'htmlProjectsdetail' ||
				$this->_class == 'htmlProjectmap' ||
				$this->_class == 'boProjects' ||
				($this->_class == 'htmlSearchBox' && $GLOBALS[GetSourceArray()]['which'] == 'dcl_projects')
			);
	}

	function _isProjectItem()
	{
		global $menuAction;

		return ($menuAction == 'boProjects.viewproject');
	}
}
?>
