<?php
/*
 * $Id: class.htmlFaqtopics.inc.php,v 1.3.2.1.2.1 2002/07/03 18:35:04 dneighbors Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('faq');

class htmlFaqtopics
{
	function DisplayForm($obj = '')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$isEdit = is_object($obj);
		$Template = CreateTemplate(array('hForm' => 'htmlFaqtopicsForm.tpl'));

		if ($isEdit)
		{
			$Template->set_var('TXT_TITLE', STR_FAQ_EDITFAQTOPIC);
			$Template->set_var('VAL_SEQ', $obj->seq);
			$Template->set_var('VAL_NAME', htmlspecialchars($obj->name));
			$Template->set_var('VAL_DESCRIPTION', htmlspecialchars($obj->description));
			$hiddenvars = '<input type="hidden" name="menuAction" value="boFaqtopics.dbmodify">' .
				'<input type="hidden" name="topicid" value="' . $obj->topicid . '">';
		}
		else
		{
			$Template->set_var('TXT_TITLE', STR_FAQ_ADDFAQTOPIC);
			$Template->set_var('VAL_SEQ', '');
			$Template->set_var('VAL_NAME', '');
			$Template->set_var('VAL_DESCRIPTION', '');
			$hiddenvars = '<input type="hidden" name="menuAction" value="boFaqtopics.dbadd">' .
				'<input type="hidden" name="faqid" value="' . $GLOBALS['faqid'] . '">';
		}

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('HIDDEN_VARS', $hiddenvars);
		$Template->set_var('TXT_DISPLAYSEQ', STR_FAQ_DISPLAYSEQ);
		$Template->set_var('TXT_NAME', STR_FAQ_NAME);
		$Template->set_var('TXT_DESCRIPTION', STR_FAQ_DESCRIPTION);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_FAQ_HIGHLIGHTEDNOTE);

		$Template->pparse('out', 'hForm');
	}

	function ShowTopic($obj)
	{
		global $dcl_info;

		if (!is_object($obj))
		{
			print('<p><center>');
			PrintWithChocoFont('[htmlFaqtopics::ShowTopic] ' . STR_FAQ_TOPICOBJECTNOTPASSED);
			print('</center>');
			return;
		}

		$objFaq = CreateObject('dcl.dbFaq');
		$objFaq->Connect($obj->conn);
		$objFaq->Load($obj->faqid);

		$Template = CreateTemplate(array('hForm' => 'htmlFaqtopicsDetail.tpl'));
		$Template->set_block('hForm', 'questions', 'hQuestions');
		$Template->set_block('hForm', 'noquestions', 'hNoQuestions');
		$Template->set_var('hQuestions', '');
		$Template->set_var('hNoQuestions', '');

		$Template->set_var('VAL_FAQID', $objFaq->faqid);
		$Template->set_var('VAL_FAQNAME', htmlspecialchars($objFaq->name));
		$Template->set_var('VAL_DESCRIPTION', htmlspecialchars($obj->description));
		$Template->set_var('VAL_TOPICID', $obj->f('topicid'));
		$Template->set_var('VAL_NAME', htmlspecialchars($obj->name));
		$Template->set_var('VAL_VIEWFAQLINK', menuLink('', 'menuAction=boFaq.view&faqid=' . $objFaq->faqid));
		$Template->set_var('VAL_ADDQUESTIONLINK', menuLink('', 'menuAction=boFaqquestions.add&topicid=' . $obj->f('topicid')));

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_QUESTIONSFOR', STR_FAQ_QUESTIONSFOR);
		$Template->set_var('TXT_FAQ', STR_FAQ_FAQ);
		$Template->set_var('TXT_TOPIC', STR_FAQ_TOPIC);
		$Template->set_var('TXT_QUESTIONS', STR_FAQ_QUESTIONS);
		$Template->set_var('TXT_NEW', STR_FAQ_NEW);

		$objF = CreateObject('dcl.dbFaqquestions');
		$objF->Connect($obj->conn);
		$objF->LoadByFaqTopicID($obj->topicid);
		if ($objF->next_record())
		{
			$i = 0;
			do
			{
				if ($i++ % 2 == 0)
					$Template->set_var('ROW_COLOR', '#ffffff');
				else
					$Template->set_var('ROW_COLOR', $dcl_info['DCL_COLOR_LIGHT']);

				$Template->set_var('VAL_NUM', $i);
				$Template->set_var('VAL_QUESTIONID', $objF->f('questionid'));
				$Template->set_var('VAL_QUESTIONTEXT', htmlspecialchars($objF->f('questiontext')));
				$Template->set_var('VAL_VIEWQUESTIONLINK', menuLink('', 'menuAction=boFaqquestions.view&questionid=' . $objF->f('questionid')));
				$Template->parse('hQuestions', 'questions', true);
			}
			while ($objF->next_record());
		}
		else
		{
			$Template->set_var('TXT_NOQUESTIONS', STR_FAQ_NOQUESTIONS);
			$Template->parse('hNoQuestions', 'noquestions');
		}

		$Template->pparse('out', 'hForm');
	}
}
?>
