/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.lang.reflect.Method;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.ExtensionsTable;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.IntStack;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.SourceTreeManager;
import org.apache.xpath.VariableStack;
import org.apache.xpath.axes.OneStepIteratorForward;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.XMLReader;

public class XPathContext
extends DTMManager {
    private DTMManager m_dtmManager = DTMManager.newInstance(XMLStringFactoryImpl.getFactory());
    SourceLocator[] m_saxLocations = new SourceLocator[4096];
    int m_saxLocationsTop = 0;
    private Object m_owner;
    private Method m_ownerGetErrorListener;
    private ExtensionsTable m_extensionsTable = new ExtensionsTable();
    private VariableStack m_variableStacks = new VariableStack();
    private SourceTreeManager m_sourceTreeManager = new SourceTreeManager();
    private ErrorListener m_errorListener;
    private ErrorListener m_defaultErrorListener;
    private URIResolver m_uriResolver;
    public XMLReader m_primaryReader;
    private static XSLMessages m_XSLMessages = new XSLMessages();
    private Stack m_contextNodeLists = new Stack();
    public static final int RECURSIONLIMIT = 4096;
    private int[] m_currentNodes = new int[4096];
    protected int m_currentNodesFirstFree = 0;
    private NodeVector m_iteratorRoots = new NodeVector();
    private NodeVector m_predicateRoots = new NodeVector();
    private int[] m_currentExpressionNodes = new int[4096];
    protected int m_currentExpressionNodesFirstFree = 0;
    private IntStack m_predicatePos = new IntStack();
    private PrefixResolver[] m_prefixResolvers = new PrefixResolver[4096];
    private int m_prefixResolversTop = 0;
    private Stack m_axesIteratorStack = new Stack();
    XPathExpressionContext expressionContext = new XPathExpressionContext();

    public XPathContext() {
        this.m_prefixResolvers[this.m_prefixResolversTop++] = null;
        this.m_currentNodes[this.m_currentNodesFirstFree++] = -1;
        this.m_currentNodes[this.m_currentExpressionNodesFirstFree++] = -1;
        this.m_saxLocations[this.m_saxLocationsTop++] = null;
    }

    public XPathContext(Object object) {
        this.m_owner = object;
        try {
            this.m_ownerGetErrorListener = this.m_owner.getClass().getMethod("getErrorListener", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        this.m_prefixResolvers[this.m_prefixResolversTop++] = null;
        this.m_currentNodes[this.m_currentNodesFirstFree++] = -1;
        this.m_currentNodes[this.m_currentExpressionNodesFirstFree++] = -1;
        this.m_saxLocations[this.m_saxLocationsTop++] = null;
    }

    private void assertion(boolean bl, String string) throws TransformerException {
        ErrorListener errorListener = this.getErrorListener();
        if (errorListener != null) {
            errorListener.fatalError(new TransformerException(XSLMessages.createMessage(30, new Object[]{string}), (SAXSourceLocator)this.getSAXLocator()));
        }
    }

    public DTMIterator createDTMIterator(int n) {
        OneStepIteratorForward oneStepIteratorForward = new OneStepIteratorForward(13);
        oneStepIteratorForward.setRoot(n, this);
        return oneStepIteratorForward;
    }

    public DTMIterator createDTMIterator(int n, DTMFilter dTMFilter, boolean bl) {
        return this.m_dtmManager.createDTMIterator(n, dTMFilter, bl);
    }

    public DTMIterator createDTMIterator(Object object, int n) {
        return this.m_dtmManager.createDTMIterator(object, n);
    }

    public DTMIterator createDTMIterator(String string, PrefixResolver prefixResolver) {
        return this.m_dtmManager.createDTMIterator(string, prefixResolver);
    }

    public DTM createDocumentFragment() {
        return this.m_dtmManager.createDocumentFragment();
    }

    public Stack getAxesIteratorStackStacks() {
        return this.m_axesIteratorStack;
    }

    public final int getContextNode() {
        return this.getCurrentNode();
    }

    public final DTMIterator getContextNodeList() {
        if (this.m_contextNodeLists.size() > 0) {
            return (DTMIterator)this.m_contextNodeLists.peek();
        }
        return null;
    }

    public Stack getContextNodeListsStack() {
        return this.m_contextNodeLists;
    }

    public final DTMIterator getContextNodes() {
        try {
            DTMIterator dTMIterator = this.getContextNodeList();
            if (dTMIterator != null) {
                return dTMIterator.cloneWithReset();
            }
            return null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final int getCurrentExpressionNode() {
        return this.m_currentExpressionNodes[this.m_currentExpressionNodesFirstFree - 1];
    }

    public int[] getCurrentExpressionNodeStack() {
        return this.m_currentExpressionNodes;
    }

    public int getCurrentExpressionNodesFirstFree() {
        return this.m_currentExpressionNodesFirstFree;
    }

    public final int getCurrentNode() {
        return this.m_currentNodes[this.m_currentNodesFirstFree - 1];
    }

    public int getCurrentNodeFirstFree() {
        return this.m_currentNodesFirstFree;
    }

    public int[] getCurrentNodeStack() {
        return this.m_currentNodes;
    }

    public DTM getDTM(int n) {
        return this.m_dtmManager.getDTM(n);
    }

    public DTM getDTM(Source source, boolean bl, DTMWSFilter dTMWSFilter, boolean bl2, boolean bl3) {
        return this.m_dtmManager.getDTM(source, bl, dTMWSFilter, bl2, bl3);
    }

    public int getDTMHandleFromNode(Node node) {
        return this.m_dtmManager.getDTMHandleFromNode(node);
    }

    public int getDTMIdentity(DTM dTM) {
        return this.m_dtmManager.getDTMIdentity(dTM);
    }

    public DTMManager getDTMManager() {
        return this.m_dtmManager;
    }

    public final ErrorListener getErrorListener() {
        if (this.m_errorListener != null) {
            return this.m_errorListener;
        }
        ErrorListener errorListener = null;
        try {
            if (this.m_ownerGetErrorListener != null) {
                errorListener = (ErrorListener)this.m_ownerGetErrorListener.invoke(this.m_owner, new Object[0]);
            }
        }
        catch (Exception exception) {}
        if (errorListener == null) {
            if (this.m_defaultErrorListener == null) {
                this.m_defaultErrorListener = new DefaultErrorHandler();
            }
            errorListener = this.m_defaultErrorListener;
        }
        return errorListener;
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public ExtensionsTable getExtensionsTable() {
        return this.m_extensionsTable;
    }

    public final int getIteratorRoot() {
        return this.m_iteratorRoots.peepOrNull();
    }

    public final PrefixResolver getNamespaceContext() {
        return this.m_prefixResolvers[this.m_prefixResolversTop - 1];
    }

    public Object getOwnerObject() {
        return this.m_owner;
    }

    public final int getPredicatePos() {
        return this.m_predicatePos.peek();
    }

    public final int getPredicateRoot() {
        return this.m_predicateRoots.peepOrNull();
    }

    public final XMLReader getPrimaryReader() {
        return this.m_primaryReader;
    }

    public SourceLocator getSAXLocator() {
        return this.m_saxLocations[this.m_saxLocationsTop - 1];
    }

    public final SourceTreeManager getSourceTreeManager() {
        return this.m_sourceTreeManager;
    }

    public SubContextList getSubContextList() {
        return this.m_axesIteratorStack.isEmpty() ? null : (SubContextList)this.m_axesIteratorStack.peek();
    }

    public final URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public final VariableStack getVarStack() {
        return this.m_variableStacks;
    }

    public final void popContextNodeList() {
        this.m_contextNodeLists.pop();
    }

    public final void popCurrentExpressionNode() {
        --this.m_currentExpressionNodesFirstFree;
    }

    public final void popCurrentNode() {
        --this.m_currentNodesFirstFree;
    }

    public final void popCurrentNodeAndExpression() {
        --this.m_currentNodesFirstFree;
        --this.m_currentExpressionNodesFirstFree;
    }

    public final void popExpressionState() {
        --this.m_currentNodesFirstFree;
        --this.m_currentExpressionNodesFirstFree;
        --this.m_prefixResolversTop;
    }

    public final void popIteratorRoot() {
        this.m_iteratorRoots.popQuick();
    }

    public final void popNamespaceContext() {
        --this.m_prefixResolversTop;
    }

    public final void popPredicatePos() {
        this.m_predicatePos.pop();
    }

    public final void popPredicateRoot() {
        this.m_predicateRoots.popQuick();
    }

    public void popSAXLocator() {
        --this.m_saxLocationsTop;
    }

    public final void popSubContextList() {
        this.m_axesIteratorStack.pop();
    }

    public final void pushContextNodeList(DTMIterator dTMIterator) {
        this.m_contextNodeLists.push(dTMIterator);
    }

    public final void pushCurrentExpressionNode(int n) {
        this.m_currentExpressionNodes[this.m_currentExpressionNodesFirstFree++] = n;
    }

    public final void pushCurrentNode(int n) {
        this.m_currentNodes[this.m_currentNodesFirstFree++] = n;
    }

    public final void pushCurrentNodeAndExpression(int n, int n2) {
        this.m_currentNodes[this.m_currentNodesFirstFree++] = n;
        this.m_currentExpressionNodes[this.m_currentExpressionNodesFirstFree++] = n;
    }

    public final void pushExpressionState(int n, int n2, PrefixResolver prefixResolver) {
        this.m_currentNodes[this.m_currentNodesFirstFree++] = n;
        this.m_currentExpressionNodes[this.m_currentExpressionNodesFirstFree++] = n;
        this.m_prefixResolvers[this.m_prefixResolversTop++] = prefixResolver;
    }

    public final void pushIteratorRoot(int n) {
        this.m_iteratorRoots.push(n);
    }

    public final void pushNamespaceContext(PrefixResolver prefixResolver) {
        this.m_prefixResolvers[this.m_prefixResolversTop++] = prefixResolver;
    }

    public final void pushNamespaceContextNull() {
        ++this.m_prefixResolversTop;
    }

    public final void pushPredicatePos(int n) {
        this.m_predicatePos.push(n);
    }

    public final void pushPredicateRoot(int n) {
        this.m_predicateRoots.push(n);
    }

    public void pushSAXLocator(SourceLocator sourceLocator) {
        this.m_saxLocations[this.m_saxLocationsTop++] = sourceLocator;
    }

    public void pushSAXLocatorNull() {
        ++this.m_saxLocationsTop;
    }

    public final void pushSubContextList(SubContextList subContextList) {
        this.m_axesIteratorStack.push(subContextList);
    }

    public boolean release(DTM dTM, boolean bl) {
        return this.m_dtmManager.release(dTM, bl);
    }

    public void reset() {
        this.m_dtmManager = DTMManager.newInstance(XMLStringFactoryImpl.getFactory());
    }

    public void setAxesIteratorStackStacks(Stack stack) {
        this.m_axesIteratorStack = stack;
    }

    public void setContextNodeListsStack(Stack stack) {
        this.m_contextNodeLists = stack;
    }

    public void setCurrentExpressionNodeStack(int[] nArray) {
        this.m_currentExpressionNodes = nArray;
    }

    public void setCurrentNodeStack(int[] nArray) {
        this.m_currentNodes = nArray;
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (errorListener == null) {
            throw new IllegalArgumentException(XSLMessages.createXPATHMessage(75, null));
        }
        this.m_errorListener = errorListener;
    }

    void setExtensionsTable(ExtensionsTable extensionsTable) {
        this.m_extensionsTable = extensionsTable;
    }

    public final void setNamespaceContext(PrefixResolver prefixResolver) {
        this.m_prefixResolvers[this.m_prefixResolversTop - 1] = prefixResolver;
    }

    public void setPrimaryReader(XMLReader xMLReader) {
        this.m_primaryReader = xMLReader;
    }

    public void setSAXLocator(SourceLocator sourceLocator) {
        this.m_saxLocations[this.m_saxLocationsTop - 1] = sourceLocator;
    }

    public void setSourceTreeManager(SourceTreeManager sourceTreeManager) {
        this.m_sourceTreeManager = sourceTreeManager;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    public final void setVarStack(VariableStack variableStack) {
        this.m_variableStacks = variableStack;
    }

    public class XPathExpressionContext
    implements ExpressionContext {
        public Node getContextNode() {
            int n = XPathContext.this.getCurrentNode();
            return XPathContext.this.getDTM(n).getNode(n);
        }

        public NodeIterator getContextNodes() {
            return new DTMNodeIterator(XPathContext.this.getContextNodeList());
        }

        public DTMManager getDTMManager() {
            return XPathContext.this.m_dtmManager;
        }

        public final XObject getVariableOrParam(QName qName) throws TransformerException {
            return XPathContext.this.m_variableStacks.getVariableOrParam(XPathContext.this, qName);
        }

        public XPathContext getXPathContext() {
            return XPathContext.this;
        }

        public double toNumber(Node node) {
            int n = XPathContext.this.getDTMHandleFromNode(node);
            DTM dTM = XPathContext.this.getDTM(n);
            XString xString = (XString)dTM.getStringValue(n);
            return xString.num();
        }

        public String toString(Node node) {
            int n = XPathContext.this.getDTMHandleFromNode(node);
            DTM dTM = XPathContext.this.getDTM(n);
            XMLString xMLString = dTM.getStringValue(n);
            return xMLString.toString();
        }
    }
}

