/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.transform.Source;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMAxisIteratorBase;
import org.apache.xml.dtm.ref.DTMDefaultBaseTraversers;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.XMLStringFactory;

public abstract class DTMDefaultBaseIterators
extends DTMDefaultBaseTraversers {
    public DTMDefaultBaseIterators(DTMManager dTMManager, Source source, int n, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl) {
        super(dTMManager, source, n, dTMWSFilter, xMLStringFactory, bl);
    }

    public DTMAxisIterator getAxisIterator(int n) {
        DTMAxisIterator dTMAxisIterator = null;
        switch (n) {
            case 13: {
                dTMAxisIterator = new SingletonIterator();
                break;
            }
            case 3: {
                dTMAxisIterator = new ChildrenIterator();
                break;
            }
            case 10: {
                return new ParentIterator();
            }
            case 0: {
                return new AncestorIterator();
            }
            case 1: {
                return new AncestorIterator().includeSelf();
            }
            case 2: {
                return new AttributeIterator();
            }
            case 4: {
                dTMAxisIterator = new DescendantIterator();
                break;
            }
            case 5: {
                dTMAxisIterator = new DescendantIterator().includeSelf();
                break;
            }
            case 6: {
                dTMAxisIterator = new FollowingIterator();
                break;
            }
            case 11: {
                dTMAxisIterator = new PrecedingIterator();
                break;
            }
            case 7: {
                dTMAxisIterator = new FollowingSiblingIterator();
                break;
            }
            case 12: {
                dTMAxisIterator = new PrecedingSiblingIterator();
                break;
            }
            case 9: {
                dTMAxisIterator = new NamespaceIterator();
                break;
            }
            case 19: {
                dTMAxisIterator = new RootIterator();
                break;
            }
            default: {
                throw new DTMException(XSLMessages.createMessage(166, new Object[]{Axis.names[n]}));
            }
        }
        return dTMAxisIterator;
    }

    public DTMAxisIterator getTypedAxisIterator(int n, int n2) {
        DTMAxisIterator dTMAxisIterator = null;
        switch (n) {
            case 13: {
                dTMAxisIterator = new TypedSingletonIterator(n2);
                break;
            }
            case 3: {
                dTMAxisIterator = new TypedChildrenIterator(n2);
                break;
            }
            case 10: {
                return new ParentIterator().setNodeType(n2);
            }
            case 0: {
                return new TypedAncestorIterator(n2);
            }
            case 1: {
                return new TypedAncestorIterator(n2).includeSelf();
            }
            case 2: {
                return new TypedAttributeIterator(n2);
            }
            case 4: {
                dTMAxisIterator = new TypedDescendantIterator(n2);
                break;
            }
            case 5: {
                dTMAxisIterator = new TypedDescendantIterator(n2).includeSelf();
                break;
            }
            case 6: {
                dTMAxisIterator = new TypedFollowingIterator(n2);
                break;
            }
            case 11: {
                dTMAxisIterator = new TypedPrecedingIterator(n2);
                break;
            }
            case 7: {
                dTMAxisIterator = new TypedFollowingSiblingIterator(n2);
                break;
            }
            case 12: {
                dTMAxisIterator = new TypedPrecedingSiblingIterator(n2);
                break;
            }
            case 9: {
                dTMAxisIterator = new TypedNamespaceIterator(n2);
                break;
            }
            case 19: {
                dTMAxisIterator = new TypedRootIterator(n2);
                break;
            }
            default: {
                throw new DTMException(XSLMessages.createMessage(165, new Object[]{Axis.names[n]}));
            }
        }
        return dTMAxisIterator;
    }

    private abstract class InternalAxisIteratorBase
    extends DTMAxisIteratorBase {
        protected int _currentNode;

        InternalAxisIteratorBase() {
        }

        public void gotoMark() {
            this._currentNode = this._markedNode;
        }

        public void setMark() {
            this._markedNode = this._currentNode;
        }
    }

    private final class ChildrenIterator
    extends InternalAxisIteratorBase {
        ChildrenIterator() {
        }

        public int next() {
            this._currentNode = this._currentNode == -2 ? DTMDefaultBaseIterators.this.getFirstChild(this._startNode) : DTMDefaultBaseIterators.this.getNextSibling(this._currentNode);
            return this.returnNode(this._currentNode);
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = -2;
                return this.resetPosition();
            }
            return this;
        }
    }

    private final class ParentIterator
    extends InternalAxisIteratorBase {
        private int _nodeType = -1;

        ParentIterator() {
        }

        public int next() {
            int n = this._currentNode;
            n = this._nodeType != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(this._currentNode) != this._nodeType ? -1 : this._currentNode;
            this._currentNode = -1;
            return this.returnNode(n);
        }

        public DTMAxisIterator setNodeType(int n) {
            this._nodeType = n;
            return this;
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = DTMDefaultBaseIterators.this.getParent(n);
                return this.resetPosition();
            }
            return this;
        }
    }

    private final class TypedChildrenIterator
    extends InternalAxisIteratorBase {
        private final int _nodeType;

        public TypedChildrenIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n = this._currentNode == -2 ? DTMDefaultBaseIterators.this.getFirstChild(this._startNode) : DTMDefaultBaseIterators.this.getNextSibling(this._currentNode);
            while (n != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(n) == this._nodeType) {
                    this._currentNode = n;
                    return this.returnNode(n);
                }
                n = DTMDefaultBaseIterators.this.getNextSibling(n);
            }
            return -1;
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = -2;
                return this.resetPosition();
            }
            return this;
        }
    }

    private final class NamespaceChildrenIterator
    extends InternalAxisIteratorBase {
        private final int _nsType;

        public NamespaceChildrenIterator(int n) {
            this._nsType = n;
        }

        public int next() {
            int n = this._currentNode == -2 ? DTMDefaultBaseIterators.this.getFirstChild(this._startNode) : DTMDefaultBaseIterators.this.getNextSibling(this._currentNode);
            while (n != -1) {
                if (DTMDefaultBaseIterators.this.getNamespaceType(n) == this._nsType) {
                    this._currentNode = n;
                    return this.returnNode(n);
                }
                n = DTMDefaultBaseIterators.this.getNextSibling(n);
            }
            return -1;
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = -2;
                return this.resetPosition();
            }
            return this;
        }
    }

    private class NamespaceIterator
    extends InternalAxisIteratorBase {
        public int next() {
            int n = this._currentNode;
            if (n != -1) {
                this._currentNode = DTMDefaultBaseIterators.this.getNextNamespaceNode(this._startNode, n, true);
            }
            return this.returnNode(n);
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstNamespaceNode(n, true);
                return this.resetPosition();
            }
            return this;
        }
    }

    private class TypedNamespaceIterator
    extends NamespaceIterator {
        private final int _nodeType;

        public TypedNamespaceIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n = super.next();
            while (n != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(n) == this._nodeType) {
                    this._currentNode = n;
                    return this.returnNode(n);
                }
                n = super.next();
            }
            return -1;
        }
    }

    private class RootIterator
    extends InternalAxisIteratorBase {
        public int next() {
            if (this._startNode == this._currentNode) {
                return -1;
            }
            this._currentNode = this._startNode;
            return this.returnNode(this._startNode);
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = DTMDefaultBaseIterators.this.getDocument();
                this._currentNode = -1;
                return this.resetPosition();
            }
            return this;
        }
    }

    private class TypedRootIterator
    extends RootIterator {
        private final int _nodeType;

        public TypedRootIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n = super.next();
            while (n != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(n) == this._nodeType) {
                    this._currentNode = n;
                    return this.returnNode(n);
                }
                n = super.next();
            }
            return -1;
        }
    }

    private final class NamespaceAttributeIterator
    extends InternalAxisIteratorBase {
        private final int _nsType;

        public NamespaceAttributeIterator(int n) {
            this._nsType = n;
        }

        public int next() {
            int n = this._currentNode;
            if (n != -1) {
                this._currentNode = DTMDefaultBaseIterators.this.getNextNamespaceNode(this._startNode, n, false);
            }
            return this.returnNode(n);
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstNamespaceNode(n, false);
                return this.resetPosition();
            }
            return this;
        }
    }

    private class FollowingSiblingIterator
    extends InternalAxisIteratorBase {
        FollowingSiblingIterator() {
        }

        public int next() {
            this._currentNode = DTMDefaultBaseIterators.this.getNextSibling(this._currentNode);
            return this.returnNode(this._currentNode);
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._currentNode = this._startNode = n;
                return this.resetPosition();
            }
            return this;
        }
    }

    private final class TypedFollowingSiblingIterator
    extends FollowingSiblingIterator {
        private final int _nodeType;

        public TypedFollowingSiblingIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n;
            while ((n = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(n) != this._nodeType) {
            }
            return n;
        }
    }

    private final class AttributeIterator
    extends InternalAxisIteratorBase {
        AttributeIterator() {
        }

        public int next() {
            int n = this._currentNode;
            this._currentNode = DTMDefaultBaseIterators.this.getNextAttribute(n);
            return this.returnNode(n);
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstAttribute(n);
                return this.resetPosition();
            }
            return this;
        }
    }

    private final class TypedAttributeIterator
    extends InternalAxisIteratorBase {
        private final int _nodeType;

        public TypedAttributeIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n = this._currentNode;
            this._currentNode = -1;
            return this.returnNode(n);
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = n;
                n = DTMDefaultBaseIterators.this.getFirstAttribute(n);
                while (n != -1) {
                    if (DTMDefaultBaseIterators.this.getExpandedTypeID(n) == this._nodeType) break;
                    n = DTMDefaultBaseIterators.this.getNextAttribute(n);
                }
                this._currentNode = n;
                return this.resetPosition();
            }
            return this;
        }
    }

    private class PrecedingSiblingIterator
    extends InternalAxisIteratorBase {
        PrecedingSiblingIterator() {
        }

        public boolean isReverse() {
            return true;
        }

        public int next() {
            if (this._currentNode == this._startNode) {
                return -1;
            }
            int n = this._currentNode;
            this._currentNode = DTMDefaultBaseIterators.this.getNextSibling(n);
            return this.returnNode(n);
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = n;
                if (n == -1) {
                    this._currentNode = n;
                    return this.resetPosition();
                }
                int n2 = DTMDefaultBaseIterators.this.getExpandedTypeID(n) & ExpandedNameTable.MASK_NODETYPE;
                this._currentNode = ExpandedNameTable.ATTRIBUTE == n2 || ExpandedNameTable.NAMESPACE == n2 ? n : DTMDefaultBaseIterators.this.getFirstChild(DTMDefaultBaseIterators.this.getParent(n));
                return this.resetPosition();
            }
            return this;
        }
    }

    private final class TypedPrecedingSiblingIterator
    extends PrecedingSiblingIterator {
        private final int _nodeType;

        public TypedPrecedingSiblingIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n;
            while ((n = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(n) != this._nodeType) {
            }
            return n;
        }
    }

    private class PrecedingIterator
    extends InternalAxisIteratorBase {
        private final int _maxAncestors = 8;
        private int[] _stack = new int[8];
        private int _sp;
        private int _oldsp;

        PrecedingIterator() {
        }

        public DTMAxisIterator cloneIterator() {
            this._isRestartable = false;
            try {
                PrecedingIterator precedingIterator = (PrecedingIterator)super.clone();
                int[] nArray = new int[this._stack.length];
                System.arraycopy(this._stack, 0, nArray, 0, this._stack.length);
                precedingIterator._stack = nArray;
                return precedingIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new DTMException(XSLMessages.createMessage(167, null));
            }
        }

        public boolean isReverse() {
            return true;
        }

        public int next() {
            int n = this._currentNode + 1;
            if (this._sp >= 0 && n < this._stack[this._sp]) {
                this._currentNode = n;
                return this.returnNode(this._currentNode | DTMDefaultBaseIterators.this.m_dtmIdent);
            }
            this._currentNode = n;
            return --this._sp >= 0 ? this.next() : -1;
        }

        public DTMAxisIterator reset() {
            this._sp = this._oldsp;
            return this.resetPosition();
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = n &= 0x3FFFFF;
                this._currentNode = 0;
                int n2 = 0;
                this._stack[0] = n;
                if (n > 0) {
                    int n3;
                    while ((n3 = DTMDefaultBaseIterators.this._parent(n)) != 0) {
                        if (++n2 == this._stack.length) {
                            int[] nArray = new int[n2 + 4];
                            System.arraycopy(this._stack, 0, nArray, 0, n2);
                            this._stack = nArray;
                        }
                        this._stack[n2] = n = n3;
                    }
                }
                this._oldsp = this._sp = n2;
                return this.resetPosition();
            }
            return this;
        }
    }

    private final class TypedPrecedingIterator
    extends PrecedingIterator {
        private final int _nodeType;

        public TypedPrecedingIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n;
            while ((n = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(n) != this._nodeType) {
            }
            return n;
        }
    }

    private class FollowingIterator
    extends InternalAxisIteratorBase {
        DTMAxisTraverser m_traverser;

        public FollowingIterator() {
            this.m_traverser = DTMDefaultBaseIterators.this.getAxisTraverser(6);
        }

        public int next() {
            int n = this._currentNode;
            this._currentNode = this.m_traverser.next(this._startNode, this._currentNode);
            return this.returnNode(n);
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = this.m_traverser.first(n);
                return this.resetPosition();
            }
            return this;
        }
    }

    private final class TypedFollowingIterator
    extends FollowingIterator {
        private final int _nodeType;

        public TypedFollowingIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n;
            while ((n = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(n) != this._nodeType) {
            }
            return this.returnNode(n);
        }
    }

    private class AncestorIterator
    extends InternalAxisIteratorBase {
        NodeVector m_ancestors = new NodeVector();
        int m_ancestorsPos;
        int m_realStartNode;

        AncestorIterator() {
        }

        public DTMAxisIterator cloneIterator() {
            this._isRestartable = false;
            try {
                AncestorIterator ancestorIterator = (AncestorIterator)super.clone();
                ancestorIterator._startNode = this._startNode;
                return ancestorIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new DTMException(XSLMessages.createMessage(167, null));
            }
        }

        public int getLast() {
            return this._startNode;
        }

        public int getStartNode() {
            return this.m_realStartNode;
        }

        public final boolean isReverse() {
            return true;
        }

        public int next() {
            int n;
            int n2 = this._currentNode;
            this._currentNode = (n = this.m_ancestorsPos--) < 0 ? -1 : this.m_ancestors.elementAt(n);
            return this.returnNode(n2);
        }

        public DTMAxisIterator reset() {
            this._currentNode = DTMDefaultBaseIterators.this.getDocument();
            this.m_ancestorsPos = this.m_ancestors.size() - 1;
            return this.resetPosition();
        }

        public DTMAxisIterator setStartNode(int n) {
            this.m_realStartNode = n;
            if (this._isRestartable) {
                this._startNode = this._includeSelf ? n : DTMDefaultBaseIterators.this.getParent(n);
                this._currentNode = DTMDefaultBaseIterators.this.getDocument();
                n = this._startNode;
                while (n != -1) {
                    this.m_ancestors.addElement(n);
                    n = DTMDefaultBaseIterators.this.getParent(n);
                }
                this.m_ancestorsPos = this.m_ancestors.size() - 1;
                return this.resetPosition();
            }
            return this;
        }
    }

    private final class TypedAncestorIterator
    extends AncestorIterator {
        private final int _nodeType;

        public TypedAncestorIterator(int n) {
            this._nodeType = n;
        }

        public int getLast() {
            int n = -1;
            int n2 = this._startNode;
            while (n2 != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(n2) == this._nodeType) {
                    n = n2;
                }
                n2 = DTMDefaultBaseIterators.this.getParent(n2);
            }
            return n;
        }

        public int next() {
            int n;
            while ((n = super.next()) != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(n) != this._nodeType) continue;
                return this.returnNode(n);
            }
            return -1;
        }
    }

    private class DescendantIterator
    extends InternalAxisIteratorBase {
        DescendantIterator() {
        }

        protected boolean isDescendant(int n) {
            return this._startNode == n || DTMDefaultBaseIterators.this._parent(n) >= this._startNode;
        }

        public int next() {
            int n;
            short s;
            do {
                if ((s = DTMDefaultBaseIterators.this._type(n = ++this._currentNode)) != -1 && this.isDescendant(n)) continue;
                return -1;
            } while (s == 2 || s == 13);
            return this.returnNode(n | DTMDefaultBaseIterators.this.m_dtmIdent);
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                n &= 0x3FFFFF;
                this._startNode = n--;
                if (this._includeSelf) {
                    // empty if block
                }
                this._currentNode = n;
                return this.resetPosition();
            }
            return this;
        }
    }

    private final class TypedDescendantIterator
    extends DescendantIterator {
        private final int _nodeType;

        public TypedDescendantIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n;
            while ((n = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(n) != this._nodeType) {
            }
            return n;
        }
    }

    private class NthDescendantIterator
    extends DescendantIterator {
        int _pos;

        public NthDescendantIterator(int n) {
            this._pos = n;
        }

        public int next() {
            int n;
            while ((n = super.next()) != -1) {
                int n2 = DTMDefaultBaseIterators.this._parent(n &= 0x3FFFFF);
                int n3 = DTMDefaultBaseIterators.this._firstch(n2);
                int n4 = 0;
                do {
                    short s;
                    if ((s = DTMDefaultBaseIterators.this._type(n3)) != 1) continue;
                    ++n4;
                } while (n4 < this._pos && (n3 = DTMDefaultBaseIterators.this._nextsib(n3)) != -1);
                if (n != n3) continue;
                return n;
            }
            return -1;
        }
    }

    private class SingletonIterator
    extends InternalAxisIteratorBase {
        private boolean _isConstant;

        public SingletonIterator() {
            this(Integer.MIN_VALUE, false);
        }

        public SingletonIterator(int n) {
            this(n, false);
        }

        public SingletonIterator(int n, boolean bl) {
            this._currentNode = this._startNode = n;
            this._isConstant = bl;
        }

        public int next() {
            int n = this._currentNode;
            this._currentNode = -1;
            return this.returnNode(n);
        }

        public DTMAxisIterator reset() {
            if (this._isConstant) {
                this._currentNode = this._startNode;
                return this.resetPosition();
            }
            boolean bl = this._isRestartable;
            this._isRestartable = true;
            this.setStartNode(this._startNode);
            this._isRestartable = bl;
            return this;
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isConstant) {
                this._currentNode = this._startNode;
                return this.resetPosition();
            }
            if (this._isRestartable) {
                if (this._currentNode == Integer.MIN_VALUE) {
                    this._currentNode = this._startNode = n;
                }
                return this.resetPosition();
            }
            return this;
        }
    }

    private final class TypedSingletonIterator
    extends SingletonIterator {
        private final int _nodeType;

        public TypedSingletonIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n = super.next();
            return DTMDefaultBaseIterators.this.getExpandedTypeID(n) == this._nodeType ? n : -1;
        }
    }
}

