/***************************************************************************
                          variable.h  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VARIABLE_H
#define VARIABLE_H

#include <qstring.h>
#include "inkompatibel.h"

/* Rckgabewert fr getOrt(). variable_global und variable_lokal werden
   auerdem verwendet:
   - beim Constructor (Variable("bla", variable_global))
   - in mDX
 */
#define variable_global 0x8000
#define variable_relativ 0x8001
#define variable_lokal 0x8002


class VarDefinition;

/** (Auftreten einer) Variable in einer Prozedur.

    Wenn mDeklaration sagt, dass es sich
    um eine (richtige echte) Konstante handelt, existiert die Variable
    nur so lange, bis in vparse.yy ein Ausdruck draus gemacht wird. Dabei
    wird es dann durch den Wert ersetzt. */
class Variable {


  /** Datei, in der diese Variablenverwendung steht (fr Fehlermeldungen) */
  //__String mDateiName;
  /** Zeilen-Nr, in der diese Variablenverwendung steht (fr Fehlermeldungen) */
  //int mZeilenNr;
  /* ... wird nicht mehr gebraucht. Diese Info wird vom darberliegenden
     Code an die Fehlermeldung gehngt. */

  VarDefinition * mDeklaration;

  /** Relative Koordinaten, so wie sie der cual-Programmierer eingegeben
      hat. */
  int mDX, mDY;
  
public:
  /** Erzeugt eine Mll-Variable. Wird verwendet, wenn es einen Fehler
      gab (blicherweise Variable nicht definiert). Die Mll-Variable
      versucht, Folgefehler zu vermeiden, so dass wenigstens noch fertig
      geparst werden kann. */
  Variable();
  
  Variable(//__String datna, int znr,
           VarDefinition * d, int dx, int dy = 0);
  
  __String toString() const;
  
  /** Liefert die absoluten Koordinaten, so wie sie intern gebraucht
      werden (also ggf. gespiegelt und Hex-bereinigt). (y wird von
      getDX() zwar nicht gebraucht, aber so sieht's schner aus.) */
  int getX(int x, int y) const;
  int getY(int x, int y) const;
  
  int getNummer() const;
  
  int getOrt() const;
  
  bool istKonstante() const;
  
  /** Liefert den Default-Wert, wenn's eine Variable ist und den
      Wert, wenn's eine Konstante ist. */
  int getDefaultWert() const;
  
  __String getName() const;

};




#endif
