/*
** Copyright 2000-2003 Double Precision, Inc.  See COPYING for
** distribution information.
*/

/*
** $Id: ldaplist.c,v 1.12 2004/02/14 04:54:09 mrsam Exp $
*/
#include	"sqwebmail.h"
#include	<stdio.h>
#include	<errno.h>
#include	<stdlib.h>
#include	<ctype.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<string.h>
#include	"cgi/cgi.h"
#include	"ldapaddressbook/ldapaddressbook.h"
#include	"maildir/maildircreate.h"
#include	"numlib/numlib.h"
#include	"htmllibdir.h"
#include	"addressbook.h"
#include	"pref.h"
#include	"rfc2045/base64.h"

#define	LOCALABOOK	"sqwebmail-ldapaddressbook"

extern void output_scriptptrget();
extern void output_attrencoded(const char *);
extern void output_attrencoded_oknl(const char *p);
extern void output_urlencoded(const char *);
extern void output_attrencoded_fp(const char *, FILE *);
extern void output_attrencoded_oknl_fp(const char *, FILE *);

extern const char *sqwebmail_content_charset;

#if HAVE_SQWEBMAIL_UNICODE
#include	"unicode/unicode.h"
#endif

void	ldaplist()
{
struct ldapabook *abooks[2];
int	i;
struct ldapabook *p;
const char	*delabook=getarg("DELABOOK");
const char	*sysbook=getarg("SYSBOOK");

	if (!delabook)	delabook="";
	if (!sysbook)	sysbook="";

	if (*cgi("addabook"))
	{
		struct ldapabook newbook;
		struct ldapabook_opts zopt, xopt, uopt, oopt, yopt;
		char *p;

		memset(&newbook, 0, sizeof(newbook));

		newbook.name=(char *)cgi("name");
		newbook.host=(char *)cgi("host");
		newbook.port=(char *)cgi("port");
		newbook.suffix=(char *)cgi("suffix");
		newbook.binddn=(char *)cgi("binddn");
		newbook.bindpw=(char *)cgi("bindpw");

		p= (char *)cgi("zopt");

		if (strcmp(p, "Z") == 0 || strcmp(p, "ZZ") == 0)
		{
			zopt.options=p;
			zopt.next=newbook.opts;
			newbook.opts= &zopt;
		}

		xopt.options=NULL;
		uopt.options=NULL;
		oopt.options=NULL;
		yopt.options=NULL;
		p= (char *)cgi("xoptu");
		if (*p)
		{
			xopt.options=malloc(strlen(p)+6);
			if (!xopt.options)
				enomem();
			xopt.options[0]=SASL_AUTHENTICATION_RID;
			strcpy(xopt.options+1, "u:");
			strcat(xopt.options, p);
			xopt.next=newbook.opts;
			newbook.opts= &xopt;
		}
		else if (*(p=(char *)cgi("xoptdn")))
		{
			xopt.options=malloc(strlen(p)+6);
			if (!xopt.options)
				enomem();
			xopt.options[0]=SASL_AUTHENTICATION_RID;
			strcpy(xopt.options+1, "dn:");
			strcat(xopt.options, p);
			xopt.next=newbook.opts;
			newbook.opts= &xopt;
		}

		p= (char *)cgi("uopt");
		if (*p)
		{
			uopt.options=malloc(strlen(p)+2);
			if (!uopt.options)
				enomem();
			uopt.options[0]=SASL_AUTHENTICATION_ID;
			strcpy(uopt.options+1, p);
			uopt.next=newbook.opts;
			newbook.opts= &uopt;
		}

		p= (char *)cgi("yopt");
		if (*p)
		{
			yopt.options=malloc(strlen(p)+2);
			if (!yopt.options)
				enomem();
			yopt.options[0]=SASL_AUTHENTICATION_MECHANISM;
			strcpy(yopt.options+1, p);
			yopt.next=newbook.opts;
			newbook.opts= &yopt;
		}

		p= (char *)cgi("oopt");
		if (*p)
		{
			oopt.options=malloc(strlen(p)+2);
			if (!oopt.options)
				enomem();
			oopt.options[0]=SASL_SECURITY_PROPERTIES;
			strcpy(oopt.options+1, p);
			oopt.next=newbook.opts;
			newbook.opts= &oopt;
		}

		if (*newbook.name && *newbook.host &&
			ldapabook_add(LOCALABOOK, &newbook) < 0)
		{
			printf("<pre>\n");
			perror("ldapabook_add");
			printf("</pre>\n");
		}
		if (xopt.options)
			free(xopt.options);
		if (yopt.options)
			free(yopt.options);
		if (oopt.options)
			free(oopt.options);
		if (uopt.options)
			free(uopt.options);
	}

	if (*cgi("delabook"))
	{
		struct maildir_tmpcreate_info createInfo;
		int fd;
		maildir_tmpcreate_init(&createInfo);

		createInfo.uniq="abook";

		if ((fd=maildir_tmpcreate_fd(&createInfo)) >= 0)
		{
			close(fd);
			unlink(createInfo.tmpname);
			ldapabook_del(LOCALABOOK, createInfo.tmpname,
				      cgi("ABOOK"));
			maildir_tmpcreate_free(&createInfo);
		}
	}

	abooks[0]=ldapabook_read(LDAPADDRESSBOOK);
	abooks[1]=ldapabook_read(LOCALABOOK);

	printf("<table border=\"0\" cellpadding=\"8\" width=\"100%%\">\n");
	for (i=0; i<2; i++)
	{
		for (p=abooks[i]; p; p=p->next)
		{
			printf("<tr valign=\"top\"><td align=\"right\">");
			printf("<input type=\"radio\" name=\"ABOOK\"");

			if (pref_ldap && strcmp(pref_ldap, p->name) == 0)
				printf(" checked=\"checked\"");

			printf(" value=\"");
			output_attrencoded(p->name);
			printf("\" /></td><td><font size=\"+1\""
			       " class=\"ldaplist-name\">%s</font><br />"
			       "&nbsp;&nbsp;&nbsp;<span class=\"tt\"><font size=\"-2\""
			       " class=\"ldaplist-ldapurl\">ldap://", p->name);
			if (*p->binddn || *p->bindpw)
			{
				printf("%s", p->binddn);
				if (*p->bindpw)
					printf(":%s", p->bindpw);
				printf("@");
			}
			printf("%s", p->host);
			if (atoi(p->port) != 389)
				printf(":%s", p->port);
			if (*p->suffix)
			{
			char	*q;

				printf("/");
				q=cgiurlencode_noeq(p->suffix);
				if (q)
				{
					printf("%s", q);
					free(q);
				}
			}
			printf("</font></span>%s</td></tr>",
				i ? "":sysbook);
		}
	}

	if (abooks[1])
	{
		printf("<tr><td></td><td>");
		printf("<input type=\"submit\" name=\"delabook\" value=\"%s\" />",
				delabook);
		printf("</td></tr>\n");
	}
	printf("</table>\n");
	ldapabook_free(abooks[0]);
	ldapabook_free(abooks[1]);
}

int	ldapsearch()
{
	if (*cgi("ABOOK") == 0 || *cgi("attr1") == 0 || *cgi("op1") == 0
		|| *cgi("value1") == 0) return (-1);
	return (0);
}

static const char *getattrn(const char *s, unsigned n)
{
char	buf1[NUMBUFSIZE+20], bufn[NUMBUFSIZE];

	return (cgi(strcat(strcpy(buf1, s), libmail_str_size_t(n, bufn))));
}

static char *getfiltern(unsigned n)
{
const char *attrname=getattrn("attr", n);
const char *attrop=getattrn("op", n);
const char *attrval=getattrn("value", n);

char *buf;
const char *p;
char *q;
size_t i;

#if HAVE_SQWEBMAIL_UNICODE
char *uattrval=NULL;
const struct unicode_info *uoptr = unicode_find(sqwebmail_content_charset);
#endif

	if (*attrname == 0 || *attrop == 0 || *attrval == 0)	return (0);

#if HAVE_SQWEBMAIL_UNICODE
	if (uoptr && (uattrval=unicode_ctoutf8(uoptr, attrval, NULL)))
		attrval = uattrval;
#endif

	/* compute length of filter string */
	for (p=attrval, i=0; *p; p++, i++)
		if (*p == '*' || *p == '(' || *p == ')' || *p == '\\')
			i+=2;
	buf=malloc(strlen(attrname)+strlen(attrop)+i+sizeof("()")+1);
	if (!buf)
	{
#if	HAVE_SQWEBMAIL_UNICODE
		if (uattrval)
			free(uattrval);
#endif
		return (0);
	}

	strcpy(buf, "(");
	strcat(buf, attrname);

	if (strcmp(attrop, "=*") == 0 || strcmp(attrop, "*=") == 0
	    || strcmp(attrop, "*=*") == 0)
		strcat(buf, "=");
	else
		strcat(buf, attrop);
	if (strcmp(attrop, "*=") == 0 || strcmp(attrop, "*=*") == 0)
		strcat(buf, "*");

	for (p=attrval, q=buf+strlen(buf); *p; p++, q++)
		if (*p == '*' || *p == '(' || *p == ')' || *p == '\\')
		{
			sprintf(q, "\\%02X", (unsigned char)(*p));
			q+=2;
		}
		else
			*q = *p;
	*q = 0;

	if (strcmp(attrop, "=*") == 0 || strcmp(attrop, "*=*") == 0)
		strcat(buf, "*");
	strcat(buf, ")");

#if	HAVE_SQWEBMAIL_UNICODE
	if (uattrval)
		free(uattrval);
#endif
	return (buf);
}

static char *getfilter()
{
char	*filter=0;
char	*s;
unsigned n=atoi(cgi("maxattrs"));
unsigned i;

	if (n < 3)	n=3;
	if (n > 20)	n=20;	/* sanity check */

	for (i=0; i<n; i++)
	{
	char	*p=getfiltern(i+1);

		if (!p)
			continue;

		if (!filter)	filter=p;
		else
		{
			s=malloc(strlen(p) + strlen(filter));
			if (!s)
			{
				free(filter);
				free(p);
				return (0);
			}
			strcat(strcpy(s, filter), p);
			free(filter);
			free(p);
			filter=s;
		}
	}
	s=malloc(strlen(filter)+sizeof("(&)"));
	if (!s)
	{
		free(filter);
		return(0);
	}
	strcat(strcat(strcpy(s, "(&"), filter), ")");
	free(filter);
	return (s);
}

static void parsesearch(FILE *, FILE *);

void	doldapsearch()
{
char	*f;
struct ldapabook *abooks[2];
const struct ldapabook *ptr;

	abooks[0]=ldapabook_read(LDAPADDRESSBOOK);
	abooks[1]=ldapabook_read(LOCALABOOK);

	ptr=ldapabook_find(abooks[0], cgi("ABOOK"));
	if (!ptr)
		ptr=ldapabook_find(abooks[1], cgi("ABOOK"));

	if (ptr && (f=getfilter()) != 0)
	{
	int	fd;
	FILE	*fpw=0;
	char	*tmpname=0;

		pref_setldap(ptr->name);
		printf("<pre>");
		fflush(stdout);

		fd=ldapabook_search(ptr, LDAPSEARCH, f, 1);
		free(f);

                if (fd >= 0)
		{
		FILE *fp=fdopen(fd, "r");

			if (fp)
			{
				struct maildir_tmpcreate_info createInfo;

				maildir_tmpcreate_init(&createInfo);
				createInfo.uniq="ldap";
				createInfo.doordie=1;

				fpw=maildir_tmpcreate_fp(&createInfo);

				tmpname=createInfo.tmpname;
				createInfo.tmpname=NULL;

				if (fpw)
					parsesearch(fp, fpw);
				else
					perror(tmpname);

				maildir_tmpcreate_free(&createInfo);

				fclose(fp);
			}
			else
				perror("fdopen");
			close(fd);
		}
		printf("</pre>");

		if (fpw)
		{
		int	c;

			fflush(fpw);
			rewind(fpw);
			while ((c=getc(fpw)) != EOF)
				putchar(c);
			fclose(fpw);
		}
		if (tmpname)
		{
			unlink(tmpname);
			free(tmpname);
		}
	}
}

static void parsesearch(FILE *r, FILE *w)
{
char	buf[BUFSIZ];
char	sn[100];
char	cn[100];
char	givenname[100];
char	o[100];
char	l[100];
char	ou[100];
char	st[100];
char	mail[512];
char	*p;
const char	*add1=getarg("ADD"),
	 *add2=getarg("CREATE"),
	 *submit=getarg("SUBMIT");

char	numbuf[NUMBUFSIZE];
char	numbuf2[NUMBUFSIZE+10];
unsigned counter;

#if HAVE_SQWEBMAIL_UNICODE
const struct unicode_info *uiptr;
#endif
 
	fprintf(w, "<table border=\"0\" cellpadding=\"4\">\n");

	counter=0;
	for (;;)
	{
		if (fgets(buf, sizeof(buf), r) == 0)	break;
		/* skip dn */

		sn[0]=0;
		cn[0]=0;
		o[0]=0;
		l[0]=0;
		ou[0]=0;
		st[0]=0;
		mail[0]=0;
		givenname[0]=0;

		for (;;)
		{
			char *base64buf=NULL;

			if (fgets(buf, sizeof(buf), r) == 0)	break;
			if ((p=strchr(buf, '\n')) != 0)	*p=0;
			if (buf[0] == 0)	break;

			for (p=buf; *p; p++)
			{
				if (*p == ':')
				{
					*p++=0;

					if (*p != ':')
					{
						while (*p &&
						       isspace((int)
							       (unsigned char)
							       *p))
							++p;
						break;
					}

					++p;
					while (*p &&isspace((int)
							    (unsigned char)*p))
						++p;

					base64buf=base64_decode_str(p);
					if (base64buf)
						p=base64buf;

#if HAVE_SQWEBMAIL_UNICODE
					if ((uiptr=unicode_find(sqwebmail_content_charset)) != 0 &&
					    (base64buf=unicode_cfromutf8(uiptr,
									 p,
									 NULL))
					    != NULL)
						p=base64buf;

#endif

					break;
				}
				*p=tolower((int)(unsigned char)*p);
			}

#define	SAFECAT(b,buf) strncat(b, buf, sizeof(b)-1-strlen(b))

#define	SAVE(n,b) if (strcmp(buf, n) == 0) \
	{ if (b[0]) SAFECAT(b, "\n"); SAFECAT(b, p); }

			SAVE("sn", sn);

			SAVE("cn", cn);
			SAVE("givenname", givenname);
			SAVE("o", o);
			SAVE("ou", ou);
			SAVE("l", l);
			SAVE("st", st);
			SAVE("mail", mail);
			if (base64buf)
				free(base64buf);
		}
		if (mail[0] == 0)	continue;

		for (p=mail; (p=strtok(p, "\n")) != 0; p=0)
		{
		char	*q;

			fprintf(w, "<tr valign=\"top\"><td><input type=\"checkbox\" "
				"name=\"%s\" value=\"&lt;",
				strcat(strcpy(numbuf2, "ADDY"),
					libmail_str_size_t(counter++, numbuf)));

			output_attrencoded_fp(p, w);
			fprintf(w, "&gt;");

			q=cn;

			if (*q)
			{
				fprintf(w, " &quot;");
				output_attrencoded_fp(q, w);
				fprintf(w, "&quot;");
			}
			else if (sn[0] || givenname[0])
			{
				fprintf(w, " &quot;");
				if (givenname[0])
					output_attrencoded_fp(givenname,
							      w);
				if (sn[0] && givenname[0])
					fprintf(w, " ");
				if (sn[0])
					output_attrencoded_fp(sn,
							      w);
			}


			fprintf(w, "\" /></td><td><font size=\"+1\" class=\"ldapsearch-name\">");

			if (*q)
			{
				fprintf(w, "\"");
				output_attrencoded_fp(q, w);
				fprintf(w, "\" ");
			}
			fprintf(w, "</font><font size=\"+1\" class=\"ldapsearch-addr\">&lt;");
			output_attrencoded_fp(p, w);
			fprintf(w, "&gt;</font>");
			printf("<span class=\"ldapsearch-misc\">");
			if (ou[0])
			{
				fprintf(w, "<br />");
				output_attrencoded_oknl_fp(ou, w);
			}
			if (o[0])
			{
				fprintf(w, "<br />");
				output_attrencoded_oknl_fp(o, w);
			}
			if (l[0])
			{
				fprintf(w, "<br />");
				output_attrencoded_oknl_fp(l, w);
			}
			if (st[0])
			{
				fprintf(w, "<br />");
				output_attrencoded_oknl_fp(st, w);
			}
			printf("</span>");
			fprintf(w, "</td></tr>\n");
		}
	}
	fprintf(w, "<tr><td colspan=\"2\"><hr width=\"90%%\" />"
		"<input type=\"hidden\" name=\"ADDYCNT\" value=\"%u\" />\n"
		"</td></tr>\n", counter);
	fprintf(w, "<tr><td colspan=\"2\"><table>");

	fprintf(w, "<tr><td align=\"right\">%s</td><td>"
			"<select name=\"nick1\"><option value=\"\"></option>\n", add1);
	ab_listselect_fp(w);
	fprintf(w, "</select></td></tr>\n");
	fprintf(w, "<tr><td align=\"right\">%s</td><td>"
			"<input type=\"text\" name=\"nick2\" /></td></tr>\n", add2);
	fprintf(w, "<tr><td></td><td>"
		"<input type=\"submit\" name=\"import\" value=\"%s\" /></td></tr>",
		submit);
	fprintf(w, "</table></td></tr></table>\n");
}
