/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

#include <gtk/gtk.h>

#include "global.h"
#include "cong-error-dialog.h"

/**
 * cong_error_test_file_ops:
 * @parent_window:
 * @filename:
 * @vfs_result:
 *
 * TODO: Write me
 */
void 
cong_error_test_file_ops(GtkWindow *parent_window, 
			 const gchar* filename,
			 GnomeVFSResult vfs_result)
{
	GtkDialog* dialog;

	GnomeVFSFileSize file_size = 5*1024*1024; /* 5 megabytes, for a test */

	g_message(_("Testing File->Open failure of \"%s\" with result %s"), filename, gnome_vfs_result_to_string(vfs_result));

	dialog = cong_error_dialog_new_from_file_open_failure_with_vfs_result(parent_window, filename, vfs_result);
	cong_error_dialog_run(GTK_DIALOG(dialog));		
	gtk_widget_destroy(GTK_WIDGET(dialog));    

	g_message(_("Testing File->Save failure of \"%s\" with result %s"), filename, gnome_vfs_result_to_string(vfs_result));

	dialog = cong_error_dialog_new_from_file_save_failure(parent_window, filename, vfs_result, &file_size);
	cong_error_dialog_run(GTK_DIALOG(dialog));		
	gtk_widget_destroy(GTK_WIDGET(dialog));    

	g_message(_("Testing generic failure of \"%s\" with result %s"), filename, gnome_vfs_result_to_string(vfs_result));

	dialog = cong_error_dialog_new_from_file_operation_failure(parent_window,
								   _("Conglomerate is simulating the failure of a generic file operation."),
								   filename, 
								   vfs_result, 
								   _("This dialog was generated by the automated testing routine"));
	cong_error_dialog_run(GTK_DIALOG(dialog));		
	gtk_widget_destroy(GTK_WIDGET(dialog));
}

/**
 * cong_error_tests:
 * @parent_window:
 *
 * TODO: Write me
 */
void 
cong_error_tests(GtkWindow *parent_window)
{
	int i;
	for (i=(int)GNOME_VFS_ERROR_NOT_FOUND;i<(int)GNOME_VFS_NUM_ERRORS;i++) {

		#define TEST_URI ("file:///home/david/test.xml")
		// #define TEST_URI ("file:///home/david/fubar.xml")
		// #define TEST_URI ("file:///home/david/faq.html")
		// #define TEST_URI ("http://www.fubar.com/fubar.xml")
		// #define TEST_URI ("ftp://www.fubar.com/fubar.xml")


		cong_error_test_file_ops(parent_window, 
					 TEST_URI, 
					 (GnomeVFSResult)i);
	}
}
