(**************************************************************************)
(*  The CDuce compiler                                                    *)
(*  Alain Frisch <Alain.Frisch@inria.fr> and the CDuce team               *)
(*  Copyright CNRS,INRIA, 2003,2004 (see LICENSE for details)             *)
(**************************************************************************)

val nil_type: Types.t
val nil_node: Types.Node.t
val nil_atom: Atoms.V.t
val nil_cst:  Types.Const.t
val any: Types.t
val seqseq: Types.t
val string: Types.t

val concat: Types.t -> Types.t -> Types.t
val flatten: Types.t -> Types.t
val map: (Types.t -> Types.t) -> Types.t -> Types.t

val map_mono: Types.t -> Types.t list * (Types.t list -> Types.t)

val map_tree: 
  (Types.t -> Types.t * Types.t) -> Types.t -> Types.t
 (* input type -> (result, residual) *)         (* sequence type *)

val star: Types.t -> Types.t
  (* For a type t, returns [t*] *)
val plus: Types.t -> Types.t
val option: Types.Node.t -> Types.t
  (* returns [t?] *)

val repet: int -> int option -> Types.t -> Types.t
  (* min, max *)

val approx: Types.t -> Types.t
  (*  For a type t <= [Any*], returns the least type s such that:
      t <= [s*]
      
      In general, for an arbitrary type, returns the least type s such that:
      t <= (X where X = (s, X) |  Any \ (Any,Any))
  *)

(* Added this interface needed in cdo2cmo -- Julien *)
val star_node : Types.Node.t -> Types.Node.t

  (** given a list of descrs create the sequence type from them *)
val seq_of_list: Types.t list -> Types.t

