(**************************************************************************)
(*  The CDuce compiler                                                    *)
(*  Alain Frisch <Alain.Frisch@inria.fr> and the CDuce team               *)
(*  Copyright CNRS,INRIA, 2003,2004 (see LICENSE for details)             *)
(**************************************************************************)

open Schema_types


(** {2 per schema component kind validators} *)

  (** CDuce domain: any values
   *
   * - when type_definition is AnyType, validate_type is the identity function
   * - when type_definition is a simple type definition, validate_type act as
   * validate_simple_type below (CDuce domain: strings)
   * - when type_definition is a complex type_definition, validate_type check
   * that a given XML value has the given type ignoring tag name (CDuce domain:
   * XML values)
   *)
val validate_type : type_definition -> Value.t -> Value.t

  (** CDuce domain: records
   *
   * Looks in the given record value to see if there's a field corresponding to
   * the given attribute_declaration. If it's the case validate it's value
   * accordingly to type definition; otherwise, if there's a default value for
   * the attribute, add the corresponding field. Fails if there is neither the
   * field nor the default value.
   *)
(*  TODO (* commented out since the semantic isn't clear. Implementing the above
 *  described semantic isn't that good since it generates records with more
 *  fields than described in the corresponding closed record type *)
  val validate_attribute : attribute_declaration -> schema -> Value.t -> Value.t
*)

  (** CDuce domain: XML values *)
val validate_element : element_declaration -> Value.t -> Value.t

  (** CDuce domain: records *)
val validate_attribute_group :
  attribute_group_definition -> Value.t -> Value.t

  (** CDuce domain: sequences of XML values *)
val validate_model_group :
  model_group_definition -> Value.t -> Value.t


(** {2 derived validators} *)

  (** CDuce domain: strings *)
val validate_simple_type : 
  simple_type_definition -> Encodings.Utf8.t -> Value.t
