(* $Id: rpc_over_http_client.mli 182 2004-05-25 16:49:11Z gerd $
 * ----------------------------------------------------------------------
 *
 *)


type gateway

val create : Unixqueue.event_system -> string -> gateway
  (* create esys url: Creates a gateway that is connected with the web
   * resource denoted by [url].
   *)

val http_pipeline : gateway -> Http_client.pipeline
  (* Returns the underlying pipeline. This may be used to set up
   * proxies and authentication.
   *)

val rpc_client_connector : gateway -> Rpc_client.connector
  (* Returns the rpc connector that is to be used for clients.
   * The protocol is always Tcp (because the connector is one end of
   * a bidirectional pipe).
   *)

val set_exception_handler : gateway -> (exn -> unit) -> unit
  (* sets an exception handler (the default is a 'log to stderr' exception
   * handler).
   * Exceptions occuring in the handler itself are silently dropped.
   *)

val close : gateway -> unit
  (* Closes the input side of the gateway immediately, i.e. the message
   * currently being received is dropped, and no further messages are
   * accepted. The already accepted calls are processed as usual until
   * responses for all have arrived (or timeouts happen).
   * This is the "graceful shutdown".
   *)

val verbose : bool -> unit

(* USAGE:
 *
 * - First create the gateway:
 *
 *   let gw = Rpc_over_http_client.create esys "http://host/path/endpoint" in
 *
 * - Then create the RPC client:
 *
 *   let connector = Rpc_over_http_client.rpc_client_connector gw in
 *   let clnt = Rpc_client.create esys connector Tcp my_program in
 *
 * - Now use the client as usual! Every remote call is forwarded to the
 *   specified HTTP endpoint.
 *
 * - IMPORTANT RESTRICTION: The synchronous client interface does not
 *   work (it hangs). You must use the asynchronous interface.
 *)
