(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(* Interfacing with emacs for file edition, through emacsclient. *)
(*
class emacs file =
  object
    method close = ()
    method reload = ()
    method save = ()
    method changed = false
  end
*)

let edit ?char file =
  let com = "emacsclient -n "^
    (match char with 
      None -> ""
    | Some c -> 
	let line = (Cam_misc.line_of_char file.Cam_types.f_name c) + 1 in
	(* + 1 because emacs start line numbers at 1 *)
	"+"^(string_of_int line)^" "
    )^
    (Filename.quote file.Cam_types.f_name) 
  in
  let n = Sys.command com in
  if n = 0 then ()
  else raise (Failure (Cam_messages.error_exec com))
