/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2003-2004 The Caudium Group
 * Based on IMHO  Stefan Wallstrm and Bosse Lincoln.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: camas_imhoscreens.pike,v 1.1.2.3 2004/02/02 22:06:01 vida Exp $
 */
//
//! module: CAMAS: IMHO Screens
//!  This module handle IMHO Screens and defvars.
//! inherits: module
//! inherits: caudiumlib
//! type: MODULE_PROVIDER
//! cvs_version: $Id: camas_imhoscreens.pike,v 1.1.2.3 2004/02/02 22:06:01 vida Exp $
//
#include <module.h>
inherit "module";
inherit "caudiumlib";

// Camas includes
// #include <camas/screens.h>	// Screen names	allready (defined in globals.h)
#include <camas/maindefvars.h>	// Defvars...
#include <camas/globals.h>	// (defined 'cause functions.h)
#include <camas/msg.h>		// MSG() Language Macros

constant cvs_version   = "$Id: camas_imhoscreens.pike,v 1.1.2.3 2004/02/02 22:06:01 vida Exp $";
constant module_type   = MODULE_PROVIDER;
constant module_name   = "CAMAS: IMHO Screens (DEPRECATED)";
constant module_doc    = "This module contains IMHO style Screens and defvars.";
constant module_unique = 1;
constant thread_safe   = 1;

// For debug
#define CAMAS_DEBUG
#ifdef CAMAS_DEBUG
# define CDEBUG(X)  if(QUERY(debug)) perror("CAMAS IMHOSCREEN: "+X+"\n");
# define RCDEBUG(X) if(QUERY(rdebug)) perror("CAMAS IMHOSCREEN: "+X+"\n");
# define DD	   QUERY(debugdump)?"<hr><imho_dumpid>":""
#else
# define CDEBUG(X)
# define RCDEBUG(X)
# define DD
#endif

#if constant(thread_create)
// Lock for sessions
object global_lock = Thread.Mutex();
#endif

// Setup Screen Stuff
// Setup screen
// vida : added AUTOFILTER
constant SETUP_FIELDS = ({ "$USERNAME", "$USERADDRESS", "$MAILPATH", "$LANGUAGE", "$LAYOUT",
                           "$REPLY", "$PREFIX", "$SIGNATURE", "$HEADERS", "$LOGOUT", "$VISIBLE",
                           "$SORTORDER", "$SORTCOLUMN", "$SHOWHTML", "$SHOWTEXT",
                           "$TRASH", "$DRAFTS", "$SENT", "$ANSWERED", "$ATTACHMENTS", "$BCCCOPY",
                           "$AUTOFILTER",  "$SHOWHEADERS", "$ORGANIZATION" });
constant SETUP_MFIELDS = ({ "$MUSERNAME", "$MUSERADDRESS", "$MMAILPATH", "$MLANGUAGE", "$MLAYOUT",
                            "$MREPLY", "$MPREFIX", "$MSIGNATURE", "$MHEADERS", "$MLOGOUT", "$MVISIBLE",
                            "$MSORTORDER", "$MSORTCOLUMN", "$MSHOWHTML", "$MSHOWTEXT",
                            "$MTRASH", "$MDRAFTS", "$MSENT", "$MANSWERED", "$MATTACHMENTS", "$MBCCCOPY",
                            "$MAUTOFILTER",  "$MSHOWHEADERS", "$MORGANIZATION" });
#define SF_UN 0
#define SF_UA 1
#define SF_MP 2
#define SF_LA 3
#define SF_LY 4
#define SF_RI 5
#define SF_RP 6
#define SF_SI 7
#define SF_UH 8
#define SF_LO 9
#define SF_VM 10
#define SF_SO 11
#define SF_SC 12
#define SF_SH 13
#define SF_ST 14
#define SF_FT 15
#define SF_FD 16
#define SF_FS 17
#define SF_FA 18
#define SF_SA 19
#define SF_BC 20
#define SF_AF 21
#define SF_DH 22
#define SF_OR 23
// End of Setup screen stuff

private multiset(string) delete_methods = (<"both", "move to trash">);

int hide_delay(){
  if(QUERY(featuredelay)){
    return 0;
  }
  else{
    return 1;
  }
}

// Module creation & configuration
void create()
{
#ifdef CAMAS_DEBUG
  // Debug
  defvar("debug",0,"Debug:Calls or Errors",TYPE_FLAG,"Debug the call / errors "
         "into Caudium error log ?");
  defvar("rdebug",0,"Debug:Dump the RXML in log",TYPE_FLAG,
         "Dump the RXML sent to RXML parser into caudium error log ?");
  defvar("debugdump", 0,"Debug:Dump Caudium id", TYPE_FLAG,"Dump Caudium 'id' "
         "mapping in the HTML output? (warning the pages can be hudge and this "
         "be a security hole if you let this to yes).");
#endif
  // ======== Login Screen ============================================
  // Login Screen - part 1
  defvar("laylogin1", DEFAULT_LAYLOGIN1, "Login page:Part 1", TYPE_TEXT_FIELD,
         "Content of the login page with some RXML contents.<br />Use the following to replace with internal imho"
         " controls:<ul><li><b>$MSGLOGIN</b>: Login message from imho languages files</li>"
         "<li><b>$MSGPASSWORD</b>: Password message from imho language files</li>"
         "<li><b>$INPUTLOGIN</b>: Input box for login</li>"
         "<li><b>$INPUTPASSWORD</b>: Input box for password</li>"
         "<li><b>$INPUTOK</b>: The Ok button from imho languages files.</li>"
         "<li><b>$MSGIMAPSERVER</b>: IMAP server from imho language files</li>"
         "<li><b>$MSGPORT</b>: Port from imho language files</li>"
         "<li><b>$INPUTIMAPSERVER</b>: Input box for letting user give their IMAP server</li>"
         "<li><b>$INPUTIMAPPORT</b>: Input box for letting user give the port of their IMAP server</li>"
         "You can set the define \"jscript\" to \"on\" if you wishe to use some "
         "\"magic\" javascript to help users to login...");

  // Login screen - part 2
  defvar("laylogin2", DEFAULT_LAYLOGIN2, "Login page:Part 2", TYPE_TEXT_FIELD,
         "Content of the login page <i>(selection of layouts if the is more than one layout)</i>.<br />"
         "As usual you can use the following to replace with controls/messages from imho:<ul>"
         "<li><b>$MSGUSRINFACE</b>:The message from imho language file to choose the user interface</li>"
         "<li><b>$INPUTSELECTINFACE</b>:Popup with the differents users interfaces in ;-)</li></ul>.");
  // ======== Logout Screen ============================================
  defvar("laylogout", DEFAULT_LAYLOGOUT, "Logout page", TYPE_TEXT_FIELD,
         "Replace the content of the logout page by some RXML contents.<br /> "
         "<ul><li><b>$LOGOUTMSG</b>: You have been logged out. </li>"
				 "<li><b>$LOGOUTRELOAD</b>: Close this browser window to make sure no one can read your mail.</li>"
				 "<li><b>$LOGOUTCLOSE</b>: Reload this page to login.</li></ul>");
  // ======== Compose Screen ============================================

  // vida : added more control over compose screen
  // Compose screen - part 1 : top actions buttons
  defvar("laycompose1top", DEFAULT_LAYCOMPOSE1TOP ,
         "Compose page: Top actions buttons",
         TYPE_TEXT_FIELD,
         "Action button layout e.g. Send, Cancel and Spell check buttons.<br /> As usual you can use<ul>"
         "<li><b>$INPUTSEND</b>: for the Send button</li>"
         "<li><b>$INPUTCANCEL</b>: for the cancel button</li>"
         "<li><b>$INPUTSPELLCHECK</b>: for the spell button</li>"
         "<li><b>$INPUTSPELLCHOOSE</b>: for the popup list of languages for the spelling</li>"
         "<li><b>$INPUTSAVEDRAFT</b>: allow the user to save a draft</li></ul>");

  // Compose screen - part 1 : bottom actions buttons
  defvar("laycompose1bottom", DEFAULT_LAYCOMPOSE1BOTTOM ,
         "Compose page: Bottom actions buttons",
         TYPE_TEXT_FIELD,
         "Action button layout e.g. Send, Cancel and Spell check buttons.<br/> As usual you can use<ul>"
         "<li><b>$INPUTSEND</b>: for the Send button</li>"
         "<li><b>$INPUTCANCEL</b>: for the cancel button</li>"
         "<li><b>$INPUTSPELLCHECK</b>: for the spell button</li>"
         "<li><b>$INPUTSPELLCHOOSE</b>: for the popup list of languages for the spelling</li>"
         "<li><b>$INPUTSAVEDRAFT</b>: allow the user to save a draft</li></ul>");

  // Compose screen - part 2 : headers
  defvar("laycompose2", DEFAULT_LAYCOMPOSE2 ,
         "Compose page: Headers actions",
         TYPE_TEXT_FIELD,
         "Header actions e.g. the input boxes, buttons to fill the mail headers.<br />"
         "As usual, some replacements"
         " fields :<ul><li><b>$MSGFROM</b>: Imho language 'from' text</li>"
         "<li><b>$MSGEMAILFROM</b>: The email entered in the configuration dialogs</li>"
         "<li><b>$MSGORGANIZATION</b>: The organization entered in the configuration dialogs</li>"
         "<li><b>$MSGTO</b>: Imho language 'To' text</li>"
         "<li><b>$MSGCC</b>: Imho language 'CC' text</li>"
         "<li><b>$MSGBCC</b>: Imho language 'Bcc' text</li>"
         "<li><b>$MSGSUBJECT</b>: Imho language 'Subject' text</li>"
         "<li><b>$INPUTTO</b>: The input box for 'To'</li>"
         "<li><b>$INPUTCC</b>: The input box for 'CC'</li>"
         "<li><b>$INPUTBCC</b>: The input box for 'Bcc'</li>"
         "<li><b>$INPUTSUBJECT</b>: The input box for the 'subject'</li>"
         "<li><b>$INPUTADDRBOOKTO</b>: Button to add address from addressbook for 'To'</li>"
         "<li><b>$INPUTADDRBOOKCC</b>: Button to add address from addressbook for 'Cc'</li>"
         "<li><b>$INPUTADDRBOOKBCC</b>: Button to add address from addressbook for 'Bcc'</li>"
         "<li><b>$INPUTADDRBOOK</b>: Button to add addresses from addressbook ('To', 'Cc', and 'Bcc')</li>"
         "<li><b>$INPUTLDAPTO</b>: Button to add address from LDAP addressbook for 'To'</li>"
         "<li><b>$INPUTLDAPCC</b>: Button to add address from LDAP addressbook for 'Cc'</li>"
         "<li><b>$INPUTLDAPBCC</b>: Button to add address from LDAP addressbook for 'Bcc'</li>"
         "<li><b>$INPUTLDAP</b>: Button to add addresses from LDAP addressbook ('To', 'Cc', and 'Bcc')</li>"
         "</ul>");


  defvar("headersize", 45,"Compose page:Header size", TYPE_INT,
         "Width of the (to, cc, bcc) input fields.");

  defvar("subjectsize", 50,"Compose page:Subject size", TYPE_INT,
         "Width of the subject field.");

  // Compose screen - part 3 : attachment toolbar
  defvar("laycompose3",DEFAULT_LAYCOMPOSE3,"Compose page:Attachments actions",
         TYPE_TEXT_FIELD,
         "Attachments actions for composing mail.<br />As usual there is options/replacements :<ul>"
         "<li><b>$MSGATTACHMENTS</b>: Imho language for adding attachements files</li>"
         "<li><b>$INPUTFILEATT</b>: List of attached files</li>"
         "<li><b>$INPUTADD</b>: Button to add new files</li>"
         "<li><b>$INPUTDEL</b>: Button to del selected files</li></ul>");

  // Compose screen - part 4 : compose mail screen
  defvar("laycompose4",DEFAULT_LAYCOMPOSE4,"Compose page:Compose screen",
         TYPE_TEXT_FIELD,
         "Compose screen.<br />As usual some options/replacements :<ul>"
         "<li><b>$INPUTMSGAREA</b>: The input box for message writting</li>"
         "<li><b>$INPUTSAVECOPY</b>: Check box to save a copy into sent mail</li>"
         "<li><b>$INPUTDSNDELAY</b> &amp; <b>$INPUTDSNSUCCESS</b>: DSN options.</li>"
         "<li><b>$INPUTMDN</b>: Request a MDN (Mail Delivery Notification)</li>"
         "<li><b>$INPUTBCC2ADMIN</b>: Add a checkbox in compose screen which all ow the user to"
         " send a BCC to the email specified in preferences</li></ul>");

  defvar("msgrows", 20,"Compose page:Input box rows", TYPE_INT,
         "Rows in the input box.");

  defvar("msgcols", 65,"Compose page:Input box columns", TYPE_INT,
         "Columns in the input box.");
  // ======== Edit Address Screen ============================================
  defvar("layeditaddress","","Edit addresses", TYPE_TEXT_FIELD,
         "Layout to edit an addressbook entry.\n"
         "Leave empty to use the default layout (autogenerated).\n"
         "Otherwise, you must use in your <tt>input</tt> tags :\n"
         "<lu>\n"
         "<li><b>$NAME</b> for the name value (primary key)</li>\n"
         "<li><b>$ADDRESS</b> for the address value</li>\n"
         "<li><b>$BUTTONSAVE</b> for the validation button</li>\n"
         "<li><b>$BUTTONDELETE</b> for the deletion button</li>\n"
         "<li><b>$BUTTONCANCEL</b> for the cancel button</li>\n"
         "</lu>\n"
         "You can also use, according to your setting of extended "
         "addressbook fields :\n"
         "<lu>\n"
         "<li><b>%<i>field</i>%</b> as the name of the <tt>input</tt> "
         "for the extended addressbook field named <i>field</i> "
         "(case sensitive)</li>\n"
         "<li><b>$<i>field</i>$</b> as it's value</li>\n"
         "</lu><br />\n"
         "e.g.:<br />\n"
         "Let's suppose we have two extended address book fields named "
         "<it>Phone</it> and <it>Postal</it>, you could write here :<tt><br/>"
         "<pre>"
         "&lt;input name=\"name\" value=\"$NAME\"&gt; is\n"
         "&lt;input size=60 name=\"address\" value=\"$ADDRESS\"&gt;\n"
         "&lt;hr /&gt;Ring at :\n"
         "&lt;input size=20 name=\"%Phone%\" value=\"$Phone$\"&gt;&lt;br /&gt;\n"
         "Write at:\n"
         "&lt;textarea name=\"%Postal%\" rows=6 cols=80&gt;"
         "$Postal$"
         "&lt;/textarea&gt;&lt;br /&gt;&"
         "$BUTTONSAVE $BUTTONDELETE $BUTTONCANCEL"
         "</pre>"
         "</tt>"
        );
  // ======== Edit Address Filter Screen ======================================
  defvar("layeditaddressfilter", DEFAULT_LAYEDITADDRESSFILTER ,
         "Edit Adress Filter", TYPE_TEXT_FIELD,
         "Layout to edit an filterbook entry.\n"
         "Leave empty to use the default layout (autogenerated).\n"
         "Otherwise, you can use :\n"
         "<lu>\n"
         "<li><b>$INPUTNAMEFIELD</b> for the name select option</li>\n"
         "<li><b>$INPUTFIELD</b> for the field select option</li>\n"
         "<li><b>$INPUTNAMEFILTER</b> for the name textbox (primary key)</li>\n"
         "<li><b>$INPUTFILTER</b> for the filter textbox</li>\n"
         "<li><b>$INPUTFOLDER</b> for the select option associated to "
         "extended filterbook field named "
         "(case sensitive)</li>\n"
         "<li><b>$BUTTONFILTERSAVE</b> for the validation button</li>\n"
         "<li><b>$BUTTONFILTERDELETE</b> for the deletion button</li>\n"
         "<li><b>$BUTTONFILTERCANCEL</b> for the cancel button</li>\n"
         "</lu>\n"
        );
  // ======== Mailindex Screen ======================================
  defvar("layindextop", DEFAULT_LAYINDEXTOP,
         "Mailindex Page: Top buttons",
         TYPE_TEXT_FIELD,
         "Note : <i>you can't have $MSGMOVEMARKED and $MSGCHANGEMBOX both in top and bottom</i><br>"
         "Action button layout e.g. Send, Cancel and Spell check buttons.<br/> As usual you can use<ul>"
         "<ul><li><b>$MSGMAILNUMBERS</b>: The numbers of mails when there more than 20 (by default)</li>"
         "<li><b>$MSGDELETEMARKED</b>: Button to delete marked mails</li>"
         "<li><b>$MSGDELETEALLTRASH</b>: Button to delete mail in the trash</li>"
         "<li><b>$MSGMOVETOTRASH</b>: Button to move mail to trash</li>"
         "<li><b>$MSGMOVEMARKED</b>: Button to move marked</li>"
         "<li><b>$MSGCHANGEMBOX</b>: Button to change mbox</li>"
         "<li><b>$MSGSHOWALLAFTERSEARCH</b>: Button to reset the search. Appear only if you search something before</li>"
         "<li><b>$MSGSEARCHMAIL</b>: Search button</li>"
         "<li><b>$MSGCHECKNEWMAIL</b>: check for new mail button</li></ul>");

  defvar("layindexbottom", DEFAULT_LAYINDEXBOTTOM,
         "Mailindex Page: Bottom buttons",
         TYPE_TEXT_FIELD,
         "Note : <i>you can't have $MSGMOVEMARKED and $MSGCHANGEMBOX both in top and bottom</i><br>"
         "Action button layout e.g. Send, Cancel and Spell check buttons.<br/> As usual you can use<ul>"
         "<ul><li><b>$MSGMAILNUMBERS</b>: The numbers of mails when there more than 20 (by default)</li>"
         "<li><b>$MSGDELETEMARKED</b>: Button to delete marked mails</li>"
         "<li><b>$MSGDELETEALLTRASH</b>: Button to delete mail in the trash</li>"
         "<li><b>$MSGMOVETOTRASH</b>: Button to move mail to trash</li>"
         "<li><b>$MSGMOVEMARKED</b>: Button to move marked</li>"
         "<li><b>$MSGCHANGEMBOX</b>: Button to change mbox</li>"
         "<li><b>$MSGSHOWALLAFTERSEARCH</b>: Button to reset the search. Appear only if you search something before</li>"
         "<li><b>$MSGSEARCHMAIL</b>: Search button</li>"
         "<li><b>$MSGCHECKNEWMAIL</b>: check for new mail button</li></ul>");

  defvar("layindexnomail", DEFAULT_LAYINDEXNOMAIL,
         "Mailindex Page: Top buttons (when mailbox listed is empty)",
         TYPE_TEXT_FIELD,
         "Action button layout e.g. Send, Cancel and Spell check buttons.<br/> As usual you can use<ul>"
         "<li><b>$MSGGETNEWMAIL</b>: Button to check for new mails</li>"
         "<li><b>$MSGCHANGEMBOX</b>: Button to change mailbox</li>"
         "<li><b>$MSGNOMAILS</b>: Message that say no mails in this mailbox</li></ul>");
  defvar("layindexsender", DEFAULT_LAYINDEXSENDER,
         "Mailindex Page: Sender field",
         TYPE_TEXT_FIELD,
         "What to write in sender name");
  defvar("featurechangembox", 1, "Mailindex Page:Change Mbox", TYPE_FLAG,
         "Allow changing Mailbox on the fly in mail index.");
  defvar("featuredelay", 0, "Mailindex Page:Delay: Delay", TYPE_FLAG,
         "Adds delay in the date column displaying the time since the mail arrived in the mailbox");
  defvar("delayforanswered", 1, "Mailindex Page:Delay: Delay displayed for answered",
         TYPE_FLAG, "Display the delay when the mail is allready answered."
         "Setting it to no can be useful if delay is meaning to warn people.",
         0,
         hide_delay);
  defvar("delayimagepath", "", "Mailindex Page:Delay: Delay image path", TYPE_STRING,
         "If set, this path will be used to display images in the date field depending of the delay.<br />"
         "These images must be named as delay<i>X</i>.gif with <i>X</i> depending of your delay step number.<br />"
         "If not set, no image will be displayed",
         0,
         hide_delay);
  defvar("shownew", 1, "Mailindex Page: Show New", TYPE_FLAG,
         "If set to no, the column N in mailindex disappear"
         " but as new messages are bold, you can always see new"
         " messages.");
  defvar("showanswered", 1, "Mailindex Page: Show Answered", TYPE_FLAG,
         " If set to no, the column R in mailindex disappear"
         " but if you set Mail index - delay, delay is not "
         " displayed for answered so you can always see them.");
  defvar("frommaxlength", 0,"Mailindex Page:Max length for the 'sender' field",
         TYPE_INT,
         "Set the max length for the 'sender' field. If set to 0, the whole "
         "string will be displayed.");
  defvar("subjectmaxlength", 0, "Mailindex Page:Max length for the 'subject' field",
         TYPE_INT,
         "Set the max length for the 'subject' field. If set to 0, the whole "
         "string will be displayed.");
  defvar("subjectlayer", 0, "Mailindex Page:Show full subject in a floating table",
         TYPE_FLAG,
         "Show the full subject in a floating layer. Need browser that support "
         "Javascript and Layers.");
  // ======== Folderlist Screen ======================================
  defvar("layfoldersrow", DEFAULT_LAYFOLDERSROW,"Folderslist Page:Table row",
         TYPE_TEXT_FIELD,
         "The layout for the folders list.<br />As usual some options/replacements :<ul>"
         "<li><b>$MARK</b>: Button to select the folder for deletion</li>"
         "<li><b>$NAME</b>: The name of the folder</li>"
         "<li><b>$MESSAGES</b>: The number of messages</li>"
         "<li><b>$RECENT</b>: The number of recent messages</li>"
         "<li><b>$UNSEEN</b>: The number of unseen messages</li>"
         "<li><b>$SIZE</b>: The size of the folder (in kb).</li></ul>");
  defvar("layfolderstop", DEFAULT_LAYFOLDERSTOP,"Folderslist Page:Table header",
         TYPE_TEXT_FIELD,
         "The layout for the top of the table. "
         "Provided rxml tag: <b>&lt;imho_totalsize&gt;</b> for the size of all the folders.<br />"
         "(also in &amp;session.allfolderssize;). <br />Some replacements for multilanguage:<ul>"
         "<li><b>$TOTALSIZE</b>: Text for the total size</li>"
         "<li><b>$OF</b>: Text for of</li>"
         "<li><b>$USED</b>: Text for used</li>"
         "<li><b>$FOLDER</b>: Text for folder</li>"
         "<li><b>$MESSAGES</b>: Text for Messages</li>"
         "<li><b>$UNSEEN</b>: Text for Unseen</li>"
         "<li><b>$SIZE</b>: Text for Size</li></ul>");
  defvar("layfoldersbottom", DEFAULT_LAYFOLDERSBOTTOM,"Folderslist Page:Table footer",
         TYPE_TEXT_FIELD,
         "The layout for the bottom of the table.<br />As usual some options/replacements :<ul>"
         "<li><ul>Creating folders :<li><b>$NEWFOLDERNAME</b>: Text area for the name of the new folder</li>"
         "<li><b>$CREATE</b>: Button to create the folder</li>"
         "<li><b>$CREATFOLDER</b>: Text for Create folder</li></ul></li>"
         "<li><ul>Renaming folders :<li><b>$OLDFOLDERNAME</b>: Selects the folder to rename</li>"
         "<li><b>$RENAMEFOLDERNAME</b>: Text area for the name of the new folder</li>"
         "<li><b>$RENAME</b>: Button to rename the folder </li>"
         "<li><b>$RENAMFOLDER</b>: Text for Rename folder</li></ul></li>"
         "<li><b>$RENAME</b>: Button to rename the folder </li></ul></li>"
         "<li><ul>Deleting folders :<li><b>$DELETE</b>: Button to delete marked folders</li></ul></li></ul>");
  // ======== Readmail Screen ======================================
  defvar("multipleselect",1,"Readmail Page:Select multiple addresses", TYPE_FLAG,
         "If set, allow the user to add all addresses from the mail headers.");
  defvar("selectaddresses", DEFAULT_SELECTADDRESSES, "Readmail Page:Select addresses",TYPE_STRING,
         "Allow the user to add individual addresses from the mail headers.<br />"
         "Allowed values are: From, To, Cc");
  defvar("rfc822readdate",0,"Readmail Page:Use RFC822 standard date", TYPE_FLAG,
         "When set, standard RFC822 date is used instead of parsed date as in the folder index.");
  defvar("rfc822dateformat", "", "Readmail Page:Date format", TYPE_TEXT_FIELD,
         "Set a format for the date.<br />"
         "You can use the following replacements :<ul>"
         "<li><b>$DD</b>: Day</li>"
         "<li><b>$MM</b>: Month</li>"
         "<li><b>$YY</b>: Short year</li>"
         "<li><b>$YYYY</b>: Long year</li>"
         "<li><b>$HOURS</b>: Hours</li>"
         "<li><b>$MINUTES</b>: Minutes</li>"
         "<li><b>$SECONDS</b>: Seconds</li>"
         "<li><b>$TZ</b>: Timezone</li>"
         "</ul>");
  defvar("attachwindow", 1, "Readmail Page:Open attachments in new window",
         TYPE_FLAG, "Enables multi-window view of attachments.");
  defvar("attachmenttype", 1, "Readmail Page:Show the attachments type",
         TYPE_FLAG, "When reading a mail with attachments, add the type of the file.");

  // ======== Setup Screen ======================================
  defvar("laysetup", DEFAULT_LAYSETUP, "Setup Page:Setup Screen", TYPE_TEXT_FIELD,
         "The layout for the setup screen."
         "<br />As usual some replacements :<ul>"
         "<li><b>" + SETUP_FIELDS[SF_UN] + "</b>: Field to change the user name.</li>"
         "<li><b>" + SETUP_FIELDS[SF_UA] + "</b>: Field to change the user address.</li>"
         "<li><b>" + SETUP_FIELDS[SF_MP] + "</b>: The mailpath.</li>"
         "<li><b>" + SETUP_FIELDS[SF_LA] + "</b>: The language.</li>"
         "<li><b>" + SETUP_FIELDS[SF_LY] + "</b>: The layout.</li>"
         "<li><b>" + SETUP_FIELDS[SF_RI] + "</b>: Include the message when replying.</li>"
         "<li><b>" + SETUP_FIELDS[SF_RP] + "</b>: The reply prefix.</li>"
         "<li><b>" + SETUP_FIELDS[SF_SI] + "</b>: The signature.</li>"
         "<li><b>" + SETUP_FIELDS[SF_UH] + "</b>: User specified headers.</li>"
         "<li><b>" + SETUP_FIELDS[SF_LO] + "</b>: Auto-logout delay.</li>"
         "<li><b>" + SETUP_FIELDS[SF_VM] + "</b>: The number of visible messages.</li>"
         "<li><b>" + SETUP_FIELDS[SF_SO] + "</b>: The mail sorting order.</li>"
         "<li><b>" + SETUP_FIELDS[SF_SC] + "</b>: The mail sorting column.</li>"
         "<li><b>" + SETUP_FIELDS[SF_SH] + "</b>: Display HTML mails.</li>"
         "<li><b>" + SETUP_FIELDS[SF_ST] + "</b>: Display text mails.</li>"
         "<li><b>" + SETUP_FIELDS[SF_FT] + "</b>: User trash folder.</li>"
         "<li><b>" + SETUP_FIELDS[SF_FD] + "</b>: User drafts folder.</li>"
         "<li><b>" + SETUP_FIELDS[SF_FA] + "</b>: User answered-mail folder.</li>"
         "<li><b>" + SETUP_FIELDS[SF_FS] + "</b>: User sent-mail folder.</li>"
         "<li><b>" + SETUP_FIELDS[SF_SA] + "</b>: Save attachments.</li>"
         "<li><b>" + SETUP_FIELDS[SF_BC] + "</b>: Default BCC.</li>"
         "<li><b>" + SETUP_FIELDS[SF_DH] + "</b>: Show/Hide headers.</li>"
         "<li><b>" + SETUP_FIELDS[SF_OR] + "</b>: Organization.</li>"
         "<li><b>" + SETUP_FIELDS[SF_AF] + "</b>: Auto filter.</li>"
         "</ul><br />"
         "Add a leading '<b>M</b>' to get the field name eg. $USERNAME -> $<b>M</b>USERNAME.");
  defvar("newusermsg", "", "Setup Page:New user message", TYPE_STRING,
         "New users are first presented with the preferences screen. This message is shown then.");
  defvar("signaturecols","55","Setup Page:Size of signature", TYPE_STRING,
         "Change the max line length for signature box in the preferences page");
}

// What we provides
string query_provides()
{
  return "camas_imhoscreens";
}

// Start of the module
void start(int cnt, object conf)
{
  module_dependencies(conf, ({ "camas_layoutimho_default" }));
}

// Checking the variables
string check_variable(string var, mixed value)
{
  switch (var)
  {
  case "headersize":
  case "subjectsize":
  case "msgrows":
  case "msgcols":
  case "frommaxlength":
  case "subjectmaxlength":
    if (value < 0)
      return "Must be positive integer.";
    break;
  }
  return 0;
}

// ------------------ Screens definitions (PUBLIC functions)

// ------------------ Login screen
//! method: string login(object id, int screen)
//!  Login screen call for camas.
//! returns:
//!  Function called when login screen is needed. It's return
//!  RXML code with replacements from defvars and correct values.
//! arg: object id
//!  Caudium ID
//! arg: int screen
//!  To be documented
//! arg: int oldplug
//!  Used if administrator asks for backward support of IMHO plugins
//
string login (object id, int screen, int oldplug) {
  string page = "";
  object features = id->conf->get_provider("camas_features");
  object camas_main = id->conf->get_provider("camas_main");

  CDEBUG("Login screen called");
  CSESSION->screen = "login";
  if (screen == LOGINFAILED) {
    page += MSGA(M_NOLOGIN, ({ (CSESSION->loginerror) ? CSESSION->loginerror : MSG(M_LOGINERROR) }));
    page += "<br />\n<br />\n";
  }
  else
    if (screen == LOGINFAILEDIMAP)
      page += MSG(M_IMAPERROR) + "<br />\n<br />\n";

  string preset_login = 0;
  if (oldplug)		// IMHO plugin compatibility
  {
    object camas_imhoplugs = id->conf->get_provider("camas_imhoplugs");
    if (objectp(camas_imhoplugs))
    {
      if (camas_imhoplugs->plugin && camas_imhoplugs->plugin->imho_preset_login)
        preset_login = camas_imhoplugs->plugin->imho_preset_login (id);
    }
  }

  page += "<form target=\"" + id->misc->camas->target + "\" action=\"" + id->misc->camas->nexttarget;
  page += "\" method=\"post\" name=\"imhologinform\"><input type=hidden name=actionlogin value=\"1\">";

  array imho_from = ({ "$MSGLOGIN", "$MSGPASSWORD",
                       "$MSGIMAPSERVER", "$MSGPORT",
                       "$INPUTLOGIN", "$INPUTPASSWORD", "$INPUTOK",
                       "$INPUTIMAPSERVER", "$INPUTIMAPPORT",
                     });
  array imho_to = ({ MSG(M_LOGIN), MSG(M_PASSWORD), MSG(M_IMAPSERVER), MSG(M_PORT) });

  string bofh = "<input name=\"login\"";
  if (preset_login)
    bofh += " value=" + HTML_ENCODE_TAG_VALUE(preset_login);
  bofh += ">";

  object auth_module = id->conf->get_provider ("camas_auth");
  if (objectp (auth_module) && auth_module->getemaillogin ()) {
    string|int domain = auth_module->getdnsname ();
    if (stringp (domain))
      bofh += "<imho_text nfont='Arial Rounded' scale=0.3>@" + domain + "</imho_text>";
  }

  imho_to += ({ bofh });

  array (string) layouts = id->conf->get_provider ("camas_layout_manager")->list_layouts ();

  bofh = "<input type=\"password\" name=\"passwd\"";
  if ((sizeof (layouts) == 1) && id->supports->javascript)
    bofh += "<if defined=\"jscript is on\"> onChange=\"this.form.submit()\" </if>";
  bofh += ">";
  imho_to += ({ bofh });
  imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_login_ok","OK",MSG(M_LOGIN_OK)) });
  string out = "";
  imho_to += ({ out });
  imho_to += ({ out });
  page += replace (QUERY (laylogin1), imho_from, imho_to);

  if (sizeof (layouts) > 1)
  {
    imho_from = ({ "$MSGUSRINFACE",
                   "$INPUTSELECTINFACE" });
    imho_to = ({ MSG(M_USERINTERFACE) });
    bofh = "<select name=\"layout\">";
    bofh+= "<option value=\"__user\" selected>" + MSG(M_SAVEDUSERINTERFACE) + "</option>\n";
    foreach (layouts, string lay) {
      bofh += "<option value=\"" + lay + "\">";
      bofh += lay + "</option>\n";
    }
    bofh+="</select>";
    imho_to += ({ bofh });
    page += replace (QUERY (laylogin2), imho_from, imho_to);
  }
  if (id->supports->javascript) {
    page += "<if defined=\"jscript is on\"> ";
    page += "<script language=\"JavaScript\" type=\"text/javascript\">\n<!--\n";
    if (preset_login)
      page += "document.imhologinform.passwd.focus();\n";
    else
      page += "document.imhologinform.login.focus();\n";
    page += "// -->\n</script></if>\n";
  }

  page += "</form>";
  page += DD;

  RCDEBUG("Login screen RXML code : " +page);

  return page;
}

// ------------------ Logout screen
//! method: string logout(object id)
//!  Logout Screen call for CAMAS
//! returns:
//!  Function called when logout screen is needed. It's return
//!  RXML code with replacements from defvars and correct values.
//! arg: object id
//!  Caudium ID
//
string logout (object id) {
  string page = "";

  CDEBUG("Logout screen called");

  CSESSION->screen = "logout";
  CSESSION->title = MSG(M_LOGGEDOUT);
  page += replace (QUERY (laylogout), ({ "$LOGOUTMSG", "$LOGOUTRELOAD", "$LOGOUTCLOSE" }) , ({ MSG(M_LOGOUTMSG), MSG(M_LOGOUTRELOAD), MSG(M_LOGOUTCLOSE) }) );
  page += DD;
  CAMAS.Tools.destroy_csession(id);
  RCDEBUG("Logout screen RXML code : "+page);

  return page;
}

// ------------------ Compose screen
//! method: string compose(object id, int feature_addressbook, int feature_ldap, int ispell, string ispelldict, string siteorg, int feature_mailboxes, int feature_savemailcopy, int feature_dsn, int feature_attachments)
//!  Compose (mail creation/forward/reply) call for CAMAS
//! returns:
//!  Function called when mail creation, forward or reply is needed.
//!  Returns RXML code with replacements from defvars and the corrects
//!  values from CAMAS internals.
//! arg: object id
//!  Caudium ID
//! arg: int feature_addressbook
//!  If addressbook is enabled ?
//! arg: int feature_ldap
//!  If the LDAP addressbook is enabled ?
//! arg: int ispell
//!  If spelling feature is enabled ?
//! arg: string ispelldict
//!  Coma separated of ispell dictionaries
//! arg: string siteorg
//!  Sitewide organization
//! arg: int feature_mailboxes
//!  If mailboxes can be used
//! arg: int feature_savemail
//!  If a mail copy can be saved
//! arg: int feature_dsn
//!  If DSN is supported
//! arg: int feature_attachments
//!  If attachements is supported
string compose (object id, int feature_addressbook, int feature_ldap, int ispell, string ispelldict, string siteorg, int feature_mailboxes, int feature_savemailcopy, int feature_dsn, int feature_attachments) {
  string page = "";

  CDEBUG("Compose screen called");

  CSESSION->screen = "compose";
  CSESSION->title = MSG(M_COMPOSEMAIL);


  array imho_from = ({ "$INPUTSEND",
                       "$INPUTCANCEL",
                       "$INPUTSPELLCHECK",
                       "$INPUTSPELLCHOOSE",
                       "$INPUTSAVEDRAFT" });

  array imho_to = ({ CAMAS.Tools.formdrawbutton(id,"m_send","actionsend",MSG(M_SEND)),
                     CAMAS.Tools.formdrawbutton(id,"m_cancelsend","actionindex",MSG(M_CANCELSEND)) });

  string buttons = "", buttons_bottom = "", bofh = "";

  if (ispell) {
    imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_spellcheck","actionspellcheck",MSG(M_SPELLCHECK)) });
    bofh = "<select name=\"ispelldict\">";
    foreach (ispelldict / ",", string dict)
    {
      int separator = search(dict, ":");
      string display_dict = dict;
      if(separator > 0)
        display_dict = dict[separator+1..];
      bofh += "<option value=\"" + dict + "\">" + HTML_ENCODE_STRING (display_dict) + "</option>";
    }
    bofh += "</select>";
    imho_to += ({ bofh });
  }
  else
    imho_to += ({ "", "" });

  imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_savedraft","actionsavedraft",MSG(M_SAVEDRAFT)) });

  buttons = replace (QUERY (laycompose1top), imho_from, imho_to);
  buttons_bottom = replace (QUERY(laycompose1bottom), imho_from, imho_to);

  page += "<form name=\"imhocomposeform\" target=\"" + id->misc->camas->target;
  page += "\" action=\"" + id->misc->camas->nexttarget + "\" method=\"post\">";

  if (!CSESSION->notopbuttons)
    page += buttons;
  imho_from = ({ "$MSGFROM",
                 "$MSGEMAILFROM",
                 "$MSGORGANIZATION",
                 "$MSGTO",
                 "$INPUTTO",
                 "$INPUTADDRBOOKTO",
                 "$INPUTADDRBOOK",
                 "$INPUTLDAPTO",
                 "$INPUTLDAP",
                 "$MSGCC",
                 "$INPUTCC",
                 "$INPUTADDRBOOKCC",
                 "$INPUTLDAPCC",
                 "$MSGBCC",
                 "$INPUTBCC",
                 "$INPUTADDRBOOKBCC",
                 "$INPUTLDAPBCC",
                 "$MSGSUBJECT",
                 "$INPUTSUBJECT" });

  string organization = (sizeof(siteorg)) ? ("(" + siteorg + ")")
                        : (sizeof (CSESSION->organization) ? ("(" + HTML_ENCODE_STRING (CSESSION->organization) + ")") : "");

  imho_to = ({ "<imho_text nfont='Arial Rounded' scale=0.4>" + MSG(M_FROM) + ":</imho_text>" });

  // TODO: We must have methodology for shared.* hierarchy
  if(sizeof(CSESSION->mailbox[MB_HIERARCHY_IDX])>2 && CSESSION->mailbox[MB_HIERARCHY_IDX][0]==CSESSION->sharedpath){
    imho_to += ({ HTML_ENCODE_STRING(CSESSION->name)+" &lt;"+HTML_ENCODE_STRING(CSESSION->mailbox[MB_HIERARCHY_IDX][1])+"."+HTML_ENCODE_STRING(CSESSION->mailbox[MB_HIERARCHY_IDX][2])+"@"+CSESSION->maildomain+"&gt;"});
  }
  else{
    imho_to += ({ HTML_ENCODE_STRING (CSESSION->name) + " &lt;" + HTML_ENCODE_STRING(CSESSION->address) + "&gt;" });
  }

  imho_to += ({ organization,
                "<imho_text nfont='Arial Rounded' scale=0.4>" + MSG(M_TO) + ":</imho_text>",
                "<input name=\"to\" size=\"" + QUERY (headersize) + "\" value=" + HTML_ENCODE_TAG_VALUE (CSESSION->to) + ">" });

  if (feature_addressbook)
  {
    imho_to +=({ CAMAS.Tools.formdrawbutton(id,"m_addressbook","actionaddressbookto",MSG(M_ADDRESSBOOK)+"...") });
    imho_to +=({ CAMAS.Tools.formdrawbutton(id,"m_addressbook","actionaddressbooktoccbcc",MSG(M_ADDRESSBOOK)+"...") });
  }
  else
    imho_to += ({ "", "" });

  if (feature_ldap)
  {
    imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_ldap","actionldapto",MSG(M_LDAP)) });
    imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_ldap","actionldaptoccbcc",MSG(M_LDAP)) });
  }
  else
    imho_to += ({ "", "" });

  imho_to += ({ "<imho_text nfont='Arial Rounded' scale=0.4>" + MSG(M_CC) + ":</imho_text>",
                "<input name=\"cc\" size=\"" + QUERY (headersize)
                + "\" value=" + HTML_ENCODE_TAG_VALUE (CSESSION->cc) + ">" });

  if (feature_addressbook)
    imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_addressbook","actionaddressbookcc",MSG(M_ADDRESSBOOK)+"...") });
  else
    imho_to += ({ "" });

  if (feature_ldap)
    imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_ldap", "actionldapcc", MSG(M_LDAP)) });
  else
    imho_to += ({ "" });

  imho_to += ({ "<imho_text nfont='Arial Rounded' scale=0.4>" + MSG(M_BCC) + ":</imho_text>",
                "<input name=\"bcc\" size=\"" + QUERY (headersize)
                + "\" value=" + HTML_ENCODE_TAG_VALUE (CSESSION->bcc) + ">" });

  if (feature_addressbook)
    imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_addressbook", "actionaddressbookbcc", MSG(M_ADDRESSBOOK)+"...") });
  else
    imho_to += ({ "" });

  if (feature_ldap)
    imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_ldap", "actionldapbcc", MSG(M_LDAP)) });
  else
    imho_to += ({ "" });

  imho_to += ({ "<imho_text nfont='Arial Rounded' scale=0.4>" + MSG(M_SUBJECT) + ":</imho_text>",
                "<input name=\"subject\" size=\"" + QUERY (subjectsize)
                + "\" value=" + HTML_ENCODE_TAG_VALUE(CSESSION->subject) + ">" });

  page += replace (QUERY (laycompose2), imho_from, imho_to);

  if (feature_attachments) {
    int no_att = sizeof (CSESSION->attachments);
    int s = (no_att > 4) ? 4 : ((no_att < 1) ? 1 : no_att);
    imho_from = ({ "$MSGATTACHMENTS",
                   "$INPUTFILEATT",
                   "$INPUTADD",
                   "$INPUTDEL",
                   "$LOGIN",
                   "$PASSWD"});
    imho_to = ({ "<imho_text nfont='Arial Rounded' scale=0.4>" + MSG(M_ATTACHMENTS) + ":</imho_text>" });

    bofh = "<select name=\"attachments\" multiple size=\"" + (string)s + "\">";
    int i = 0;
    if (!sizeof (CSESSION->attachments))
      bofh += "<option value=\"-1\">(" + MSG(M_NOATTACHMENTS) + ")</option>";
    foreach (CSESSION->attachments, mapping file) {
      bofh += "<option value=\"" + (string)i + "\">";
      bofh += HTML_ENCODE_STRING (file->fname + " (" + file->size + " bytes)");
      bofh += "</option>";
      i++;
    }
    bofh += "</select>";
    imho_to += ({ bofh,
                  CAMAS.Tools.formdrawbutton(id,"m_addattachment", "actiongotoaddattachment", MSG(M_ADDATTACHMENT)+"..."),
                  sizeof(CSESSION->attachments)?CAMAS.Tools.formdrawbutton(id,"m_removemarkedattachments", "actionremoveattachment", MSG(M_REMOVEMARKEDATTACHMENTS)):""
                });
    imho_to += ({ CSESSION->login });
    imho_to += ({ CSESSION->passwd });
    page += replace (QUERY (laycompose3), imho_from, imho_to);
  }

  imho_from = ({ "$INPUTMSGAREA",
                 "$INPUTSAVECOPY",
                 "$INPUTDSNDELAY",
                 "$INPUTDSNSUCCESS",
                 "$INPUTMDN",
                 "$INPUTBCC2ADMIN" });
  imho_to = ({ "<textarea rows=\"" + QUERY (msgrows) + "\" cols=\"" + QUERY (msgcols) +
               "\" name=\"message\" wrap=\"physical\">" + HTML_ENCODE_STRING (CSESSION->message) + "</textarea>" });

  if ( feature_mailboxes && sizeof (CSESSION->sentfolder))
  {
    if(feature_savemailcopy)
      imho_to += ({ "<input type=\"checkbox\" name=\"nosavemail\" value=\"1\"> " + MSG(M_DONTSAVEMAIL) });
    else
      imho_to += ({ "<input type=\"checkbox\" name=\"dosavemail\" value=\"1\"> " + MSG(M_SAVEMAILCOPY) });
  }
  else
    imho_to += ({ "" });

  if (feature_dsn && (id->conf->get_provider("camas_main")->QUERY (sendmethod) == "SMTP"))
    imho_to += ({ "<input type=\"checkbox\" name=\"dsndelay\" value=\"1\"> " + MSG(M_DSN_DELAY),
                  "<input type=\"checkbox\" name=\"dsnsuccess\" value=\"1\"> " + MSG(M_DSN_SUCCESS) });
  else
    imho_to += ({ "", "" });

  imho_to += ({ "<input type=\"checkbox\" name=\"mdn\" value=\"1\"> " + MSG(M_MDN) });
  if(sizeof(CSESSION->bcc2admin))
    imho_to += ({ "<input type=\"checkbox\" name=\"bcc2admin\" value="
                  + HTML_ENCODE_TAG_VALUE (CSESSION->bcc2admin) + ">" + MSG(M_CHECKBCC) } );
  else
    imho_to += ({ "" });

  page += replace (QUERY (laycompose4), imho_from, imho_to);

  page += replace (buttons_bottom, ({ "ispelldict", "actionspellcheck" }), ({ "ispelldict2", "actionspellcheck2" }) );

  //page+="</td></tr>\n</form></table>";
  page += "</form>";
  if (id->supports->javascript) {
    page += "<script language=\"JavaScript\" type=\"text/javascript\">\n<!--\n";
    page += "document.imhocomposeform.to.focus();\n";
    page += "// -->\n</script>\n";
  }
  page+=DD;
  RCDEBUG("Compose screen RXML code : "+page);
  return page;
}

// ------------------ Attachments screen
//! method: attachments(object id, int uploaddir)
//!  Attachement screen call for CAMAS
//! returns:
//!  Function called when attachements is handled when composing mail.
//!  Return RXML code with replacements from defvars and values from
//!  CAMAS internals
//! arg: object id
//!  Caudium ID
//! arg: int uploaddir
//!  If upload directory exists
string attachments (object id, int uploaddir) {
  string page = "";

  CDEBUG("Attachements screen called");
  CSESSION->screen = "attachments";
  CSESSION->title = MSG(M_ATTACHMENTSHEADER);

  page += "<center><br />\n<table ";
  if (!uploaddir)
    page += "width=\"50%\"";
  page += "><tr>";

  if (uploaddir) {
    page += "<th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
    page += MSG(M_ADDFILEASATTACHMENT) + "</font></th>";
  }

  page += "<th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += MSG(M_UPLOADATTACHMENT) + "</font></th></tr>\n<tr>";

  if (uploaddir) {
    page += "<td width=\"50%\" bgcolor=\"&imho_tdbgcolor;\"><form target=\"" + id->misc->camas->target;
    page += "\" method=\"post\" action=\"" + id->misc->camas->nexttarget + "\">";
    page += "<select name=\"attachments\" multiple size=\"3\">";

    if (!sizeof (CSESSION->files))
      page += "<option value=\"-1\">(" + MSG(M_NOATTACHFILES) + ")</option>";
    else {
      int i = 0;
      foreach (CSESSION->files, mapping file) {
        page += "<option value=\"" + (string)i + "\">" + HTML_ENCODE_STRING (file->fname);
        page += "</option>";
        i++;
      }
    }

    page += "</select><br />\n";
    page += CAMAS.Tools.formdrawbutton(id,"m_addmarkedtoattachments", "actionaddfileattachment", MSG(M_ADDMARKEDTOATTACHMENTS));
    page += "</form></td>";
  }

  page += "<td width=\"50%\" bgcolor=\"&imho_tdbgcolor;\"><form name=\"imhouploadform\" target=\"" + id->misc->camas->target;
  page += "\" method=\"post\" enctype=\"multipart/form-data\" action=\"" + id->misc->camas->nexttarget + "\"><br />\n";
  page += "<input name=\"file\" type=\"file\">";

  if (id->supports->javascript)
    page += "<input type=\"hidden\" name=\"fixedfilename\" value=\"\" /><br />\n";
  else
    page += "<br />\n" + MSG(M_WINDOWSBUG);

  page += "<br />\n<input type=\"hidden\" name=\"actionuploadattachment\" value=\"1\" />";

  if (id->supports->javascript)
    page += CAMAS.Tools.formdrawbutton(id,"m_uploadtoattachments", "1", MSG(M_UPLOADTOATTACHMENTS),
                                       ([ "OnClick" : "\"document.forms.imhouploadform.fixedfilename.value=document.forms.imhouploadform."
                                       "file.value.replace(/\\\\/g,'\\\\\\\\')\"" ]));
  else
    page += CAMAS.Tools.formdrawbutton(id,"m_uploadtoattachments", "1", MSG(M_UPLOADTOATTACHMENTS));

  page += "</form><br />\n";
  page += "</td></tr>\n</table>";

  if (sizeof (CSESSION->attachments)) {
    int no_att = sizeof (CSESSION->attachments);
    int s = (no_att > 4) ? 4 : ((no_att < 1) ? 1 : no_att);

    page += "<center><form target=\"" + id->misc->camas->target;
    page += "\" action=\"" + id->misc->camas->nexttarget + "\" method=\"post\">";

    string bofh = "<select name=\"attachments\" multiple size=\"" + (string)s + "\">";
    int i = 0;

    foreach (CSESSION->attachments, mapping file) {
      bofh += "<option value=\"" + (string)i + "\">";
      bofh += HTML_ENCODE_STRING (file->fname + " (" + file->size + " bytes)");
      bofh += "</option>";
      i++;
    }
    bofh += "</select>";

    page += bofh;
    page += "<br />";
    page += CAMAS.Tools.formdrawbutton(id,"m_removemarkedattachments", "actionremoveattachment", MSG(M_REMOVEMARKEDATTACHMENTS));
    page += "</form></center>";
  }

  page += "<table><tr><td><form target=\"" + id->misc->camas->target;
  page += "\" method=\"post\" action=\"" + id->misc->camas->nexttarget + "\">";
  page += CAMAS.Tools.formdrawbutton(id,"m_backtocompose", "actioncontinuecompose", MSG(M_BACKTOCOMPOSE));
  page += "</form></td></tr>\n</table></center>";
  page +=DD;
  RCDEBUG("Attachement screen RXML code : "+page);
  return page;
}

// ------------------ Addressbook screen
//! method: string addressbook(object id, int feature_editaddressbook, gabook)
//!  Addressbook Screen call for CAMAS
//! returns:
//!  Function called when address book is needed (main menu or when composing
//!  a mail). Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
//! arg: int feature_editaddressbook
//!  If addressbook is enabled
//! arg: int gabook
//!  If global addressbook is enabled
string addressbook (object id, int feature_editaddressbook, int gabook) {
  string page = "";

  CDEBUG("Addressbook screen called");
  CSESSION->screen = "addressbook";
  CSESSION->title = MSG(M_ADDRESSBOOKTITLE);

  page += "<form target=\"" + id->misc->camas->target;
  page += "\" method=\"post\" action=\"" + id->misc->camas->nexttarget + "\">";
  page += "<table width=\"100%\"><tr>";
  page += "<th class=\"name\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += (CSESSION->recipientfield ? MSG(M_INDEXNAMERECIPIENT) : MSG(M_INDEXNAMEEDIT)) + "</font></th>";
  page += "<th class=\"address\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += MSG(M_ADDRESS) + "</font></th></tr>";

  int i = 0;
  if (!sizeof (CSESSION->addressbook))
    page += "<tr><td>" + MSG(M_NOADDRESSES) + "</td></tr>";
  else {
    foreach (CSESSION->addressbook / "\n", string line) {
      string name = "", address = "";
      if (sscanf (line, "%s:%s", name, address) == 2) {
        page += "<tr><td class=\"name\" bgcolor=\"&imho_tdbgcolor;\">";
        if (CSESSION->recipientfield) {
          page += "<a  target=\"" + id->misc->camas->target + "\" href=\"" + id->misc->camas->nexttarget;
          page += "?actionaddrecipient=1&address=" + HTTP_ENCODE_URL (address) + "\">";
          page += CAMAS.Tools.fix_header (name) + "</a>";
        }
        else {
          if (feature_editaddressbook) {
            page += "<a  target=\"" + id->misc->camas->target + "\" href=\"" + id->misc->camas->nexttarget;
            page += "?actioneditaddress=1&address=" + (string)i + "\">";
            page += CAMAS.Tools.fix_header (name) + "</a>";
          }
          else
            page += CAMAS.Tools.fix_header (name);
        }
        page += "</td><td class=\"address\" bgcolor=\"&imho_tdbgcolor;\">";
        page += replace (CAMAS.Tools.fix_header (address), ",", "<br />") + "</td></tr>";
      }
      i++;
    }
  }

  if (gabook) {
    object global_abook = id->conf->get_provider("camas_gabook");
    if (objectp(global_abook) && (sizeof(global_abook->global_addressbook)>0)) {
      page += "<tr><td class=\"name\" bgcolor=\"&imho_tdbgcolor;\">";
      page += "<b>" + MSG(M_GLOBALADDRESSES) + "</b></td></tr>";
      foreach (global_abook->global_addressbook / "\n", string line) {
        string name = "", address = "";
        if (sscanf (line, "%s:%s", name, address) == 2) {
          page += "<tr><td class=\"name\" bgcolor=\"&imho_tdbgcolor;\">";
          if (CSESSION->recipientfield) {
            page +="<a  target=\"" + id->misc->camas->target + "\" href=\"" + id->misc->camas->nexttarget;
            page += "?actionaddrecipient=1&address=" + HTTP_ENCODE_URL (address) + "\">";
            page += CAMAS.Tools.fix_header (name) + "</a>";
          }
          else
            page += CAMAS.Tools.fix_header (name);

          page += "</td><td class=\"address\" bgcolor=\"&imho_tdbgcolor;\">";
          page += replace (CAMAS.Tools.fix_header (address), ",", "<br />") + "</td></tr>";
          i++;
        }
      }
    }
  }

  page += "</table>";
  if (feature_editaddressbook)
    page += CAMAS.Tools.formdrawbutton(id,"m_newaddress", "actionnewaddress", MSG(M_NEWADDRESS)+"...");
  page += CAMAS.Tools.formdrawbutton(id,"m_importaddressbook", "actiongotoimportaddress", MSG(M_IMPORTADDRESSBOOK)+"...");
  if (sizeof (CSESSION->addressbook))
    page += CAMAS.Tools.formdrawbutton(id,"m_deletealladdress", "actiondeletealladdress", MSG(M_DELETEALLADDRESS));
  page += "</form><br />";

  page += DD;
  RCDEBUG("Addressbook screen RXML code : "+ page);

  return page;
}


// ------------------ Addressbook screen (multiple selection)
//! method: string addressbook2(object id, int gabook)
//!  Addressbook Screen with multiple selection call for CAMAS
//! returns:
//!  Function called when address book is needed (main menu or when composing
//!  a mail). Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
//! arg: int gabook
//!  If Global Addressbook is enabled
string addressbook2 (object id, int gabook) {
  string page = "";

  CDEBUG("AddressBook2 screen called");

  CSESSION->screen = "addressbook";
  CSESSION->title = MSG(M_ADDRESSBOOKTITLE);

  page += "<form method=\"post\" action=\"" + id->misc->camas->nextpage + "\">";
  page += "<table width=\"100%\"><tr>";
  page += "<th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" + MSG(M_TO) + "</font></th>";
  page += "<th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" + MSG(M_CC) + "</font></th>";
  page += "<th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" + MSG(M_BCC) + "</font></th>";
  page += "<th class=\"name\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" + MSG(M_INDEXNAME);
  page += "</font></th>";
  page += "<th class=\"address\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" + MSG(M_ADDRESS);
  page += "</font></th></tr>";

  int i = 0;
  if (!sizeof (CSESSION->addressbook))
    page += "<tr><td>" + MSG(M_NOADDRESSES) + "</td></tr>";
  else {
    foreach (CSESSION->addressbook / "\n", string line) {
      string name = "", address = "";
      if (sscanf (line, "%s:%s", name, address) == 2) {
        page += "<tr>";
        page += "<td align=\"center\"><input type=\"checkbox\" name=\"recipient_to_" + i + "\"></td>";
        page += "<td align=\"center\"><input type=\"checkbox\" name=\"recipient_cc_" + i + "\"></td>";
        page += "<td align=\"center\"><input type=\"checkbox\" name=\"recipient_bcc_" + i + "\"></td>";
        page += "<td class=\"name\" bgcolor=\"&imho_tdbgcolor;\">";
        page += CAMAS.Tools.fix_header (name);
        page += "</td><td class=\"address\" bgcolor=\"&imho_tdbgcolor;\">";
        page += "<input type=\"hidden\" name=\"address_" + i + "\" value=\"" + address + "\">";
        page += replace (CAMAS.Tools.fix_header (address), ",", "<br />") + "</td></tr>";
        i++;
      }
    }

    if (gabook) {
      object global_abook = id->conf->get_provider("camas_gabook");
      if (objectp(global_abook) && (sizeof(global_abook->global_addressbook)>0)) {
        page += "<tr><td colspan=\"5\" class=\"name\" bgcolor=\"&imho_tdbgcolor;\">";
        page += "<b>" + MSG(M_GLOBALADDRESSES) + "</b></td></tr>";
        foreach (global_abook->global_addressbook / "\n", string line) {
          string name = "", address = "";
          if (sscanf (line, "%s:%s", name, address) == 2) {
            page += "<tr>";
            page += "<td align=\"center\"><input type=\"checkbox\" name=\"recipient_to_" + i + "\"></td>";
            page += "<td align=\"center\"><input type=\"checkbox\" name=\"recipient_cc_" + i + "\"></td>";
            page += "<td align=\"center\"><input type=\"checkbox\" name=\"recipient_bcc_" + i + "\"></td>";
            page += "<td class=\"name\" bgcolor=\"&imho_tdbgcolor;\">";
            page += CAMAS.Tools.fix_header (name);
            page += "</td><td class=\"address\" bgcolor=\"&imho_tdbgcolor;\">";
            page += "<input type=\"hidden\" name=\"address_" + i + "\" value=\"" + address + "\">";
            page += replace (CAMAS.Tools.fix_header (address), ",", "<br />") + "</td></tr>";
            i++;
          }
        }
      }
    }
  }

  page += "</table>";
  page += CAMAS.Tools.formdrawbutton(id,"m_addrecipients", "actionaddrecipients", MSG(M_ADDRECIPIENTS));
  page += CAMAS.Tools.formdrawbutton(id,"m_backtocompose", "actioncontinuecompose", MSG(M_BACKTOCOMPOSE));
  page += "</form><br />";

  page += DD;
  RCDEBUG("AddressBook2 screen RXML code : "+page);

  return page;
}

// ------------------ LDAP search results screen
//! method: string ldapresult(object id, int showou)
//!  LDAP search results call for CAMAS
//! returns:
//!  Function called when LDAP results is needed when composing
//!  a mail. Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
//! arg: int showou
//!  Show LDAP 'ou' if enabled
string ldapresult (object id, int showou) {
  string page = "";

  CDEBUG("LDAP Result screen called");
  CSESSION->screen = "ldapresult";
  CSESSION->title = MSG(M_LDAPTITLE);

  page += "<table width=\"100%\"><tr>";
  page += "<th class=\"name\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += (CSESSION->recipientfield ? MSG(M_INDEXNAMERECIPIENT) : MSG(M_INDEXNAMEEDIT)) + "</font></th>";
  page += "<th class=\"address\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += MSG(M_ADDRESS) + "</font></th>";
  if (showou)
    page += "<th class=\"ou\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" + MSG(M_OU) + "</font></th>";
  page += "</tr>";

  if (!sizeof (CSESSION->ldapadd))
    page += "<tr><td>" + MSG(M_NOADDRESSES) + "</td></tr>";
  else {
    foreach (CSESSION->ldapadd / "\n", string line) {
      string name = "", address = "", ou="";
      if (showou) {
        if (sscanf (line, "%s:%s:%s", name, address, ou) == 3) {
          page += "<tr><td class=\"name\" bgcolor=\"&imho_tdbgcolor;\"><a target=\"";
          page += id->misc->camas->target + "\" href=\"" + id->misc->camas->nexttarget;
          page += "?actionaddrecipient=1&address=" + HTTP_ENCODE_URL (address) + "\">";
          page += CAMAS.Tools.fix_header (name) + "</a></td><td class=\"address\" bgcolor=\"&imho_tdbgcolor;\">";
          page += replace (CAMAS.Tools.fix_header (address), ",", "<br />") + "</td>";
          page += "<td class=\"ou\" bgcolor=\"&imho_tdbgcolor;\">";
          page += replace (CAMAS.Tools.fix_header (ou), ",", "<br />") + "</td>";
          page += "</tr>";
        }
      }
      else {
        if (sscanf (line, "%s:%s", name, address) == 2) {
          page += "<tr><td class=\"name\" bgcolor=\"&imho_tdbgcolor;\"><a target=\"";
          page += id->misc->camas->target + "\" href=\"" + id->misc->camas->nexttarget;
          page += "?actionaddrecipient=1&address=" + HTTP_ENCODE_URL (address) + "\">";
          page += CAMAS.Tools.fix_header (name) + "</a></td><td class=\"address\" bgcolor=\"&imho_tdbgcolor;\">";
          page += replace (CAMAS.Tools.fix_header (address), ",", "<br />") + "</td></tr>";
        }
      }
    }
  }
  page += "</table><br />";
  page += "<form>" + CAMAS.Tools.formdrawbutton(id,"m_backtocompose", "actioncontinuecompose", MSG(M_BACKTOCOMPOSE)) + "</form>";
  page += DD;
  RCDEBUG("LDAP Result screen RXML code : "+page);

  return page;
}


// ------------------ LDAP search results screen (multiple selection)
//! method: string ldapresult2(object id, int showou)
//!  LDAP search results with multiple selection call for CAMAS
//! returns:
//!  Function called when LDAP results is needed when composing
//!  a mail. Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
//! arg: int showou
//!  Show LDAP 'ou' when enabled
string ldapresult2 (object id, int showou) {
  string page = "";

  CDEBUG("LDAP Result2 screen called");

  CSESSION->screen = "ldapresult";
  CSESSION->title = MSG(M_LDAPTITLE);

  page += "<form method=\"post\" action=\"" + id->misc->camas->nextpage + "\">";

  page += "<table width=\"100%\"><tr>";
  page += "<th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" + MSG(M_TO) + "</font></th>";
  page += "<th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" + MSG(M_CC) + "</font></th>";
  page += "<th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" + MSG(M_BCC) + "</font></th>";
  page += "<th class=\"name\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += MSG(M_INDEXNAME) + "</font></th>";
  page += "<th class=\"address\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += MSG(M_ADDRESS) + "</font></th>";
  if (showou)
    page += "<th class=\"ou\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" + MSG(M_OU) + "</font></th>";
  page += "</tr>";

  int i = 0;
  if (!sizeof (CSESSION->ldapadd)) {
    page += "<tr><td>" + MSG(M_NOADDRESSES) + "</td></tr>";
    page += "<tr><td>";
    page += CAMAS.Tools.formdrawbutton(id,"m_backtocompose", "actioncontinuecompose", MSG(M_BACKTOCOMPOSE));
    page += "</td></tr></table></form>";
  }
  else {
    foreach (CSESSION->ldapadd / "\n", string line) {
      string name = "", address = "", ou="";
      if (showou) {
        if (sscanf (line, "%s:%s:%s", name, address, ou) == 3) {
          page += "<tr>";
          page += "<td align=\"center\"><input type=\"checkbox\" name=\"recipient_to_" + i + "\"></td>";
          page += "<td align=\"center\"><input type=\"checkbox\" name=\"recipient_cc_" + i + "\"></td>";
          page += "<td align=\"center\"><input type=\"checkbox\" name=\"recipient_bcc_" + i + "\"></td>";
          page += "<td class=\"name\" bgcolor=\"&imho_tdbgcolor;\">";
          page += "<input type=\"hidden\" name=\"address_" + i + "\" value=\"" + address + "\">";
          page += CAMAS.Tools.fix_header (name) + "</td><td class=\"address\" bgcolor=\"&imho_tdbgcolor;\">";
          page += replace (CAMAS.Tools.fix_header (address), ",", "<br />") + "</td>";
          page += "<td class=\"ou\" bgcolor=\"&imho_tdbgcolor;\">";
          page += replace (CAMAS.Tools.fix_header (ou), ",", "<br />") + "</td>";
          page += "</tr>";
        }
      }
      else {
        if (sscanf (line, "%s:%s", name, address) == 2) {
          page += "<tr>";
          page += "<td align=\"center\"><input type=\"checkbox\" name=\"recipient_to_" + i + "\"></td>";
          page += "<td align=\"center\"><input type=\"checkbox\" name=\"recipient_cc_" + i + "\"></td>";
          page += "<td align=\"center\"><input type=\"checkbox\" name=\"recipient_bcc_" + i + "\"></td>";
          page += "<td class=\"name\" bgcolor=\"&imho_tdbgcolor;\">";
          page += "<input type=\"hidden\" name=\"address_" + i + "\" value=\"" + address + "\">";
          page += CAMAS.Tools.fix_header (name) + "</td><td class=\"address\" bgcolor=\"&imho_tdbgcolor;\">";
          page += replace (CAMAS.Tools.fix_header (address), ",", "<br />") + "</td></tr>";
        }
      }
      i++;
    }
    page += "</table>";
    page += CAMAS.Tools.formdrawbutton(id,"m_addrecipients", "actionaddrecipients", MSG(M_ADDRECIPIENTS));
    page += CAMAS.Tools.formdrawbutton(id,"m_backtocompose", "actioncontinuecompose", MSG(M_BACKTOCOMPOSE));
    page += "</form>";
  }
  page += DD;
  RCDEBUG("LDAP Result2 screen RXML code : "+page);

  return page;
}

// ------------------ Mail filters screen
//! method: string mailfilter(object id)
//!  Mail filters screen call for CAMAS
//! returns:
//!  Function called when mail filters is called.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
//! arg: int feature_editfilterbook
//!  Set if edit filterbook is enabled
string mailfilter (object id, int feature_editfilterbook) {
  string page = "";

  CDEBUG("MailFilter screen called");

  CSESSION->screen = "filterbook";
  CSESSION->title = MSG(M_FILTERBOOKTITLE);

  page += "<form target=\"" + id->misc->camas->target;
  page += "\" method=\"post\" action=\"" + id->misc->camas->nexttarget + "\">";
  page += "<table width=\"100%\"><tr>";
  page += "<th class=\"namefield\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += (CSESSION->recipientfield ? MSG(M_INDEXNAMEFIELDFILTER) : MSG(M_INDEXNAMEEDITFIELDFILTER));
  page += "</font></th>";
  page += "<th class=\"filterexpression\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += (CSESSION->recipientfield ? MSG(M_INDEXNAMERECIPIENTFILTER) : MSG(M_INDEXNAMEEDITFILTER));
  page += "</font></th>";
  page += "<th class=\"filterfolder\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += MSG(M_ADDRESSFILTER) + "</font></th></tr>";

  if (!sizeof (CSESSION->filterbook))
    page += "<tr><td>" + MSG(M_NOADDRESSESFILTER) + "</td></tr>";
  else {
    int i = 0;
    foreach (CSESSION->filterbook / "\n", string line) {
      string namefield = "", filterexpression = "", filterfolder = "";
      if (sscanf (line, "%s:%s:%s", namefield, filterexpression, filterfolder) == 3) {
        page += "<tr><td class=\"namefield\" bgcolor=\"&imho_tdbgcolor;\">";
        page += "<a target=\"" + id->misc->camas->target + "\" href=\"" + id->misc->camas->nexttarget;
        page += "?actioneditaddressfilter=1&namefield=" + (string)i + "\">";
        page += CAMAS.Tools.fix_header (namefield) + "</a>";

        page += "</td><td class=\"filterexpression\" bgcolor=\"&imho_tdbgcolor;\">";
        page += "<a target=\"" + id->misc->camas->target + "\" href=\"" + id->misc->camas->nexttarget;
        page += "?actioneditaddressfilter=1&namefield=" + (string)i + "\">";
        page += CAMAS.Tools.fix_header (filterexpression) + "</a>";

        page += "</td><td class=\"filterfolder\" bgcolor=\"&imho_tdbgcolor;\">";
        page += "<a target=\"" + id->misc->camas->target + "\" href=\"" + id->misc->camas->nexttarget;
        page += "?actioneditaddressfilter=1&namefield=" + (string)i + "\">";
        page += CAMAS.Tools.fix_header (filterfolder)+"</a>";
        page += "</td></tr>";

        i++;
      }
    }
  }

  page += "</table>";
  if (feature_editfilterbook)
    page += CAMAS.Tools.formdrawbutton(id,"m_newfilter", "actionnewaddressfilter", MSG(M_NEWADDRESSFILTER)+"...");
  page += "</form><br />";
  page += DD;
  RCDEBUG("FilterBook screen RXML code : "+page);

  return page;
}

// ------------------ LDAP search screen
//! method: string ldapsearch(object id)
//!  LDAP search screen call for CAMAS
//! returns:
//!  Function called when LDAP search is needed when composing
//!  a mail. Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
string ldapsearch (object id) {
  string page = "";

  CDEBUG("LDAP Search screen called");

  CSESSION->screen = "ldapsearch";
  CSESSION->title = MSG(M_LDAPTITLE);

  page += "<form target=\"" + id->misc->camas->target;
  page += "\" method=\"post\" action=\"" + id->misc->camas->nexttarget + "\">";
  page += "<center><table><th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += MSG(M_NAMECONT) +"</font></th>";
  page += "<tr><td bgcolor=\"&imho_tdbgcolor;\">";
  page += "<input name=\"namecont\" type=\"text\"> </td></tr>";
  page += "<tr><td bgcolor=\"&imho_tdbgcolor;\">";
  if (CSESSION->recipientfield == "toccbcc")
    page += "<input name=\"actionsearchldaptoccbcc\" type=\"hidden\" value=\"1\">";
  else
    page += "<input name=\"actionsearchldap\" type=\"hidden\" value=\"1\">";
  page += CAMAS.Tools.formdrawbutton(id,"m_searchldap", "", MSG(M_SEARCHLDAP));
  page += "</td></tr></table></center></form>";
  page += DD;
  RCDEBUG("LDAP Search screen RXML code : "+page);

  return page;
}

// ------------------ Import address screen
//! method: string importaddress(object id)
//!  Import address screen results call for CAMAS
//! returns:
//!  Function called when importing an addressbook.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
string importaddress(object id) {
  string page = "";

  CDEBUG("Import address screen called");

  CSESSION->screen = "importaddress";
  CSESSION->title = MSG(M_ADDRESSBOOKTITLE);

  page += "<form target=\"" + id->misc->camas->target;
  page += "\" method=\"post\" enctype=\"multipart/form-data\" action=\"" + id->misc->camas->nexttarget + "\">";
  page += "<center><table><th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += MSG(M_IMPORTADDRESSBOOKTITLE) + "</font></th>";
  page += "<tr><td bgcolor=\"&imho_tdbgcolor;\">";
  page += MSG(M_UPLOADADDRESSBOOK)+":<br />";
  page += "<input name=\"file\" type=\"file\"><br />" + MSG(M_PINELOCATION) + "</td></tr>";
  page += "<tr><td><input type=\"hidden\" name=\"actionoldimportaddress\" value=\"1\">";
  page += CAMAS.Tools.formdrawbutton(id,"m_uploadandimport", "\"\"", MSG(M_UPLOADANDIMPORT));
  page += "</td></tr></table></center></form>";
  page += DD;
  RCDEBUG("Import address screen RXML code : "+page);

  return page;
}

// ------------------ Edit address screen
//! method: string editaddress(object id, int feature_extendedabook)
//!  Edit address screen call for CAMAS
//! returns:
//!  Function called when edit addressbook address is needed.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
//! arg: int feature_extendedabook
//!  If Extended addressbook is enabled.
string editaddress(object id, int feature_extendedabook) {
  string page = "";

  CDEBUG("Edit address screen called");

  CSESSION->screen = "editaddress";
  CSESSION->title = MSG(M_ADDRESSBOOKTITLE);

  page += "<form target=\"" + id->misc->camas->target;
  page += "\" method=\"post\" action=\"" + id->misc->camas->nexttarget + "\">";
  page += "<center><table><tr><th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += ((CSESSION->editaddressmode == "old") ? MSG(M_EDITADDRESS) : MSG(M_ADDADDRESS)) + "</font></th></tr>";
  page += "<tr><td bgcolor=\"&imho_tdbgcolor;\">";
  string name = "", address = "";
  sscanf ((CSESSION->addressbook / "\n")[((int)CSESSION->editaddress)], "%s:%s", name, address);
  string baz = QUERY(layeditaddress);

  if (sizeof (baz)) {
    array imho_from = ({ "$NAME", "$ADDRESS", "$BUTTONSAVE", "$BUTTONDELETE", "$BUTTONCANCEL" });
    array imho_to = ({
                       HTML_ENCODE_STRING (name),
                       HTML_ENCODE_STRING (address),
                       CAMAS.Tools.formdrawbutton(id,"m_saveaddress", "actioneditaddressdone", MSG(M_SAVEADDRESS)),
                       CAMAS.Tools.formdrawbutton(id,"m_deleteaddress", "actiondeleteaddress", MSG(M_DELETEADDRESS)),
                       CAMAS.Tools.formdrawbutton(id,"m_canceladdress", "actioncanceleditaddress", MSG(M_CANCELADDRESS))
                     });
    baz = replace (baz, imho_from, imho_to);

    if (feature_extendedabook) {
      array(string) fn = CSESSION->extendedabook->get_fields ();
      foreach (indices (fn), int i) {
        baz = replace (baz, "$" + fn[i] + "$", HTML_ENCODE_STRING
                       (CSESSION->extendedabook->get_entry (name, fn[i])));
        baz = replace (baz, "%" + fn[i] + "%", HTML_ENCODE_STRING
                       (sprintf ("ebook%d", i)));
      }
    }
    page += baz;
  }
  else {
    page += MSG(M_INDEXNAME) + ":<br /><input name=\"name\" size=\"60\" value=";
    page += HTML_ENCODE_TAG_VALUE (name) + "><br />";
    page += MSG(M_ADDRESSFORMAT) + ":<br /><input name=\"address\" size=\"60\" value=";
    page += HTML_ENCODE_TAG_VALUE (address) + "><br /></td></tr>";
    if (feature_extendedabook) {
      array(string) fn = CSESSION->extendedabook->get_fields ();
      foreach (indices (fn), int i) {
        page += "<tr><td>";
        page += HTML_ENCODE_STRING(fn[i]) + ":<br /><input name=";
        page += HTML_ENCODE_TAG_VALUE(sprintf("ebook%d",i)) + " size=60 value=";
        page += HTML_ENCODE_TAG_VALUE(CSESSION->extendedabook->get_entry (name, fn[i]));
        page += "><br />";
        page += "</td></tr>";
      }
    }
    page += "<tr><td>";
    page += CAMAS.Tools.formdrawbutton(id,"m_saveaddress", "actioneditaddressdone", MSG(M_SAVEADDRESS));
    if (CSESSION->editaddressmode == "old")
      page += CAMAS.Tools.formdrawbutton(id,"m_deleteaddress", "actiondeleteaddress", MSG(M_DELETEADDRESS));
    page += CAMAS.Tools.formdrawbutton(id,"m_canceladdress", "actioncanceleditaddress", MSG(M_CANCELADDRESS));
    page += "</td></tr></table></center>";
  }
  page += "</form>";

  page += DD;
  RCDEBUG("Edit address screen RXML code : "+page);

  return page;
}

// ------------------ Edit mail filter screen
//! method: string editfilter(object id)
//!  Edit filter screen call for CAMAS
//! returns:
//!  Function called when edit filter is needed.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
string editfilter (object id) {
  string page = "";

  CDEBUG("Edit Filter screen called");

  CSESSION->screen = "editaddressfilter";
  CSESSION->title = MSG(M_FILTERBOOKTITLE);

  page += "<form target=\"" + id->misc->camas->target;
  page += "\" method=\"post\" action=\"" + id->misc->camas->nexttarget + "\">";

  string namefield = "", filterexpression = "", filterfolder = "", varfolder = "", varfield = "";
  array fieldsfilters = ({ "From", "Subject", "Date", "To", "Cc" });

  if (CSESSION->editaddressfiltermode == "old")
    sscanf ((CSESSION->filterbook / "\n")[((int)CSESSION->editaddressfilter)], "%s:%s:%s",
            namefield, filterexpression, filterfolder);
  else
    sscanf (CSESSION->newaddressfilter, "%s:%s:%s", namefield, filterexpression, filterfolder);

  if (sizeof (QUERY (layeditaddressfilter))) {
    string baz = QUERY (layeditaddressfilter);
    array imho_from = ({
                         "$INPUTNAMEFIELD",
                         "$INPUTFIELD",
                         "$INPUTNAMEFILTER",
                         "$INPUTFILTER",
                         "$INPUTFOLDER",
                         "$BUTTONFILTERSAVE",
                         "$BUTTONFILTERDELETE",
                         "$BUTTONFILTERCANCEL"
                       });
    varfolder += "<select name=\"filterfolder\"><option value=\"imhonomailbox\">" + MSG(M_SELECTMBOX) + "</option>\n";
    for (int i = 0; i < sizeof (CSESSION->mailboxes); i++) {
      if (!(CSESSION->mailboxes[i][MB_FLAGS_IDX] & MB_NOSELECT)) {
        string mbox = CAMAS.FolderTools.translate_frommboxindex (id, i);
        if (CSESSION->mailboxes[i][MB_FOLDERNAME_IDX] != CSESSION->mailbox[MB_FOLDERNAME_IDX]) {
          if (filterfolder == ("INBOX" + mbox)) {
            varfolder += "<option value=" + HTML_ENCODE_TAG_VALUE (CSESSION->mailboxes[i][MB_FOLDERNAME_IDX]);
            varfolder += " selected>" + HTML_ENCODE_STRING (mbox) + "</option>\n";
          }
          else {
            varfolder += "<option value=" + HTML_ENCODE_TAG_VALUE (CSESSION->mailboxes[i][MB_FOLDERNAME_IDX]) + ">";
            varfolder += HTML_ENCODE_STRING (mbox) + "</option>\n";
          }
        }
      }
    }
    varfolder += "</select>";

    varfield += "<select name=\"namefield\"><option value=\"imhonofield\">" + MSG(M_SELECTFIELD) + "</option>\n";
    foreach (fieldsfilters , string elem)
    if (namefield == elem)
      varfield += "<option value=\"" + elem + "\" selected>" + elem + "</option>\n";
    else
      varfield += "<option value=\"" + elem + "\">" + elem + "</option>\n";
    varfield += "</select>";

    array imho_to = ({
                       "",
                       varfield,
                       "<input name=\"nameexpression\" value=\"\">",
                       "<input name=\"filterexpression\" value=" + HTML_ENCODE_TAG_VALUE (filterexpression) + ">",
                       varfolder,
                       //"<input name=filterfolder value="+HTML_ENCODE_TAG_VALUE(filterfolder)+">",
                       CAMAS.Tools.formdrawbutton(id,"m_savefilter", "actioneditaddressfilterdone", MSG(M_SAVEADDRESSFILTER)),
                       CAMAS.Tools.formdrawbutton(id,"m_deletefilter", "actiondeleteaddressfilter", MSG(M_DELETEADDRESSFILTER)),
                       CAMAS.Tools.formdrawbutton(id,"m_cancelfilter", "actioncanceleditaddressfilter", MSG(M_CANCELADDRESSFILTER))
                     });
    baz = replace (baz, imho_from, imho_to);
    page += baz;
  }
  else {
    page += "<center><table><th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
    page += ((CSESSION->editaddressfiltermode == "old") ? MSG(M_EDITADDRESSFILTER) : MSG(M_ADDADDRESSFILTER));
    page += "</font></th>";
    page += "<tr><td bgcolor=\"&imho_tdbgcolor;\">";
    page += MSG(M_INDEXFIELDFILTER) + ":<br /><input name=\"namefield\" size=\"60\" value=";
    page += HTML_ENCODE_TAG_VALUE (namefield) + "><br />";
    page += MSG(M_INDEXNAMEFILTER) + ":<br /><input name=\"filterexpression\" size=\"60\" value=";
    page += HTML_ENCODE_TAG_VALUE (filterexpression) + "><br />";
    page += MSG(M_FILTERFOLDER) + ":<br /><input name=\"filterfolder\" size=\"60\" value=";
    page += HTML_ENCODE_TAG_VALUE (filterfolder) + "><br /></td></tr>";
    page += "<tr><td>";
    page += CAMAS.Tools.formdrawbutton(id,"m_savefilter", "actioneditaddressfilterdone", MSG(M_SAVEADDRESSFILTER));
    if (CSESSION->editaddressfiltermode == "old")
      page += CAMAS.Tools.formdrawbutton(id,"m_deletefilter", "actiondeleteaddressfilter", MSG(M_DELETEADDRESSFILTER));
    page += CAMAS.Tools.formdrawbutton(id,"m_cancelfilter", "actioncanceleditaddressfilter", MSG(M_CANCELADDRESSFILTER));
    page += "</td></tr></table></center>";
  }
  page += "</form>";
  page += DD;
  RCDEBUG("Edit Filter screen RXML code : "+page);

  return page;
}


// ------------------ Mail index screen
//! method: string mailindex(object id, string defaultmailpath, int feature_mailboxes)
//!  Mailindex screen call for CAMAS
//! returns:
//!  Function called when mailindex address is needed.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
//! arg: string defaultmailpath
//!  The default IMAP mail folder path (from CIF)
//! arg: int feature_mailboxes
//!  If mailboxes option is enabled
//! arg: string deletemethod
//!  The way how is handled deleting mail (Features options)
string mailindex(object id,string defaultmailpath, int feature_mailboxes, string deletemethod, int feature_delaystepnumber, string indexdelayformat, string indexdateshortformat, string indexdatelongformat) {
  string page = "";
  mapping args = ([ ]);
  mapping vars = ([ ]);
  object camas_main = id->conf->get_provider("camas_main");	// For date subsystem...

  CDEBUG("Mailindex screen called");
  if (!objectp(camas_main)) CDEBUG("Wow ! Camas Main module not here... ? What the hell ?");

  int in_drafts = (CSESSION->mailbox[MB_FOLDERNAME_IDX] == defaultmailpath + CSESSION->draftsfolder);
  CSESSION->screen = "mailindex";
  int mails = sizeof(CSESSION->mails);

  page += "<form method=\"post\" target=\"" + id->misc->camas->uptarget;
  page += "\" action=\"" + id->misc->camas->nextuptarget + "\">";

  if (CSESSION->searchstring && strlen (CSESSION->searchstring))
  {
    page += "<div class=\"search\">" + MSG(M_SEARCHSHOWINGMAIL) + CAMAS.Tools.fixstring(CSESSION->searchstring) + ":<br /></div>";
    if(CSESSION->nothingfound)
    {
      page += "<b><div class=\"search\">" + MSG(M_NOSEARCHRESULTS) + "</div></b>";
      CSESSION->searchstring = "";
    }
  }

  if (mails) {
    if (CSESSION->mailssortcolumn && (CSESSION->mailssortcolumn != CSESSION->sortcolumn)) {
      CSESSION->mailssortcolumn = CSESSION->sortcolumn;
      mapping colvals = ([ ]);

      for (int i = 0; i < mails; i++) {
        object mail = CSESSION->mails[i];
        switch (CSESSION->sortcolumn) {

        case "date":
          colvals[CAMAS.DateTools.sortable_date(mail->imap->ENVELOPE[DATE_IDX], mail->imap->INTERNALDATE)
                  + " " + sprintf ("%08d", mail->number)] = i;
          break;

        case "from":
          string from_name, from_addr;
          if (mail->imap->ENVELOPE[FROM_IDX]) {
            from_name = mail->imap->ENVELOPE[FROM_IDX][0][0];
            from_addr = mail->imap->ENVELOPE[FROM_IDX][0][2] + "@" + mail->imap->ENVELOPE[FROM_IDX][0][3];
            from_addr = replace (from_addr, "@.MISSING-HOST-NAME.", "");
          }
          else
            from_name = "-";
          from_name = CAMAS.Tools.fix_header (from_name ? from_name : from_addr);
          colvals[lower_case (from_name) + " " + (string)sprintf ("%08d", mail->number)] = i;
          break;

        case "to":
          string to_name, to_addr;
          if (mail->imap->ENVELOPE[TO_IDX]) {
            //write (sprintf ("to= %O\n", mail->imap->ENVELOPE[TO_IDX]));
            to_name = mail->imap->ENVELOPE[TO_IDX][0][0];
            to_addr = mail->imap->ENVELOPE[TO_IDX][0][2] + "@" + mail->imap->ENVELOPE[TO_IDX][0][3];
            to_addr = replace (to_addr, "@.MISSING-HOST-NAME.", "");
          }
          else
            to_name = "-";
          to_name = CAMAS.Tools.fix_header (to_name ? to_name : to_addr);

          colvals[lower_case (to_name) + " " + (string)sprintf ("%08d", mail->number)] = i;
          break;

        case "subject":
          string nsub, subj = CAMAS.Tools.fix_header (mail->imap->ENVELOPE[SUBJECT_IDX]) || "?";
          while (sscanf (lower_case (subj), "re:%*[ \t]%s", nsub) >= 1)
            subj = nsub;
          colvals[subj + " " + (string)sprintf ("%08d", mail->number)] = i;
          break;

        case "size":
          colvals[sprintf ("%08d", ((int)mail->imap["RFC822.SIZE"]))
                  + " " + (string)sprintf ("%08d", mail->number)] = i;
          break;

        default:
          colvals[(string)sprintf ("%08d", mail->number)] = i;
          break;
        }
      }

      array newmails = allocate (mails);
      array order = sort (indices (colvals));
      for (int t = 0; t < mails; t++)
        newmails[t] = CSESSION->mails[colvals[order[t]]];
      CSESSION->mails = newmails;
    }
    
    if (CSESSION->hasnewmail > 0 || CSESSION->firstvisiblemail < 0 ||
      CSESSION->firstvisiblemail >= mails)
      CSESSION->firstvisiblemail = mails - 1;
    
    int offset = CSESSION->firstvisiblemail%(int)CSESSION->visiblemail;

    // always begin the mail list at the beginning of a page
    if(offset != 0)
      CSESSION->firstvisiblemail -= offset;

    CSESSION->lastvisiblemail = CSESSION->firstvisiblemail + (int)CSESSION->visiblemail - 1;

    if ((CSESSION->lastvisiblemail) >= mails)
      CSESSION->lastvisiblemail = mails - 1;
    
    if (!CSESSION->sessionsortorder)
      CSESSION->sessionsortorder = CSESSION->sortorder;

    string buttons = "", buttons_bottom = "";

    array imho_from = ({ "$MSGDELETEMARKED",
                         "$MSGDELETEALLTRASH",
                         "$MSGMOVETOTRASH",
                         "$MSGDELETEMARKED",
                         "$MSGMOVEMARKED",
                         "$MSGCHANGEMBOX",
                         "$MSGSHOWALLAFTERSEARCH",
                         "$MSGSEARCHMAIL",
                         "$MSGCHECKNEWMAIL",
                         "$MSGMAILNUMBERS" });
    array imho_to;

    if (feature_mailboxes)
    {
      if (CSESSION->mailbox[MB_DISPLAYNAME_IDX] == CSESSION->trashfolder)
      {
        imho_to = ({ CAMAS.Tools.formdrawbutton(id,"m_deletemarked", "actiondelete", MSG(M_DELETEMARKED)) });
        imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_deletealltrash", "actiondeleteall", MSG(M_DELETEALLTRASH)) });
        imho_to += ({ "","" });
      }
      else
      {
        imho_to = ({ "", "" });
        if ((delete_methods[deletemethod]) && sizeof (CSESSION->trashfolder))
        {
          imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_movetotrash", "actiontrash", MSG(M_MOVETOTRASH)) });
        }
        else
        {
          imho_to += ({ "" });
        }
        if (deletemethod != "move to trash" || !sizeof (CSESSION->trashfolder))
          imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_deletemarked", "actiondeleteask", MSG(M_DELETEMARKED)) });
        else
          imho_to += ({ "" });
      }


      string imho_to_movemarked = "";
      imho_to_movemarked += CAMAS.Tools.formdrawbutton(id,"m_movemarked", "actionmove", MSG(M_MOVEMARKED));
      imho_to_movemarked += "<select name=\"mboxmove\"><option value=\"imhonomailbox\">" + MSG (M_SELECTMBOX) + "</option>\n";

      // TODO: We must have methodology for shared.* hierarchy and an option for moving mails across mailboxes
      for(int i=0; i<sizeof(CSESSION->mailboxes); i++){
        //if(CSESSION->mailboxes[i][MB_HIERARCHY_IDX][0] == CSESSION->mailbox[MB_HIERARCHY_IDX][0]){
        // if(CSESSION->mailboxes[i][MB_HIERARCHY_IDX][0]=="INBOX"){
        if (!(CSESSION->mailboxes[i][MB_FLAGS_IDX] & MB_NOSELECT)) {
          if (CSESSION->mailboxes[i][MB_FOLDERNAME_IDX] != CSESSION->mailbox[MB_FOLDERNAME_IDX]) {
            imho_to_movemarked += "<option value=";
            imho_to_movemarked += HTML_ENCODE_TAG_VALUE(CSESSION->mailboxes[i][MB_FOLDERNAME_IDX]);
            imho_to_movemarked += ">" + HTML_ENCODE_STRING(CAMAS.FolderTools.translate_frommboxindex(id,i)) + "</option>\n";
          }
          else{
            if((sizeof(CSESSION->mailboxes[i][MB_HIERARCHY_IDX])==4)){
              if(CSESSION->mailboxes[i][MB_HIERARCHY_IDX][0]==CSESSION->sharedpath && CSESSION->mailboxes[i][MB_HIERARCHY_IDX][1]==CSESSION->mailbox[MB_HIERARCHY_IDX][1] && CSESSION->mailboxes[i][MB_HIERARCHY_IDX][2]==CSESSION->mailbox[MB_HIERARCHY_IDX][2]){
                imho_to_movemarked += "<option value=";
                imho_to_movemarked += HTML_ENCODE_TAG_VALUE(CSESSION->mailboxes[i][MB_FOLDERNAME_IDX]);
                imho_to_movemarked += ">" + HTML_ENCODE_STRING(CSESSION->mailboxes[i][MB_HIERARCHY_IDX][3]) + "</option>\n";
              }
            }
          }
        }
      }

      imho_to_movemarked += "</select>\n";
      imho_to += ({ imho_to_movemarked });

      string imho_to_changembox = "";
      // vida : QUERY(featurechangembox) replaced by imho_to, imho_from
      imho_to_changembox += CAMAS.Tools.formdrawbutton(id,"m_changembox", "actionmailindex", MSG(M_MAILBOXES));
      imho_to_changembox += "<select name=\"mbox\"><option value=\"imhonomailbox\">" + MSG (M_SELECTMBOX) + "</option>\n";

      for (int i = 0; i < sizeof (CSESSION->mailboxes); i++)
      {
        if (!(CSESSION->mailboxes[i][MB_FLAGS_IDX] & MB_NOSELECT))
        {
          string mbox;
          if (CSESSION->mailboxes[i][MB_FOLDERNAME_IDX] != CSESSION->mailbox[MB_FOLDERNAME_IDX])
          {
            mbox = CAMAS.FolderTools.translate_frommboxindex (id, i);
            imho_to_changembox += "<option value=";
            imho_to_changembox += HTML_ENCODE_TAG_VALUE (CSESSION->mailboxes[i][MB_FOLDERNAME_IDX]);
            imho_to_changembox += ">" + HTML_ENCODE_STRING (mbox) + "</option>\n";
          }
        }
      }
      imho_to_changembox += "</select>\n";
      imho_to += ({ imho_to_changembox });
    }
    else
      imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_deletemarked", "actiondeleteask", MSG(M_DELETEMARKED)), "", "", "", "", "" });
    if(CSESSION->searchstring && sizeof(CSESSION->searchstring) > 0 &&
        CSESSION->nothingfound == 0)
      imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_showallaftersearch","actionreload", MSG(M_SHOWALLAFTERSEARCH)) });
    else
      imho_to += ({ "" });
    imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_searchmail", "actionsearchmail", MSG(M_SEARCHMAIL)+"...") });
    imho_to += ({ CAMAS.Tools.formdrawbutton(id,"m_checknewmail", "actionreload", MSG(M_CHECKNEWMAIL)) });

    string mailnumbers = "";
    if (mails > (int)CSESSION->visiblemail) {
      mailnumbers += "<table border=\"0\"><tr><td>";

      string mnrs = sprintf ("<b class=\"mailnumbers\">[%d-%d]</b>", CSESSION->firstvisiblemail + 1, CSESSION->lastvisiblemail + 1);
      int i = CSESSION->firstvisiblemail;
      while (i > 0) {
        i -= (int)CSESSION->visiblemail;
        if (i < 0)
          i = 0;
        int t = (((i + (int)CSESSION->visiblemail) >= mails) ? (mails - 1) : (i + (int)CSESSION->visiblemail - 1));
        mnrs = "<a class=\"mailnumbers\" href=\"" + id->misc->camas->nextpage + "?actiongotoblock=1&msg="
               + i + "\">" + sprintf ("[%d-%d]</a> ", (i + 1), (t + 1)) + mnrs;
      }
      i = CSESSION->firstvisiblemail + (int)CSESSION->visiblemail;

      while (i < mails) {
        int t = (((i + (int)CSESSION->visiblemail) >= mails) ? (mails - 1) : (i + (int)CSESSION->visiblemail - 1));
        mnrs += " <a class=\"mailnumbers\" href=\"" + id->misc->camas->nextpage + "?actiongotoblock=1&msg=";
        mnrs += ((string)i) + "\">" + sprintf ("[%d-%d]</a>", (i + 1), (t + 1));
        i += (int)CSESSION->visiblemail;
      }

      mailnumbers += mnrs + " ";
      mnrs = "";
      if (CSESSION->firstvisiblemail > 0) {
        mailnumbers += " <a class=\"mailnumbers\" href=\"" + id->misc->camas->nextpage + "?actionprevblock=1\">";
        mailnumbers += HTML_ENCODE_STRING (MSGA (M_BACKN, ({ (int)CSESSION->visiblemail }))) + "</a>";
      }
      if ((CSESSION->lastvisiblemail + 1) < mails) {
        mailnumbers += " <a class=\"mailnumbers\" href=\"" + id->misc->camas->nextpage + "?actionnextblock=1\">";
        mailnumbers += HTML_ENCODE_STRING (MSGA (M_FORWARDN, ({ (int)CSESSION->visiblemail }))) + "</a>";
      }
      mailnumbers += "</td></tr>\n</table>";
      imho_to += ({ mailnumbers });
    }
    else
      imho_to += ({ "" });
    if (!CSESSION->notopbuttons)
      page +=  replace (QUERY (layindextop), imho_from, imho_to);

    // the index itself
    page += "<table border=\"0\" width=\"100%\"><tr>";

    array columns;
    if (!CSESSION->columns)
      columns = ({ "num", "mark", "history", "date", "fromto", "subject" });
    else {
      columns = Array.map (CSESSION->columns / ",", lower_case);
      if (!has_value (columns, "mark"))
        columns = ({ "mark" }) + columns;
      if (!has_value (columns, "subject"))
        columns += ({ "subject" });
    }

    columns = replace (columns,
                       "fromto",
                       ((CSESSION->mailbox[MB_DISPLAYNAME_IDX] == CSESSION->sentfolder) || in_drafts) ? "to" : "from");

    string sortarrow = "<a href=\"" + id->misc->camas->nextpage + "?actiontogglesortorder=1\">";
    sortarrow += "<imho_image fg=\"&imho_thcolor;\" bg=\"&imho_thbgcolor;\" border=\"0\" src=";
    if (CSESSION->sessionsortorder == "forward")
      sortarrow += "\"&imhoarrowdownsrc;\" image=\"arrowdown\"";
    else
      sortarrow += "\"&imhoarrowupsrc;\" image=\"arrowup\"";
    sortarrow += " alt=\"" + MSG(M_CHANGESORTORDER) + "\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";

    foreach (columns, string column) {
      switch (column) {

      case "num":
        page += "<th class=\"num\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\">";
        if (CSESSION->sortcolumn == column)
          page += sortarrow;
        else
          page +=
            "<a href=\"" + id->misc->camas->nextpage + "?actionchangesort=1" +
            "&col=" + column + "\"><imho_image fg=\"&imho_thcolor;\"" +
            " bg=&imho_thbgcolor; border=0" +
            " image=\"arrownone\" alt=\"" + MSG(M_CHANGESORTORDER) +
            "\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";
        page += "<font class=\"num\" color=\"&imho_thcolor;\">" + MSG(M_NUMBER) + "</font></th>";
        break;

      case "mark":
        page += "<th class=\"mark\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\">";
        page += "<font class=\"mark\" color=\"&imho_thcolor;\">" + MSG(M_MARKFLAG) + "</font></th>";
        break;

      case "history":
        page += "<th class=\"history\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\">";
        page += "<font class=\"history\" color=\"&imho_thcolor;\">" + MSG(M_HISTFLAG) + "</font></th>";
        break;

      case "new":
        if(QUERY(shownew))
        {
          page += "<th class=\"new\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\">";
          page += "<font class=\"new\" color=\"&imho_thcolor;\">" + MSG(M_NEWFLAG) + "</font></th>";
        }
        break;

      case "answered":
        if(QUERY(showanswered))
        {
          page += "<th class=\"answered\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\">";
          page += "<font class=\"answered\" color=\"&imho_thcolor;\">" + MSG(M_ANSWEREDFLAG) + "</font></th>";
        }
        break;

      case "date":
        page += "<th class=\"date\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\">";
        if (CSESSION->sortcolumn == column)
          page += sortarrow;
        else
          page +=
            "<a href=\"" + id->misc->camas->nextpage + "?actionchangesort=1" +
            "&col=" + column + "\"><imho_image fg=\"&imho_thcolor;\"" +
            " bg=\"&imho_thbgcolor;\" border=\"0\"" +
            " image=\"arrownone\" alt=\"" + MSG(M_CHANGESORTORDER) +
            "\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";
        page += "<font class=\"date\" color=\"&imho_thcolor;\">" + MSG(M_DATE);
        if(QUERY(featuredelay))
          page += "&nbsp;(" + MSG(M_DELAY) + ")";
        page += "</font></th>";
        break;
      case "from":
        page += "<th class=\"from\" bgcolor=\"&imho_thbgcolor;\" width=\"20%\" valign=\"middle\">";
        if (CSESSION->sortcolumn == column)
          page += sortarrow;
        else
          page +=
            "<a href=\"" + id->misc->camas->nextpage + "?actionchangesort=1" +
            "&col=" + column + "\"><imho_image fg=\"&imho_thcolor;\"" +
            " bg=\"&imho_thbgcolor;\" border=\"0\"" +
            " image=\"arrownone\" alt=\"" + MSG(M_CHANGESORTORDER) +
            "\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";
        page += "<font class=\"from\" color=\"&imho_thcolor;\">" + MSG(M_FROM) + "</font></th>";
        break;

      case "to":
        page += "<th class=\"to\" bgcolor=\"&imho_thbgcolor;\" width=\"20%\" valign=\"middle\">";
        if (CSESSION->sortcolumn == column)
          page += sortarrow;
        else
          page +=
            "<a href=\"" + id->misc->camas->nextpage + "?actionchangesort=1" +
            "&col=" + column + "\"><imho_image fg=\"&imho_thcolor;\"" +
            " bg=\"&imho_thbgcolor;\" border=\"0\"" +
            " image=\"arrownone\" alt=\"" + MSG(M_CHANGESORTORDER) +
            "\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";
        page += "<font class=\"to\" color=\"&imho_thcolor;\">" + MSG(M_TO) + "</font></th>";
        break;

      case "subject":
        page += "<th class=\"subject\" bgcolor=\"&imho_thbgcolor;\" width=\"60%\" valign=\"middle\">";
        if (CSESSION->sortcolumn == column)
          page += sortarrow;
        else
          page +=
            "<a href=\"" + id->misc->camas->nextpage + "?actionchangesort=1" +
            "&col=" + column + "\"><imho_image fg=\"&imho_thcolor;\"" +
            " bg=\"&imho_thbgcolor;\" border=\"0\"" +
            " image=\"arrownone\" alt=\"" + MSG(M_CHANGESORTORDER) +
            "\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";
        page += "<font class=\"subject\" color=\"&imho_thcolor;\">" + MSG(M_SUBJECT) + "</font></th>";
        break;

      case "size":
        page += "<th class=\"size\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\">";
        if (CSESSION->sortcolumn == column)
          page += sortarrow;
        else
          page +=
            "<a href=\"" + id->misc->camas->nextpage + "?actionchangesort=1" +
            "&col=" + column + "\"><imho_image fg=\"&imho_thcolor;\"" +
            " bg=\"&imho_thbgcolor;\" border=\"0\"" +
            " image=\"arrownone\" alt=\"" + MSG(M_CHANGESORTORDER) +
            "\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";
        page += "<font class=\"size\" color=\"&imho_thcolor;\">" + MSG(M_SIZE) + "</font></th>";
        break;
      }
      page += "\n";
    }
    page += "</tr>\n";

    if (CSESSION->sortcolumn == "num") { // range select only works in mailbox order

      if ((CSESSION->firstvisiblemail > 0) && (CSESSION->sessionsortorder == "forward")) {
        page += "<tr>";
        foreach (columns, string column) {
          switch (column) {

          case "num":
            page += "<td class=\"num\" bgcolor=\"&imho_tdbgcolor;\">1-";
            page += (string)((int)CSESSION->firstvisiblemail) + "</td>";
            break;

          case "mark":
            page += "<td class=\"mark\" bgcolor=\"&imho_tdbgcolor;\">";
            page += "<input type=\"checkbox\" name=\"msg";
            page += (string)CSESSION->mails[0]->imap->UID + "-";
            page += CSESSION->mails[(int)CSESSION->firstvisiblemail - 1]->imap->UID;
            page += "\" value=\"1\" /></td>";
            break;

          case "subject":
            page += "<td class=\"subject\" bgcolor=\"&imho_tdbgcolor;\">";
            page += MSGA (M_MAILSHOWN, ({ 1, CSESSION->firstvisiblemail, mails })) + "</td>";
            break;

          case "new":
            if(QUERY(shownew))
              page += "<td class=\"" + column + "\" bgcolor=\"&imho_tdbgcolor;\">&nbsp;</td>";
            break;

          case "answered":
            if(QUERY(showanswered))
              page += "<td class=\"" + column + "\" bgcolor=\"&imho_tdbgcolor;\">&nbsp;</td>";
            break;

          default:
            page += "<td class=\"" + column + "\" bgcolor=\"&imho_tdbgcolor;\">&nbsp;</td>";
            break;
          }
          page += "\n";
        }
        page += "</tr>\n";
      }

      if (((CSESSION->lastvisiblemail + 1) < mails) && (CSESSION->sessionsortorder != "forward")) {
        page += "<tr>";
        foreach (columns, string column) {
          switch (column) {

          case "num":
            page += "<td class=\"num\" bgcolor=\"&imho_tdbgcolor;\">";
            page += (string)((int)CSESSION->lastvisiblemail + 2) + "-";
            page += (string)((int)mails) + "</td>";
            break;

          case "mark":
            page += "<td class=\"mark\" bgcolor=\"&imho_tdbgcolor;\">";
            page += "<input type=\"checkbox\" name=\"msg";
            page += CSESSION->mails[((int)CSESSION->lastvisiblemail + 1)]->imap->UID + "-";
            page += CSESSION->mails[((int)mails - 1)]->imap->UID + "\" value=\"1\" /></td>";
            break;

          case "subject":
            page += "<td class=\"subject\" bgcolor=\"&imho_tdbgcolor;\">";
            page += MSGA (M_MAILSHOWN, ({ CSESSION->lastvisiblemail + 2, mails, mails })) + "</td>";
            break;

          case "new":
            if(QUERY(shownew))
              page += "<td class=\"" + column + "\" bgcolor=\"&imho_tdbgcolor;\">&nbsp;</td>";
            break;

          case "answered":
            if(QUERY(showanswered))
              page += "<td class=\"" + column + "\" bgcolor=\"&imho_tdbgcolor;\">&nbsp;</td>";
            break;

          default:
            page += "<td class=\"" + column + "\" bgcolor=\"&imho_tdbgcolor;\">&nbsp;</td>";
            break;
          }
          page += "\n";
        }
        page += "</tr>\n";
      }
    }

    int frommail, tomail, deltamail;
    if (CSESSION->sessionsortorder == "forward") {
      frommail = CSESSION->firstvisiblemail;
      tomail = CSESSION->lastvisiblemail + 1;
      deltamail = 1;
    }
    else {
      tomail = CSESSION->firstvisiblemail - 1;
      frommail = CSESSION->lastvisiblemail;
      deltamail = -1;
    }

    for (int i = frommail; i != tomail; i+=deltamail) {
      string from_name, from_addr;
      object mail = CSESSION->mails[i];
      page += "<tr>";
      // New mail?
      int unseen = !has_value (mail->imap->FLAGS, "\\Seen");
      foreach (columns, string column) {
        switch (column) {
        case "num":
          page += "<td class=\"" + (unseen ? "h" : "") + "num\" bgcolor=\"&imho_tdbgcolor;\"><b>";
          page += (string)(CSESSION->mails[i]->number + 1) + "</b></td>";
          break;

        case "mark":
          page += "<td class=\"" + (unseen ? "h" : "") + "mark\" bgcolor=\"&imho_tdbgcolor;\">";
          page += "<input type=\"checkbox\" name=\"msg";
          page += (string)CSESSION->mails[i]->imap->UID + "\" value=\"1\" />";
          page += "</td>";
          break;

        case "history":
          from_addr = mail->imap->ENVELOPE[FROM_IDX][0][2] + "@" + mail->imap->ENVELOPE[FROM_IDX][0][3];
          from_addr = replace (from_addr, "@.MISSING-HOST-NAME.", "");
          page += "<td class=\"history\" bgcolor=\"&imho_tdbgcolor;\">";
          page += "<a href=\""+id->misc->camas->nextuptarget+"?text1="+from_addr+"&searchfield1=from&nohistsearch=1&actionsearchmail.x=10&actionsearchmail.y=10\">";
          page += MSG(M_HISTSEARCH)+"</a></td>";
          break;

        case "new":
          if(QUERY(shownew))
          {
            page += "<td class=\"" + (unseen ? "h" : "") + "new\" bgcolor=\"&imho_tdbgcolor;\" nowrap>";
            page += (unseen ?
                     "<imho_image src=\"&imhochecksrc;\" fg=&imhocheckfg; bg=&imho_tdbgcolor; "
                     "size=&imhochecksize; scale=\"0.25\" image=\"ncheck\" alt=\"X\" />" : " ") + "&nbsp;</td>";
          }
          break;

        case "answered":
          if(QUERY(showanswered))
          {
            page += "<td class=\"" + (unseen ? "h" : "") + "answered\" bgcolor=\"&imho_tdbgcolor;\" nowrap>";
            page += (has_value (mail->imap->FLAGS, "\\Answered") ?
                     "<imho_image src=\"&imhochecksrc;\" fg=&imhocheckfg; bg=&imho_tdbgcolor; "
                     "size=&imhochecksize; scale=\"0.25\" image=\"check\" alt=\"X\" />" : " ") + "&nbsp;</td>";
          }
          break;

        case "date":
          page += "<td class=\"" + (unseen ? "h" : "") + "date\" bgcolor=\"&imho_tdbgcolor;\" nowrap>";
          page += (unseen ? "<b>" : "");

          // TODO: neither show delay if in .sent-mail/.trash/.answered directory
          if(QUERY(featuredelay) && !(QUERY(delayforanswered)) && !has_value(mail->imap->FLAGS,"\\Answered"))
          {
            page += CAMAS.DateTools.mailindex_delay (mail->imap->ENVELOPE[DATE_IDX], mail->imap->INTERNALDATE, feature_delaystepnumber, indexdelayformat);
          }
          else
          {
            page += CAMAS.DateTools.mailindex_date (id, mail->imap->ENVELOPE[DATE_IDX], mail->imap->INTERNALDATE, indexdateshortformat, indexdatelongformat);
          }
          page += (unseen ? "</b>" : "") + "</td>";
          break;

        case "from":
          // From

          array imho_from2 = ({ "$FROMNAME", "$FROMADDR", "$ORGANIZATION" });
          array imho_to2 = ({ });

          string from_name, from_addr;

          if (mail->imap->ENVELOPE[FROM_IDX]) {
            from_name = mail->imap->ENVELOPE[FROM_IDX][0][0];
            from_addr = mail->imap->ENVELOPE[FROM_IDX][0][2] + "@" + mail->imap->ENVELOPE[FROM_IDX][0][3];
            from_addr = replace (from_addr, "@.MISSING-HOST-NAME.", "");
          }
          else
            from_name = "-";

          from_name = CAMAS.Tools.fix_header (from_name ? from_name : from_addr);
          from_addr = CAMAS.Tools.fix_header (from_addr);
          if (QUERY (frommaxlength))
            from_name = CAMAS.Tools.scut(from_name,QUERY (frommaxlength));

          if(from_name){
            imho_to2 += ({ from_name });
          }
          else{
            imho_to2 += ({ "-" });
          }

          if(from_addr){
            imho_to2 += ({ from_addr });
          }
          else{
            imho_to2 += ({ "-" });
          }

          if(CSESSION->organization){
            imho_to2 += ({ CSESSION->organization });
          }
          else{
            imho_to2 += ({ "UNKNOWN" });
          }

          page += "<td class=\"" + (unseen ? "h" : "") + "from\" bgcolor=\"&imho_tdbgcolor;\">";
          page += (unseen ? "<b>" : "");

          if(QUERY(frommaxlength)){
            page += CAMAS.Tools.scut(replace(QUERY(layindexsender), imho_from2, imho_to2),QUERY(frommaxlength));
          }
          else{
            page += replace(QUERY(layindexsender), imho_from2, imho_to2);

          }
          page += (unseen ? "</b>" : "");
          page += "</td>";
          break;

        case "to":
          // To
          string to_name, to_addr;
          if (mail->imap->ENVELOPE[TO_IDX]) {
            to_name = mail->imap->ENVELOPE[TO_IDX][0][0];
            to_addr = mail->imap->ENVELOPE[TO_IDX][0][2] + "@" + mail->imap->ENVELOPE[TO_IDX][0][3];
            to_addr = replace (to_addr,"@.MISSING-HOST-NAME.","");
          }
          else
            to_name = "-";

          to_name = CAMAS.Tools.fix_header (to_name ? to_name : to_addr);
          if (QUERY (frommaxlength))
            to_name = CAMAS.Tools.scut(to_name,QUERY(frommaxlength));

          page += "<td class=\"" + (unseen ? "h" : "");
          page += "to\" bgcolor=\"&imho_tdbgcolor;\">";
          page += (unseen ? "<b>" : "") + to_name + (unseen ? "</b>" : "") + "</td>";
          break;

        case "subject":
          // Subject
          page += "<td class=\"" + (unseen ? "h" : "");
          page += "subject\" bgcolor=\"&imho_tdbgcolor;\">" + (unseen ? "<b>" : "");

	  vars = ([ 
	    "actionread" : "1", 
	    "msguid" : (string)CSESSION->mails[i]->imap->UID,
	    "mbox" : HTTP_ENCODE_URL(CSESSION->mailbox[MB_FOLDERNAME_IDX]),
	  ]);
	  args = ([ ]);
	  args -> target = id->misc->camas->uptarget;
	  args -> href = CAMAS.Tools->make_get_url(id, args, vars);

          string subject = CAMAS.Tools.fix_header (mail->imap->ENVELOPE[SUBJECT_IDX]);
          if (!strlen (subject))
            subject = "?";

          if (QUERY (subjectmaxlength))
            subject = CAMAS.Tools.scut(subject,QUERY(subjectmaxlength));

          if (QUERY (subjectlayer) && id->supports->javascript) 
	  {
	    string jslay_prev, jslay_next;
	    if (id->supports->msie)
	    {
	      jslay_prev = "all.laymsg";
	      jslay_next = ".style";
	    }
	    else
	    {
	      jslay_prev = "layers['laymsg";
	      jslay_next = "']";
	    }
	    args -> onmouseover = 
	      sprintf("window.status='';document.%s%i%s.visibility = 'visible';document.%s%i%s.left = event.x -150;document.%s%i%s.top = event.y - 100;", 
		      jslay_prev, CSESSION->mails[i]->imap->UID, jslay_next,
		      jslay_prev, CSESSION->mails[i]->imap->UID, jslay_next,
		      jslay_prev, CSESSION->mails[i]->imap->UID, jslay_next);
	    args -> onmouseout = 
	      sprintf("document.%s%i%s.visibility = 'hidden'",
		      jslay_prev, CSESSION->mails[i]->imap->UID, jslay_next);
	  }
	  page += CAMAS.Tools.make_container("a", args, subject);
	  page += (unseen ? "</b>" : "") + "</td>";
          break;

        case "size":
          // Size
          page += "<td class=\"" + (unseen ? "h" : "") + "size\" bgcolor=\"&imho_tdbgcolor;\">";
          page += (unseen ? "<b>" : "") + ((string)(((int)mail->imap["RFC822.SIZE"]) / 1024)) + " K";
          page += (unseen ? "</b>" : "") + "</td>";
          break;
        }
        page += "\n";
      }
      page += "</tr>\n";
    }

    if (CSESSION->sortcolumn == "num") { // range select only works in mailbox order
      if ((CSESSION->firstvisiblemail > 0) && (CSESSION->sessionsortorder != "forward")) {
        page += "<tr>";
        foreach (columns, string column) {
          switch (column) {

          case "num":
            page += "<td class=\"num\" bgcolor=\"&imho_tdbgcolor;\">1-";
            page += (string)((int)CSESSION->firstvisiblemail) + "</td>";
            break;

          case "mark":
            page += "<td class=\"mark\" bgcolor=\"&imho_tdbgcolor;\">";
            page += "<input type=\"checkbox\" name=\"msg" + (string)CSESSION->mails[0]->imap->UID + "-";
            page += (string)CSESSION->mails[(int)CSESSION->firstvisiblemail - 1]->imap->UID + "\" value=\"1\" /></td>";
            break;

          case "subject":
            page += "<td class=\"subject\" bgcolor=\"&imho_tdbgcolor;\">";
            page += MSGA (M_MAILSHOWN, ({ 1, CSESSION->firstvisiblemail, mails })) + "</td>";
            break;

          case "new":
            if(QUERY(shownew))
              page += "<td class=\"" + column + "\" bgcolor=\"&imho_tdbgcolor;\">&nbsp;</td>";
            break;

          case "answered":
            if(QUERY(showanswered))
              page += "<td class=\"" + column + "\" bgcolor=\"&imho_tdbgcolor;\">&nbsp;</td>";
            break;

          default:
            page += "<td class=\"" + column + "\" bgcolor=\"&imho_tdbgcolor;\">&nbsp;</td>";
            break;
          }
          page += "\n";
        }
        page += "</tr>\n";
      }

      if (((CSESSION->lastvisiblemail + 1) < mails) && (CSESSION->sessionsortorder == "forward")) {
        page += "<tr>";
        foreach (columns, string column) {
          switch (column) {

          case "num":
            page += "<td class=\"num\" bgcolor=\"&imho_tdbgcolor;\">";
            page += (string)((int) CSESSION->lastvisiblemail + 2) + "-" + (string)((int)mails) + "</td>";
            break;

          case "mark":
            page += "<td class=\"mark\" bgcolor=\"&imho_tdbgcolor;\"><input type=\"checkbox\" name=\"msg";
            page += (string)CSESSION->mails[(int) CSESSION->lastvisiblemail + 1]->imap->UID + "-";
            page += (string)CSESSION->mails[(int)mails - 1]->imap->UID + "\" value=\"1\" /></td>";
            break;

          case "subject":
            page += "<td class=\"subject\" bgcolor=\"&imho_tdbgcolor;\">";
            page += MSGA (M_MAILSHOWN, ({ CSESSION->lastvisiblemail + 2, mails, mails })) + "</td>";
            break;

          case "new":
            if(QUERY(shownew))
              page += "<td class=\"" + column + "\" bgcolor=\"&imho_tdbgcolor;\">&nbsp;</td>";
            break;

          case "answered":
            if(QUERY(showanswered))
              page += "<td class=\"" + column + "\" bgcolor=\"&imho_tdbgcolor;\">&nbsp;</td>";
            break;

          default:
            page += "<td class=\"" + column + "\" bgcolor=\"&imho_tdbgcolor;\">&nbsp;</td>";
            break;
          }
          page += "\n";
        }
        page += "</tr>\n";
      }
    }


    if (id->supports->javascript) {
      page += "<tr><td>&nbsp;</td>";
      page += "<td><div class=\"markall\"><input type=\"checkbox\" name=\"all\" onClick=\"";
      page += " for(var i=0;i<this.form.elements.length;i++)";
      page += " {var inpt=this.form.elements[i];if(inpt.name.substr(0,3)=='msg')";
      page += " inpt.checked=this.form.all.checked}\" /></div></td>";
      int colspan = 4;
      if(QUERY(shownew))
        colspan++;
      if(QUERY(showanswered))
        colspan++;
      page += "<td colspan=\"" + colspan + "\"><div class=\"markall\">" + MSG (M_MARKALL) + "</div></td>";
      page += "</tr></table>";
    }
    page += "<br />\n";

    if (!CSESSION->nobottombuttons) {
      page += replace (QUERY (layindexbottom), imho_from, imho_to);
    }

    page += "</form>";

    if (QUERY (subjectlayer) && id->supports->javascript) {
      if (!id->supports->msie) {
        page += "<script language=\"JavaScript\" type=\"text/javascript\">\n<!--\n";
        page += "document.captureEvents(Event.MOUSEMOVE);\n"
                "document.onMouseMove = MoveHandler;\n"
                "function MoveHandler(e) {\n"
                "Xpos = e.pageX;\n"
                "Ypos = e.pageY;"
                "return true;\n"
                "}\n";
        page += "// -->\n</script>\n";
      }

      for (int i = frommail; i != tomail; i+=deltamail) {
        object mail = CSESSION->mails[i];

        string subject = CAMAS.Tools.fix_header (mail->imap->ENVELOPE[SUBJECT_IDX]);
        if (!strlen (subject))
          subject = "?";

        page += "<div id=\"laymsg";
        page += (string)mail->imap->UID + "\"";
        page += " style=\"position: absolute; z-index: 10; visibility: hidden;";
        page += " top: 0px; left: 0px;\">";
        page += "<table bgcolor=black><tr><td bgcolor=\"yellow\">" + subject + "</td></tr></table>";
        page += "</div>\n";
      }
    }
  }
  else {
    string imho_to_changembox = "";
    array imho_from = ({ "$MSGGETNEWMAIL", "$MSGNOMAILS", "$MSGCHANGEMBOX" });
    array imho_to = ({ CAMAS.Tools.formdrawbutton(id,"m_getnewmail", "actionreload", MSG(M_CHECKNEWMAIL)) });
    if(CSESSION->mailboxes) {
      imho_to += ({ MSG (M_NOMAILS) });
      imho_to_changembox += "<select name=\"mbox\"><option value=\"imhonomailbox\">" + MSG (M_SELECTMBOX) + "</option>\n";
      for (int i = 0; i < sizeof (CSESSION->mailboxes); i++)
      {
        if (!(CSESSION->mailboxes[i][MB_FLAGS_IDX] & MB_NOSELECT))
        {
          string mbox;
          if (CSESSION->mailboxes[i][MB_FOLDERNAME_IDX] != CSESSION->mailbox[MB_FOLDERNAME_IDX])
          {
            mbox = CAMAS.FolderTools.translate_frommboxindex (id, i);
            imho_to_changembox += "<option value=";
            imho_to_changembox += HTML_ENCODE_TAG_VALUE (CSESSION->mailboxes[i][MB_FOLDERNAME_IDX]);
            imho_to_changembox += ">" + HTML_ENCODE_STRING (mbox) + "</option>\n";
          }
        }
      }
      imho_to_changembox += "</select>\n";
      imho_to_changembox += CAMAS.Tools.formdrawbutton(id,"m_changembox", "actionmailindex", MSG(M_MAILBOXES));
      imho_to += ({ imho_to_changembox });
    }
    else
      imho_to += ({ "", "" });
    page += replace (QUERY (layindexnomail), imho_from, imho_to);
    page += "</form>";
  }
  page += DD;
  RCDEBUG("Mailindex screen RXML code : "+page);
  camas_main = 0;	// GC

  return page;
}

// ------------------ Search mail screen
//! method: string searchmail(object id)
//!  Search for mail screen call for CAMAS, deprecated
//! returns:
//!  Function called when searching a mail is needed.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
string searchmail(object id) {
  string page = "";

  CDEBUG("Searchmail screen called")

  CSESSION->screen = "searchmail";
  CSESSION->title = MSG(M_SEARCHMAILTITLE);

  page += "<form target=\"" + id->misc->camas->target;
  page += "\" method=\"post\" action=\"" + id->misc->camas->nexttarget + "\">";
  page += "<center><table><th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
  page += MSG(M_SEARCHMAILTITLE) + "</font></th>";
  page += "<tr><td bgcolor=\"&imho_tdbgcolor;\"><font color=\"red\">Warning: screen deprecated, use Camas "
  "Tags instead</font>";
  page += "</td></tr>";
  page += "<tr><td bgcolor=\"&imho_tdbgcolor;\">";
  page += "<input name=\"text1\" size=\"20\" />";
  page += "<select name=\"searchfield1\">";
  page += "<option value=\"text\" selected>" + MSG(M_SEARCHANYWHERE) + "</option>";
  page += "<option value=\"to\">" + MSG(M_SEARCHTOFIELD) + "</option>";
  page += "<option value=\"from\">" + MSG(M_SEARCHFROMFIELD) + "</option>";
  page += "<option value=\"subject\">" + MSG(M_SEARCHSUBJECT) + "</option>";
  page += "<option value=\"body\">" + MSG(M_SEARCHBODY) + "</option>";
  page += "</select><br /></tr></td>";
  page += "<tr><td bgcolor=\"&imho_tdbgcolor;\"><table width=\"100%\"><tr>";
  page += "<td bgcolor=\"&imho_tdbgcolor;\">";
  page += CAMAS.Tools.formdrawbutton(id,"m_searchmail", "actionsearchmail", MSG(M_SEARCHMAIL)+"...");
  page += "</td></tr></table></td></tr></table></form>";

  page += DD;
  RCDEBUG("Searchmail screen RXML code : "+page);

  return page;
}

// ------------------ Folder list screen
//! method: string folderlist(object id,int foldersinfo)
//!  Folder list screen call for CAMAS
//! returns:
//!  Function called when displaying list of folders is needed.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
//! arg: int foldersinfo
//!  Enable folders infos
string folderlist(object id,int foldersinfo) {
  string page = "";
  CDEBUG("Folderslist screen called.");

  // layout stuff
  string fl_layfolderstop = (sizeof(QUERY(layfolderstop)) ? QUERY(layfolderstop) : DEFAULT_LAYFOLDERSTOP);
  string fl_layfoldersrow = (sizeof(QUERY(layfoldersrow)) ? QUERY(layfoldersrow) : DEFAULT_LAYFOLDERSROW);
  string fl_layfoldersbottom = (sizeof(QUERY(layfoldersbottom)) ? QUERY(layfoldersbottom) : DEFAULT_LAYFOLDERSBOTTOM);

  CSESSION->screen = "folderlist";
  CSESSION->title = MSG(M_MAILBOXES);

  string path = id->variables->path || CSESSION->mailbox[MB_FOLDERNAME_IDX];
  string pathname;
  int deletable_folders = 0;
  int can_create_folders = 1;
  //write("path=%O\n", path);
  // find the currently selected folder
  int mbox_idx = Array.search_array (CSESSION->mailboxes,
                                     lambda (array a, string path) {
                                       if (a[MB_FOLDERNAME_IDX] == path)
                                         return 1;
                                       return 0;
                                     },
                                     path);
  //write("mbox_idx=%d\n", mbox_idx);
  array mbox_path = ({ });

  //write("mbox_idx=%d\n", mbox_idx);
  
  if (mbox_idx == -1) {
    path = "";
    pathname = "";
  }
  else {
    pathname = CSESSION->mailboxes[mbox_idx][MB_DISPLAYNAME_IDX];
    mbox_path = CSESSION->mailboxes[mbox_idx][MB_HIERARCHY_IDX];
    if (CSESSION->mailboxes[mbox_idx][MB_FLAGS_IDX] & MB_IMPLICIT_FOLDER)
      can_create_folders = 0;
  }
  CSESSION->lastpath = path;

  //write("mbox_path=%O\n", mbox_path);
  //write (sprintf ("CSESSION->mailboxes= %O\n", CSESSION->mailboxes));

  // find the mailboxes at the current hierarchy level
  array mboxes_to_show = Array.filter (CSESSION->mailboxes,
                                       lambda (array a, array mbox_path) {
                                         if ((sizeof (a[MB_HIERARCHY_IDX])) <= (sizeof (mbox_path)) ||
					                                  (sizeof (a[MB_HIERARCHY_IDX])) > (sizeof (mbox_path)+1))
                              					 {
					   //write("mailbox %O is NOT ok\n", a[MB_HIERARCHY_IDX]);
                                           return 0;
                              					}
                                        
                                        for (int i = 0; i < sizeof (mbox_path); i++)
                                          if (mbox_path[i] != a[MB_HIERARCHY_IDX][i])
                                				  {
					     //write("mailbox %O is not selectable either\n", a[MB_HIERARCHY_IDX]);
                                             return 0;
                                				  }
					 //write("mailbox %O is ok\n", a[MB_HIERARCHY_IDX]);
                                         return 1;
                                       },
                                       mbox_path);

  if (path != "") { // if we're not at the top level, add a "up" pseudo folder
    array up_folder =
      ({
         ({ "", // foldername
            (CSESSION->mailboxes[mbox_idx][MB_HIERARCHY_IDX][0..sizeof(CSESSION->mailboxes[mbox_idx][MB_HIERARCHY_IDX])-2]) * CSESSION->mailboxes[mbox_idx][MB_SEPARATOR_IDX], // folder to select to go up in the hierarchy
            MB_NOSELECT | MB_PREVIOUS_FOLDER, // flags
            "", // no separator
            ({ MSG(M_PREVIOUS_LEVEL) })
          })
       });
    write (sprintf ("up folder= %O\n", up_folder));
    mboxes_to_show = up_folder + mboxes_to_show;
  }

  //write (sprintf ("mboxes_to_show= %O\n", mboxes_to_show));

  // stene FIXME: merge mailboxes if "folderstyle" is "mailandfolders"
  page += "<form method=\"post\" action=\""+id->misc->camas->nextpage+"\">";

  array from = ({ "$TOTALSIZE", "$OF", "$USED", "$FOLDER", "$MESSAGES", "$UNSEEN", "$SIZE" });
  array to = ({ MSG(M_TOTALSIZE), MSG(M_OF), MSG(M_USED), MSG(M_FOLDER), MSG(M_MESSAGES), MSG(M_UNSEEN), MSG(M_SIZE) });
  fl_layfolderstop = replace (fl_layfolderstop, from, to);
  page += replace (fl_layfolderstop, ({ "$PATH" }), ({ HTML_ENCODE_STRING (path) }));
  from = ({ "$MARK", "$NAME", "$MESSAGES", "$RECENT", "$UNSEEN", "$SIZE" });

  int i = 0;
  int i2 = -1;
  foreach (mboxes_to_show, array mbox_a) {
    string row_mark="", row_name="", row_messages="", row_recent="", row_unseen="", row_size="";

    i2++;
    int deletable=!((mbox_a[MB_FLAGS_IDX] & MB_PREVIOUS_FOLDER) ||
                    mbox_a[MB_DISPLAYNAME_IDX] == "INBOX" ||
                    mbox_a[MB_DISPLAYNAME_IDX] == CSESSION->sentfolder ||
                    mbox_a[MB_DISPLAYNAME_IDX] == CSESSION->trashfolder ||
                    mbox_a[MB_DISPLAYNAME_IDX] == CSESSION->draftsfolder ||
                    mbox_a[MB_DISPLAYNAME_IDX] == CSESSION->answeredfolder ||
                    mbox_a[MB_DISPLAYNAME_IDX] == CSESSION->prefsbox ||
                    (mbox_a[MB_FLAGS_IDX] & MB_IMPLICIT_FOLDER) ||
                    // folder has children?
                    (Array.search_array (CSESSION->mailboxes,
                                         lambda(array a,array mbox_path) {
                                           if (sizeof(a[MB_HIERARCHY_IDX]) <= sizeof (mbox_path))
                                             return 0;
                                           int i;
                                           for(i=0;i<sizeof(mbox_path);i++)
                                             if(mbox_path[i]!=a[MB_HIERARCHY_IDX][i])
                                               return 0;
                                           return 1;
                                         },
                                         mbox_a[MB_HIERARCHY_IDX])
                     != -1 )
                   );

    deletable_folders |= deletable;

    if (!(mbox_a[MB_FLAGS_IDX] & (MB_NOSELECT | MB_IMPLICIT_FOLDER))) {

      string mbox_name = CAMAS.FolderTools.translate_frommbox (id, mbox_a);

      if (deletable)
        row_mark = "<input type=\"checkbox\" name="+HTML_ENCODE_TAG_VALUE("delf_"+mbox_a[MB_FOLDERNAME_IDX])+" value=\"1\">";
      else
        row_mark = "&nbsp;";

      row_name = "<a class=\"mailbox\" target=\"" + id->misc->camas->target + "\" href=\"";
      row_name += id->misc->camas->nexttarget + "?actionmailindex=1&mbox=";
      row_name += HTTP_ENCODE_URL (mboxes_to_show[i2][MB_FOLDERNAME_IDX]) + "\">";
      row_name += HTML_ENCODE_STRING (mbox_name) + "</a>";

      string mbname = mbox_a[MB_FOLDERNAME_IDX];
      if (foldersinfo) {
        row_messages = (string)CSESSION->foldersinfo[mbname][MB_MESSAGES_IDX];
        row_recent = (string)CSESSION->foldersinfo[mbname][MB_RECENT_IDX];
        row_unseen = (string)CSESSION->foldersinfo[mbname][MB_UNSEEN_IDX];
        row_size = (string)(CSESSION->foldersinfo[mbname][MB_SIZE_IDX] >> SIZE_SHIFT);
      }

      to = ({ row_mark, row_name, row_messages, row_recent, row_unseen, row_size });

      page += replace (fl_layfoldersrow, from, to);

      i++;
    }

    if (!(mbox_a[MB_FLAGS_IDX] & (MB_NOINFERIORS))) {

      string mbox_name = CAMAS.FolderTools.translate_frommbox (id, mbox_a);
      if (mbox_a[MB_FOLDERNAME_IDX] == "INBOX")
        mbox_name = MSG(M_INBOX);

      if(deletable)
        row_mark = "<input type=\"checkbox\" name=\""+HTML_ENCODE_TAG_VALUE("delf_"+mbox_a[MB_FOLDERNAME_IDX])+"\" value=\"1\">";
      else
        row_mark = "&nbsp;";

      string mbname = mbox_a[MB_FOLDERNAME_IDX];
      if (mbname != "") {
        row_name = "<a class=\"mailbox\" target=\"" + id->misc->camas->target + "\" href=\"";
        row_name += id->misc->camas->nexttarget + "?actionfolderlistshow=1&path=";
        row_name += HTTP_ENCODE_URL (mbname) + "\">";
        row_name += "<img border=\"0\" src=\"&imho_folder;\" alt=\"\"> ";
        row_name += HTML_ENCODE_STRING (mbox_name) + "</a>";

        if (foldersinfo) {
          row_messages = (string)CSESSION->foldersinfo[mbname][MB_MESSAGES_IDX];
          row_recent = (string)CSESSION->foldersinfo[mbname][MB_RECENT_IDX];
          row_unseen = (string)CSESSION->foldersinfo[mbname][MB_UNSEEN_IDX];
          row_size = (string)(CSESSION->foldersinfo[mbname][MB_SIZE_IDX] >> SIZE_SHIFT);
        }
      }
      else {
        row_name = "<a class=\"mailbox\" target=\"" + id->misc->camas->target + "\" href=\"";
        row_name += id->misc->camas->nexttarget + "?actionfolderlistshow=1&path=";
        if (stringp (mbox_a[MB_DISPLAYNAME_IDX]))
          row_name += HTTP_ENCODE_URL (mbox_a[MB_DISPLAYNAME_IDX]);
        row_name += "\">";

        row_name += "<img border=\"0\" src=\"&imho_folder;\" alt=\"\"> " + mbox_name + "</a>";
      }

      to = ({ row_mark, row_name, row_messages, row_recent, row_unseen, row_size });

      page += replace (fl_layfoldersrow, from, to);

      i++;
    }
  }

  string delete_button = "";
  if (deletable_folders)
    delete_button = CAMAS.Tools.formdrawbutton(id,"m_deletemarkedmbox", "actiondeletefolder", MSG(M_DELETEMARKEDMBOX));

  string create_newname = "", create_button = "";
  if (can_create_folders) {
    create_button = CAMAS.Tools.formdrawbutton(id,"m_creatembox", "actioncreatefolder", MSG(M_CREATEMBOX));
    create_newname = "<input name=\"foldername\" value=\"" + MSG(M_NEWMBOXNAME) + "\"";
    if (id->supports->javascript)
      create_newname += " onChange=\"this.form.actioncreatefolder.click()\"";
    create_newname += ">";
  }

  string rename_select = "", rename_button = "", rename_newname = "";
  rename_select = "<select name=\"oldfoldername\"><option value=\"imhonomailbox\">";
  rename_select += MSG(M_SELECTMBOX) + "</option>\n";
  for (int i = 0; i < sizeof (CSESSION->mailboxes); i++) {
    if (CSESSION->mailbox[MB_FOLDERNAME_IDX] != CSESSION->mailboxes[i][MB_FOLDERNAME_IDX])
      if (!(CSESSION->mailboxes[i][MB_FLAGS_IDX] & MB_NOSELECT)) {
        string mbox = CSESSION->mailboxes[i][MB_DISPLAYNAME_IDX];
	string mbname = CSESSION->mailboxes[i][MB_HIERARCHY_IDX][-1];
        if (!((mbname == "INBOX") ||
	      (mbname == CSESSION->sentfolder) ||
	      (mbname == CSESSION->trashfolder) ||
	      (mbname == CSESSION->draftsfolder) ||
	      (mbname == CSESSION->answeredfolder) ||
	      (mbname == CSESSION->prefsbox)))
	{
          rename_select += "<option value=" + HTML_ENCODE_TAG_VALUE(CSESSION->mailboxes[i][MB_FOLDERNAME_IDX]);
          rename_select += ">" + HTML_ENCODE_STRING (mbox) + "</option>\n";
        }
      }
  }
  rename_select += "</select>";
  rename_button = CAMAS.Tools.formdrawbutton(id,"m_renamembox", "actionrenamefolder", MSG(M_RENAMEMBOX));

  rename_newname = "<input name=\"newfoldername\" value=\"" + MSG(M_NEWMBOXNAME) + "\"";
  if (id->supports->javascript)
    rename_newname += " onChange=\"this.form.actionrenamefolder.click()\"";
  rename_newname += ">";

  from = ({
            "$NEWFOLDERNAME", "$CREATE", "$CREATFOLDER", // create folder
            "$OLDFOLDERNAME", "$RENAMEFOLDERNAME", "$RENAME", "$RENAMFOLDER", // rename folder
            "$DELETE" // delete folder
          });

  to = ({
          create_newname, create_button, MSG(M_CREATEMBOX), // create folder
          rename_select, rename_newname, rename_button, MSG(M_RENAMEMBOX), // rename folder
          delete_button // delete folder
        });

  string bottom = fl_layfoldersbottom;
  page += replace (bottom, from, to);

  page += "<input type=\"hidden\" name=\"path\" value=\"" + path + "\">";
  page += "</form>";

  page += DD;

  return page;
}

// ------------------ Mail Delivery Notification screen
//! method: string mdndialog(object id)
//!  Mail Delivery Notification screen call for CAMAS
//! returns:
//!  Function called when Mail Delivery Notification (client side part
//!  not the MTA part) is needed.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
string mdndialog(object id) {
  string page = "";

  CDEBUG("MDN Dialogbox called");

  object mail = CSESSION->cmail;
  string notify_to = mail->headers["disposition-notification-to"] || mail->headers["return-receipt-to"];

  //write ("AR: this mail needs a reply to: " + notify_to + "\n");
  page += "<br /><form method=\"post\" action=\"" + id->misc->camas->nextpage + "\">";
  page += "<div align=\"center\">";
  page += MSGA (M_NOTIFYTO, ({ CAMAS.Tools.fix_header (notify_to) }));
  page += "<br />";
  page += CAMAS.Tools.formdrawbutton(id,"m_sendmdn", "actionsendmdn", MSG(M_YES));
  page += CAMAS.Tools.formdrawbutton(id,"m_read", "actionread", MSG(M_NO));
  page += "</form></div>";

  page += DD;
  RCDEBUG("MDN Dialogbox RXML code : "+page);

  return page;
}

// ------------------ Read Mail screen
//! method: string readmail(object id, string defaultmailpath, int feature_addressbook, int feature_showtext, int feature_showhtml, int feature_linkwindow, string deletemethod, int showhiddenheaders, int showmoveanswered)
//!  Read a Mail screen call for CAMAS
//! returns:
//!  Function called when reading a mail is needed.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
//! arg: string defaultmailpath
//!  The default mailpath used for IMAP inboxes
//! arg: int feature_addressbook
//!  If the Addressbook feature is enabled
//! arg: int feature_showtext
//!  If feature showtext is enabled
//! arg: int feature_showhtml
//!  If shown HTML mail is enabled
//! arg: int feature_linkwindow
//!  If the feature linkwindow is enabled
//! arg: string deletemethod
//!  Type of deletemethod used
//! arg: int feature_mailboxes
//!  If mailboxes are enabled
//! arg: int showhiddenheaders
//!  If show hidden headers option is enabled
//! arg: int showmoveanswered
//!  if move answered option is enabled
string readmail(object id, string defaultmailpath, int feature_addressbook, int feature_showtext, int feature_showhtml, int feature_linkwindow, string feature_mimeremap, string deletemethod, int feature_mailboxes, int showhiddenheaders, int showmoveanswered, string indexdateshortformat, string indexdatelongformat) {
  string page = "";
  object camas_main = id->conf->get_provider("camas_main");	// For date subsystem...

  CDEBUG("Readmail screen called");
  if (!objectp(camas_main)) CDEBUG("Wow ! Camas Main module not here... ? What the hell ?");
  int in_drafts = (CSESSION->mailbox[MB_FOLDERNAME_IDX] == (defaultmailpath+CSESSION->draftsfolder));
  if (!in_drafts)
    CSESSION->draftuid = 0;

  CSESSION->screen = "readmail";
  CSESSION->title = MSG(M_MAIL);

  CSESSION->cmailidx = CAMAS.Tools.find_mail (CSESSION->mails, CSESSION->cmailuid);
  object mail = CSESSION->cmail;

  if (!mail || (CSESSION->cmailidx < 0)) {
    page += "<div align=\"center\"><br />";
    page += MSG (M_MAILMISSING);
    if (CSESSION->nobackbutton) {
      page += "<br />\n<form method=\"post\" target=\"" + id->misc->camas->target;
      page += "\" action=\""+id->misc->camas->nexttarget+"\">";
      page += "<input type=\"hidden\" name=\"actionindex\" value=\"1\">";
      page += "<input type=\"hidden\" name=\"mbox\" value=\"" + CSESSION->mailbox[MB_FOLDERNAME_IDX] + "\">";
      page += CAMAS.Tools.formdrawbutton(id,"m_mailmissingback", "\"\"", MSG (M_MAILMISSINGBACK));
      page += "</form></div>";
    }
    return page;
  }

  if (!in_drafts && (mail->headers["disposition-notification-to"] || mail->headers["return-receipt-to"])
      && (!has_value (CSESSION->mails[CSESSION->cmailidx]->imap->FLAGS, IMAP_MDN_FLAG)))
    // XB: Should be better to cal our internals instead ?
    return camas_main->create_main (id, MDNDIALOG);

  if (sizeof(CSESSION->mails) > CSESSION->cmailidx && !has_value ((CSESSION->mails[CSESSION->cmailidx]->imap->FLAGS), "\\Seen"))
    CSESSION->mails[CSESSION->cmailidx]->imap->FLAGS += ({ "\\Seen" });

  if (!mail->headers->to)
    mail->headers->to = "?";
  if (!mail->headers->from)
    mail->headers->from = "?";

  int nextuid = -1;
  int prevuid = -1;
  if (sizeof(CSESSION->mails)>CSESSION->cmailidx + 1)
    nextuid=((int)CSESSION->mails[(CSESSION->cmailidx) + 1]->imap->UID);
  if (CSESSION->cmailidx>0)
    prevuid=((int)CSESSION->mails[(CSESSION->cmailidx) - 1]->imap->UID);

  string buttons = "\n<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>";
  buttons += "<td><form target=\""+id->misc->camas->uptarget+"\" method=\"post\" action=\""+id->misc->camas->nextuptarget+"\">";

  if (in_drafts)
    // Mail from draft
    buttons += CAMAS.Tools.formdrawbutton(id,"m_compose", "actioncomposedraft", MSG(M_CONTINUECOMPOSE)+"...");
  else {
    // Reply
    buttons += CAMAS.Tools.formdrawbutton(id,"m_reply", "actionreply", MSG(M_REPLY));
    // Reply to all
    buttons += CAMAS.Tools.formdrawbutton(id,"m_replytoall", "actionreplytoall", MSG(M_REPLYTOALL));
    // Forward
    buttons += CAMAS.Tools.formdrawbutton(id,"m_forward", "actionforward", MSG(M_FORWARD));
  }
  buttons += "<input type=\"hidden\" name=\"mbox\" value=";
  buttons += HTML_ENCODE_TAG_VALUE (CSESSION->mailbox[MB_FOLDERNAME_IDX]) + " />";
  buttons += "<input type=\"hidden\" name=\"msg" + CSESSION->cmailuid + "\" value=\"1\" />";
  buttons += "</form></td><td>";
  buttons += "<form target=\"" + id->misc->camas->uptarget;
  buttons += "\" method=\"post\" action=\"" + id->misc->camas->nextuptarget + "\">";
  buttons += "<input type=\"hidden\" name=\"mbox\" value=";
  buttons += HTML_ENCODE_TAG_VALUE (CSESSION->mailbox[MB_FOLDERNAME_IDX]) + " />";
  buttons += "<input type=\"hidden\" name=\"msg" + CSESSION->cmailuid + "\" value=\"1\" />";

  buttons += "<input type=\"hidden\" name=\"prevuid\" value=\"" + prevuid + "\">";
  buttons += "<input type=\"hidden\" name=\"nextuid\" value=\"" + nextuid + "\">";

  if (CSESSION->mailbox[MB_DISPLAYNAME_IDX] != CSESSION->trashfolder) {
    if (feature_mailboxes && sizeof (CSESSION->trashfolder)
        && (<"both","move to trash">)[deletemethod] )
      buttons += CAMAS.Tools.formdrawbutton(id,"m_movethistotrash", "actiontrashthis", MSG(M_MOVETHISTOTRASH));
    if (!feature_mailboxes || (deletemethod != "move to trash")
        || !sizeof(CSESSION->trashfolder))
      buttons += CAMAS.Tools.formdrawbutton(id,"m_delete", "actiondeletethis", MSG(M_DELETE));
  }
  buttons += "</form></td><td>";
  buttons += "<form method=\"post\" action=\"" + id->misc->camas->nextpage + "\">";
  buttons += "<input type=\"hidden\" name=\"prevuid\" value=\"" + prevuid + "\">";
  buttons += "<input type=\"hidden\" name=\"nextuid\" value=\"" + nextuid + "\">";

  if (showhiddenheaders && (CSESSION->showhiddenheaders == "1")) {
    // Show/hide headers
    if (CSESSION->showheaders)
      buttons += CAMAS.Tools.formdrawbutton(id,"m_hidefullheaders", "actionhideheaders", MSG(M_HIDEFULLHEADERS));
    else
      buttons += CAMAS.Tools.formdrawbutton(id,"m_showfullheaders", "actionshowheaders", MSG(M_SHOWFULLHEADERS));
  }

  // Read previous/next
  if (prevuid != -1)
    buttons += CAMAS.Tools.formdrawbutton(id,"m_readprev", "actionreadprev", MSG(M_READPREV));
  if (nextuid != -1)
    buttons += CAMAS.Tools.formdrawbutton(id,"m_readnext", "actionreadnext", MSG(M_READNEXT));
  buttons += "</form></td></tr>";
  buttons += "<tr><td colspan=\"3\"><form target=\""+id->misc->camas->uptarget+"\" method=\"post\" action=\""+id->misc->camas->nextuptarget+"\">";
  // Reply and move to answered-mail
  if (showmoveanswered)
  {
    // TODO: We must have methodology for shared.* hierarchy. Here, only messages in users's shared mailbox space is replyable
    if(CSESSION->mailbox[MB_HIERARCHY_IDX][0]=="INBOX" ||
        (CSESSION->mailbox[MB_HIERARCHY_IDX][0]==CSESSION->sharedpath && CSESSION->mailbox[MB_HIERARCHY_IDX][sizeof(CSESSION->mailbox[MB_HIERARCHY_IDX])-1]==CSESSION->name)){
      buttons += CAMAS.Tools.formdrawbutton(id,"m_replymove", "actionreplymove", MSG(M_REPLYMOVE));
      buttons += CAMAS.Tools.formdrawbutton(id,"m_replytoallmove", "actionreplytoallmove", MSG(M_REPLYTOALLMOVE));
    }
  }
  buttons += "</form></td></tr></table>\n";

  //int feature_addressbook = feature (FEAT_EDITADDRESSBOOK);

  if (!CSESSION->notopbuttons)
    page += buttons;

  // Formating headers :-)
  page += "<table border=\"0\">";
  page += "<tr><td><font class=\"header1\"><b>";
  if (feature_addressbook && QUERY (multipleselect))
  {
    page += "<a target=\"" + id->misc->camas->target + "\" href=\"" + id->misc->camas->nexttarget;
    page += "?actionnewaddress=1&address=" + HTTP_ENCODE_URL (mail->headers->from) + "&take=1\">";
  }
  page += MSG(M_FROM) + ":";
  if (feature_addressbook && QUERY (multipleselect))
    page += "</a>";
  page += "</b></font></TD><TD><font class=\"header2\"><b>";

  int address_links = (feature_addressbook && has_value (lower_case (QUERY(selectaddresses)), "from"));
  if (address_links)
  {
    string from = String.trim_whites (mail->headers->from);
    page += "<a target=\""+id->misc->camas->target+"\" href=\""+id->misc->camas->nexttarget;
    page += "?actionnewaddress=1&address="+HTTP_ENCODE_URL(from)+"&take=1\">";
    page += CAMAS.Tools.fix_header (from);
    //write ("CAMAS.Tools.fix_header (" + from + ") -> " + CAMAS.Tools.fix_header (from) + "\n");
    page += "</a>";
  }
  else
    page += CAMAS.Tools.fix_header (mail->headers->from);

  // FIXME: isn't Image and Image.XFace allways included in Pike 7.x??
  // Not necessarily, but generally yes -- david
#if constant(Image.XFace.decode)
  if (mail->headers["x-face"])
  {
    page += "<img src=";
    page += HTML_ENCODE_TAG_VALUE (id->misc->camas->nextpage + "?xface=1");
    page += " alt=\":-)\">";
  }
#endif
  page += "</b></font></TD></TR><TR><TD><font class=\"header1\"><b>";

  if (feature_addressbook && QUERY (multipleselect))
  {
    page += "<a target=\"" + id->misc->camas->target + "\" href=\"" + id->misc->camas->nexttarget;
    page += "?actionnewaddress=1&address="+HTTP_ENCODE_URL(mail->headers->to)+"&take=1\">";
  }
  page += MSG(M_TO) + ":";
  if (feature_addressbook && QUERY (multipleselect))
    page += "</a>";
  page += "</b></font></TD><TD><font class=\"header2\"><b>";

  address_links = (feature_addressbook && has_value (lower_case (QUERY(selectaddresses)), "to"));
  if (address_links) {
    array (string) tos = mail->headers->to / ",";
    int add = sizeof (tos);
    foreach (tos, string to) {
      to = String.trim_whites(to);
      page += "<a target=\"" + id->misc->camas->target + "\" href=\"" + id->misc->camas->nexttarget;
      page += "?actionnewaddress=1&address=" + HTTP_ENCODE_URL(to) + "&take=1\">";
      page += CAMAS.Tools.fix_header(to);
      page += "</a>";
      if (--add)
        page += ", ";
    }
  }
  else
    page += CAMAS.Tools.fix_header(mail->headers->to);

  if (mail->headers->cc) {
    page += "</b></font></td></tr><tr><td><font class=\"header1\"><b>";
    if (feature_addressbook && QUERY (multipleselect)) {
      page += "<a target=\"" + id->misc->camas->target + "\" href=\"" + id->misc->camas->nexttarget;
      page += "?actionnewaddress=1&address=" + HTTP_ENCODE_URL (mail->headers->cc) + "&take=1\">";
    }
    page += MSG(M_CC) + ":";
    if (feature_addressbook && QUERY (multipleselect))
      page += "</a>";
    page += "</b></font></td><td><font class=\"header2\"><b>";

    address_links = (feature_addressbook && has_value(lower_case (QUERY(selectaddresses)), "cc"));
    if (address_links) {
      array (string) ccs = mail->headers->cc / ",";
      int add = sizeof (ccs);
      foreach (ccs, string cc) {
        cc = String.trim_whites(cc);
        page += "<a target=\"" + id->misc->camas->target + "\" href=\"" + id->misc->camas->nexttarget;
        page += "?actionnewaddress=1&address=" + HTTP_ENCODE_URL(cc) + "&take=1\">";
        page += CAMAS.Tools.fix_header(cc);
        page += "</a>";
        if (--add)
          page += ", ";
      }
    }
    else
      page += CAMAS.Tools.fix_header(mail->headers->cc);
  }

  if (sizeof(QUERY(rfc822dateformat))) {
    page += "</b></font></td></tr><tr><td><font class=\"header1\"><b>";
    page += MSG(M_TIME)+" :</b></font></td><td nowrap><font class=\"header2\">";

    void|array pdate = CAMAS.DateTools.parse_date (mail->headers->date);
    if (pdate) {
      array imho_from = ({ "$DD", "$MM", "$YY", "$TZ", "$HOURS", "$MINUTES", "$SECONDS", "$YYYY" });
      array imho_to   = ({
                           pdate[DD_INDEX], pdate[MM_INDEX], pdate[YY_INDEX], pdate[TZ_INDEX],
                           pdate[HOURS_INDEX], pdate[MINUTES_INDEX], pdate[SECONDS_INDEX], pdate[YYYY_INDEX]
                         });
      page += replace (QUERY(rfc822dateformat), imho_from, imho_to);
    }
    else
      page += "?";
  }
  else
    if (QUERY(rfc822readdate)) {
      page += "</b></font></td></tr><tr><td><font class=\"header1\"><b>";
      page += MSG(M_TIME) + " :</font></b></td><td><font class=\"header2\">";
      page += CAMAS.Tools.fix_header (mail->headers->date);
    }
    else {
      page += "</b></font></td></tr><tr><td><font class=\"header1\"><b>";
      page += MSG(M_TIME) + " :</b></font></td><td nowrap><font class=\"header2\">";
      page += CAMAS.DateTools.mailindex_date (id, CAMAS.Tools.fix_header (mail->headers->date),
                                          CAMAS.Tools.fix_header(mail->headers->date),
					  indexdateshortformat,
					  indexdatelongformat);
    }

  page += "</font></td></tr><tr><td><font class=\"header1\"><b>";
  page += MSG(M_SUBJECT) + " :</b></font></td><td><font class=\"header2\"> ";
  page += CAMAS.Tools.fix_header(mail->headers->subject);
  page += "</font></td></tr>";

  if (CSESSION->showheaders)
    foreach (indices(mail->headers), string h)
    if (!(< "to", "from", "cc", "date", "subject" >)[h])
      foreach (mail->headers[h] / "\0", string h2)
      page += "<br /><b>" + h + ":</b> " + CAMAS.Tools.fix_header(h2);

  page += "</table>";

  array(object) msgs = ({ });
  if(mail->body_parts)
    msgs += mail->body_parts;
  else
    msgs += ({ mail });

  int p = 0, msgshown = 0, part = 0;
  mapping refparts = ([ ]);
  array(string) partnos = ({ });
  array parenttypes = ({ });
  mapping parenttype = 0;
  string partno;
  object mess;

  if (sizeof (msgs)) {

    foreach (msgs, mess) {
      partnos += ({ ((string) p++) });
      parenttypes += ({ ([ "type": mail->type, "subtype": mail->subtype]) });
    }

    for (mess = msgs[0]; mess != 0; ) {
      partno = partnos[0];
      parenttype = parenttypes[0];
      msgs = msgs[1..];
      partnos = partnos[1..];
      parenttypes = parenttypes[1..];

      if (mess->body_parts) {
        msgs = mess->body_parts + msgs;
        for (p = sizeof (mess->body_parts) - 1; p >= 0; p--) {
          partnos =  ({ partno + "," + ((string)p) }) + partnos;
	  parenttypes = ({ ([ "type": mess->type, "subtype": mess->subtype]) }) + parenttypes;
        }
      }
      else {
        string name = CAMAS.Tools.fix_coding (mess->disp_params["filename"] || mess->params["name"] || "");
        page+="<table width=\"100%\" bgcolor=\"&imho_tdbgcolor;\"><tr><td>";

        int dotext = (!msgshown || (feature_showtext && (CSESSION->showtext == "1")));
        int linkshown = 0;

	string mime_remap = feature_mimeremap;

        if (mime_remap && strlen (mime_remap)) {
          array remap = mime_remap / "\n";
          foreach (remap, string rem) {
            array fromto = rem / ":";
            string tmp = mess->type + "/" + mess->subtype;
            if (tmp == fromto[0]) {
              mess->type = (fromto[1] / "/")[0];
              mess->subtype = (fromto[1] / "/")[1];
              CDEBUG("remapped: " + tmp + " => " + mess->type + "/" + mess->subtype );
              break;
            }
          }
        }

        if ((!mess->headers["content-id"] ||
             !refparts[mess->headers["content-id"]]) &&
            !(!msgshown && mess->type == "text" &&
              (parenttype->type == "multipart" &&
               parenttype->subtype == "alternative")?((feature_showhtml&&(CSESSION->showhtml == "1"))?0:(mess->subtype=="plain" && dotext)):((mess->subtype == "plain") && dotext))) {
          linkshown = 1;
          page += "<a";
          if (QUERY (attachwindow))
            page += " target=\"_blank\"";
          page += " href=\""+id->misc->camas->nextpage+"/";
          page += (sizeof (name) ? HTTP_ENCODE_URL (name) : "unknown");
          page += "?mailpart=" + partno + "\"><img src=\"";
          page += IMAGE_FROM_TYPE (((mess->type) / "/")[0]) + "\" alt=\"\" border=\"0\"> ";
          if (QUERY (attachmenttype))
            page += replace (MSGA(M_ATTACHMENTLINK, ({ sizeof (name) ? HTML_ENCODE_STRING (name) + ", " : "", "\0" })),
                             "\0",
                             mess->type + "/" + mess->subtype);
          else
            if (sizeof (name))
              page += HTML_ENCODE_STRING (name);
          page += "</a>";
        }
        // Big if-clause to find out whether this part should be shown...
        /*
          write(sprintf ("refparts= %O\n", refparts));
          write("content-id= " + mess->headers["content-id"] + "...\n");
          write("refparts[content-id]= " + refparts[mess->headers["content-id"]] + "...\n");
        */
        if ((mess->type == "text") &&
            (!mess->headers["content-id"] ||
             !refparts[mess->headers["content-id"]]) &&
            (parenttype->type == "multipart" &&
             parenttype->subtype == "alternative")?((feature_showhtml &&(CSESSION->showhtml == "1"))?(mess->subtype == "html" && !msgshown):((mess->subtype == "plain") && dotext)):((mess->subtype == "plain" && dotext) || (feature_showhtml &&(CSESSION->showhtml == "1") && (mess->subtype == "html") && !msgshown))) {
          // Fix for M$ Passeport fscking mails
          if (mess->headers["content-transfer-encoding"] == "7-bit")
            mess->headers["content-transfer-encoding"] = "7bit";
          if (mess->transfer_encoding == "7-bit")
            mess->transfer_encoding = "7bit";
          string data = mess->getdata () || "";
          //msgshown = 1;

          if (linkshown)
            page += "<hr />";

          if (sizeof (data) > ((int)camas_main->QUERY(maxmailsize))) {
            page += "<a target=\"_blank\" href=\"" + id->misc->camas->nextpage + "/";
            page += (sizeof (name) ? HTTP_ENCODE_URL (name) : "mail.txt");
            page += "?mailpart=" + partno + "\"><img src=\"";
            page += IMAGE_FROM_TYPE (((mess->type) / "/")[0]);
            page += "\" alt=\"\" border=\"0\">" + MSG(M_MAILTOOBIG) + "</a>";
          }
          else {
            mixed err = 0;
            string _mess;
            err = catch {
                    _mess = Locale.Charset->decoder (mess->charset)->feed (data)->drain ();
                  };

          if (err)
              page += " " + replace (MSGA(M_CHARSETWARNING, ({ "\0" })), "\0", HTML_ENCODE_STRING (mess->charset)) + "<hr />";

            page += "<noparse>";

            if (mess->subtype == "html") {
              //write("safe_html... ");
              page += my_configuration ()->get_provider ("camas_html")->safe_html ((err ? data : _mess), id, refparts, mess->headers["content-base"]);
              //write ("done.\n");
            }
            else {
              string tmp = "";
              page += "<font face=\"Courier\">";
              // page += replace (CAMAS.ScreenTools.make_links (id, CAMAS.Tools.fixstring (err ? data : _mess)), "  ", "&nbsp;&nbsp;");
              tmp = CAMAS.ScreenTools.make_links (CAMAS.Tools.fixstring (err ? data : _mess), feature_linkwindow,
                                                  ({ id->misc->camas->uptarget, id->misc->camas->nextuptarget }));
              page += replace (tmp, "  ", "&nbsp;&nbsp;");
              page += "</font>";
            }

            page += "</noparse>";
          }
        }
        else
          // About images can we try to use "magic" things eg: Image.ANY to
          // convert it into eg JPEG or GIF ? --Xavier
          if ((mess->type == "image") && camas_main->image_types[lower_case (mess->subtype)] &&
              (!mess->headers["content-id"] || !refparts[mess->headers["content-id"]])) {
            /*write (sprintf ("type= %O, image_types= %O, mess->headers[\"content-id\"]=%O, "
              "refparts[mess->headers[\"content-id\"]]= %O\n",
              mess->type,
              image_types[lower_case (mess->subtype)],
              mess->headers["content-id"],
              refparts[mess->headers["content-id"]]));*/
            page += "<hr /><img src=\"" + id->misc->camas->nextpage + "/";
            page += HTTP_ENCODE_URL (name) + "?mailpart=" + partno + "\" alt=\"\">";
          }

        page += "</td></tr>\n</table><br />\n";
        part++;
      }
      if (sizeof(msgs) > 0)
        mess = msgs[0];
      else
        mess = 0;
    }
  }

  if (!CSESSION->nobottombuttons)
    page += buttons;

  page += DD;
  RCDEBUG("Readmail screen RXML code : "+page);
  camas_main = 0;		// GC
  return page;
}

// ------------------ Files screen
//! method: string files(object id)
//!  Files screen call for CAMAS
//! returns:
//!  Function called when Files handling is needed.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
//! arg: int uploadquota
//!  The upload quota in bytes
string files(object id, int uploadquota) {
  string page = "";
  int allow_upload = 1;	// By default uploading is allowed
  int totsize = 0;

  CDEBUG("Files screen called");
  CSESSION->screen = "files";
  CSESSION->title = MSG(M_FILES);

  if (sizeof (CSESSION->files)) {
    page += "<form method=\"post\" action=\"" + id->misc->camas->nextpage + "\">";
    page += "<table width=\"100%\"><tr><th class=\"mark\" bgcolor=\"&imho_thbgcolor;\">";
    page += "<font color=\"&imho_thcolor;\">" + MSG(M_MARKFLAG) + "</font></th>";
    page += "<th class=\"filename\" bgcolor=\"&imho_thbgcolor;\" width=\"100%\">";
    page += "<font color=\"&imho_thcolor;\">" + MSG(M_FILENAME) + "</font></th>";
    page += "<th class=\"size\" bgcolor=\"&imho_thbgcolor;\">";
    page += "<font color=\"&imho_thcolor;\">" + MSG(M_SIZE) + "</font></th>";
    page += "<th class=\"type\" bgcolor=\"&imho_thbgcolor;\">";
    page += "<font color=\"&imho_thcolor;\">" + MSG(M_MIMETYPE) + "</font></th></tr>\n";

    int i = 0;
    foreach (CSESSION->files, mapping file) {
      page += "<tr><td bgcolor=&imho_tdbgcolor;><input type=\"checkbox\" name=\"file";
      page += (string)i+ "\" value=\"1\"></td><td bgcolor=&imho_tdbgcolor;>";
      page += "<a href=\"" + id->misc->camas->nextpage + file->fname + "?download=";
      page += (string)i+ "\">" + file->fname + "</td><td bgcolor=&imho_tdbgcolor;>";
      page += file->size + "</td><td bgcolor=&imho_tdbgcolor;>" + file->type + "</td></tr>";
      i++;
      totsize += file->size;
    }
    page += "</table><table><tr><td>";
    page += CAMAS.Tools.formdrawbutton(id,"m_deletemarkedfiles", "actiondeletefiles", MSG(M_DELETEMARKEDFILES));
    page += "</td></tr>\n</table></form>";
  }
  else
    page += MSG(M_NOFILES);

  if (uploadquota) {
    int space = (((uploadquota*1024) - totsize) / 1024);
    page += MSGA(M_AVAILSPACE, ({ space })) + "<br />\n";
    if (space <= 0)
      allow_upload = 0;
  }

  if (allow_upload) {
    page += "<form name=\"imhouploadform\" method=\"post\"";
    page += " enctype=\"multipart/form-data\" action=\"" + id->misc->camas->nextpage + "\">";
    page += "<table><tr><td>";
    page += "<input name=\"file\" type=\"file\">";
    page += "<input type=\"hidden\" name=\"actionupload\" value=\"1\">";
    if (id->supports->javascript)
    {
      page += CAMAS.Tools.formdrawbutton(id,"m_upload", "\"\"", MSG(M_UPLOAD),
                                         ([ "OnClick" : "document.forms.imhouploadform.fixedfilename.value=document.forms.imhouploadform.file.value.replace(/\\\\/g,'\\\\\\\\')" ]));
      page += "<input type=\"hidden\" name=\"fixedfilename\" value=\"\">";
    }
    page += "</td></tr>\n</table></form>";
    if (!id->supports->javascript)
      page += MSG(M_WINDOWSBUG);
  }

  page += DD;
  RCDEBUG("Files screen RXML code : "+page);
  return page;
}

// ------------------ Dialog Box screen
//! method: string dialog(object id)
//!  Dialog box call for CAMAS
//! returns:
//!  Function called when a dialog box is needed.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
string dialog (object id) {
  string page = "";

  CDEBUG("Dialog box called");
  CSESSION->screen = "dialog";
  if (sizeof (CSESSION->dialogstrings) == 1)
    CSESSION->title = MSG(M_INFO);
  else
    CSESSION->title = MSG(M_QUESTION);

  page += "<br />\n<br />\n<center><table border=2><tr><td><table>";
  page += "<tr><td bgcolor=&imho_thbgcolor;><br />\n</td><tr><tr><td>";
  page += "<table cellspacing=10 bgcolor=&imho_tdbgcolor;><tr><td>";
  page += CAMAS.Tools.fixstring (CSESSION->dialogtext) + "</td></tr>\n</table></td></tr>\n";
  page += "<tr><td><center><form method=\"post\" target=\"";

  if (CSESSION->dialogtarget) {
    page += CSESSION->dialogtarget + "\" action=\"";
    page += CSESSION->nexturl+CSESSION->dialogtarget + "\">";
  }
  else {
    page += id->misc->camas->target + "\" action=\"";
    page += id->misc->camas->nexttarget + "\">";
  }

  foreach (indices (CSESSION->dialogstrings), int i) {
    page += CAMAS.Tools.formdrawbutton(id,"dialog_"+CSESSION->dialogactions[i],
                                       CSESSION->dialogactions[i],
                                       CSESSION->dialogstrings[i]);
  }

  //oliv3: optional arguments
  if (CSESSION->dialogoptions) {
    foreach (CSESSION->dialogoptions, string option) {
      array opts = option / "=";
      page += "<input type=\"hidden\" name=\"" + opts[0] + "\" value=\"" + opts[1] + "\">";
    }
    CSESSION->dialogoptions = 0;
  }
  page += "</form></center></td></tr>\n</table></td></tr>\n</table></center>";

  page += DD;
  RCDEBUG("Dialog box RXML code : "+page);
  return page;
}

// ------------------ Spell Checker screen
//! method: string spellcheck(object id)
//!  Spell check screen call for CAMAS
//! returns:
//!  Function called when spell checking is needed.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
string spellcheck (object id) {
  string page = "";

  CDEBUG("Spellcheck screen called");

  CSESSION->screen = "spellcheck";
  CSESSION->title = MSG(M_SPELLCHECK);

  if ((CSESSION->checkword < 0) || (CSESSION->checkword >= sizeof (CSESSION->misspelled)))
    CSESSION->checkword = 0;

  string spellret = "";
  int i = 0;
  int j = -1;
  foreach (CSESSION->spelling, mixed foo) {
    j++;
    if (arrayp (foo)) {
      if ((CSESSION->misspelled)[CSESSION->checkword] == j) {
        spellret += "<b>" + HTML_ENCODE_STRING (foo[1]) + "</b>";
        i++;
      }
      else {
        spellret += "<a href=" + id->misc->camas->nextpage + "?actioncheckword=1&word=";
        spellret += (i++) + ">" + HTML_ENCODE_STRING (foo[1]) + "</a>";
      }
    }
    else
      spellret += HTML_ENCODE_STRING (foo);
  }

  page += "<table width=\"100%\" bgcolor=\"&imho_tdbgcolor;\"><tr><td><font face=\"Courier\">";
  page += replace (spellret, "\n", "<br />\n");
  page += "</font></td></tr>\n</table>";
  if (CSESSION->misspelled && sizeof(CSESSION->misspelled) == 0)
    page += "<B>"+MSG(M_NOSPELLINGERRORS)+"</b>\n";

  if (sizeof (CSESSION->misspelled)) {
    page += "<form method=\"post\" action=\"" + id->misc->camas->nextpage + "\">";
    if (CSESSION->checkword > 0)
      page += CAMAS.Tools.formdrawbutton(id,"m_spellprev", "actionspellprev", MSG(M_SPELLPREV));
    if (CSESSION->checkword < (sizeof(CSESSION->misspelled) - 1))
      page += CAMAS.Tools.formdrawbutton(id,"m_spellnext", "actionspellnext", MSG(M_SPELLNEXT));
    page += "</form>";

    // original word : (CSESSION->spelling)[(CSESSION->misspelled)[CSESSION->checkword]][0]

    page += "<br />\n<form method=\"post\" action=\"" + id->misc->camas->nextpage + "\">";
    page += CAMAS.Tools.formdrawbutton(id,"m_spellchangeto", "\"\"", MSG(M_SPELLCHANGETO) + ":");
    page += "<input type=\"hidden\" name=\"actionspellreplace\" value=\"1\">";
    page += "<input name=\"newword\" value=";
    page += HTML_ENCODE_TAG_VALUE ((CSESSION->spelling)[(CSESSION->misspelled)[CSESSION->checkword]][1]);
    page += "></form>";

    if (sizeof ((CSESSION->spelling)[(CSESSION->misspelled)[CSESSION->checkword]]) > 2) {
      page += MSG(M_SPELLSUGGESTIONS) + ":<br />\n";
      page += "<form method=\"post\" action=\"" + id->misc->camas->nextpage + "\">";
      page += CAMAS.Tools.formdrawbutton(id,"m_spellchangeto", "\"\"", MSG(M_SPELLCHANGETO) + ":");
      page += "<input type=\"hidden\" name=\"actionspellselect\" value=\"1\">";
      page += "<select name=\"selectedword\">";
      int k = 0;
      foreach ((CSESSION->spelling)[(CSESSION->misspelled)[CSESSION->checkword]][2..], string word) {
        page += "<option value=\"" + k + "\">" + HTML_ENCODE_STRING (word) + "</option>";
        k++;
      }
      page += "</select></form>";
    }
  }

  page += "<form target=\"" + id->misc->camas->target;
  page += "\" method=\"post\" action=\"" + id->misc->camas->nexttarget;
  page += "\"><input type=\"hidden\" name=\"actionspelldone\" value=\"1\">";
  page += CAMAS.Tools.formdrawbutton(id,"m_spelldone", "\"\"", MSG(M_SPELLDONE));
  page += "</form>";

  page += DD;
  RCDEBUG("Spellcheck screen RXML code : "+page);
  return page;
}

// ------------------ Preferences screen
//! method: string setup(object id)
//!  Setup/Preferences screen call for CAMAS
//! returns:
//!  Function called when Setup/Preferences is needed.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
//! arg: object id
//!  Caudium ID
string setup(object id,int feature_usercanchangename,int feature_useraddress, int feature_usermailpath, int feature_userlanguage, int chgreplymsgprefix, int feature_headers, int feature_showhtml, int feature_showtext, int feature_mailboxes, string deletemethod, int feature_userdraftsfolder, int feature_usersentfolder, int feature_useransweredfolder, int feature_usersentsaveattachments, int feature_userbcccopy, int feature_autofiltersetup, int feature_usersetupshowhiddenheaders, int feature_organization, int feature_usertrashfolder) {
  string page = "";

  CDEBUG("Setup screen called");

  array(string) replacements = ({ "" }) * sizeof (SETUP_FIELDS);
  array(string) m_replacements = ({ "" }) * sizeof (SETUP_MFIELDS);

  CSESSION->screen = "setup";
  CSESSION->title = MSG(M_PREFS);

  if (!CSESSION->prefsloaded) {
    CSESSION->prefsloaded = 1;
    page += QUERY(newusermsg);
  }

  page += "<table><form target=\"_top\" method=\"post\" action=\"" + CSESSION->nexturl + "_top\">";

  if (feature_usercanchangename) {
    m_replacements[SF_UN] = MSG(M_PNAME);
    replacements[SF_UN] = "<input name=\"name\" value=\"" + CAMAS.Tools.fixstring (CSESSION->name) + "\">";
  }

  if (feature_useraddress) {
    m_replacements[SF_UA] = MSG(M_PMAILADDRESS);
    replacements[SF_UA] = "<input name=\"address\" value=\"" + CAMAS.Tools.fixstring (CSESSION->address) + "\">";
  }

  if (feature_usermailpath) {
    m_replacements[SF_MP] = MSG(M_PMAILPATH);
    replacements[SF_MP] = "<input name=\"mailpath\" value=\"" + CAMAS.Tools.fixstring (CSESSION->mailpath) + "\">";
  }

  if ((sizeof (CAMAS_LANGUAGE->lang_progs) > 1) && feature_userlanguage) {
    m_replacements[SF_LA] = MSG(M_PLANGUAGE);
    replacements[SF_LA] = "<select name=\"language\">";
    foreach (sort (indices (CAMAS_LANGUAGE->lang_progs)), string opt) {
      replacements[SF_LA] += "<option value=\"" + opt + "\"";
      if (CSESSION->language == opt)
        replacements[SF_LA] += " selected";
      replacements[SF_LA] += ">" + upper_case (opt[0..0]) + opt[1..] + "</option>";
    }
    replacements[SF_LA] += "</select>";
  }

  array (string) layouts = id->conf->get_provider ("camas_layout_manager")->list_layouts ();
  if (sizeof (layouts) > 1) {
    m_replacements[SF_LY] = MSG(M_PUSERINTERFACE);
    replacements[SF_LY] = "<select name=\"layout\">";
    foreach (layouts, string lay) {
      replacements[SF_LY] += "<option value=\"" + lay + "\"";
      if (CSESSION->layout == lay)
        replacements[SF_LY] += " selected";
      replacements[SF_LY] += ">" + lay + "</option>";
    }
    replacements[SF_LY] += "</select>";
  }

  m_replacements[SF_RI] = MSG(M_PINCLUDEMAIL);

  /*  if (QUERY (chgreplymsgprefix))
      page += "<table><tr><td>";*/

  replacements[SF_RI] = "<select name=\"replyincludemsg\">";
  replacements[SF_RI] += "<option value=\"1\"";
  if (CSESSION->replyincludemsg == "1")
    replacements[SF_RI] += " selected";
  replacements[SF_RI] += ">" + MSG(M_YES) + "</option>";
  replacements[SF_RI] += "<option value=\"0\"";
  if (CSESSION->replyincludemsg == "0")
    replacements[SF_RI] += " selected";
  replacements[SF_RI] += ">" + MSG(M_NO) + "</option>";
  replacements[SF_RI] += "</select>";

  if (chgreplymsgprefix)
  {
    m_replacements[SF_RP] = MSG(M_PQUOTEPREFIX);
    replacements[SF_RP] = "<input name=\"replymsgprefix\" size=\"5\" value=\"";
    replacements[SF_RP] += CAMAS.Tools.fixstring (CSESSION->replymsgprefix)+"\">";
  }

  m_replacements[SF_SI] = MSG(M_PSIGNATURE);
  replacements[SF_SI] = "<textarea rows=\"4\" cols=\"" + QUERY(signaturecols) + "\" name=\"signature\">";
  replacements[SF_SI] += HTML_ENCODE_STRING (CSESSION->signature) + "</textarea>";

  if (feature_headers) {
    m_replacements[SF_UH] = MSG(M_PHEADER);
    replacements[SF_UH] = "<textarea rows=\"2\" cols=\"70\" name=\"extraheader\">";
    replacements[SF_UH] += HTML_ENCODE_STRING (CSESSION->extraheader)+"</textarea><br />";
    replacements[SF_UH] += MSG(M_PHEADERDESC);
  }

  m_replacements[SF_LO] = MSG(M_PINACTIVELOGOUT);
  replacements[SF_LO] = "<select name=\"autologout\">";
  // vida : someone can work 8h a day (have to play with 123session config)
  foreach (({ /* "1", */ "5", "10", "20", "60", "120", "480" }), string opt) {
    replacements[SF_LO] += "<option value=\"" + opt + "\"";
    if (CSESSION->autologout == opt)
      replacements[SF_LO] += " selected";
    replacements[SF_LO] += ">" + opt + "</option>";
  }
  replacements[SF_LO] += "</select>";

  m_replacements[SF_VM] = MSG(M_PVISIBLEMESSAGES);
  replacements[SF_VM] = "<select name=\"visiblemail\">";
  foreach (({ "10", "15", "20", "30", "40", "60", "100" }), string opt) {
    replacements[SF_VM] += "<option value=\"" + opt + "\"";
    if (CSESSION->visiblemail == opt)
      replacements[SF_VM] +=" selected";
    replacements[SF_VM] += ">" + opt + "</option>";
  }
  replacements[SF_VM] += "</select>";

  m_replacements[SF_SO]= MSG(M_PSORTORDER);
  replacements[SF_SO] = "<select name=\"sortorder\">";
  foreach (({ "forward", "backward" }), string opt) {
    replacements[SF_SO] += "<option value=\"" + opt + "\"";
    if (CSESSION->sortorder == opt)
      replacements[SF_SO] += " selected";
    replacements[SF_SO] += ">";
    string sortord = MSGA(M_PSORTORDERS, ({ opt }) );
    replacements[SF_SO] += upper_case (sortord[0..0]) + sortord[1..];
    replacements[SF_SO] += "</option>";
  }
  replacements[SF_SO] += "</select>";

  m_replacements[SF_SC] = MSG(M_PSORTCOLUMN);
  replacements[SF_SC] = "<select name=\"sortcolumn\">";
  array columns = ({ "num", "date", "from", "to", "subject", "size" });

  foreach (columns, string col) {
    replacements[SF_SC] += "<option value=\"" + (string)col + "\"";
    if (CSESSION->sortcolumn == (string)col)
      replacements[SF_SC] += " selected";
    replacements[SF_SC] += ">";

    switch (col) {
    case "num":
      replacements[SF_SC] += MSG(M_NUMBER);
      break;
    case "date":
      replacements[SF_SC] += MSG(M_DATE);
      break;
    case "from":
      replacements[SF_SC] += MSG(M_FROM);
      break;
    case "to":
      replacements[SF_SC] += MSG(M_TO);
      break;
    case "subject":
      replacements[SF_SC] += MSG(M_SUBJECT);
      break;
    case "size":
      replacements[SF_SC] += MSG(M_SIZE);
      break;
    }
    replacements[SF_SC] += "</option>";
  }
  replacements[SF_SC] += "</select>";

  if (feature_showhtml) {
    m_replacements[SF_SH] = MSG(M_PSHOWHTML);
    replacements[SF_SH] = "<select name=\"showhtml\">";
    replacements[SF_SH] += "<option value=\"1\"";
    if (CSESSION->showhtml == "1")
      replacements[SF_SH] += " selected";
    replacements[SF_SH] += ">" + MSG(M_YES) + "</option>";
    replacements[SF_SH] += "<option value=\"0\"";
    if (CSESSION->showhtml == "0")
      replacements[SF_SH] += " selected";
    replacements[SF_SH] += ">" + MSG(M_NO) + "</option>";
    replacements[SF_SH] += "</select>";
  }

  if (feature_showtext) {
    m_replacements[SF_ST] = MSG(M_PSHOWTEXT);
    replacements[SF_ST] = "<select name=\"showtext\">";
    replacements[SF_ST] += "<option value=\"1\"";
    if (CSESSION->showtext == "1")
      replacements[SF_ST] += " selected";
    replacements[SF_ST] += ">" + MSG(M_YES) + "</option>";
    replacements[SF_ST] += "<option value=\"0\"";
    if (CSESSION->showtext == "0")
      replacements[SF_ST] +=" selected";
    replacements[SF_ST] += ">" + MSG(M_NO) + "</option>";
    replacements[SF_ST] += "</select>";
  }

  if (feature_mailboxes) {
    if ((<"both", "move to trash">)[deletemethod])
      if (feature_usertrashfolder) {
        m_replacements[SF_FT] = MSG(M_PTRASHFOLDER);
        replacements[SF_FT] = "<input name=\"trashfolder\" value=\"" + CAMAS.Tools.fixstring (CSESSION->trashfolder)+"\">";
      }

    if (feature_userdraftsfolder) {
      m_replacements[SF_FD] = MSG(M_PDRAFTSFOLDER);
      replacements[SF_FD] = "<input name=\"draftsfolder\" value=\"" + CAMAS.Tools.fixstring (CSESSION->draftsfolder) + "\">";
    }

    if (feature_useransweredfolder) {
      m_replacements[SF_FA] = MSG(M_PANSWEREDFOLDER);
      replacements[SF_FA] = "<input name=\"answeredfolder\" value=\"" + CAMAS.Tools.fixstring (CSESSION->answeredfolder) + "\">";
    }

    if (feature_usersentfolder) {
      m_replacements[SF_FS] = MSG(M_PSENTFOLDER);
      replacements[SF_FS] = "<input name=\"sentfolder\" value=\"" + CAMAS.Tools.fixstring (CSESSION->sentfolder) + "\">";

      if (feature_usersentsaveattachments) {
        m_replacements[SF_SA] = MSG(M_PSAVEATTACHMENTS);
        replacements[SF_SA] += "<select name=\"saveattachments\">";
        replacements[SF_SA] += "<option value=\"1\"";
        if (CSESSION->saveattachments == "1")
          replacements[SF_SA] += " selected";
        replacements[SF_SA] += ">" + MSG(M_YES) + "</option>";
        replacements[SF_SA] += "<option value=\"0\"";
        if (CSESSION->saveattachments == "0")
          replacements[SF_SA] += " selected";
        replacements[SF_SA] += ">" + MSG(M_NO) + "</option>";
        replacements[SF_SA] += "</select>";
      }
    }
  }

  if (feature_userbcccopy) {
    m_replacements[SF_BC] = MSG(M_PDEFAULTBCC);
    replacements[SF_BC] = "<input name=\"autobcc\" value=\"" + CAMAS.Tools.fixstring (CSESSION->autobcc) + "\">";
  }

  if(feature_autofiltersetup) {
    m_replacements[SF_AF] += MSG(M_PAUTOFILTER);
    replacements[SF_AF] += "<select name=\"autofilter\">";
    replacements[SF_AF] += "<option value=\"1\"";
    if (CSESSION->autofilter == "1")
      replacements[SF_AF] += " selected";
    replacements[SF_AF] += ">" + MSG(M_YES) + "</option>\n";
    replacements[SF_AF] += "<option value=\"0\"";
    if (CSESSION->autofilter == "0")
      replacements[SF_AF] += " selected";
    replacements[SF_AF] += ">" + MSG(M_NO) + "</option>\n";
    replacements[SF_AF] += "</select>";
  }

  if (feature_usersetupshowhiddenheaders) {
    m_replacements[SF_DH] = MSG(M_PSHOWHIDDENHEADERS);
    replacements[SF_DH] = "<select name=\"showhiddenheaders\">";
    replacements[SF_DH] += "<option value=\"1\"";
    if (CSESSION->showhiddenheaders == "1")
      replacements[SF_DH] += " selected";
    replacements[SF_DH] += ">" + MSG(M_YES) + "</option>";
    replacements[SF_DH] += "<option value=\"0\"";
    if (CSESSION->showhiddenheaders == "0")
      replacements[SF_DH] += " selected";
    replacements[SF_DH] += ">" + MSG(M_NO) + "</option>";
    replacements[SF_DH] += "</select>";
  }

  if (feature_organization) {
    m_replacements[SF_OR] = MSG(M_PORGANIZATION);
    replacements[SF_OR] = "<input name=\"organization\" value=\"" + CAMAS.Tools.fixstring (CSESSION->organization) + "\">";
  }

  page += QUERY(laysetup);
  page = replace (page, SETUP_MFIELDS, m_replacements);
  page = replace (page, SETUP_FIELDS, replacements);

  page += "<tr><td>&nbsp;</td><td>";
  page += CAMAS.Tools.formdrawbutton(id,"m_psaveanduse", "actionsavesetup", MSG(M_PSAVEANDUSE));
  page += "</td></tr>";
  page += "</form></table>";

  page += DD;
  RCDEBUG("Setup screen RXML code : "+page);

  return page;
}



/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: debug
//! Debug the call / errors into Caudium error log ?
//!  type: TYPE_FLAG
//!  name: Debug:Calls or Errors
//
//! defvar: rdebug
//! Dump the RXML sent to RXML parser into caudium error log ?
//!  type: TYPE_FLAG
//!  name: Debug:Dump the RXML in log
//
//! defvar: debugdump
//! Dump Caudium 'id' mapping in the HTML output? (warning the pages can be hudge and this be a security hole if you let this to yes).
//!  type: TYPE_FLAG
//!  name: Debug:Dump Caudium id
//
//! defvar: laylogin1
//! Content of the login page with some RXML contents.<br />Use the following to replace with internal imho controls:<ul><li><b>$MSGLOGIN</b>: Login message from imho languages files</li><li><b>$MSGPASSWORD</b>: Password message from imho language files</li><li><b>$INPUTLOGIN</b>: Input box for login</li><li><b>$INPUTPASSWORD</b>: Input box for password</li><li><b>$INPUTOK</b>: The Ok button from imho languages files.</li><li><b>$MSGIMAPSERVER</b>: IMAP server from imho language files</li><li><b>$MSGPORT</b>: Port from imho language files</li><li><b>$INPUTIMAPSERVER</b>: Input box for letting user give their IMAP server</li><li><b>$INPUTIMAPPORT</b>: Input box for letting user give the port of their IMAP server</li>You can set the define "jscript" to "on" if you wishe to use some "magic" javascript to help users to login...
//!  type: TYPE_TEXT_FIELD
//!  name: Login page:Part 1
//
//! defvar: laylogin2
//! Content of the login page <i>(selection of layouts if the is more than one layout)</i>.<br />As usual you can use the following to replace with controls/messages from imho:<ul><li><b>$MSGUSRINFACE</b>:The message from imho language file to choose the user interface</li><li><b>$INPUTSELECTINFACE</b>:Popup with the differents users interfaces in ;-)</li></ul>.
//!  type: TYPE_TEXT_FIELD
//!  name: Login page:Part 2
//
//! defvar: laylogout
//! Replace the content of the logout page by some RXML contents.<br /> <ul><li><b>$LOGOUTMSG</b>: You have been logged out. </li><li><b>$LOGOUTRELOAD</b>: Close this browser window to make sure no one can read your mail.</li><li><b>$LOGOUTCLOSE</b>: Reload this page to login.</li></ul>
//!  type: TYPE_TEXT_FIELD
//!  name: Logout page
//
//! defvar: laycompose1top
//! Action button layout e.g. Send, Cancel and Spell check buttons.<br /> As usual you can use<ul><li><b>$INPUTSEND</b>: for the Send button</li><li><b>$INPUTCANCEL</b>: for the cancel button</li><li><b>$INPUTSPELLCHECK</b>: for the spell button</li><li><b>$INPUTSPELLCHOOSE</b>: for the popup list of languages for the spelling</li><li><b>$INPUTSAVEDRAFT</b>: allow the user to save a draft</li></ul>
//!  type: TYPE_TEXT_FIELD
//!  name: Compose page: Top actions buttons
//
//! defvar: laycompose1bottom
//! Action button layout e.g. Send, Cancel and Spell check buttons.<br/> As usual you can use<ul><li><b>$INPUTSEND</b>: for the Send button</li><li><b>$INPUTCANCEL</b>: for the cancel button</li><li><b>$INPUTSPELLCHECK</b>: for the spell button</li><li><b>$INPUTSPELLCHOOSE</b>: for the popup list of languages for the spelling</li><li><b>$INPUTSAVEDRAFT</b>: allow the user to save a draft</li></ul>
//!  type: TYPE_TEXT_FIELD
//!  name: Compose page: Bottom actions buttons
//
//! defvar: laycompose2
//! Header actions e.g. the input boxes, buttons to fill the mail headers.<br />As usual, some replacements fields :<ul><li><b>$MSGFROM</b>: Imho language 'from' text</li><li><b>$MSGEMAILFROM</b>: The email entered in the configuration dialogs</li><li><b>$MSGORGANIZATION</b>: The organization entered in the configuration dialogs</li><li><b>$MSGTO</b>: Imho language 'To' text</li><li><b>$MSGCC</b>: Imho language 'CC' text</li><li><b>$MSGBCC</b>: Imho language 'Bcc' text</li><li><b>$MSGSUBJECT</b>: Imho language 'Subject' text</li><li><b>$INPUTTO</b>: The input box for 'To'</li><li><b>$INPUTCC</b>: The input box for 'CC'</li><li><b>$INPUTBCC</b>: The input box for 'Bcc'</li><li><b>$INPUTSUBJECT</b>: The input box for the 'subject'</li><li><b>$INPUTADDRBOOKTO</b>: Button to add address from addressbook for 'To'</li><li><b>$INPUTADDRBOOKCC</b>: Button to add address from addressbook for 'Cc'</li><li><b>$INPUTADDRBOOKBCC</b>: Button to add address from addressbook for 'Bcc'</li><li><b>$INPUTADDRBOOK</b>: Button to add addresses from addressbook ('To', 'Cc', and 'Bcc')</li><li><b>$INPUTLDAPTO</b>: Button to add address from LDAP addressbook for 'To'</li><li><b>$INPUTLDAPCC</b>: Button to add address from LDAP addressbook for 'Cc'</li><li><b>$INPUTLDAPBCC</b>: Button to add address from LDAP addressbook for 'Bcc'</li><li><b>$INPUTLDAP</b>: Button to add addresses from LDAP addressbook ('To', 'Cc', and 'Bcc')</li></ul>
//!  type: TYPE_TEXT_FIELD
//!  name: Compose page: Headers actions
//
//! defvar: headersize
//! Width of the (to, cc, bcc) input fields.
//!  type: TYPE_INT
//!  name: Compose page:Header size
//
//! defvar: subjectsize
//! Width of the subject field.
//!  type: TYPE_INT
//!  name: Compose page:Subject size
//
//! defvar: laycompose3
//! Attachments actions for composing mail.<br />As usual there is options/replacements :<ul><li><b>$MSGATTACHMENTS</b>: Imho language for adding attachements files</li><li><b>$INPUTFILEATT</b>: List of attached files</li><li><b>$INPUTADD</b>: Button to add new files</li><li><b>$INPUTDEL</b>: Button to del selected files</li></ul>
//!  type: TYPE_TEXT_FIELD
//!  name: Compose page:Attachments actions
//
//! defvar: laycompose4
//! Compose screen.<br />As usual some options/replacements :<ul><li><b>$INPUTMSGAREA</b>: The input box for message writting</li><li><b>$INPUTSAVECOPY</b>: Check box to save a copy into sent mail</li><li><b>$INPUTDSNDELAY</b> &amp; <b>$INPUTDSNSUCCESS</b>: DSN options.</li><li><b>$INPUTMDN</b>: Request a MDN (Mail Delivery Notification)</li><li><b>$INPUTBCC2ADMIN</b>: Add a checkbox in compose screen which all ow the user to send a BCC to the email specified in preferences</li></ul>
//!  type: TYPE_TEXT_FIELD
//!  name: Compose page:Compose screen
//
//! defvar: msgrows
//! Rows in the input box.
//!  type: TYPE_INT
//!  name: Compose page:Input box rows
//
//! defvar: msgcols
//! Columns in the input box.
//!  type: TYPE_INT
//!  name: Compose page:Input box columns
//
//! defvar: layeditaddress
//! Layout to edit an addressbook entry.
//!Leave empty to use the default layout (autogenerated).
//!Otherwise, you must use in your <tt>input</tt> tags :
//!<lu>
//!<li><b>$NAME</b> for the name value (primary key)</li>
//!<li><b>$ADDRESS</b> for the address value</li>
//!<li><b>$BUTTONSAVE</b> for the validation button</li>
//!<li><b>$BUTTONDELETE</b> for the deletion button</li>
//!<li><b>$BUTTONCANCEL</b> for the cancel button</li>
//!</lu>
//!You can also use, according to your setting of extended addressbook fields :
//!<lu>
//!<li><b>%<i>field</i>%</b> as the name of the <tt>input</tt> for the extended addressbook field named <i>field</i> (case sensitive)</li>
//!<li><b>$<i>field</i>$</b> as it's value</li>
//!</lu><br />
//!e.g.:<br />
//!Let's suppose we have two extended address book fields named <it>Phone</it> and <it>Postal</it>, you could write here :<tt><br/><pre>&lt;input name="name" value="$NAME"&gt; is
//!&lt;input size=60 name="address" value="$ADDRESS"&gt;
//!&lt;hr /&gt;Ring at :
//!&lt;input size=20 name="%Phone%" value="$Phone$"&gt;&lt;br /&gt;
//!Write at:
//!&lt;textarea name="%Postal%" rows=6 cols=80&gt;$Postal$&lt;/textarea&gt;&lt;br /&gt;&$BUTTONSAVE $BUTTONDELETE $BUTTONCANCEL</pre></tt>
//!  type: TYPE_TEXT_FIELD
//!  name: Edit addresses
//
//! defvar: layeditaddressfilter
//! Layout to edit an filterbook entry.
//!Leave empty to use the default layout (autogenerated).
//!Otherwise, you can use :
//!<lu>
//!<li><b>$INPUTNAMEFIELD</b> for the name select option</li>
//!<li><b>$INPUTFIELD</b> for the field select option</li>
//!<li><b>$INPUTNAMEFILTER</b> for the name textbox (primary key)</li>
//!<li><b>$INPUTFILTER</b> for the filter textbox</li>
//!<li><b>$INPUTFOLDER</b> for the select option associated to extended filterbook field named (case sensitive)</li>
//!<li><b>$BUTTONFILTERSAVE</b> for the validation button</li>
//!<li><b>$BUTTONFILTERDELETE</b> for the deletion button</li>
//!<li><b>$BUTTONFILTERCANCEL</b> for the cancel button</li>
//!</lu>
//!
//!  type: TYPE_TEXT_FIELD
//!  name: Edit Adress Filter
//
//! defvar: layindextop
//! Note : <i>you can't have $MSGMOVEMARKED and $MSGCHANGEMBOX both in top and bottom</i><br />Action button layout e.g. Send, Cancel and Spell check buttons.<br/> As usual you can use<ul><ul><li><b>$MSGMAILNUMBERS</b>: The numbers of mails when there more than 20 (by default)</li><li><b>$MSGDELETEMARKED</b>: Button to delete marked mails</li><li><b>$MSGDELETEALLTRASH</b>: Button to delete mail in the trash</li><li><b>$MSGMOVETOTRASH</b>: Button to move mail to trash</li><li><b>$MSGMOVEMARKED</b>: Button to move marked</li><li><b>$MSGCHANGEMBOX</b>: Button to change mbox</li><li><b>$MSGSHOWALLAFTERSEARCH</b>: Button to reset the search. Appear only if you search something before</li><li><b>$MSGSEARCHMAIL</b>: Search button</li><li><b>$MSGCHECKNEWMAIL</b>: check for new mail button</li></ul>
//!  type: TYPE_TEXT_FIELD
//!  name: Mailindex Page: Top buttons
//
//! defvar: layindexbottom
//! Note : <i>you can't have $MSGMOVEMARKED and $MSGCHANGEMBOX both in top and bottom</i><br />Action button layout e.g. Send, Cancel and Spell check buttons.<br/> As usual you can use<ul><ul><li><b>$MSGMAILNUMBERS</b>: The numbers of mails when there more than 20 (by default)</li><li><b>$MSGDELETEMARKED</b>: Button to delete marked mails</li><li><b>$MSGDELETEALLTRASH</b>: Button to delete mail in the trash</li><li><b>$MSGMOVETOTRASH</b>: Button to move mail to trash</li><li><b>$MSGMOVEMARKED</b>: Button to move marked</li><li><b>$MSGCHANGEMBOX</b>: Button to change mbox</li><li><b>$MSGSHOWALLAFTERSEARCH</b>: Button to reset the search. Appear only if you search something before</li><li><b>$MSGSEARCHMAIL</b>: Search button</li><li><b>$MSGCHECKNEWMAIL</b>: check for new mail button</li></ul>
//!  type: TYPE_TEXT_FIELD
//!  name: Mailindex Page: Bottom buttons
//
//! defvar: layindexnomail
//! Action button layout e.g. Send, Cancel and Spell check buttons.<br/> As usual you can use<ul><li><b>$MSGGETNEWMAIL</b>: Button to check for new mails</li><li><b>$MSGCHANGEMBOX</b>: Button to change mailbox</li><li><b>$MSGNOMAILS</b>: Message that say no mails in this mailbox</li></ul>
//!  type: TYPE_TEXT_FIELD
//!  name: Mailindex Page: Top buttons (when mailbox listed is empty)
//
//! defvar: layindexsender
//! What to write in sender name
//!  type: TYPE_TEXT_FIELD
//!  name: Mailindex Page: Sender field
//
//! defvar: featurechangembox
//! Allow changing Mailbox on the fly in mail index.
//!  type: TYPE_FLAG
//!  name: Mailindex Page:Change Mbox
//
//! defvar: featuredelay
//! Adds delay in the date column displaying the time since the mail arrived in the mailbox
//!  type: TYPE_FLAG
//!  name: Mailindex Page:Delay: Delay
//
//! defvar: delayforanswered
//! Display the delay when the mail is allready answered.Setting it to no can be useful if delay is meaning to warn people.
//!  type: TYPE_FLAG
//!  name: Mailindex Page:Delay: Delay displayed for answered
//
//! defvar: delayimagepath
//! If set, this path will be used to display images in the date field depending of the delay.<br />These images must be named as delay<i>X</i>.gif with <i>X</i> depending of your delay step number.<br />If not set, no image will be displayed
//!  type: TYPE_STRING
//!  name: Mailindex Page:Delay: Delay image path
//
//! defvar: shownew
//! If set to no, the column N in mailindex disappear but as new messages are bold, you can always see new messages.
//!  type: TYPE_FLAG
//!  name: Mailindex Page: Show New
//
//! defvar: showanswered
//!  If set to no, the column R in mailindex disappear but if you set Mail index - delay, delay is not  displayed for answered so you can always see them.
//!  type: TYPE_FLAG
//!  name: Mailindex Page: Show Answered
//
//! defvar: frommaxlength
//! Set the max length for the 'sender' field. If set to 0, the whole string will be displayed.
//!  type: TYPE_INT
//!  name: Mailindex Page:Max length for the 'sender' field
//
//! defvar: subjectmaxlength
//! Set the max length for the 'subject' field. If set to 0, the whole string will be displayed.
//!  type: TYPE_INT
//!  name: Mailindex Page:Max length for the 'subject' field
//
//! defvar: subjectlayer
//! Show the full subject in a floating layer. Need browser that support Javascript and Layers.
//!  type: TYPE_FLAG
//!  name: Mailindex Page:Show full subject in a floating table
//
//! defvar: layfoldersrow
//! The layout for the folders list.<br />As usual some options/replacements :<ul><li><b>$MARK</b>: Button to select the folder for deletion</li><li><b>$NAME</b>: The name of the folder</li><li><b>$MESSAGES</b>: The number of messages</li><li><b>$RECENT</b>: The number of recent messages</li><li><b>$UNSEEN</b>: The number of unseen messages</li><li><b>$SIZE</b>: The size of the folder (in kb).</li></ul>
//!  type: TYPE_TEXT_FIELD
//!  name: Folderslist Page:Table row
//
//! defvar: layfolderstop
//! The layout for the top of the table. Provided rxml tag: <b>&lt;imho_totalsize&gt;</b> for the size of all the folders.<br />(also in &amp;session.allfolderssize;). <br />Some replacements for multilanguage:<ul><li><b>$TOTALSIZE</b>: Text for the total size</li><li><b>$OF</b>: Text for of</li><li><b>$USED</b>: Text for used</li><li><b>$FOLDER</b>: Text for folder</li><li><b>$MESSAGES</b>: Text for Messages</li><li><b>$UNSEEN</b>: Text for Unseen</li><li><b>$SIZE</b>: Text for Size</li></ul>
//!  type: TYPE_TEXT_FIELD
//!  name: Folderslist Page:Table header
//
//! defvar: layfoldersbottom
//! The layout for the bottom of the table.<br />As usual some options/replacements :<ul><li><ul>Creating folders :<li><b>$NEWFOLDERNAME</b>: Text area for the name of the new folder</li><li><b>$CREATE</b>: Button to create the folder</li><li><b>$CREATFOLDER</b>: Text for Create folder</li></ul></li><li><ul>Renaming folders :<li><b>$OLDFOLDERNAME</b>: Selects the folder to rename</li><li><b>$RENAMEFOLDERNAME</b>: Text area for the name of the new folder</li><li><b>$RENAME</b>: Button to rename the folder </li><li><b>$RENAMFOLDER</b>: Text for Rename folder</li></ul></li><li><b>$RENAME</b>: Button to rename the folder </li></ul></li><li><ul>Deleting folders :<li><b>$DELETE</b>: Button to delete marked folders</li></ul></li></ul>
//!  type: TYPE_TEXT_FIELD
//!  name: Folderslist Page:Table footer
//
//! defvar: multipleselect
//! If set, allow the user to add all addresses from the mail headers.
//!  type: TYPE_FLAG
//!  name: Readmail Page:Select multiple addresses
//
//! defvar: selectaddresses
//! Allow the user to add individual addresses from the mail headers.<br />Allowed values are: From, To, Cc
//!  type: TYPE_STRING
//!  name: Readmail Page:Select addresses
//
//! defvar: rfc822readdate
//! When set, standard RFC822 date is used instead of parsed date as in the folder index.
//!  type: TYPE_FLAG
//!  name: Readmail Page:Use RFC822 standard date
//
//! defvar: rfc822dateformat
//! Set a format for the date.<br />You can use the following replacements :<ul><li><b>$DD</b>: Day</li><li><b>$MM</b>: Month</li><li><b>$YY</b>: Short year</li><li><b>$YYYY</b>: Long year</li><li><b>$HOURS</b>: Hours</li><li><b>$MINUTES</b>: Minutes</li><li><b>$SECONDS</b>: Seconds</li><li><b>$TZ</b>: Timezone</li></ul>
//!  type: TYPE_TEXT_FIELD
//!  name: Readmail Page:Date format
//
//! defvar: attachwindow
//! Enables multi-window view of attachments.
//!  type: TYPE_FLAG
//!  name: Readmail Page:Open attachments in new window
//
//! defvar: attachmenttype
//! When reading a mail with attachments, add the type of the file.
//!  type: TYPE_FLAG
//!  name: Readmail Page:Show the attachments type
//
//! defvar: laysetup
//! The layout for the setup screen.<br />As usual some replacements :<ul><li><b>
//!  type: TYPE_TEXT_FIELD
//!  name: Setup Page:Setup Screen
//
//! defvar: newusermsg
//! New users are first presented with the preferences screen. This message is shown then.
//!  type: TYPE_STRING
//!  name: Setup Page:New user message
//
//! defvar: signaturecols
//! Change the max line length for signature box in the preferences page
//!  type: TYPE_STRING
//!  name: Setup Page:Size of signature
//

/*
 * If you visit a file that doesn't contain these lines at its end, please
 * cut and paste everything from here to that file.
 */

/*
 * Local Variables:
 * c-basic-offset: 2
 * End:
 *
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

