/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: camas_auth_null.pike,v 1.30 2004/01/08 20:53:18 vida Exp $
 */

//
//! module: CAMAS: Null Auth
//!  Null Auth Module for CAMAS e.g. example module provider that
//!  can be used as skel for more complex auth schemes.
//!  WARNING : This module is Work In Progress and not finished yet.
//!
//! type: MODULE_PROVIDER|MODULE_EXPERIMENTAL
//! cvs_version: $Id: camas_auth_null.pike,v 1.30 2004/01/08 20:53:18 vida Exp $
//

#include <module.h>
inherit "module";

constant cvs_version="$Id: camas_auth_null.pike,v 1.30 2004/01/08 20:53:18 vida Exp $";
constant module_type = MODULE_PROVIDER | MODULE_EXPERIMENTAL;
constant module_name = "CAMAS: Auth Null";
constant module_doc  = "Null Auth Module for CAMAS e.g. example module provider that "
                       "can be used as skel for more complex auth schemes."
                       "<font color=red><b>Warning:</b> This module is Work In Progress and not "
                       "finished yet.</font>"
                       "<br />You can have several Auth modules, the internal priority of these "
                       "modules can be used to specify the order in which the user are "
                       "checked against each module.";
constant module_unique = 1;
constant thread_safe=1;		// I think this module should be :)

void create()
{
  defvar("emaillogin",0,"Login using email address",TYPE_FLAG,
         "Use the email address to login instead of the imap login");

}

void start(int cnt, object conf)
{
}

string status()
{
  return "NULL Authentication module.";
}

string query_provides()
{
  return("camas_auth");
}

/*
 * What we provide here
 */

//
//! method: int version(void)
//!  Give the CAMAS_AUTH api version
//!  supported by the module
//! returns:
//!  the version of the API
//! note:
//!  The base API is 1. But if we provide de v2, we
//!  *MUST* be backward compatible with v1.
//
int version()
{
  return 2;
}

//
//! method: string|int getlogin(string login)
//!  Return the imap login to be used to connect into IMAP
//!  server. Or a int to throw with an error
//! arg: string login
//!  The login typed/entered on the CAMAS login string.
//!  This can be an email, a part of an email or an imap id.
//! returns:
//!  a string : the imap login to be used.<br />
//!  an int : an error code if there is an error, see notes.
//! note:
//!  error codes :<br />
//!  0 : Error (standard code or for unknown error type)<br />
//!  1 : Bad password<br />
//!  2 : Access denied<br />
//!  3 : Account is locked<br />
//!  4 : Change your password<br />
//
string|int getlogin(string login)
{
  return login;
}

//
//! method: string|int getdnsname(void)
//!  Gets the sitewide email domain name that can be used
//!  for email login or to complete unqualified emails
//! returns:
//!  a string : the dns domain name<br />
//!  an int : an error code if there is an error, see notes.
//! note:
//!  error codes :<br />
//!  0 : Error (standard code or unknown error type)<br />
//!  1 : There is no domain name set, use whole email or imap login
//
string|int getdnsname()
{
  return 1;
}

//
//! method: int getemaillogin(void)
//!  Do the email is used instead of the imap login as
//!  login method ?
//! returns:
//!  a int : 1 = Yes, 0 = No
//
int getemaillogin()
{
  return (int)QUERY(emaillogin);
}

//
//! method: array|int getfullnames(string login)
//!  Get the name and the surname of the specifier imap login
//! arg: string login
//!  The imap login
//! returns:
//!  a array : the name and surname in the form :
//!  ({ "surname", "name", "email@domain.com", "imaplogin" })<br />
//!  an int : an error code if there is an error, see notes.
//! note:
//!  error codes :<br />
//!  0 : Error (standard error code or unknown error type)<br />
//!  1 : Empty set
//
array|int getfullnames(string login)
{
  return 1;
}

//
//! method: mapping(string:string|int) getimapserver(string login)
//!  Return the imap informations to be used to connect into IMAP
//!  server. Or a int to throw with an error
//! arg: string login
//!  The login typed/entered on the CAMAS login string.
//!  This can be an email, a part of an email or an imap id.
//! returns:
//!  a mapping : maps configuration name to their values<br />
//!   usual names include domain, imapport, imapserver.
//!  an int : an error code if there is an error.
//
mapping(string:string|int)|int getimapserver(string login)
{
  return ([ "imapsrv": "localhost", "mailpath": "INBOX" ]);
}

/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: emaillogin
//! Use the email address to login instead of the imap login
//!  type: TYPE_FLAG
//!  name: Login using email address
//

/*
 * If you visit a file that doesn't contain these lines at its end, please
 * cut and paste everything from here to that file.
 */

/*
 * Local Variables:
 * c-basic-offset: 2
 * End:
 *
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

