/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * Based on IMHO  Stefan Wallstrm and Bosse Lincoln.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: LDAP.pmod,v 1.13 2004/01/13 11:01:37 vida Exp $
 */

#include <camas/globals.h>

//! file: LDAP.pmod
//!  CAMAS LDAP functions
//! cvs_version: $Id: LDAP.pmod,v 1.13 2004/01/13 11:01:37 vida Exp $


//! method: string getldapaddr(string namecont, string server, string basedn, int version, string uname, string passwd, int ldapshowou)
//!  Get a name, email address from a LDAP server
//! Returns:
//!  A string formatted with the following conventions : name ":" email ":" ou
//! arg: string namecont
//!  A name to search in the LDAP directory
//! arg: string server
//!  The server name
//! arg: string basedn
//!  The LDAP basedn
//! arg: int version
//!  The LDAP server protocol version (2 ou 3)
//! arg: string uname
//!  The username used to query the LDAP server
//! arg: string passwd
//!  The password used to query the LDAP server
//! arg: int ldapshowou
//!  Get the LDAP 'ou' when do this query
//! arg: string mailattr
//!  The LDAP attribute to use in case it's not "mail"
string getldapaddr (string namecont, string server, string basedn,
                    int version, string uname, string passwd, int ldapshowou, string mailattr)
{
#if constant(Protocols.LDAP) && constant(Protocols.LDAP.client)
  string filter;
  mixed status;
  mixed error;
  string name, address, dn, ou, output = "";
  object con;
  int inx;

  if (!strlen (mailattr))
    mailattr = "mail";

  namecont = string_to_utf8(namecont);
  if (server == "")
    server = "localhost";

  error = catch (con = Protocols.LDAP.client (server));
  error |= catch (con->bind (uname, passwd, version));

  if (error || !objectp(con)) {
    LDAP_DEBUG("Protocols.LDAP: error= " + error[0] + "\n");
    return "";
  }

  status = con->set_basedn(basedn);
  status = con->set_scope(2);

  // filter = "cn=*";
  filter = "(|(cn=*" + namecont + "*)(sn=*" + namecont + "*))";
  object en;
  string ldap_last_error;

  if (error = catch(en = con->search(filter))) {
      //string con_err = con->error_string();
      string con_err = error[0];
      ldap_last_error = "LDAP search \"" + filter + "\" failed: " + con_err;
      LDAP_DEBUG(ldap_last_error + "\n");
      return "";
    }
  con->unbind();

  int start;

  for(inx = 1; inx <= en->num_entries(); inx++)
  {
    address = sprintf("%s", (en->fetch(inx)[mailattr]||({ "" }))[0]);
    string temp = (en->fetch(inx)["dn"]||({ "" }))[0];
    name = (en->fetch(inx)["cn"]||({ "" }))[0];
    if(sizeof(name) == 0) {
      name = (en->fetch(inx)["givenname"]||({ "" }))[0] + " " + (en->fetch(inx)["sn"]||({ "" }))[0];
    }
    if(ldapshowou)
    {
      if(arrayp(en->fetch(inx)["ou"])==1)
        ou = en->fetch(inx)["ou"][0];
      else
        sscanf(temp, "ou=%s", ou);
      if(sizeof(output) == 0)
        output = name + ":" +  address + ":" + ou;
      else
        output += "\n" + name + ":" + address + ":" + ou;
    }
    else
    {
      if(sizeof(output) == 0)
        output = name + ":" +  address;
      else
        output += "\n" + name + ":" + address;
    }
  }
  return utf8_to_string(output);
#else
  return "";
#endif
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

