/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: utf.h,v 1.15 2004/01/13 11:01:37 vida Exp $
 */

//! file: utf.h
//!  Basic macros to handle UTF / ISO caracter conversion
//! cvs_version: $Id: utf.h,v 1.15 2004/01/13 11:01:37 vida Exp $

#ifndef __UTF_H
#define __UTF_H

/*
 * CAMAS UTF8 Conversion macros
 */

//! method: string TO_UNICODE(string s)
//!  Macro. Convert a string using its current charset in sessobj-&gt;charset to unicode
#define TO_UNICODE(s) (Locale.Charset.decoder(CSESSION->charset)->feed(s)->drain())

#endif //__UTF_H
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

