
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define KEYTAB_SIZE 256
#define KEY_HEIGHT 5

#define BIT_ON 1
#define BIT_OFF 2

typedef struct Bkey {
	int map;
	int width;
	unsigned char bitmap[KEY_HEIGHT];
} bkey;

bkey key[KEYTAB_SIZE];

setkey(int index, int width, unsigned char ch0, unsigned char ch1,
unsigned char ch2, unsigned char ch3, unsigned char ch4)
{
	if (index >= KEYTAB_SIZE)
		return;

	key[index].map = index;
	key[index].width = width;
	key[index].bitmap[0] = ch0;
	key[index].bitmap[1] = ch1;
	key[index].bitmap[2] = ch2;
	key[index].bitmap[3] = ch3;
	key[index].bitmap[4] = ch4;
}

initkeys()
{
	int i;

	for (i = 0; i < KEYTAB_SIZE; i++)
	{
		key[i].map = -1;
		key[i].width = -1;
	}
	key[0].width = 4;
	key[0].bitmap[0] = 0xf0;
	key[0].bitmap[1] = 0xf0;
	key[0].bitmap[2] = 0xf0;
	key[0].bitmap[3] = 0xf0;
	key[0].bitmap[4] = 0xf0;

	setkey(' ', 3, 0x00, 0x00, 0x00, 0x00, 0x00);

	setkey('A', 5, 0x20, 0x50, 0x70, 0x88, 0x88);
	setkey('B', 4, 0xe0, 0x90, 0xe0, 0x90, 0xe0);
	setkey('C', 4, 0x60, 0x90, 0x80, 0x90, 0x60);
	setkey('D', 4, 0xe0, 0x90, 0x90, 0x90, 0xe0);
	setkey('E', 4, 0xf0, 0x80, 0xe0, 0x80, 0xf0);
	setkey('F', 4, 0xf0, 0x80, 0xe0, 0x80, 0x80);

	setkey('G', 4, 0x60, 0x90, 0x80, 0xb0, 0x60);
	setkey('H', 4, 0x90, 0x90, 0xf0, 0x90, 0x90);
	setkey('I', 1, 0x80, 0x80, 0x80, 0x80, 0x80);
	setkey('J', 4, 0x70, 0x20, 0x20, 0xa0, 0x40);
	setkey('K', 4, 0x90, 0xa0, 0xc0, 0xa0, 0x90);
	setkey('L', 4, 0x80, 0x80, 0x80, 0x80, 0xf0);

	setkey('M', 5, 0x88, 0xd8, 0xa8, 0x88, 0x88);
	//setkey('N', 5, 0x88, 0xc8, 0xa8, 0x98, 0x88);
	setkey('N', 4, 0x90, 0xd0, 0xb0, 0x90, 0x90);
	setkey('O', 4, 0x60, 0x90, 0x90, 0x90, 0x60);
	setkey('P', 4, 0xe0, 0x90, 0xe0, 0x80, 0x80);
	setkey('Q', 4, 0x60, 0x90, 0x90, 0xb0, 0x70);
	setkey('R', 4, 0xe0, 0x90, 0xe0, 0xa0, 0x90);
	setkey('S', 4, 0x70, 0x80, 0x60, 0x10, 0xe0);
	setkey('T', 5, 0xf8, 0x20, 0x20, 0x20, 0x20);

	setkey('U', 4, 0x90, 0x90, 0x90, 0x90, 0x60);
	setkey('V', 5, 0x88, 0x88, 0x50, 0x50, 0x20);
	setkey('W', 5, 0x88, 0x88, 0xa8, 0xd8, 0x88);
	setkey('X', 4, 0x90, 0x90, 0x60, 0x60, 0x90);
	setkey('Y', 5, 0x88, 0x50, 0x20, 0x20, 0x20);
	setkey('Z', 4, 0xf0, 0x10, 0x20, 0x40, 0xf0);

	setkey('0', 4, 0x60, 0x90, 0x90, 0x90, 0x60);
	setkey('1', 2, 0x40, 0xc0, 0x40, 0x40, 0x40);
	setkey('2', 4, 0x60, 0x90, 0x20, 0x40, 0xf0);
	setkey('3', 4, 0x60, 0x90, 0x20, 0x90, 0x60);
	setkey('4', 4, 0x10, 0x30, 0x50, 0xf0, 0x10);
	setkey('5', 4, 0xf0, 0x80, 0xe0, 0x10, 0xe0);

	setkey('6', 4, 0x60, 0x80, 0xe0, 0x90, 0x60);
	setkey('7', 4, 0xf0, 0x10, 0x20, 0x40, 0x40);
	setkey('8', 4, 0x60, 0x90, 0x60, 0x90, 0x60);
	setkey('9', 4, 0x60, 0x90, 0x70, 0x10, 0x60);

	setkey('-', 3, 0x00, 0x00, 0xe0, 0x00, 0x00);
	setkey(':', 1, 0x00, 0x80, 0x00, 0x80, 0x00);
	setkey('?', 4, 0x60, 0x90, 0x20, 0x00, 0x20);

	key['a'].map = 'A';
	key['b'].map = 'B';
	key['c'].map = 'C';
	key['d'].map = 'D';
	key['e'].map = 'E';
	key['f'].map = 'F';
	key['g'].map = 'G';
	key['h'].map = 'H';
	key['i'].map = 'I';
	key['j'].map = 'J';
	key['k'].map = 'K';
	key['l'].map = 'L';
	key['m'].map = 'M';

	key['n'].map = 'N';
	key['o'].map = 'O';
	key['p'].map = 'P';
	key['q'].map = 'Q';
	key['r'].map = 'R';
	key['s'].map = 'S';
	key['t'].map = 'T';
	key['u'].map = 'U';
	key['v'].map = 'V';
	key['w'].map = 'W';
	key['x'].map = 'X';
	key['y'].map = 'Y';
	key['z'].map = 'Z';

}

