/*  This file is part of the Brahms project
    Copyright (C) 2001 Matthias Kretz <kretz@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* $Id: kspinboxaction.cpp,v 1.1 2001/07/23 08:16:59 mkretz Exp $ */

#include "kspinboxaction.h"

#include <qwhatsthis.h>
#include <qspinbox.h>

#include <ktoolbar.h>

KSpinBoxAction::KSpinBoxAction( int minValue, int maxValue, int step, const QString& text, QObject* parent, const char* name )
	: KAction( text, 0, parent, name ),
	m_spinbox( 0 ),
	m_min( minValue ),
	m_max( maxValue ),
	m_step( step ),
	m_prefix( QString::null ),
	m_value( 0 )
{
}

KSpinBoxAction::~KSpinBoxAction()
{
}

int KSpinBoxAction::plug( QWidget *w, int index )
{
	if( !w->inherits( "KToolBar" ) )
		return -1;

	KToolBar *toolBar = (KToolBar *)w;
	
	int id = KAction::getToolButtonID();

	QSpinBox *spinbox = new QSpinBox( m_min, m_max, m_step, toolBar, "ToolBar SpinBox" );
	spinbox->setPrefix( m_prefix );
	spinbox->setValue( m_value );
	toolBar->insertWidget( id, 64, spinbox, index );

	addContainer( toolBar, id );

	connect( spinbox, SIGNAL( valueChanged( int ) ), SIGNAL( valueChanged( int ) ) );
	connect( toolBar, SIGNAL( destroyed() ), this, SLOT( slotDestroyed() ) );

	toolBar->setItemAutoSized( id, true );

	m_spinbox = spinbox;

	emit plugged();

	QWhatsThis::add( spinbox, whatsThis() );

	return containerCount() - 1;
}

void KSpinBoxAction::unplug( QWidget *w )
{
	if ( !w->inherits( "KToolBar" ) )
		return;

	KToolBar *toolBar = (KToolBar *)w;

	int idx = findContainer( w );

	toolBar->removeItem( menuId( idx ) );

	removeContainer( idx );
	m_spinbox = 0L;
}

void KSpinBoxAction::setPrefix( const QString & prefix )
{
	m_prefix = prefix;
	if( m_spinbox )
		m_spinbox->setPrefix( m_prefix );
}

void KSpinBoxAction::setValue( int value )
{
	m_value = value;
	if( m_spinbox )
		m_spinbox->setValue( m_value );
}

#include "kspinboxaction.moc"

// vim:tw=4:sw=4
