#ifndef _DELETESELECTION_H_
#define _DELETESELECTION_H_

#include "operation.h"

class Element;
class Compound;
class Table;
class Reference;
class Part;

/** This operation copies the selection to an internal memory
 */
class DeleteSelection : public Operation
{
 private:
  Table * _selection;
  Compound  * _comp;
  bool    _scratch;

 public:
  DeleteSelection(Compound * pt);
  DeleteSelection(const DeleteSelection&);
  ~DeleteSelection();

  void undo();
  void redo();

  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
