/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SEARCH_H
#define SEARCH_H

#include <qwidget.h>
#include <qtimer.h>

class KLineEdit;
class KToolBarButton;

/** The structure that contain all search terms
  * @author Sbastien Laot
  */
class SearchData// : public QObject
{
//  Q_OBJECT
  public:
	SearchData()  { isSearching = false; }
	~SearchData() {                      }
//  private:
	QString string;
	bool    isSearching;
	// TODO: finer search terms
};

/** A QWidget that allow user to enter terms to search in a Basket.
  * @author Sbastien Laot
  */
class SearchBar : public QWidget
{
  Q_OBJECT
  public:
	SearchBar(QWidget *parent = 0, const char *name = 0);
	~SearchBar();
	const SearchData& searchData();
  signals:
	void newSearch(const SearchData &data);
	void resetSearch();
  public slots:
	void reset();
	void setEditFocus();
  public:
	bool hasEditFocus();
	void show();
	void hide();
	KLineEdit* lineEdit() { return m_lineEdit; }
  private slots:
	void textChanged(const QString &text);
	void blinkBar();
  private:
	SearchData     *m_data;
	KLineEdit      *m_lineEdit;
	KToolBarButton *m_resetButton; // FIXME: TODO: Make the bar a ToolBar and then plug KActions
	QTimer          m_blinkTimer;
	int             m_blinkedTimes;
};

#endif // SEARCH_H
