/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kapplication.h>
#include <qwidget.h>
#include <qcursor.h>

#include "clickcursorfeedback.h"
#include "keyboard.h"

static const int interval = 100; // msec

ClickCursorFeedback::ClickCursorFeedback(QObject *parent, const char *name)
 : QObject(parent, name),
   m_widget(0L), m_timer(this), m_curShape(0), m_ctrlCurShape(0), m_altCurShape(0)
{
	connect( &m_timer, SIGNAL(timeout()), this, SLOT(timeout()) );
}


ClickCursorFeedback::~ClickCursorFeedback()
{
}

void ClickCursorFeedback::setWidget(QWidget *widget, int curShape, int ctrlCurShape, int altCurShape)
{
	m_curShape     = curShape;
	m_ctrlCurShape = ctrlCurShape;
	m_altCurShape  = altCurShape;

	m_widget = widget;
	m_timer.start(interval);
	timeout(true);
}

void ClickCursorFeedback::stopWidget()
{
	if (m_widget != 0L && // In case stopWidget() is called without calling setWidget() before
	    dynamic_cast<QWidget*>(m_widget) != 0L) // The widget can have been deleted since last time
		m_widget->unsetCursor();
	m_widget = 0L;
	m_timer.stop();
}

/** Change cursor every x msec
 *  Also emit shiftChanged if user pressed/released Shift
 *   since the last time or if force == true
 *  TODO: memorize last cursor to not change cursor too many times
 */
void ClickCursorFeedback::timeout(bool force)
{
	static bool oldShift = false;

	// The widget can have been deleted since last time: if yes, we do nothing!
	if (dynamic_cast<QWidget*>(m_widget) == 0L)
		return;

	bool shift = Keyboard::shiftPressed();
	bool ctrl  = Keyboard::controlPressed();
	bool alt   = Keyboard::altPressed();

	if (force || (shift != oldShift))
		emit shiftChanged(shift);
	oldShift = shift;

	if (ctrl && !alt)
		m_widget->setCursor(QCursor(m_ctrlCurShape));
	else if (!ctrl && alt)
		m_widget->setCursor(QCursor(m_altCurShape));
	else
		m_widget->setCursor(QCursor(m_curShape));
}

#include "clickcursorfeedback.moc"
