#!/usr/bin/php4 -q
<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    lu-unindex-story.php                                    */
/* Author:      Paul Waite                                              */
/* Description: Wrapper for un-indexing an HTML story file from         */
/*              Lucene. We expect the story ID to be passed on          */
/*              the command line.                                       */
/*                                                                      */
/*       usage: ./lu-unindex-story.php <storyid>                        */
/*                                                                      */
/* ******************************************************************** */
// CLI Program working dir is always its own directory
// so we need to get into the website root directory..
chdir("..");

include_once("application.php");
include_once("$LIBDIR/lucene-defs.php");

//debug_on(DBG_DIAGNOSTIC);
//debug_output(DBG_O_CLI);

// Only do anything if there are args..
if ($argc > 1) {
  $storyid = $argv[1];

  // Check for verbose mode of operation..
  if ($storyid == "-v") {
    debug_on(DBG_DIAGNOSTIC|DBG_DUMP);
    debug_output(DBG_O_CLI);
    $storyid = $argv[2];
  }
  if (is_numeric($storyid) && $storyid > 0) {
    $UI = new lucene_unindexmsg();
    $UI->unindex($storyid);
    $UI->send();
  }
  else {
    debugbr("invalid story ID $storyid");
  }
  debugbr("done.");
}
?>
