/*==============================================================*/
/* Database name:  axyl                                         */
/* DBMS name:      ORACLE Version 8i2 (8.1.6)                   */
/* Created on:     3/03/2005 12:07:59 p.m.                      */
/*==============================================================*/


drop index "ax_block_layout_FK";

drop index "ax_block_blocklet_FK";

drop index "ax_block_blocklet_FK2";

drop index "ax_configuration_config_FK";

drop index "ax_forum_member_FK";

drop index "ax_forum_member_FK2";

drop index "ax_fk_forum_msg_forum_FK";

drop index "ax_layout_set_FK";

drop index "ax_layout_set_sitepage_FK";

drop index "menu_language";

drop index "ax_menuoption_menu_FK";

drop index "ax_org_contactinfo_FK";

drop index "ax_user_org_FK";

drop index "ax_user_group_FK";

drop index "ax_user_group_FK2";

drop index "ax_user_ip_user_FK";

drop index "ax_wwwsession_user_FK";

drop table "ax_block" cascade constraints;

drop table "ax_block_blocklet" cascade constraints;

drop table "ax_blocklet" cascade constraints;

drop table "ax_catalog" cascade constraints;

drop table "ax_config" cascade constraints;

drop table "ax_configuration" cascade constraints;

drop table "ax_contactinfo" cascade constraints;

drop table "ax_content_location" cascade constraints;

drop table "ax_control" cascade constraints;

drop table "ax_element_set_enc" cascade constraints;

drop table "ax_enc_qualifier" cascade constraints;

drop table "ax_enc_scheme" cascade constraints;

drop table "ax_enc_value" cascade constraints;

drop table "ax_forum" cascade constraints;

drop table "ax_forum_member" cascade constraints;

drop table "ax_forum_msg" cascade constraints;

drop table "ax_group" cascade constraints;

drop table "ax_language" cascade constraints;

drop table "ax_layout" cascade constraints;

drop table "ax_layout_metadata" cascade constraints;

drop table "ax_layout_set" cascade constraints;

drop table "ax_layout_set_group" cascade constraints;

drop table "ax_menu" cascade constraints;

drop table "ax_menuoption" cascade constraints;

drop table "ax_meta_element" cascade constraints;

drop table "ax_meta_element_set" cascade constraints;

drop table "ax_meta_schema" cascade constraints;

drop table "ax_microsite" cascade constraints;

drop table "ax_microsite_media" cascade constraints;

drop table "ax_microsite_page" cascade constraints;

drop table "ax_microsite_page_plugin" cascade constraints;

drop table "ax_microsite_template" cascade constraints;

drop table "ax_organisation" cascade constraints;

drop table "ax_plugin_area" cascade constraints;

drop table "ax_plugin_content" cascade constraints;

drop table "ax_query_resource" cascade constraints;

drop table "ax_site_meta_element" cascade constraints;

drop table "ax_sitepage" cascade constraints;

drop table "ax_sitepage_group" cascade constraints;

drop table "ax_story" cascade constraints;

drop table "ax_story_category" cascade constraints;

drop table "ax_story_category_locs" cascade constraints;

drop table "ax_story_location" cascade constraints;

drop table "ax_story_media" cascade constraints;

drop table "ax_story_microsite" cascade constraints;

drop table "ax_story_translation" cascade constraints;

drop table "ax_user" cascade constraints;

drop table "ax_user_group" cascade constraints;

drop table "ax_user_ip" cascade constraints;

drop table "ax_wwwsession" cascade constraints;

create tablespace "axyl_system";

/*==============================================================*/
/* Table: "ax_block"                                            */
/*==============================================================*/
create table "ax_block"  (
   "block_id"           LONG                            not null,
   "layout_id"          LONG                            not null,
   "background_img"     LONG,
   "lang_id"            LONG                           default '0' not null,
   "block_desc"         VARCHAR2(4000),
   "block_style"        VARCHAR2(64),
   "block_type"         VARCHAR2(64),
   "cols"               INTEGER                        default 1 not null,
   "gutter_width"       INTEGER                        default 0 not null,
   "gutter_colour"      VARCHAR2(64),
   "blocklet_sep"       INTEGER                        default 0 not null,
   "border_width"       INTEGER                        default 0 not null,
   "border_colour"      VARCHAR2(64),
   "background_colour"  VARCHAR2(64),
   "justify"            VARCHAR2(16)                   default '' not null
      constraint CKC_JUSTIFY_AX_BLOCK check ("justify" in ('','left','center','right')),
   "valign"             VARCHAR2(50)                   default '' not null
      constraint CKC_VALIGN_AX_BLOCK check ("valign" in ('','top','middle','bottom')),
   "exportable"         SMALLINT                       default 0 not null,
   "cache"              VARCHAR2(64),
   "cache_updated"      DATE                           default SYSDATE not null,
   "last_modified"      DATE                           default SYSDATE not null,
   constraint "ax_block_pkey" primary key ("block_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

comment on column "ax_block"."lang_id" is
'A unique text code for this language';

/*==============================================================*/
/* Index: "ax_block_layout_FK"                                  */
/*==============================================================*/
create index "ax_block_layout_FK" on "ax_block" (
   "layout_id" ASC
);

/*==============================================================*/
/* Table: "ax_block_blocklet"                                   */
/*==============================================================*/
create table "ax_block_blocklet"  (
   "blocklet_id"        LONG                            not null,
   "block_id"           LONG                            not null,
   "display_order"      INTEGER                        default 0 not null,
   "visible"            SMALLINT                       default 1 not null,
   constraint "ax_block_blocklet_pkey" primary key ("blocklet_id", "block_id")
)
pctfree 15
pctused 75
storage
(
    initial 64K
    next 16K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Index: "ax_block_blocklet_FK"                                */
/*==============================================================*/
create index "ax_block_blocklet_FK" on "ax_block_blocklet" (
   "blocklet_id" ASC
);

/*==============================================================*/
/* Index: "ax_block_blocklet_FK2"                               */
/*==============================================================*/
create index "ax_block_blocklet_FK2" on "ax_block_blocklet" (
   "block_id" ASC
);

/*==============================================================*/
/* Table: "ax_blocklet"                                         */
/*==============================================================*/
create table "ax_blocklet"  (
   "blocklet_id"        LONG                            not null,
   "blocklet_desc"      VARCHAR2(4000),
   "blocklet_type"      VARCHAR2(50)                   default 'text' not null
      constraint CKC_BLOCKLET_TYPE_AX_BLOCKLET check ("blocklet_type" in ('text','list','ordered','bullets','table','raw')),
   "blocklet_width"     INTEGER                        default 100 not null
      constraint CKC_BLOCKLET_WIDTH_AX_BLOCKLET check ("blocklet_width" between 0 and 100),
   "blocklet_style"     VARCHAR2(64),
   "justify"            VARCHAR2(16)                   default '' not null
      constraint CKC_JUSTIFY_AX_BLOCKLET check ("justify" in ('','left','center','right')),
   "heading"            VARCHAR2(64),
   "heading_level"      INTEGER                        default 3 not null,
   "heading_colour"     VARCHAR2(64),
   "ruler"              VARCHAR2(50)                   default 'none' not null
      constraint CKC_RULER_AX_BLOCKLET check ("ruler" in ('none','top','bottom')),
   "ruler_width"        INTEGER                        default 100 not null
      constraint CKC_RULER_WIDTH_AX_BLOCKLET check ("ruler_width" between 0 and 100),
   "ruler_size"         INTEGER                        default 1 not null,
   "ruler_colour"       VARCHAR2(64),
   "content"            CLOB,
   "content_size"       FLOAT                          default 1.0 not null,
   "content_colour"     VARCHAR2(64),
   "table_style"        VARCHAR2(64),
   "table_autojustify"  SMALLINT                       default false not null,
   "table_rowstripes"   SMALLINT                       default false not null,
   constraint "ax_blocklet_pkey" primary key ("blocklet_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Table: "ax_catalog"                                          */
/*==============================================================*/
create table "ax_catalog"  (
   "cat_id"             LONG                            not null,
   "cat_name"           VARCHAR2(64)                    not null,
   "cat_desc"           VARCHAR2(64),
   "mime_type"          VARCHAR2(64)                    not null,
   "mime_category"      VARCHAR2(64)                    not null,
   "upload_timestamp"   DATE                           default SYSDATE not null,
   "category"           VARCHAR2(64),
   "keywords"           VARCHAR2(64),
   "filesize"           INTEGER                        default 0 not null,
   "filepath"           VARCHAR2(64)                    not null,
   "width"              INTEGER                        default 0 not null,
   "height"             INTEGER                        default 0 not null,
   constraint "ax_catalog_pkey" primary key ("cat_id")
)
pctfree 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Table: "ax_config"                                           */
/*==============================================================*/
create table "ax_config"  (
   "config_name"        VARCHAR2(64)                    not null,
   "config_fields"      VARCHAR2(64),
   constraint "ax_config_pkey" primary key ("config_name")
)
pctfree 5
pctused 85
storage
(
    initial 32K
    next 16K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Table: "ax_configuration"                                    */
/*==============================================================*/
create table "ax_configuration"  (
   "config_name"        VARCHAR2(64)                    not null,
   "config_id"          VARCHAR2(64)                    not null,
   "config_set"         VARCHAR2(64),
   constraint "ax_configuration_pkey" primary key ("config_name", "config_id")
)
pctfree 5
pctused 85
storage
(
    initial 32K
    next 16K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Index: "ax_configuration_config_FK"                          */
/*==============================================================*/
create index "ax_configuration_config_FK" on "ax_configuration" (
   "config_name" ASC
);

/*==============================================================*/
/* Table: "ax_contactinfo"                                      */
/*==============================================================*/
create table "ax_contactinfo"  (
   "contactinfo_id"     LONG                            not null,
   "addr_postal"        VARCHAR2(64),
   "addr_street"        VARCHAR2(64),
   "addr_suburb"        VARCHAR2(64),
   "addr_city"          VARCHAR2(64),
   "addr_country"       VARCHAR2(64),
   "addr_code"          VARCHAR2(64),
   "addr_other"         VARCHAR2(64),
   "emails"             VARCHAR2(50),
   "phone"              VARCHAR2(50),
   "phone_fax"          VARCHAR2(50),
   "phone_work"         VARCHAR2(50),
   "phone_mobile"       VARCHAR2(50),
   "urls"               VARCHAR2(64),
   constraint "ax_contactinfo_pkey" primary key ("contactinfo_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Table: "ax_content_location"                                 */
/*==============================================================*/
create table "ax_content_location"  (
   "location_id"        LONG                            not null,
   "location_name"      VARCHAR2(64)                    not null,
   "location_desc"      VARCHAR2(64),
   "enabled"            SMALLINT                       default 1 not null,
   constraint PK_AX_CONTENT_LOCATION primary key ("location_id")
)
pctfree 15
pctused 75
storage
(
    initial 50K
    next 50K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

comment on table "ax_content_location" is
'Contains unique logical locations on the website for content. These are not necessarily physical pages, but can be used in your application code to present the story in the locations required.';

comment on column "ax_content_location"."enabled" is
'If true, then items in this location can be displayed in an order determined by the user, else display by default method (usually reverse date order)';

/*==============================================================*/
/* Table: "ax_control"                                          */
/*==============================================================*/
create table "ax_control"  (
   "app_prefix"         VARCHAR2(64),
   "site_axyl_version"  VARCHAR2(64),
   "site_docroot"       VARCHAR2(64)
);

comment on table "ax_control" is
'Details which are registered for any Axyl website, on first access, or on upgrade.';

comment on column "ax_control"."app_prefix" is
'The code name of this website - often used as a prefix for messaging etc.';

comment on column "ax_control"."site_axyl_version" is
'The version of Axyl that this website was installed under';

comment on column "ax_control"."site_docroot" is
'The full physical path to this website when installed';

/*==============================================================*/
/* Table: "ax_element_set_enc"                                  */
/*==============================================================*/
create table "ax_element_set_enc"  (
   "schema_name"        VARCHAR2(64)                    not null,
   "element_id"         LONG                            not null,
   "enc_scheme_id"      LONG                            not null,
   constraint PK_AX_ELEMENT_SET_ENC primary key ("schema_name", "element_id", "enc_scheme_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

/*==============================================================*/
/* Table: "ax_enc_qualifier"                                    */
/*==============================================================*/
create table "ax_enc_qualifier"  (
   "enc_scheme_id"      LONG                            not null,
   "qual_name"          VARCHAR2(64)                    not null,
   "qual_label"         VARCHAR2(64),
   "comments"           VARCHAR2(64),
   "default_value"      VARCHAR2(64),
   "list_of_values"     VARCHAR2(64),
   "display_order"      INTEGER                        default 999 not null,
   constraint PK_AX_ENC_QUALIFIER primary key ("enc_scheme_id", "qual_name")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

/*==============================================================*/
/* Table: "ax_enc_scheme"                                       */
/*==============================================================*/
create table "ax_enc_scheme"  (
   "enc_scheme_id"      LONG                            not null,
   "enc_scheme_name"    VARCHAR2(64)                    not null,
   "label"              VARCHAR2(64),
   "tag_name"           VARCHAR2(64)                    not null,
   "description"        VARCHAR2(64),
   "datasrc_uri"        VARCHAR2(64),
   "reference_url"      VARCHAR2(64),
   "enabled"            SMALLINT                       default true not null,
   constraint PK_AX_ENC_SCHEME primary key ("enc_scheme_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

comment on table "ax_enc_scheme" is
'This table holds encoding schemes, which are basically lists of values. An example would be an encoding scheme for Media Types, which is essentially a list of mime-types. Other examples include Language Name Codes, and even Medical Subject Headings.';

comment on column "ax_enc_scheme"."enc_scheme_name" is
'Short name-tag - often an code like ''RFC3066''.';

comment on column "ax_enc_scheme"."label" is
'Full name of the scheme.';

comment on column "ax_enc_scheme"."datasrc_uri" is
'Location of downloadable scheme data.';

comment on column "ax_enc_scheme"."reference_url" is
'Web-page where scheme is described/defined.';

/*==============================================================*/
/* Table: "ax_enc_value"                                        */
/*==============================================================*/
create table "ax_enc_value"  (
   "enc_scheme_id"      LONG                            not null,
   "enc_value"          VARCHAR2(64)                    not null,
   "enc_label"          VARCHAR2(64),
   constraint PK_AX_ENC_VALUE primary key ("enc_scheme_id", "enc_value")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

/*==============================================================*/
/* Table: "ax_forum"                                            */
/*==============================================================*/
create table "ax_forum"  (
   "forum_id"           LONG                            not null,
   "moderator"          VARCHAR2(64),
   "forum_name"         VARCHAR2(64)                    not null,
   "forum_desc"         VARCHAR2(64),
   "enabled"            SMALLINT                       default 1 not null,
   "private"            SMALLINT                       default 0 not null,
   "last_author"        VARCHAR2(64),
   "threadlast_author"  INTEGER                        default 0 not null,
   "datelast_author"    DATE,
   "posts"              INTEGER                        default 0 not null,
   constraint "ax_forum_pkey" primary key ("forum_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Table: "ax_forum_member"                                     */
/*==============================================================*/
create table "ax_forum_member"  (
   "user_id"            VARCHAR2(64)                    not null,
   "forum_id"           LONG                            not null,
   constraint "ax_forum_mbr_pkey" primary key ("user_id", "forum_id")
)
pctfree 15
pctused 75
storage
(
    initial 64K
    next 16K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Index: "ax_forum_member_FK"                                  */
/*==============================================================*/
create index "ax_forum_member_FK" on "ax_forum_member" (
   "user_id" ASC
);

/*==============================================================*/
/* Index: "ax_forum_member_FK2"                                 */
/*==============================================================*/
create index "ax_forum_member_FK2" on "ax_forum_member" (
   "forum_id" ASC
);

/*==============================================================*/
/* Table: "ax_forum_msg"                                        */
/*==============================================================*/
create table "ax_forum_msg"  (
   "msg_id"             LONG                            not null,
   "forum_id"           LONG                            not null,
   "msg_subject"        VARCHAR2(64)                    not null,
   "msg_text"           VARCHAR2(64)                    not null,
   "msg_author"         VARCHAR2(64)                    not null,
   "msg_votes"          INTEGER                        default 0 not null,
   "last_modified"      DATE                           default SYSDATE not null,
   "parent_thread_id"   LONG,
   "sticky"             SMALLINT                       default false not null,
   "locked"             SMALLINT                       default false not null,
   "views"              INTEGER                        default 0 not null,
   "enabled"            SMALLINT                       default 1 not null,
   "replies"            INTEGER                        default 0 not null,
   constraint "ax_forum_msg_pkey" primary key ("msg_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Index: "ax_fk_forum_msg_forum_FK"                            */
/*==============================================================*/
create index "ax_fk_forum_msg_forum_FK" on "ax_forum_msg" (
   "forum_id" ASC
);

/*==============================================================*/
/* Table: "ax_group"                                            */
/*==============================================================*/
create table "ax_group"  (
   "group_id"           LONG                            not null,
   "group_desc"         VARCHAR2(4000)                  not null,
   constraint "ax_group_pkey" primary key ("group_id")
)
pctfree 15
pctused 75
storage
(
    initial 32K
    next 16K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Table: "ax_language"                                         */
/*==============================================================*/
create table "ax_language"  (
   "lang_id"            LONG                            not null,
   "lang_desc"          VARCHAR2(64)                    not null,
   "char_encoding"      VARCHAR2(64)                    not null,
   "direction"          VARCHAR(4)                     default 'LTR' not null
      constraint CKC_DIRECTION_AX_LANGU check ("direction" in ('LTR','RTL')),
   "is_default"         SMALLINT                       default 0 not null,
   "display_order"      INTEGER                        default 999 not null,
   "enabled"            SMALLINT                       default 1 not null,
   constraint PK_AX_LANGUAGE primary key ("lang_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

comment on table "ax_language" is
'Contains the languages that Axyl supports.';

comment on column "ax_language"."lang_id" is
'A unique text code for this language';

comment on column "ax_language"."lang_desc" is
'Nice descriptive word or phrase for this language.';

comment on column "ax_language"."char_encoding" is
'The character encoding code to use for this language. This code may appear in various webpage tags to guide browsers.';

comment on column "ax_language"."direction" is
'The direction the language is written in: LTR (left to right) or RTL (right to left.';

comment on column "ax_language"."is_default" is
'Whether this language is the default one.';

/*==============================================================*/
/* Table: "ax_layout"                                           */
/*==============================================================*/
create table "ax_layout"  (
   "layout_id"          LONG                            not null,
   "layout_name"        VARCHAR2(64)                    not null,
   "lang_id"            LONG                           default '0' not null,
   "index_category"     VARCHAR2(64),
   "layout_table"       VARCHAR2(64),
   "show_last_modified" SMALLINT                       default false not null,
   "format_last_modified" VARCHAR2(64),
   "prefix_last_modified" VARCHAR2(64),
   "layout_style"       VARCHAR2(64),
   "cache"              VARCHAR2(64),
   "cache_updated"      DATE,
   "last_modified"      DATE                           default SYSDATE not null,
   constraint "ax_layout_pkey" primary key ("layout_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

comment on column "ax_layout"."lang_id" is
'A unique text code for this language';

/*==============================================================*/
/* Index: "ax_layout_set_FK"                                    */
/*==============================================================*/
create index "ax_layout_set_FK" on "ax_layout" (
   "layout_name" ASC
);

/*==============================================================*/
/* Table: "ax_layout_metadata"                                  */
/*==============================================================*/
create table "ax_layout_metadata"  (
   "layout_id"          LONG                            not null,
   "element_id"         LONG                            not null,
   "schema_name"        VARCHAR2(64)                    not null,
   "meta_tag_value"     VARCHAR2(64),
   "enc_scheme_id"      LONG,
   "linked_uri"         SMALLINT                       default false not null,
   "language"           VARCHAR2(64),
   constraint PK_AX_LAYOUT_METADATA primary key ("element_id", "schema_name", "layout_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

comment on table "ax_layout_metadata" is
'This is the actual container of metadata values for the given layout. A webpage might contain multiple layouts, therefore the metadata to be entered for the page is the unique combination of all layout metadata elements.';

/*==============================================================*/
/* Table: "ax_layout_set"                                       */
/*==============================================================*/
create table "ax_layout_set"  (
   "layout_name"        VARCHAR2(64)                    not null,
   "page_id"            LONG,
   constraint "ax_layout_set_pkey" primary key ("layout_name")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Index: "ax_layout_set_sitepage_FK"                           */
/*==============================================================*/
create index "ax_layout_set_sitepage_FK" on "ax_layout_set" (
   "page_id" ASC
);

/*==============================================================*/
/* Table: "ax_layout_set_group"                                 */
/*==============================================================*/
create table "ax_layout_set_group"  (
   "layout_name"        VARCHAR2(64)                    not null,
   "cm_privilege"       VARCHAR(16)                     not null
      constraint CKC_CM_PRIVILEGE_AX_LAYOU check ("cm_privilege" in ('editor','author','entry')),
   "group_id"           LONG                            not null,
   constraint PK_AX_LAYOUT_SET_GROUP primary key ("layout_name", "cm_privilege", "group_id")
)
pctfree 15
pctused 75
storage
(
    initial 50K
    next 25K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

/*==============================================================*/
/* Table: "ax_menu"                                             */
/*==============================================================*/
create table "ax_menu"  (
   "menu_id"            LONG                            not null,
   "menu_name"          VARCHAR2(64)                    not null,
   "lang_id"            LONG                           default '0' not null,
   "menu_desc"          VARCHAR2(64),
   "menu_user_groups"   VARCHAR2(64),
   "active"             SMALLINT                       default 1 not null,
   "last_modified"      DATE                           default SYSDATE not null,
   constraint "ax_menu_pkey" primary key ("menu_id")
)
pctfree 5
pctused 85
storage
(
    initial 16K
    next 16K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

comment on column "ax_menu"."lang_id" is
'A unique text code for this language';

/*==============================================================*/
/* Index: "menu_language"                                       */
/*==============================================================*/
create unique index "menu_language" on "ax_menu" (
   "menu_name" ASC,
   "lang_id" ASC
);

/*==============================================================*/
/* Table: "ax_menuoption"                                       */
/*==============================================================*/
create table "ax_menuoption"  (
   "menuoption_id"      LONG                            not null,
   "menu_id"            LONG                            not null,
   "parent_id"          LONG                           default '0',
   "user_groups"        VARCHAR2(64),
   "user_type"          VARCHAR2(64),
   "menu_level"         INTEGER                        default 0 not null,
   "label"              VARCHAR2(64),
   "description"        VARCHAR2(64),
   "display_order"      INTEGER                        default 0 not null,
   "action"             VARCHAR2(64),
   "sitepage"           VARCHAR2(64),
   "sitepage_parms"     VARCHAR2(64),
   "auth_code"          SMALLINT                       default false not null,
   "active"             SMALLINT                       default 1 not null,
   "width"              INTEGER                        default 80 not null,
   "height"             INTEGER                        default 20 not null,
   "is_parent"          SMALLINT                       default 0 not null,
   "target"             VARCHAR2(64),
   "last_modified"      DATE                           default SYSDATE not null,
   constraint "ax_menuoption_pkey" primary key ("menuoption_id")
)
pctfree 15
pctused 75
storage
(
    initial 32K
    next 16K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Index: "ax_menuoption_menu_FK"                               */
/*==============================================================*/
create index "ax_menuoption_menu_FK" on "ax_menuoption" (
   "menu_id" ASC
);

/*==============================================================*/
/* Table: "ax_meta_element"                                     */
/*==============================================================*/
create table "ax_meta_element"  (
   "element_id"         LONG                            not null,
   "label"              VARCHAR2(64),
   "tag_name"           VARCHAR2(64)                    not null,
   "definition"         VARCHAR2(64),
   "parent_element"     LONG,
   "parent_schema"      VARCHAR2(64),
   "enabled"            SMALLINT                       default true not null,
   constraint PK_AX_META_ELEMENT primary key ("element_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

comment on table "ax_meta_element" is
'A metadata element is the basic description of a template for an actual container of metadata. It is usually first ''born'' in a particular meta schema, but can thenceforth be picked up and used as part of other schemas - this is the function of the foreign key field ''parent_schema''.';

/*==============================================================*/
/* Table: "ax_meta_element_set"                                 */
/*==============================================================*/
create table "ax_meta_element_set"  (
   "schema_name"        VARCHAR2(64)                    not null,
   "element_id"         LONG                            not null,
   "preferred_enc_scheme" LONG,
   "comments"           VARCHAR2(64),
   "obligation"         CHAR(1)                        default 'o' not null
      constraint CKC_OBLIGATION_AX_META_ check ("obligation" in ('m','c','r','o')),
   "default_value"      VARCHAR2(64),
   "list_of_values"     VARCHAR2(64),
   "display_order"      INTEGER                        default 999 not null,
   "enabled"            SMALLINT                       default true not null,
   constraint PK_AX_META_ELEMENT_SET primary key ("schema_name", "element_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

comment on table "ax_meta_element_set" is
'This table represents a list of metadata elements which comprise the given schema. The elements might originate from other schemas, but all together they comprise a logical set for this schema. Each schema can also flag it''s elements as either mandatory or not, and can define a default display (data entry) order.';

/*==============================================================*/
/* Table: "ax_meta_schema"                                      */
/*==============================================================*/
create table "ax_meta_schema"  (
   "schema_name"        VARCHAR2(64)                    not null,
   "description"        VARCHAR2(64),
   "namespace"          VARCHAR2(64),
   "namespace_uri"      VARCHAR2(64),
   constraint PK_AX_META_SCHEMA primary key ("schema_name")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

comment on table "ax_meta_schema" is
'A meta schema is simply an umbrella entity which describes a metadata element set. Examples would be ''Dublin Core'', ''AGLS'', or ''NZGLS''.';

/*==============================================================*/
/* Table: "ax_microsite"                                        */
/*==============================================================*/
create table "ax_microsite"  (
   "microsite_name"     VARCHAR2(64)                    not null,
   "menu_id"            LONG,
   "microsite_desc"     VARCHAR2(64),
   "microsite_domain"   VARCHAR2(64),
   "css"                CLOB,
   "css_ie"             CLOB,
   "css_ns"             CLOB,
   "req_microsite_publish" SMALLINT                       default 0 not null,
   "req_microsite_remove" SMALLINT                       default 0 not null,
   "currently_installed" SMALLINT                       default 0 not null,
   "last_installed"     DATE,
   "last_modified"      DATE                           default SYSDATE not null,
   constraint PK_AX_MICROSITE primary key ("microsite_name")
)
pctfree 15
storage
(
    initial 256K
    next 128K
    maxextents unlimited
)
tablespace "axyl_system";

/*==============================================================*/
/* Table: "ax_microsite_media"                                  */
/*==============================================================*/
create table "ax_microsite_media"  (
   "microsite_name"     VARCHAR2(64)                    not null,
   "cat_id"             LONG                            not null,
   constraint PK_AX_MICROSITE_MEDIA primary key ("microsite_name", "cat_id")
)
pctfree 15
pctused 75
storage
(
    initial 128K
    next 50K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system"
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

/*==============================================================*/
/* Table: "ax_microsite_page"                                   */
/*==============================================================*/
create table "ax_microsite_page"  (
   "microsite_page_id"  LONG                            not null,
   "microsite_name"     VARCHAR2(64)                    not null,
   "page_id"            LONG,
   "menuoption_id"      LONG,
   "microsite_template_id" LONG,
   "page_title"         VARCHAR2(64)                    not null,
   "corepage"           SMALLINT                       default 0 not null,
   "microsite_homepage" SMALLINT                       default 0 not null,
   "menuoption_label"   VARCHAR2(64)                    not null,
   "display_order"      INTEGER                        default 0 not null,
   "cache_seconds"      INTEGER                        default 0 not null,
   "enabled"            SMALLINT                       default 1 not null,
   constraint PK_AX_MICROSITE_PAGE primary key ("microsite_page_id")
)
pctfree 15
pctused 75
storage
(
    initial 128K
    next 50K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system"
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

/*==============================================================*/
/* Table: "ax_microsite_page_plugin"                            */
/*==============================================================*/
create table "ax_microsite_page_plugin"  (
   "plugin_id"          LONG                            not null,
   "microsite_page_id"  LONG                            not null,
   "plugin_pattern"     VARCHAR2(64)                    not null,
   "plugin_content"     VARCHAR2(64)                    not null,
   constraint PK_AX_MICROSITE_PAGE_PLUGIN primary key ("plugin_id")
);

/*==============================================================*/
/* Table: "ax_microsite_template"                               */
/*==============================================================*/
create table "ax_microsite_template"  (
   "microsite_template_id" LONG                            not null,
   "microsite_name"     VARCHAR2(64)                    not null,
   "template_name"      VARCHAR2(64)                    not null,
   "template_type"      VARCHAR2(64)                   default 'html' not null
      constraint CKC_TEMPLATE_TYPE_AX_MICRO check ("template_type" in ('html','wml')),
   "template_content"   VARCHAR2(64),
   constraint PK_AX_MICROSITE_TEMPLATE primary key ("microsite_template_id")
)
pctfree 15
pctused 75
storage
(
    initial 128K
    next 50K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system"
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

/*==============================================================*/
/* Table: "ax_organisation"                                     */
/*==============================================================*/
create table "ax_organisation"  (
   "org_id"             LONG                            not null,
   "contactinfo_id"     LONG,
   "org_name"           VARCHAR2(64)                    not null,
   "org_desc"           VARCHAR2(64),
   "org_contact"        VARCHAR2(64),
   "enabled"            SMALLINT                       default 1 not null,
   constraint "ax_org_pkey" primary key ("org_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Index: "ax_org_contactinfo_FK"                               */
/*==============================================================*/
create index "ax_org_contactinfo_FK" on "ax_organisation" (
   "contactinfo_id" ASC
);

/*==============================================================*/
/* Table: "ax_plugin_area"                                      */
/*==============================================================*/
create table "ax_plugin_area"  (
   "plugin_pattern"     VARCHAR2(64)                    not null,
   "plugin_desc"        VARCHAR2(64),
   constraint PK_AX_PLUGIN_AREA primary key ("plugin_pattern")
);

/*==============================================================*/
/* Table: "ax_plugin_content"                                   */
/*==============================================================*/
create table "ax_plugin_content"  (
   "plugin_content"     VARCHAR2(64)                    not null,
   "plugin_content_desc" VARCHAR2(64)                    not null,
   "generator"          VARCHAR2(64)                    not null,
   "generator_type"     TEXT                           default 'defer' not null
      constraint CKC_GENERATOR_TYPE_AX_PLUGI check ("generator_type" in ('cm','func','defer','lit','file')),
   "replace_content"    SMALLINT                       default 0 not null,
   constraint PK_AX_PLUGIN_CONTENT primary key ("plugin_content")
);

/*==============================================================*/
/* Table: "ax_query_resource"                                   */
/*==============================================================*/
create table "ax_query_resource"  (
   "quid"               LONG                            not null,
   "q_desc"             VARCHAR2(64),
   "q_query"            VARCHAR2(64),
   "q_script"           VARCHAR2(64),
   "enabled"            SMALLINT                       default 1 not null,
   constraint "ax_query_key" primary key ("quid")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Table: "ax_site_meta_element"                                */
/*==============================================================*/
create table "ax_site_meta_element"  (
   "element_id"         LONG                            not null,
   "schema_name"        VARCHAR2(64)                    not null,
   "label"              VARCHAR2(64),
   "description"        VARCHAR2(64),
   "indexed"            SMALLINT                       default false not null,
   "searchable"         SMALLINT                       default false not null,
   "obligation"         CHAR(1)                        default 'o' not null
      constraint CKC_OBLIGATION_AX_SITE_ check ("obligation" in ('m','c','r','o')),
   "default_value"      VARCHAR2(64),
   "list_of_values"     VARCHAR2(64),
   "display_order"      INTEGER                        default 999 not null,
   "enabled"            SMALLINT                       default true,
   constraint PK_AX_SITE_META_ELEMENT primary key ("element_id", "schema_name")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

comment on table "ax_site_meta_element" is
'This table holds the list of metadata elements which are going to be used for the website. These can be assembled from any of the defined metadata elements.';

/*==============================================================*/
/* Table: "ax_sitepage"                                         */
/*==============================================================*/
create table "ax_sitepage"  (
   "page_id"            LONG                            not null,
   "page_title"         VARCHAR2(64)                    not null,
   "page_path"          VARCHAR2(64)                    not null,
   "managed"            SMALLINT                       default 1 not null,
   "enabled"            SMALLINT                       default 1 not null,
   constraint "ax_sitepage_pkey" primary key ("page_id")
)
pctfree 5
pctused 85
storage
(
    initial 32K
    next 16K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Table: "ax_sitepage_group"                                   */
/*==============================================================*/
create table "ax_sitepage_group"  (
   "page_id"            LONG                            not null,
   "group_id"           LONG                            not null
)
pctfree 15
pctused 75
storage
(
    initial 125K
    next 100K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

/*==============================================================*/
/* Table: "ax_story"                                            */
/*==============================================================*/
create table "ax_story"  (
   "story_id"           LONG                            not null,
   "lang_id"            LONG                            not null,
   "category_id"        LONG,
   "story_author"       VARCHAR2(64)                    not null,
   "story_icon"         LONG,
   "story_icon_url"     VARCHAR2(64),
   "story_headline"     VARCHAR2(64),
   "story_precis"       VARCHAR2(64),
   "story_content"      VARCHAR2(64),
   "story_type"         VARCHAR2(64),
   "story_url"          VARCHAR2(64),
   "story_date"         DATE                           default 'now()' not null,
   "expiry_date"        DATE                            not null,
   "last_modified"      DATE                           default 'now()' not null,
   "deleted"            SMALLINT                       default 0 not null,
   "visible"            SMALLINT                       default 1 not null,
   constraint PK_AX_STORY primary key ("story_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

comment on column "ax_story"."story_url" is
'If the story is on a remote website, or a filesystem then the URL or physical path to the file is stored here.';

/*==============================================================*/
/* Table: "ax_story_category"                                   */
/*==============================================================*/
create table "ax_story_category"  (
   "category_id"        LONG                            not null,
   "category_desc"      VARCHAR2(64)                    not null,
   "has_media"          SMALLINT                       default 0 not null,
   "has_precis"         SMALLINT                       default 1 not null,
   "has_expiry"         SMALLINT                       default 0 not null,
   "has_multilang"      SMALLINT                       default 1 not null,
   "has_multimedia"     SMALLINT                       default 0 not null,
   constraint PK_AX_STORY_CATEGORY primary key ("category_id")
)
pctfree 15
pctused 75
storage
(
    initial 50K
    next 50K
    maxextents unlimited
    pctincrease 50
)
tablespace "axyl_system";

comment on table "ax_story_category" is
'The story can be used to split stories into groups, or subject areas.';

comment on column "ax_story_category"."has_media" is
'True if this category can have media (images, movies etc.) associated with it.';

comment on column "ax_story_category"."has_precis" is
'True if this category requires a precis or lead-in.';

comment on column "ax_story_category"."has_expiry" is
'True if this category has an expiry date associated with it.';

comment on column "ax_story_category"."has_multilang" is
'True if this category is for stories which could be translated into multiple languages.';

comment on column "ax_story_category"."has_multimedia" is
'If true then the category will support more than one item of associated media.';

/*==============================================================*/
/* Table: "ax_story_category_locs"                              */
/*==============================================================*/
create table "ax_story_category_locs"  (
   "category_id"        LONG                            not null,
   "location_id"        LONG                            not null
)
pctfree 15
pctused 75
storage
(
    initial 10K
    next 10K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

comment on table "ax_story_category_locs" is
'The default content locations for a story category.';

/*==============================================================*/
/* Table: "ax_story_location"                                   */
/*==============================================================*/
create table "ax_story_location"  (
   "story_id"           LONG                            not null,
   "location_id"        LONG                            not null,
   "display_order"      INTEGER                        default 0 not null
)
pctfree 15
pctused 75
storage
(
    initial 10K
    next 10K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

comment on table "ax_story_location" is
'Contains lists of stories which should be displayed in a particular location on the website. Also determines the order that the stories should be displayed in.';

/*==============================================================*/
/* Table: "ax_story_media"                                      */
/*==============================================================*/
create table "ax_story_media"  (
   "story_id"           LONG                            not null,
   "cat_id"             LONG                            not null,
   "caption"            VARCHAR2(64),
   "width"              INTEGER                        default 0 not null,
   "height"             INTEGER                        default 0 not null,
   "justify"            VARCHAR2(16)                   default '' not null
      constraint CKC_JUSTIFY_AX_STORY check ("justify" in ('','left','center','right')),
   "display_order"      INTEGER                        default 0 not null,
   constraint PK_AX_STORY_MEDIA primary key ("story_id", "cat_id")
)
pctfree 15
pctused 75
storage
(
    initial 50K
    next 50K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

comment on table "ax_story_media" is
'Media items associated with the story.';

/*==============================================================*/
/* Table: "ax_story_microsite"                                  */
/*==============================================================*/
create table "ax_story_microsite"  (
   "microsite_name"     VARCHAR2(64)                    not null,
   "story_id"           LONG                            not null
);

/*==============================================================*/
/* Table: "ax_story_translation"                                */
/*==============================================================*/
create table "ax_story_translation"  (
   "story_id"           LONG                            not null,
   "translated_story_id" LONG                            not null,
   constraint PK_AX_STORY_TRANSLATION primary key ("story_id", "translated_story_id")
)
pctfree 15
pctused 75
storage
(
    initial 10K
    next 10K
    maxextents unlimited
    pctincrease 0
)
tablespace "axyl_system";

comment on table "ax_story_translation" is
'Used to link translations of the same story together.';

/*==============================================================*/
/* Table: "ax_user"                                             */
/*==============================================================*/
create table "ax_user"  (
   "user_id"            VARCHAR2(64)                    not null,
   "org_id"             LONG                           default '0' not null,
   "password"           VARCHAR2(64),
   "full_name"          VARCHAR2(64),
   "user_type"          VARCHAR2(50)                   default 'user' not null
      constraint CKC_USER_TYPE_AX_USER check ("user_type" in ('user','sys')),
   "email"              VARCHAR2(50),
   "address"            VARCHAR2(50),
   "phone"              VARCHAR2(50),
   "fax"                VARCHAR2(50),
   "mobile"             VARCHAR2(50),
   "last_login"         DATE,
   "total_logins"       INTEGER                        default 0 not null,
   "limit_logins"       INTEGER                        default 0 not null,
   "enabled"            SMALLINT                       default 1 not null,
   "auth_code"          VARCHAR2(64),
   constraint "ax_user_pkey" primary key ("user_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Index: "ax_user_org_FK"                                      */
/*==============================================================*/
create index "ax_user_org_FK" on "ax_user" (
   "org_id" ASC
);

/*==============================================================*/
/* Table: "ax_user_group"                                       */
/*==============================================================*/
create table "ax_user_group"  (
   "group_id"           LONG                            not null,
   "user_id"            VARCHAR2(64)                    not null,
   constraint "ax_ugroup_pkey" primary key ("group_id", "user_id")
)
pctfree 5
pctused 85
storage
(
    initial 32K
    next 16K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Index: "ax_user_group_FK"                                    */
/*==============================================================*/
create index "ax_user_group_FK" on "ax_user_group" (
   "group_id" ASC
);

/*==============================================================*/
/* Index: "ax_user_group_FK2"                                   */
/*==============================================================*/
create index "ax_user_group_FK2" on "ax_user_group" (
   "user_id" ASC
);

/*==============================================================*/
/* Table: "ax_user_ip"                                          */
/*==============================================================*/
create table "ax_user_ip"  (
   "user_id"            VARCHAR2(64)                    not null,
   "ip"                 VARCHAR2(15)                    not null,
   constraint "ax_user_ip_pkey" primary key ("user_id", "ip")
)
pctfree 5
pctused 85
storage
(
    initial 16K
    next 16K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

/*==============================================================*/
/* Index: "ax_user_ip_user_FK"                                  */
/*==============================================================*/
create index "ax_user_ip_user_FK" on "ax_user_ip" (
   "user_id" ASC
);

/*==============================================================*/
/* Table: "ax_wwwsession"                                       */
/*==============================================================*/
create table "ax_wwwsession"  (
   "session_id"         VARCHAR2(64)                    not null,
   "user_id"            VARCHAR2(64)                    not null,
   "menuoption_id"      LONG,
   "lang_id"            LONG                           default '0' not null,
   "menu_status"        VARCHAR2(64),
   "user_groups"        VARCHAR2(64),
   "login_type"         INTEGER                        default 0 not null
      constraint CKC_LOGIN_TYPE_AX_WWWSE check ("login_type" between 0 and 4),
   "login_datetime"     DATE                           default SYSDATE not null,
   constraint "wwwsession_pkey" primary key ("session_id")
)
pctfree 15
pctused 75
storage
(
    initial 512K
    next 256K
    maxextents unlimited
    pctincrease 0
)
tablespace axyl_system;

comment on column "ax_wwwsession"."lang_id" is
'A unique text code for this language';

/*==============================================================*/
/* Index: "ax_wwwsession_user_FK"                               */
/*==============================================================*/
create index "ax_wwwsession_user_FK" on "ax_wwwsession" (
   "user_id" ASC
);

alter table "ax_block"
   add constraint FK_AX_BLOCK_AX_BLOCK__AX_CATAL foreign key ("background_img")
      references "ax_catalog" ("cat_id")
      on delete set null;

alter table "ax_block"
   add constraint "fk_ax_block_language" foreign key ("lang_id")
      references "ax_language" ("lang_id");

alter table "ax_block"
   add constraint "ax_block_layout" foreign key ("layout_id")
      references "ax_layout" ("layout_id")
      on delete cascade;

alter table "ax_block_blocklet"
   add constraint "ax_block_blocklet_block" foreign key ("block_id")
      references "ax_block" ("block_id")
      on delete cascade;

alter table "ax_block_blocklet"
   add constraint "ax_block_blocklet_blocklet" foreign key ("blocklet_id")
      references "ax_blocklet" ("blocklet_id")
      on delete cascade;

alter table "ax_configuration"
   add constraint "ax_configuration_config" foreign key ("config_name")
      references "ax_config" ("config_name")
      on delete cascade;

alter table "ax_element_set_enc"
   add constraint "fk_ax_elemset_enc_enc" foreign key ("enc_scheme_id")
      references "ax_enc_scheme" ("enc_scheme_id")
      on delete cascade;

alter table "ax_element_set_enc"
   add constraint "fk_ax_elemset_enc_set" foreign key ("schema_name", "element_id")
      references "ax_meta_element_set" ("schema_name", "element_id")
      on delete cascade;

alter table "ax_enc_qualifier"
   add constraint "fk_ax_enc_qual_scheme" foreign key ("enc_scheme_id")
      references "ax_enc_scheme" ("enc_scheme_id");

alter table "ax_enc_value"
   add constraint "fk_ax_enc_schema_value" foreign key ("enc_scheme_id")
      references "ax_enc_scheme" ("enc_scheme_id");

alter table "ax_forum"
   add constraint FK_AX_FORUM_MODERATOR foreign key ("moderator")
      references "ax_user" ("user_id");

alter table "ax_forum_member"
   add constraint "ax_forum_mbr_forum" foreign key ("forum_id")
      references "ax_forum" ("forum_id")
      on delete cascade;

alter table "ax_forum_member"
   add constraint "ax_forum_mbr_user" foreign key ("user_id")
      references "ax_user" ("user_id")
      on delete cascade;

alter table "ax_forum_msg"
   add constraint "ax_forum_msg_forum" foreign key ("forum_id")
      references "ax_forum" ("forum_id")
      on delete cascade;

alter table "ax_forum_msg"
   add constraint FK_AX_FORUM_PARENT_TH_AX_FORUM foreign key ("parent_thread_id")
      references "ax_forum_msg" ("msg_id")
      on delete cascade;

alter table "ax_layout"
   add constraint "fk_ax_layout_language" foreign key ("lang_id")
      references "ax_language" ("lang_id");

alter table "ax_layout"
   add constraint "ax_layout_set_layout" foreign key ("layout_name")
      references "ax_layout_set" ("layout_name")
      on delete cascade;

alter table "ax_layout_metadata"
   add constraint "fk_ax_lay_metadata_elem" foreign key ("element_id", "schema_name")
      references "ax_site_meta_element" ("element_id", "schema_name");

alter table "ax_layout_metadata"
   add constraint "fk_ax_lay_metadata_scheme" foreign key ("enc_scheme_id")
      references "ax_enc_scheme" ("enc_scheme_id")
      on delete set null;

alter table "ax_layout_metadata"
   add constraint "fk_ax_layout_meta_data" foreign key ("layout_id")
      references "ax_layout" ("layout_id")
      on delete cascade;

alter table "ax_layout_set"
   add constraint "ax_layout_set_sitepage" foreign key ("page_id")
      references "ax_sitepage" ("page_id")
      on delete set null;

alter table "ax_layout_set_group"
   add constraint "fk_group_layout_set" foreign key ("layout_name")
      references "ax_layout_set" ("layout_name")
      on delete cascade;

alter table "ax_layout_set_group"
   add constraint "fk_layout_set_group" foreign key ("group_id")
      references "ax_group" ("group_id")
      on delete cascade;

alter table "ax_menu"
   add constraint "fk_ax_menu_language" foreign key ("lang_id")
      references "ax_language" ("lang_id");

alter table "ax_menuoption"
   add constraint "fk_ax_menuoption_menu" foreign key ("menu_id")
      references "ax_menu" ("menu_id")
      on delete cascade;

alter table "ax_meta_element"
   add constraint "fk_ax_meta_elem_parent_schema" foreign key ("parent_schema")
      references "ax_meta_schema" ("schema_name");

alter table "ax_meta_element"
   add constraint "fk_ax_parent_element" foreign key ("parent_element")
      references "ax_meta_element" ("element_id")
      on delete cascade;

alter table "ax_meta_element_set"
   add constraint "fk_ax_meta_elem_set_elem" foreign key ("element_id")
      references "ax_meta_element" ("element_id")
      on delete cascade;

alter table "ax_meta_element_set"
   add constraint "fk_ax_meta_elem_set_schema" foreign key ("schema_name")
      references "ax_meta_schema" ("schema_name")
      on delete cascade;

alter table "ax_meta_element_set"
   add constraint "fk_ax_pref_enc_scheme" foreign key ("preferred_enc_scheme")
      references "ax_enc_scheme" ("enc_scheme_id");

alter table "ax_microsite"
   add constraint "fk_ax_microsite_menu" foreign key ("menu_id")
      references "ax_menu" ("menu_id")
      on delete set null;

alter table "ax_microsite_media"
   add constraint "fk_ax_microsite_media" foreign key ("cat_id")
      references "ax_catalog" ("cat_id")
      on delete cascade;

alter table "ax_microsite_media"
   add constraint "fk_ax_microsite_media_page" foreign key ("microsite_name")
      references "ax_microsite" ("microsite_name");

alter table "ax_microsite_page"
   add constraint "fk_ax_microsite_page" foreign key ("microsite_name")
      references "ax_microsite" ("microsite_name");

alter table "ax_microsite_page"
   add constraint "fk_ax_microsite_page_template" foreign key ("microsite_template_id")
      references "ax_microsite_template" ("microsite_template_id")
      on delete set null;

alter table "ax_microsite_page"
   add constraint "fk_ax_microsite_sitepage" foreign key ("page_id")
      references "ax_sitepage" ("page_id")
      on delete set null;

alter table "ax_microsite_page"
   add constraint "fk_microsite_page_menuoption" foreign key ("menuoption_id")
      references "ax_menuoption" ("menuoption_id")
      on delete set null;

alter table "ax_microsite_page_plugin"
   add constraint "fk_microsite_page_plugin" foreign key ("microsite_page_id")
      references "ax_microsite_page" ("microsite_page_id")
      on delete cascade;

alter table "ax_microsite_page_plugin"
   add constraint "fk_plugin_area" foreign key ("plugin_pattern")
      references "ax_plugin_area" ("plugin_pattern")
      on delete cascade;

alter table "ax_microsite_page_plugin"
   add constraint "fk_plugin_content" foreign key ("plugin_content")
      references "ax_plugin_content" ("plugin_content")
      on delete cascade;

alter table "ax_microsite_template"
   add constraint "fk_ax_microsite_template" foreign key ("microsite_name")
      references "ax_microsite" ("microsite_name");

alter table "ax_organisation"
   add constraint "ax_org_contactinfo" foreign key ("contactinfo_id")
      references "ax_contactinfo" ("contactinfo_id");

alter table "ax_site_meta_element"
   add constraint "fk_ax_site_meta_element" foreign key ("schema_name", "element_id")
      references "ax_meta_element_set" ("schema_name", "element_id");

alter table "ax_sitepage_group"
   add constraint "fk_ax_sitepage_gp_group" foreign key ("group_id")
      references "ax_group" ("group_id")
      on delete cascade;

alter table "ax_sitepage_group"
   add constraint "fk_ax_sitepage_gp_page" foreign key ("page_id")
      references "ax_sitepage" ("page_id")
      on delete cascade;

alter table "ax_story"
   add constraint "fk_ax_story_author" foreign key ("story_author")
      references "ax_user" ("user_id")
      on delete set null;

alter table "ax_story"
   add constraint "fk_ax_story_category" foreign key ("category_id")
      references "ax_story_category" ("category_id");

alter table "ax_story"
   add constraint "fk_ax_story_language" foreign key ("lang_id")
      references "ax_language" ("lang_id");

alter table "ax_story"
   add constraint "fk_story_icon" foreign key ("story_icon")
      references "ax_catalog" ("cat_id")
      on delete set null;

alter table "ax_story_category_locs"
   add constraint "fk_ax_story_categ_loc" foreign key ("category_id")
      references "ax_story_category" ("category_id");

alter table "ax_story_category_locs"
   add constraint FK_AX_STORY_AX_STORY__AX_CONTE foreign key ("location_id")
      references "ax_content_location" ("location_id")
      on delete cascade;

alter table "ax_story_location"
   add constraint "fk_ax_content_location" foreign key ("location_id")
      references "ax_content_location" ("location_id")
      on delete cascade;

alter table "ax_story_location"
   add constraint "fk_ax_story_location" foreign key ("story_id")
      references "ax_story" ("story_id")
      on delete cascade;

alter table "ax_story_media"
   add constraint FK_AX_STORY_AX_STORY__AX_CATAL foreign key ("cat_id")
      references "ax_catalog" ("cat_id")
      on delete cascade;

alter table "ax_story_media"
   add constraint FK_AX_STORY_AX_STORY__AX_STORY foreign key ("story_id")
      references "ax_story" ("story_id")
      on delete cascade;

alter table "ax_story_microsite"
   add constraint "fk_microsite_story" foreign key ("story_id")
      references "ax_story" ("story_id")
      on delete cascade;

alter table "ax_story_microsite"
   add constraint "fk_story_microsite" foreign key ("microsite_name")
      references "ax_microsite" ("microsite_name")
      on delete cascade;

alter table "ax_story_translation"
   add constraint "fk_ax_original_story" foreign key ("story_id")
      references "ax_story" ("story_id")
      on delete cascade;

alter table "ax_story_translation"
   add constraint "fk_ax_translated_story" foreign key ("translated_story_id")
      references "ax_story" ("story_id")
      on delete cascade;

alter table "ax_user"
   add constraint "ax_user_organisation" foreign key ("org_id")
      references "ax_organisation" ("org_id");

alter table "ax_user_group"
   add constraint "ax_user_group_group" foreign key ("group_id")
      references "ax_group" ("group_id")
      on delete cascade;

alter table "ax_user_group"
   add constraint "ax_user_group_user" foreign key ("user_id")
      references "ax_user" ("user_id")
      on delete cascade;

alter table "ax_user_ip"
   add constraint "ax_user_ip_user" foreign key ("user_id")
      references "ax_user" ("user_id")
      on delete cascade;

alter table "ax_wwwsession"
   add constraint "fk_ax_session_language" foreign key ("lang_id")
      references "ax_language" ("lang_id");

alter table "ax_wwwsession"
   add constraint "ax_wwwsession_user" foreign key ("user_id")
      references "ax_user" ("user_id")
      on delete cascade;

alter table "ax_wwwsession"
   add constraint FK_AX_WWWSE_SESSION_M_AX_MENUO foreign key ("menuoption_id")
      references "ax_menuoption" ("menuoption_id")
      on delete set null;

