/****************************************************************
**
** Attal : Lords of Doom
**
** propertiesBuilding.h
** Defines properties box for buildings on map
**
** Version : $Id: propertiesBuilding.h,v 1.2 2004/07/31 19:29:47 audoux Exp $
**
** Author(s) : Sardi Carlo - Pascal Audoux
**
** Date : 22/04/2004
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef PROPERTIESBUILDING_H
#define PROPERTIESBUILDING_H
 
 
// generic include files
// include files for QT
#include <qdialog.h>
#include <qptrlist.h>
#include <qlabel.h>
// application specific include files
#include "libCommon/genericPlayer.h"
#include "libCommon/genericBuilding.h"

class QComboBox;
class QListBox;
class GenericLord;
class GenericBuilding;
class GenericPlayer;

/*              ------------------------------
 *                         propertiesBuilding
 *              ------------------------------ */


/** Dialog for editing the properties of the building */
class PropertiesBuilding : public QDialog
{
	Q_OBJECT
public:
	/** Constructor */
	PropertiesBuilding( QPtrList<GenericPlayer> * players, QWidget * parent = 0, const char * name = 0 );

	void init( GenericBuilding * building );

	void refresh( QPtrList<GenericPlayer> * players );

public slots:
	void slot_accept();

	void slot_owner( int );

private:
	QPtrList<GenericPlayer> * _players;
	GenericBuilding * _building;
	QListBox * _listBuilding;
	QLabel * _name;
	QComboBox * _ownerList;
};

#endif // PROPERTIESBUILDING_H
