/****************************************************************
**
** Attal : Lords of Doom
**
** propertiesBase.h
** Defines properties box for bases on map
**
** Version : $Id: propertiesBase.h,v 1.4 2004/12/08 11:17:30 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 29/12/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef PROPERTIESBASE_H
#define PROPERTIESBASE_H
 
#include "propertiesLord.h"
 
// generic include files
// include files for QT
#include <qdialog.h>
#include <qptrlist.h>
// application specific include files
#include "libCommon/genericPlayer.h"

class QComboBox;
class QListView;

class AskString;
class GenericLord;
class GenericBase;
class GenericPlayer;
class GeneralPropertiesBase;
class PropertiesBaseUnits;

/*              ------------------------------
 *                         PropertiesBase
 *              ------------------------------ */

class PropertiesBase : public QTabDialog
{
	Q_OBJECT
public:
	/** Constructor */
	PropertiesBase( QPtrList<GenericPlayer> * players, QWidget * parent = 0, const char * name = 0 );

	void init( GenericBase * base );

public slots:
	virtual void accept();

private:
	QPtrList<GenericPlayer> * _players;
	GenericBase * _base;

	GeneralPropertiesBase * _general;
	PropertiesBaseUnits * _units;
};



/** Dialog for editing the properties of the base */
class GeneralPropertiesBase : public QWidget
{
	Q_OBJECT
public:
	/** Constructor */
	GeneralPropertiesBase( QPtrList<GenericPlayer> * players, QWidget * parent = 0, const char * name = 0 );

	void init( GenericBase * base );

	void refresh( QPtrList<GenericPlayer> * players );
	
	void accept();

public slots:

	void slot_owner( int );

private:
	QPtrList<GenericPlayer> * _players;
	GenericBase * _base;
	QListView * _listBuilding;
	QComboBox * _ownerList;
	AskString * _name;
};

class PropertiesBaseUnits : public QWidget
{
public:
	PropertiesBaseUnits( QWidget * parent = 0, const char * name = 0 );

	void init( GenericBase * base );

	void accept();

	bool hasNoneUnits ();

protected:
	GenericBase * _base;
	EditTroop * _troop[MAX_UNIT];
};



#endif // PROPERTIESBASE_H
