/****************************************************************
**
** Attal : Lords of Doom
**
** graphicalLord.h
** draw a hero on the map
**
** Version : $Id: graphicalLord.h,v 1.3 2004/09/05 20:41:32 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 09/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#ifndef GRAPHICALLORD_H
#define GRAPHICALLORD_H
 
// generic include files
// include files for QT
#include <qcanvas.h>
#include <qcolor.h>
// application specific includes
#include "libClient/cell.h"
#include "libClient/flag.h"

class GenericPlayer;

/*              ------------------------------
 *                        GraphicalLord
 *              ------------------------------ */

/** build the graphical part of the Lord */
class GraphicalLord : public QCanvasSprite
{
public:
	/** Constructor */
	GraphicalLord( QCanvas * canvas );

	virtual ~GraphicalLord();

	/** Set the Lord on the cell */
	virtual void setPosition( Cell *cell );
	
	/** Move the lord at the given cell */
	virtual void goTo( GenericCell *cell );
	
	virtual void setVisible( bool state );
	
	/** Advance animation */
	void advance( int stage );
	
	virtual void setOwner( GenericPlayer * player );
	
	/** Return RTTI */
	int rtti() const { return RTTI; };
	
	static const int RTTI;
	
protected:
	QCanvasPixmap* imageAdvanced() const;
	Flag * _flag;
};

#endif // GRAPHICALLORD_H

