/****************************************************************
**
** Attal : Lords of Doom
**
** gameDescription.cpp
** description of game info
**
** Version : $Id: gameDescription.cpp,v 1.5 2004/09/09 21:43:01 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 07/01/2001
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "gameDescription.h"

// generic include files
// include files for QT
#include <qfile.h>
#include <qtextstream.h>
// application specific include files
#include "libCommon/calendar.h"
#include "libCommon/dataTheme.h"
#include "libCommon/genericLord.h"
#include "libCommon/genericPlayer.h"
#include "libCommon/log.h"
#include "libCommon/unit.h"

#include "libClient/graphicalArtefact.h"

extern DataTheme DataTheme;
extern QString IMAGE_PATH;
extern QString DATA_PATH;


GameDescription::GameDescription()
{
	_calendar = new Calendar();
	_calendar->reinit();
	_artefacts.setAutoDelete( true );
	_players.setAutoDelete( true );
}

GameDescription::~GameDescription()
{
	delete _calendar;	
}

void GameDescription::setPlayerNumber( uint nb )
{
	_players.clear();
	for( uint i = 0; i < nb; i++ ) {
		/// XXX: theMap = 0...
		_players.append( new GenericPlayer( 0 ) );
	}
}

uint GameDescription::getPlayerNumber()
{
	return _players.count();
}

GenericPlayer * GameDescription::getPlayer( uint num )
{
	GenericPlayer * ret = 0;
	
	if( num < _players.count() ) {
		ret = _players.at( num );
	}
	
	return ret;
}

Artefact * GameDescription::getArtefactById( int id )
{
	Artefact * ret = 0;
	for( uint i = 0; i < _artefacts.count(); i++ ) {
		if( _artefacts.at( i )->getId() == id ) {
			ret = _artefacts.at( i );
		}
	}
	return ret;
}

void GameDescription::initLords()
{
	uint nbLord = DataTheme.lords.count();
	uint i;

	_realLords = new Lord * [ nbLord ];
	for( i = 0; i < nbLord; i++ ) {
		_realLords[i] = 0;
	}
}


void GameDescription::reInitLords()
{
	uint nbLord = DataTheme.lords.count();
	uint i;
	
	for( i = 0; i < nbLord; i++ ) {
		_realLords[i] = 0;
	}

}
