/*
 * Copyright (c) 1995 - 2001 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <nnpfs/nnpfs_locl.h>

RCSID("$Id: nnpfs_syscalls-wrap-macos.c,v 1.4 2002/09/07 10:45:19 lha Exp $");

/*
 * NNPFS system calls.
 */

#include <nnpfs/nnpfs_syscalls.h>
#include <nnpfs/nnpfs_message.h>
#include <nnpfs/nnpfs_fs.h>
#include <nnpfs/nnpfs_dev.h>
#include <nnpfs/nnpfs_node.h>
#include <nnpfs/nnpfs_deb.h>

#include <kafs.h>

int nnpfs_syscall_num;

static struct sysent old_syscallent;

static struct sysent nnpfs_syscallent = {
    5,				       /* number of args */
    1,				       /* can execute in parallel */
    KERNEL_FUNNEL,		       /* funnel type */
    nnpfspioctl			       /* function pointer */
};

static struct sysent old_setgroups;

/* XXX really defined in kern/kern_lkm.c */
extern int
sys_lkmnosys(struct proc *p, void *v, register_t *retval);

/*
 *
 */

static int
try_install_syscall (int offset,
		     struct sysent new_sysent,
		     struct sysent *old_sysent)
{
    if(sysent[offset].sy_call != sys_lkmnosys)
       return EBUSY;

    *old_sysent = sysent[offset];
    sysent[offset] = new_sysent;
    return 0;
}

/*
 *
 */

static int
install_first_free_syscall (int *offset,
			    struct sysent sysent,
			    struct sysent *old_sysent)
{
    int i;

    for (i = 1; i < SYS_MAXSYSCALL; ++i)
	if (try_install_syscall (i, sysent, old_sysent) == 0) {
	    *offset = i;
	    return 0;
	}
    return ENFILE;
}

/*
 * Try AFS_SYSCALL first, if that fails, any free slot
 */

int
nnpfs_install_syscalls(void)
{
    int ret = ENOENT;

#ifdef AFS_SYSCALL
    if (ret != 0) {
	ret = try_install_syscall(AFS_SYSCALL,
				  nnpfs_syscallent,
				  &old_syscallent);
	if (ret == 0)
	    nnpfs_syscall_num = AFS_SYSCALL;
    }
#endif
    if (ret != 0)
	ret = install_first_free_syscall (&nnpfs_syscall_num,
					  nnpfs_syscallent,
					  &old_syscallent);
    if (ret != 0)
	NNPFSDEB(XDEBSYS, ("failed installing nnpfs_syscall\n"));
    if (ret == 0) {
	old_setgroups = sysent[SYS_setgroups];
	old_setgroups_func = old_setgroups.sy_call;
	sysent[SYS_setgroups].sy_call = nnpfs_setgroups;
    }
    return ret;
}

int
nnpfs_uninstall_syscalls(void)
{
    if (nnpfs_syscall_num) {
	sysent[nnpfs_syscall_num] = old_syscallent;
	sysent[SYS_setgroups] = old_setgroups;
    }
    return 0;
}

int
nnpfs_stat_syscalls(void)
{
    return 0;
}
