/* $Id: GLRenderer.h,v 1.12 2003/03/23 20:09:25 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the ArkRPG Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARKGLRENDERER_H
#define ARKGLRENDERER_H

#include <Ark/ArkRenderer.h>
#include <Ark/ArkTimer.h>

#include <Modules/Renderer/ArkRenderer.h>

#ifdef WIN32
#include <windows.h>
#include <wingdi.h>
#define GL_GLEXT_DYNAMIC
#endif

#ifndef GL_GLEXT_DYNAMIC
#define GL_GLEXT_LEGACY
#endif

#include <GL/gl.h>

#ifndef GL_GLEXT_DYNAMIC
#define GL_GLEXT_PROTOTYPES
#endif

#include <Modules/Renderer/glext.h>

#include "Visual.h"

namespace Ark
{
   typedef void (APIENTRY * PFNGLACTIVETEXTUREARBPROC) (GLenum texture);
   typedef void (APIENTRY * PFNGLCLIENTACTIVETEXTUREARBPROC) (GLenum texture);

   typedef void (APIENTRY * PFNGLLOCKARRAYSEXTPROC)
      (GLint first, GLsizei count);
   typedef void (APIENTRY * PFNGLUNLOCKARRAYSEXTPROC) (void);

   class ARKRENDERER_DLL_API GLRenderer : public Renderer
   {
      public:
	 //
	 Ptr<GLCache> m_Cache;
	 Camera m_Camera;
	 Matrix44 m_ProjectionMatrix;
	 Matrix44 m_ViewMatrix;
	 Frustum m_Frustum;

	 /// m_Near and m_Far should be replaced by frustum usage
	 scalar m_Near;
	 scalar m_Far;

	 int m_Viewport[4];
	 bool m_DumpNormals;

	 Timer m_Timer;
	 scalar m_FrameTime;

	 // State. Beware that the State has to be deleted before the cache
         // because it can contains a reference to a texture..
	 Material m_State;
	 int m_TexUnit;


     public:
	 void SetTexture (const TexturePtr& tex);
	 void SetCulling (bool enable);
	 void SetDepthTest(bool enable);
	 void SetDepthFunc (DepthFunc df);
	 void SetDepthWrite (bool write);
	 void SetBlend (bool blend,
			BlendFunc src = BLEND_UNDEFINED,
			BlendFunc dst = BLEND_UNDEFINED);
	 void SetAlphaTest (bool alphatest,
			    DepthFunc funct = DEPTHFUNC_UNDEFINED,
			    scalar value = 0.5);

	 void DisableLighting();
	 void SetLighting (bool lighting,
			   const Color &ambient,
			   const Color &diffuse,
			   const Color &specular);

	 virtual void RenderLight(const Light &, int);

	 // Texgen

	 void SetLinearTexGen (const scalar *planeU,
			       const scalar *planeV);
	 void SetTexGen (bool enabled);
	 void SetTexEnv (TextureEnv texenv);

      private:

	 /**
	  * If these functions are set, then the corresponding extension is
	  * supported. Compiled vertex buffers might be disabled by setting the
	  * \c glrenderer::CompiledVertexBuffer config var to \c false.
	  */
	 bool EXT_compiled_vertex_array;
#ifdef GL_GLEXT_DYNAMIC
	 PFNGLLOCKARRAYSEXTPROC glLockArraysEXT;
	 PFNGLUNLOCKARRAYSEXTPROC glUnlockArraysEXT;
#endif

	 /// Multitexturing
	 bool ARB_multitexture;
#ifdef GL_GLEXT_DYNAMIC
	 PFNGLACTIVETEXTUREARBPROC glActiveTextureARB;
	 PFNGLCLIENTACTIVETEXTUREARBPROC glClientActiveTextureARB;
#endif

	 /**
	  * On some cards setting this value to \c true corrects the problem
	  * of odd colors when using CVA. This value can be set using the
	  * \c glrenderer::CVAHack var.
	  */
	 bool CVA_hack;
      
	 /**
	  * Misc. support functions.
	  */
	 bool SetupMaterial (const Material &mat);
	 bool SetupPass (const ShaderPass &pass, bool setdefault);
	 bool SetVertexBuffer (int format, const VertexBuffer &VB,
			       bool disable);
	 
	 /// Get view matrix and compute view frustum
	 void MatrixChanged ();
	 
	 /// Keep informations about set pointers..
	 uchar *m_CoordPointer;
	 uchar *m_NormalPointer;
	 int m_CoordStride, m_NormalStride;

      public:
	 /// Renderer implementation.
	 virtual bool SetActiveVB (const VertexBuffer &VB);
	 virtual bool OverrideVB (int override_flags,
				  const VertexBuffer &VB);
	 
	 /**
	  * Those two functions do nothing if compiled vertex arrays are not
	  * supported or are disabled.
	  */
	 virtual bool LockVB (int begin, size_t n);
	 virtual bool UnlockVB ();

	 virtual bool RenderBlock (const Material &material,
				   PrimitiveType type,
				   const ushort *indices,
				   size_t n);

	 virtual bool RenderBlock (const Material &material,
				   PrimitiveType type,
				   const VertexBuffer &vb,
				   int numvertices);

	 /**
	  * Send a list of polygons to OpenGL, WITHOUT caring about
	  * the current state, and without setting the material.
	  */
	 virtual bool PushBlock (PrimitiveType type,
				 const ushort *indices,
				 size_t n);

	 /**
	  * Send a list of polygons to OpenGL, WITHOUT caring about
	  * the current state, and without setting the material. This function
	  * doesnt use vertex buffers.
	  */
	 virtual bool PushBlock (PrimitiveType type,
				 const VertexBuffer &vb,
				 size_t n);
      public:
	 GLRenderer (GLCache *cache = NULL);
	 virtual ~GLRenderer ();

	 virtual Cache &GetCache()
	 {return *m_Cache;}

	 // ===================================================================

	 virtual bool RenderParticleSys (ParticleSys *psys);

	 // ==================================================================
	 virtual bool SetViewport (int x, int y, int w, int h);
	 virtual bool SetCamera (const Camera &cam);
	 virtual bool SetPlanes (scalar np, scalar fp);
	 virtual bool SetIdentity ();

	 virtual const Matrix44 &GetViewMatrix();
	 virtual const Matrix44 &GetProjectionMatrix();
	 virtual void PushModelMatrix(Matrix44 &matx);
	 virtual void PopModelMatrix();
	 virtual const Frustum &GetFrustum() const;
   };

} // namespace Ark

#include <Ark/ArkFactoryDef.h>
ARK_REGISTER_DEF(ARKRENDERER_DLL_API);

#endif // ARKGLRENDERER_H
