/* $Id: LuaEntity.h,v 1.5 2003/02/14 13:40:28 mat Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_LUAENTITY_H
#define ARK_LUAENTITY_H

#include <Modules/Lua/ArkLua.h>

#include <Engine/Entity.h>
#include <Modules/Lua/luna.h>
#include <Modules/Lua/LuaListTable.h>

namespace Ark
{
   EngineEntity *CreateLuaEntity();

   class ARKLUA_DLL_API LuaEntity : public EngineEntity, public LunaObject
   {
      public:
	 static const char className[];
	 static const Luna<LuaEntity>::RegType Register[];

      private:
	 String m_Callback;
	 bool push_check_objfunction (const String &fname);

      public:
	 LuaEntity(lua_State *L);
	 ~LuaEntity();

	 /// Name, short name, identifier
	 int get_name (lua_State *L);
	 int set_name (lua_State *L);
	 int get_shortname (lua_State *L);
	 int set_shortname (lua_State *L);
	 int get_id (lua_State *L);

	 /// Callbacks
	 int add_timer (lua_State *L);
	 int add_message (lua_State *L);

	 /// Visual
	 int psys_set (lua_State *L);
	 int psys_stop (lua_State *L);
	 int psys_exists (lua_State *L);
	 int set_model (lua_State *L);
	 int get_model (lua_State *L);
	 int play_anim (lua_State *L);
	 int play_sound (lua_State *L);
	 int play_music (lua_State *L);

	 /// Position
	 int set_position (lua_State *L);
	 int set_entity_goal (lua_State *L);
	 int set_position_goal (lua_State *L);
	 int set_no_goal (lua_State *L);
	 int get_position (lua_State *L);
      
	 /// Flags
#define FLAGACCESSOR(func, flagvalue)                               \
      int is_ ## func (lua_State *L);                               \
      int set_ ## func (lua_State *L);

	 FLAGACCESSOR (aidriven, AIDRIVEN);
	 FLAGACCESSOR (dead, DEAD);
	 FLAGACCESSOR (visible, VISIBLE);
	 FLAGACCESSOR (collider, COLLISION);
	 FLAGACCESSOR (staticp, STATIC);
#undef FLAGACCESSOR
	 
	 /// Clear changed flag
	 int clear_changed (lua_State *L);
      
	 /// Entity binding.
	 int attach_to_entity (lua_State *L);
	 int is_attached (lua_State *L);

	 /// Entity management
	 int set_entries (lua_State *L);
	 int set_callback_entries (lua_State *L);
	 int set_callback (lua_State *L);
	 int get_callback (lua_State *L);

	 //////////////////////////////////////////////////////////////////////
	 //////////////////////////////////////////////////////////////////////
	 //////////////////////////////////////////////////////////////////////

	 // === Functions to be implemented by script entities ===

	 //////////////////////////////////////////////////////////////////////
	 //////////////////////////////////////////////////////////////////////
	 //////////////////////////////////////////////////////////////////////

	 bool SetEntries (Engine *engine, const Ark::EntryList &entries);
	 bool SetCallback (Engine *engine, const Ark::EntryList &entries);

	 virtual void Create ();
	 virtual bool EvGoalReached ();
	 virtual bool EvTimer (int n);
	 virtual bool EvTell ();
	 void EvHit (const EntityCollision &col);
   };

   extern ARKLUA_DLL_API lua_State *g_LuaState;

  /**
  * Allow to manage list of entities.
  */
  class ARKLUA_DLL_API LuaEntityList : public LuaListTable
  {
    public:
    /**
     * Constructor
     */
    LuaEntityList(lua_State* L, int index = -1) : LuaListTable(L, index) {}
    
    /**
     * Add an element to the list
     *
     * \param element The element to add.
     */
    void addElement(LuaEntity& element);

    /**
     * Constructs a LuaEntityList from scratch. This creates a new table on
     * the stack.
     *
     * \param L The lua state where we are going to create the table.
     */
    static LuaEntityList* createTable(lua_State* L);
  };
}

#endif
