/* $Id: ArkSkin.cpp,v 1.9 2003/03/20 17:23:25 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <Ark/ArkSkin.h>
#include <Ark/ArkCache.h>
#include <Ark/ArkSystem.h>

namespace Ark
{
   /// Create an empty skin with the given name.
   Skin::Skin (const String &name) : 
      Object (name, V_SKIN)
   {}

   /// Destroy the given skin.
   Skin::~Skin ()
   {
   }

   /// Load the skin from the given file.
   bool
   Skin::Load (Cache* cache, const String &name)
   {
      AutoReadStream file (name);
      ReadStream& str = file.Get();
      
      while (! str.fail())
      {
	  String mName;
	  std::getline (str, mName);

	  if (mName.empty())
	     continue;
	  
	  MaterialPtr mat;
	  if (cache->Get (V_MATERIAL, mName, mat))
	  {
	      m_Materials.push_back(mat);
	  }
      }

      return m_Materials.size() != 0;
   }


   /// Insert a new material in this skin.
   void
   Skin::Insert (const MaterialPtr& mat)
   {
       // References the material
       m_Materials.push_back(mat);
   }

   /**
    * Give the integer identifier corresponding to the 
    * material name.
    */
   int
   Skin::Find (const Ark::String &name)
   {
      const int materialCount = m_Materials.size();
      for (int i=0 ; i<materialCount ; ++i)
      {
	 if (m_Materials[i]->Name() == name)
	 {
	    //Sys()->Log ("%s index is %d\n", name.c_str(), i);
	    return i;
	 }
      }

      return -1;
   }

   /// Get the material whith the given identifier.
   Material*
   Skin::GetMaterial (int id)
   {
      return &*m_Materials[id];
   }
      
}
