/* $Id: ArkObject.cpp,v 1.3 2001/10/17 19:50:31 zongo_fr Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sstream>
      
#include <Ark/ArkObject.h>
#include <Ark/ArkString.h>

namespace Ark
{

   /**
    * Create a new object. It simply sets its name.
    *  \param name is the name of the object
    */
   Object::Object (const String &name, ObjectType type) :
      m_Name (name),
      m_Type (type)
   {}
   
   /**
    * A object can't be destroyed directly : the Unref() method should
    * be called and only the cache can decide if it needs to be destroyed
    * (if the memory is low, or if the object hasn't been accessed for
    * a long time, by example).
    */
   Object::~Object ()
   {
   }

   /**
    * A  object implementation can have a Load method, which tries
    * to read from \c file, to override the \c Loaders one in Cache
    */
   bool
   Object::Load (Cache* cache, const String &name)
   {
      return false;
   }

	 
   /**
    * Called by the object cache after the object has been loaded. It
    * can be used to do operations that need data to be loaded 
    * (ie. create a compiled vertex buffer for a Model, send the texture
    * to the rendering engine for a Texture, and so on).
    */
   bool
   Object::PostLoad (Cache* cache)
   {
      return true;
   }

   /**
    * Return a description of this object. This is used to dump the state
    * of the object cache, by example.
    */
   String
   Object::Dump (bool long_version)
   {
       std::ostringstream os;
      os << "[obj] " << m_Name;
      return os.str();
   }
}
