
/*
 * Argus Client Software.  Tools to read, analyze and manage Argus data.
 * Copyright (C) 2000-2001 QoSient, LLC.
 * All Rights Reserved
 *
 * THE ACCOMPANYING PROGRAM IS PROPRIETARY SOFTWARE OF QoSIENT, LLC,
 * AND CANNOT BE USED, DISTRIBUTED, COPIED OR MODIFIED WITHOUT
 * EXPRESS PERMISSION OF QoSIENT, LLC.
 *
 */

#ifndef RaHistogram_h
#define RaHistogram_h

#include <stdlib.h>

#include <errno.h>
#include <stdio.h>
#include <string.h>

#include <netinet/in.h>

#include <ctype.h>
#include <argus-namedb.h>

#include <argus_filter.h>
 
void RaProcessQueue(struct RaQueueStruct *, unsigned char state);
void *RaFindHashObject (struct RaHashTableStruct *, struct RaHashStruct *); 
struct RaHashTableHeader *RaFindHash (struct RaHashTableStruct *, struct RaHashStruct *);
struct RaHashTableHeader *RaAddHashObject (struct RaHashTableStruct *, void *, struct RaHashStruct *);

void ArgusReverseDataRecord (struct ArgusRecord *);

int RaProbeMonitorsThisAddr (unsigned int, unsigned int);

struct RaHashTableStruct RaProbeTable;
struct RaHashTableStruct *RaMonitorTable = NULL;

#endif
