/*
    Copyright (C) 1998-99 Paul Barton-Davis 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: nullmidi.h,v 1.1 2001/11/24 00:31:57 pbd Exp $
*/

#ifndef __nullmidi_h__
#define __nullmidi_h__

#include <fcntl.h>
#include <vector>
#include <string>

#include <midi++/port.h>
#include <midi++/port_request.h>

namespace MIDI {

class Null_MidiPort : public Port 

{
  public:
	Null_MidiPort (PortRequest &req) 
		: Port (req) { 

		/* reset devname and tagname */
		
		_devname = "nullmidi";
		_tagname = "null";
		_type = Port::Null;
		_ok = true;
	}

	virtual ~Null_MidiPort () {};

	virtual int write (byte *msg, size_t msglen) {
		return msglen;
	}

	virtual int read (byte *buf, size_t max) {
		return 0;
	}
	
	virtual int selectable() const { return -1; }
};

}; /* namespace MIDI */

#endif // __nullmidi_h__
