#define _BSD_SOURCE
#include <gtkmmext/idle_adjustment.h>
#include <gtk--/main.h>
#include <iostream>

using namespace Gtk;
using namespace SigC;
using namespace Gtkmmext;

IdleAdjustment::IdleAdjustment (Gtk::Adjustment& adj)
{
	adj.value_changed.connect (slot (*this, &IdleAdjustment::underlying_adjustment_value_changed));
	timeout_queued = 0;
	gettimeofday (&last_vc, 0);
}

IdleAdjustment::~IdleAdjustment ()
{
}

void
IdleAdjustment::underlying_adjustment_value_changed ()
{
	gettimeofday (&last_vc, 0);
	
	if (timeout_queued) {
		return;
	}

	TimeoutSig t;
	t.connect (slot (*this, &IdleAdjustment::timeout_handler), 250);
	timeout_queued = true;
}	

gint
IdleAdjustment::timeout_handler ()
{
	struct timeval now;
	struct timeval tdiff;

	gettimeofday (&now, 0);

	timersub (&now, &last_vc, &tdiff);

	std::cerr << "timer elapsed, diff = " << tdiff.tv_sec << " + " << tdiff.tv_usec << std::endl;

	if (tdiff.tv_sec > 0 || tdiff.tv_usec > 250000) {
		std::cerr << "send signal\n";
		value_changed ();
		timeout_queued = false;
		return FALSE;
	} else {
		return TRUE;
	}
}
