#include <ardour/location.h>
#include <ardour/diskstream.h>

#include "editor.h"
#include "editing.h"
#include "audio_time_axis.h"
#include "regionview.h"
#include "selection.h"

using namespace ARDOUR;

void
Editor::set_route_loop_selection ()
{
	AudioTimeAxisView* atv;

	if (selection->time.empty()) {
		return;
	}

	if (session == 0 || clicked_trackview == 0) {
		return;
	}

	if ((atv = dynamic_cast<AudioTimeAxisView*>(clicked_trackview)) == 0) {
		return;
	}

	jack_nframes_t start = selection->time[clicked_selection].start;
	jack_nframes_t end = selection->time[clicked_selection].end;

	if (transport_loop_location) {
		transport_loop_location->set (start, end);

		// enable looping, reposition and start rolling
		session->request_auto_loop (true);
		session->request_locate (transport_loop_location->start(), true);
	}

}

void
Editor::set_show_waveforms (bool yn)
{
	AudioTimeAxisView* atv;

	if (_show_waveforms != yn) {
		_show_waveforms = yn;
		for (TrackViewList::iterator i = track_views.begin(); i != track_views.end(); ++i) {
			if ((atv = dynamic_cast<AudioTimeAxisView*>(*i)) != 0) {
				atv->set_show_waveforms (yn);
			}
		}
		DisplayControlChanged (Editing::ShowWaveforms);
	}
}

void
Editor::set_show_waveforms_recording (bool yn)
{
	AudioTimeAxisView* atv;

	if (_show_waveforms_recording != yn) {
		_show_waveforms_recording = yn;
		for (TrackViewList::iterator i = track_views.begin(); i != track_views.end(); ++i) {
			if ((atv = dynamic_cast<AudioTimeAxisView*>(*i)) != 0) {
				atv->set_show_waveforms_recording (yn);
			}
		}
		DisplayControlChanged (Editing::ShowWaveformsRecording);
	}
}
