.\" manual page [] for apctest
.\" SH section heading
.\" SS subsection heading
.\" LP paragraph
.\" IP indented paragraph
.\" TP hanging label
.TH apctest 8 "testing/configuration for apcupsd -- October 2004"
.SH NAME
apctest \- test connection and set configurable values on UPS
.SH SYNOPSIS
.B apctest
.br
.SH DESCRIPTION
.LP
apctest is a program that allows you to talk directly to your UPS
and run certain low-level tests, display all know values from the
UPS's EEPROM, perform a battery runtime calibration, program the
EEPROM (serial connection only), and enter in TTY mode dialog with
the UPS. 
.LP
.SH USAGE
.LP
Make sure your apcupsd.conf file has correct values for UPSTYPE and
UPSCABLE.
.LP
Shutdown apcupsd if it is running.
.LP
Run apctest:
.LP
user@host> apctest
.LP
2004-10-17 15:40:33 apctest 3.10.15 (26 August 2004) freebsd
Checking configuration ...
Attached to driver: usb
sharenet.type = DISABLE
cable.type = USB_CABLE

You are using a USB cable type, so I'm entering USB test mode
model.type = USB_UPS
Setting up the port ...
Creating the device lock file ...
Hello, this is the apcupsd Cable Test program.
This part of apctest is for testing USB UPSes.
Getting UPS capabilities...SUCCESS
Please select the function you want to perform.
1) Test kill UPS power
2) Perform self-test
3) Read last self-test result
4) Change battery date
5) View battery date
6) View manufacturing date
7) Quit

Select function number: 

Item 1 will probe the UPS for all values known to apcupsd and
present them in rather raw format. This output can be useful for
providing technical support if you are having problems with your
UPS. 

Item 2 will perform a Battery Runtime Calibration. This test will
only be performed if your battery is 100% charged. Running the test
will cause the batteries to be discharged to approximately 30% of
capacity. The exact number depends on the UPS model. In any case,
apctest will abort the test if it detects that the battery charge is
20% or less. 

The advantage of doing this test is that the UPS will be able to
recalibrate the remaining runtime counter that it maintains in its
firmware. As your batteries age, they tend to hold less of a charge,
so the runtime calibration may not be accurate after several years. 

We recommend that perform a Battery Calibration about once a
year. You should not perform this calibration too often since
discharging the batteries tends to shorten their lifespan. 

Item 3 can be used to abort a Battery Calibration in progress, if
you some how became disconnected. 

Item 4 can be used to restart the monitoring of a Battery
Calibration if you should some how become disconnected during the
test. 

Item 5 is used to program the EEPROM. Please see the the section
called \u201cConfiguration Directives Used to Set the UPS
EPROM\u201d chapter of this manual for the details. 

Item 6 will initiate a direct communication between your terminal
and the UPS at which point, you can enter raw UPS commands. Please
be aware that you should be careful what commands you enter because
you can cause your UPS to suddenly shutdown, or you can modify the
EEPROM in a way to disable your UPS. The details of the raw Smart
mode UPS commands can be found in the UPS Bible chapter of this
manual. 

Item 7 will terminate apctest.

.SH SEE ALSO

The html manual installed on your system or
.br
http://www.apcupsd.com/3.10.x-manual/usb_apctest.html

.SH AUTHOR
Robert Huff
.SS Current maintainers
Kern Sibbald
Adam Kropelin
.SS Contributors
An enormous list of past and former persons who have devoted
their time and energy to this project -- thanks.
