// ---------------------------------------------------------------------------
// - Persist.cpp                                                            -
// - aleph:odb library - persist class implementation                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can rodbstribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Vector.hpp"
#include "Persist.hpp"
#include "OutputFile.hpp"

namespace aleph {
  // the persist supported quarks
  static const long QUARK_SAVE   = String::intern ("save");
  static const long QUARK_SAVEAS = String::intern ("saveas");

  // save the persistent object to a file

  void Persist::save (void) const {
    saveas (getname ());
  }

  // save a persistent object by name

  void Persist::saveas (const String& name) const {
    OutputFile os (name);
    serialize (os);
  }

  // apply a persist method with a set of arguments and a quark

  Object* Persist::apply (Runnable* robj, Nameset* nset, const long quark,
			  Vector* argv) {
    // get the number of arguments
    long argc = (argv == nilp) ? 0 : argv->length ();

    // dispatch 0 argument
    if (argc == 0) {
      if (quark == QUARK_SAVE ) {
	save ();
	return nilp;
      }
    }
    // dispatch 1 argument
    if (argc == 1) {
      if (quark == QUARK_SAVEAS) {
	String name = argv->getstring (0);
	saveas (name);
	return nilp;
      }
    }
    // call the object method
    return Object::apply (robj, nset, quark, argv);
  }
}
