(in-package "ACL2")

;much of this book has been gutted, since we don't need theorems about setbits if we always open it up

;the commented-out evenst in this book may need the lemmas from sitck2.lisp, but I doubt it

(include-book "setbits2")
(include-book "merge")
(local (include-book "arith"))
;(local (include-book "bits"))

(in-theory (disable floor))

(defthm ash-rewrite
    (implies (integerp n)
	     (equal (ash n i)
		    (fl (* n (expt 2 i)))))
  :hints (("Goal" :in-theory (enable fl ash))))

;used in bits-setbits proofs too?
(local (defthm natp-setbits-1
    (implies (and (natp x)
		  (natp i))
	     (natp (FL (* 1/2 X (EXPT 2 (* -1 I))))))
  :hints (("Goal" :in-theory (enable natp)))))


(defthm natp-
    (implies (and (natp x)
		  (natp y)
		  (>= x y))
	     (natp (+ x (* -1 y))))
  :hints (("Goal" :in-theory (enable natp))))

(in-theory (disable cat))

;(local (in-theory (enable setbits)))

(local (in-theory (enable bits-bits)))

(defthm bits-with-i-not-an-integer
  (implies (not (integerp i))
           (equal (bits x i j)
                  0))
  :hints (("Goal" :in-theory (enable bits))))

(defthm bits-with-j-not-an-integer
  (implies (not (integerp j))
           (equal (bits x i j)
                  0))
  :hints (("Goal" :in-theory (enable bits))))

;(local (include-book "bvecp-lemmas"))
(local (include-book "integerp"))

;taking bits from the lower third
(defthm bits-setbits-1
  (implies (and (< k j)
                (case-split (< 0 w))
                (case-split (< i w))
                (case-split (<= 0 l))
                (case-split (<= j i)) ;drop?
                (case-split (integerp w))
                (case-split (integerp i))
                (case-split (integerp j))
                )
           (equal (bits (setbits x w i j y) k l)
                  (bits x k l)))
  :hints (("Goal" :in-theory (enable setbits-rewrite natp))))

;taking bits from the middle third
;gen?
(defthm bits-setbits-2
    (implies (and (<= k i)
		  (<= j l)
		  (case-split (integerp i))
                  (case-split (<= 0 j))
		  (case-split (integerp j))
		  (case-split (integerp k))
		  (case-split (integerp l))
                  (case-split (<= 0 l))
                  (case-split (integerp w))
                  (case-split (< 0 w))
                  (case-split (< i w))
		  )
	     (equal (bits (setbits x w i j y) k l)
		    (bits y (- k j) (- l j))))
    :hints (("Goal" :in-theory (enable setbits natp))))

;taking bits from the upper third

(defthm bits-setbits-3
    (implies (and (< i l)
		  (case-split (natp i))
		  (case-split (natp j))
		  (case-split (natp k)) ;gen
		  (case-split (natp l)) ;gen
		  (case-split (<= j i))
                  (case-split (integerp w))
                  (case-split (< 0 w))
                  (case-split (< i w))
                  (case-split (< k w)) ;handle this?
                  )
	     (equal (bits (setbits x w i j y) k l)
		    (bits x k l)))
    :hints (("Goal" :in-theory (enable setbits natp))))



(defthm bvecp-shift
    (implies (and (bvecp x n)
		  (natp n)
		  (natp k)
		  (>= n k))
	     (bvecp (fl (/ x (expt 2 k))) (- n k)))
  :hints (("Goal" :in-theory (enable bvecp natp))))

(in-theory (disable bvecp-shift))

#|

(defthm bitn-setbits-1
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (natp k)
		  (<= j i)
		  (< k j))
	     (equal (bitn (setbits x i j y) k)
		    (bitn x k))))
|#
;(local (include-book "setbits2"))


(in-theory (disable setbits bits-n-n-rewrite))

#|
(defthm bitn-setbits-2
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (natp k)
		  (<= k i)
		  (<= j k))
	     (equal (bitn (setbits x i j y) k)
		    (bitn y (- k j))))
  :hints (("Goal" :use ((:instance bits-n-n-rewrite (x (setbits x i j y)) (n k))))
	  ("Goal'''" :in-theory (enable bits-n-n-rewrite))))

(defthm bitn-setbits-3
    (implies (and (natp x)
		  (bvecp y (1+ (- i j)))
		  (natp i)
		  (natp j)
		  (natp k)
		  (< i k)
		  (<= j i))
	     (equal (bitn (setbits x i j y) k)
		    (bitn x k)))
  :hints (("Goal" :use ((:instance bits-n-n-rewrite (x (setbits x i j y)) (n k))))
	  ("Goal'''" :in-theory (enable bits-n-n-rewrite))))

|#

(defthm bvecp-expo
    (implies (natp x)
	     (bvecp x (1+ (expo x))))
  :hints (("Goal" :in-theory (enable natp bvecp )
		  :use (expo-upper-bound))))

(in-theory (disable bvecp-expo))

#|
(defthm bits-setbits-4
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (natp k)
		  (natp l)
		  (<= k i)
		  (<= j k)
		  (< l j)
		  (bvecp y (1+ (- i j))))
	     (equal (bits (setbits x i j y) k l)
		    (cat (bits y (- k j) 0)
			 (bits x (1- j) l)
			 (- j l))))
  :hints (("Goal" :use (bvecp-expo
			(:instance bits-plus-bits
				   (x (setbits x i j y))
				   (m (1+ k))
				   (n j)
				   (r l))))
	  ("Subgoal 1" :in-theory (enable cat))))

(defthm bits-setbits-5
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (natp k)
		  (natp l)
		  (< i k)
		  (<= l i)
		  (<= j l)
		  (bvecp y (1+ (- i j))))
	     (equal (bits (setbits x i j y) k l)
		    (cat (bits x k (1+ i))
			 (bits y (- i j) (- l j))
			 (1+ (- i l)))))
  :hints (("Goal" :use (bvecp-expo
			(:instance bits-plus-bits
				   (x (setbits x i j y))
				   (m (1+ k))
				   (n (1+ i))
				   (r l))))
	  ("Subgoal 2" :in-theory (enable cat)
           :expand ((expt 2 (+ 1 i (* -1 l)))))))

(local (include-book
        "integerp"))
(local (include-book
        "type"))


(defthm bits-setbits-6
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (natp k)
		  (natp l)
		  (< i k)
		  (<= j i)
		  (< l j)
		  (bvecp y (1+ (- i j))))
	     (equal (bits (setbits x i j y) k l)
		    (cat (cat (bits x k (1+ i))
			      y
			      (1+ (- i j)))
			 (bits x (1- j) l)
			 (- j l))))
  :hints (("Goal" :use (bvecp-expo
			(:instance bits-plus-bits
				   (x (setbits x i j y))
				   (m (1+ k))
				   (n (1+ i))
				   (r l))
			(:instance bits-plus-bits
				   (x (setbits x i j y))
				   (m (1+ i))
				   (n j)
				   (r l))))
	  ("Subgoal 3" :in-theory (enable cat)
           :expand ((expt 2 (+ 1 i (* -1 l)))))))
|#

(defthm natp>=0
  (implies (natp x)
           (>= x 0)))

(defthm setbits-with-0-width
  (equal (setbits x 0 i j y)
         0)
  :hints (("Goal" :in-theory (enable setbits)))
)
