(in-package "ACL2")

;(include-book "include-book-macros")
(include-book "float")
(include-book "negative-syntaxp")
(include-book "power2p")
(include-book "unary-divide")
(include-book "arith2")

;has case-split on hyps
(defthm expo-shift-nice
  (IMPLIES (AND (case-split (RATIONALP X)) ;if not, we want to know about it
                (case-split (NOT (= X 0))) ;if x=0 we can simplify further
                )
           (= (EXPO (* (EXPT 2 i) X))
              (+ (ifix i) (EXPO X))))
  :HINTS (("Goal" :USE (:instance SIG-EXPO-SHIFT (n i)))))

(defthm expo-shift-nice-2
  (IMPLIES (AND (case-split (RATIONALP X)) ;if not, we want to know about it
                (case-split (NOT (= X 0))) ;if x=0 we can simplify further
                (case-split (INTEGERP i)) ;if not, (expt 2 n) is 1
                )
           (= (EXPO (* X (EXPT 2 i)))
              (+ i (EXPO X))))
  :HINTS (("Goal" :USE (:instance SIG-EXPO-SHIFT (n i)))))

(in-theory (disable expo-shift))


;more gen than expo-of-non-negative-integerp in irepsproofs
;sort of a weird way of proving this?
(encapsulate ()
             (local (defthm expo-of-non-negative-integerp
                      (implies (and (integerp x)
                                    (>= x 0))
                               (>= (expo x) 0))
                      :hints (("Goal" 
                               :use ((:instance expo>= 
                                                (x x)
                                                (n 0)))))))

             (defthm expo-type-when-x-is-integerp
               (implies (integerp x)
                        (and (integerp (expo x)) ;included to make the conclusion a "type" fact
                             (<= 0 (expo x))))
               :hints (("Goal" :in-theory (disable expo-of-non-negative-integerp)
                        :use ((:instance  expo-of-non-negative-integerp (x x))
                              (:instance  expo-of-non-negative-integerp (x (- x))))))
               :rule-classes (:rewrite (:type-prescription :typed-term (expo x)))))




(DEFTHM EXPO-MINUS-eric
  (implies (syntaxp (negative-syntaxp x))
           (equal (EXPO X) 
                  (EXPO (* -1 X)))))

(in-theory (disable expo-minus))
;also don't need expo-minus-dist from irepsproofs

(DEFTHM EXPO-SHIFT-3
  (IMPLIES (AND (case-split (RATIONALP X))
                (case-split (RATIONALP y))
                (case-split (not (= (* x y) 0)))
                (case-split (INTEGERP N)))
           (equal (EXPO (* X y (EXPT 2 N)))
                  (+ N (EXPO (* X y)))))
  :HINTS (("Goal" :USE (:instance SIG-EXPO-SHIFT (x (* x y))))))

(defthm expo-shift-4
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (integerp n)
                (not (equal (* a b c) 0))
                )
           (equal (EXPO (* a b c (EXPT 2 n)))
                  (+ n (expo (* a b c)))))
  :HINTS (("Goal" :USE (:instance SIG-EXPO-SHIFT (x (* a b c)))))
)

(defthm expo-shift-6
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (integerp n)
                (not (equal (+ a (* b c)) 0))
                )
           (equal (EXPO (+ (* a (EXPT 2 n)) (* b c (EXPT 2 n))))
                  (+ n (EXPO (+ a (* b c ))))))
  :otf-flg t
  :HINTS (("Goal" :USE (:instance SIG-EXPO-SHIFT (x (+ a (* b c))))))
)

(defthm expo-shift-8
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (integerp n)
                (not (equal (+ a (* b c)) 0))
                )
           (equal (EXPO (+ (* a (EXPT 2 n)) (* b (EXPT 2 n) c)))
                  (+ n (EXPO (+ a (* b c ))))))
  :otf-flg t
  :HINTS (("Goal" :USE (:instance SIG-EXPO-SHIFT (x (+ a (* b c))))))
)

(include-book "expt")
(include-book "expt2")

(local (in-theory (disable  EXPT-COMPARE-EQUAL)))  ;new addition

(defthm expo-shift-9
  (implies (and (rationalp a)
                (rationalp b)
                (integerp n)
                (not (equal (+ a b) 0))
                )
           (equal (EXPO (+ (* a (/ (EXPT 2 n))) (* (/ (EXPT 2 n)) b)))
                  (+ (- n) (EXPO (+ a b)))))
  :otf-flg t
  :HINTS (("Goal" :in-theory (enable  expt-pull-negation-out-of-power)
           :USE (:instance SIG-EXPO-SHIFT (n (- n)) (x (+ a b)))))
)

(defthm expo-shift-7
  (implies (and (rationalp a)
                (rationalp b)
                (integerp n)
                (not (equal (+ a b) 0))
                )
           (equal (EXPO (+ (* a (EXPT 2 n)) (* b (EXPT 2 n))))
                  (+ n (EXPO (+ a b)))))
  :otf-flg t
  :HINTS (("Goal" :USE (:instance SIG-EXPO-SHIFT (x (+ a b)))))
)

(defthm expo-shift-10
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (integerp n)
                (not (equal (+ a (* b c)) 0))
                )
           (equal (EXPO (+ (* a (/ (EXPT 2 n))) (* b c (/ (EXPT 2 n)))))
                  (+ (- n) (EXPO (+ a (* b c))))))
  :otf-flg t
  :HINTS (("Goal" :in-theory (enable  expt-pull-negation-out-of-power)
           :USE (:instance SIG-EXPO-SHIFT (n (- n)) (x (+ a (* b c))))))
)

(defthm expo-shift-11
  (implies (and (case-split (integerp n))
                (case-split (rationalp x))
                (case-split (rationalp y))
                (case-split (rationalp z))
                (case-split (rationalp a))
                (case-split (rationalp b))
                (case-split (rationalp c))
                (case-split (not (EQUAL (+ X (* Y Z) (* A B C)) 0)))
                )
           (equal (EXPO (+ (* x
                              (EXPT 2
                                    n))
                           (* y
                              z
                              (EXPT 2
                                    n))
                           (* a b c
                              (EXPT 2
                                    n))))
                  (+ n (expo (+ x (* y z) (* a b c))))))
  :hints (("Goal"           
           :USE (:instance SIG-EXPO-SHIFT (n n) (x (+ x (* y z) (* a b c))))))
           
)

(defthm expo-shift-11-2
  (implies (and (case-split (integerp n))
                (case-split (rationalp x))
                (case-split (rationalp y))
                (case-split (rationalp z))
                (case-split (rationalp a))
                (case-split (rationalp b))
                (case-split (not (EQUAL (+ X (* Y Z) (* A B)) 0)))
                )
           (equal (EXPO (+ (* x
                              (EXPT 2
                                    n))
                           (* y
                              z
                              (EXPT 2
                                    n))
                           (* a b
                              (EXPT 2
                                    n))))
                  (+ n (expo (+ x (* y z) (* a b))))))
    :hints (("Goal"           
             :USE (:instance SIG-EXPO-SHIFT (n n) (x (+ x (* y z) (* a b))))))
          )

(defthm expo-shift-13
  (implies (and (case-split (integerp n))
                (case-split (rationalp x))
                (case-split (rationalp y))
                (case-split (rationalp z))
                (case-split (rationalp a))
                (case-split (not (equal (+ (* x a) (* y z)) 0)))
                )
           (equal (EXPO (+ (* x a
                              (EXPT 2
                                    n))
                           (* y
                              z
                              (EXPT 2
                                    n))))
                  (+ n (expo (+ (* x a) (* y z) )))))
  :hints (("Goal"           
           :USE (:instance SIG-EXPO-SHIFT (n n) (x (+ (* x a) (* y z) )))))
           
)

(defthm expo-shift-14
  (implies (and (case-split (integerp n))
                (case-split (rationalp x))
                (case-split (rationalp y))
                (case-split (rationalp z))
                (case-split (rationalp a))
                (case-split (rationalp b))
                (case-split (not (equal (+ x (* y a b z)) 0)))
                )
           (equal (EXPO (+ (* x
                              (EXPT 2
                                    n))
                           (* y
                              z
                              a
                              b
                              (EXPT 2
                                    n))))
                  (+ n (expo (+ x (* a y b z) )))))
  :hints (("Goal"           
           :USE (:instance SIG-EXPO-SHIFT (n n) (x (+ x (* y a b z) )))))
           
)


(defthm expo-shift-15
  (implies (and (case-split (integerp n))
                (case-split (rationalp c))
                (case-split (rationalp a))
                (case-split (rationalp b))
                (case-split (not (equal (+ 1 (* a b c)) 0)))
                )
           (equal (EXPO (+ (/ (EXPT 2 n))
                           (*
                            a
                            b
                            (/ (EXPT 2
                                     n))
                            c)))
                  (+ (- n) (expo (+ 1 (* a b c) )))))
  :hints (("Goal"           
           :USE (:instance SIG-EXPO-SHIFT (n (- n)) (x (+ 1 (* a b c))))))
           
)




;local in support/float:

(local (in-theory (disable expt-compare)))

(local
 (defthm expo-unique-1
  (implies (and (rationalp x)
                (not (= x 0))
                (integerp n)
                (< n (expo x)))
           (<= (expt 2 (1+ n)) (abs x)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable expo abs)
           :use ((:instance expt-monotone (n (1+ n)) (m (expo x))))))))

(local
 (defthm expo-unique-2
  (implies (and (rationalp x)
;                (not (= x 0))
                (integerp n)
                (> n (expo x)))
           (> (expt 2 n) (abs x)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable expo abs)
           :use (;(:instance expo-upper-bound)
                 (:instance expt-monotone (n (1+ (expo x))) (m n)))))))

;expensive?
;n is a free var
(defthm expo-unique-eric
  (implies (and (rationalp x)
                (integerp n)
                (<= (expt 2 n) (abs x))
                (< (abs x) (expt 2 (1+ n))))
           (equal (expo x) n))
  :hints (("goal" :in-theory (disable expo abs)
           :use ((:instance expo-unique-1)
                 (:instance expo-unique-2)))))

(in-theory (disable expo-unique-eric))



;could be even better if move hyps into the conclusion? (perhaps only when n is a constant?)
; wow! this actually worked when the one above didn't!
(defthm expo-unique-eric-2
  (implies (and (rationalp x)
                (integerp n)
                (<= (expt 2 n) (abs x))
                (< (abs x) (expt 2 (1+ n))))
           (equal (equal (expo x) n)
                  t))
  :hints (("goal" :in-theory (disable expo abs)
           :use ((:instance expo-unique)))))

;find a way to make this hit (EQUAL (+ I (EXPO (/ X))) -1) to (i.e., an expression containing one call to expo)
(defthm expo-equality-reduce-to-bounds
  (implies (and (case-split (rationalp x))
                (case-split (integerp n)))
           (equal (equal (expo x) n)
                  (if (equal 0 x)
                      (equal 0 n)
                    (and (<= (expt 2 n) (abs x))
                         (< (abs x) (expt 2 (1+ n)))))))
  :hints (("goal" :in-theory (disable expo abs)
           :cases ((= x 0)))))

(in-theory (disable expo-equality-reduce-to-bounds))

#|
(in-theory (enable expo-minus))

(defthm expo-minus-const-mult
  (implies (and (syntaxp (and (quotep k) (< (cadr k) 0))))
           (equal (EXPO (* k X)) 
                  (EXPO (* -1 k X)))))
|#

;combine this with others?
(DEFTHM EXPO-SHIFT-alt
  (IMPLIES (AND (syntaxp (quotep k))
                (equal k (expt 2 (expo k))) ; use power2p?
                (RATIONALP X)
                (NOT (= X 0)))
           (= (EXPO (* k X))
              (+ (expo k) (EXPO X))))
  :HINTS (("Goal" :in-theory (disable  expo-shift)
           :USE (:instance expo-shift (n (expo k))))))

#|
(defthm expo-shift-12
  (implies (and (syntaxp (should-have-a-2-factor-divided-out x))
                (case-split (rationalp x))
                (case-split (not (equal x 0)))
                )
           (equal (expo x)
                  (+ 1 (expo (* 1/2 x))))))
|#
;(local (in-theory (enable power2p)))




#|
(defthm expo-x+2**k-eric
    (implies (and (syntaxp (quotep k))
                  (power2p k)
		  (rationalp x)
		  (<= 0 x)
		  (< (expo x) (expo k)))
	     (equal (expo (+ k x))
		    (expo k)))
    :hints (("Goal" :in-theory (disable expo-x+2**k)
             :use (:instance expo-x+2**k (k (expo k))))))

|#

(in-theory (disable EXPO-2**N))

;like EXPO-2**N but better (now hypothesis-free)
(DEFTHM EXPO-expt2-i
  (EQUAL (EXPO (EXPT 2 i))
         (if (integerp i)
             i
           0))
  :hints (("Goal" :in-theory (enable expt)))
)

;these next 2 can be very expensive since (expt 2 k) gets calculated!

;restrict to constants k?
(defthm expo-comparison-rewrite-to-bound
  (implies (and (case-split (not (equal 0 x)))
                (integerp k) ;gen?
                (case-split (rationalp x))
                )
           (equal (< (expo x) k)
                  (< (abs x) (expt 2 k))))
  :otf-flg t
  :hints (("Goal" :use ((:instance expo-monotone (x (expt 2 k)) (y x))
                        (:instance expo-monotone (y (expt 2 k)) (x x))))
          )
  )

;restrict to constants k?
(defthm expo-comparison-rewrite-to-bound-2
  (implies (and (case-split (not (equal 0 x)))
                (integerp k) ;gen?
                (case-split (rationalp x))
                )
           (equal (< k (expo x))
                  (<= (expt 2 (+ k 1)) (abs x))))
  :otf-flg t
  :hints (("Goal" :in-theory (disable EXPO-COMPARISON-REWRITE-TO-BOUND)
           :use ((:instance expo-monotone (x (expt 2 (+ 1 k))) (y x))
                 (:instance expo-monotone (y (expt 2 (+ 1 k))) (x x))))
          )
  )




;have a better version but need this for the proofs
(DEFTHM EXPO-expt2-i-inverse
  (EQUAL (EXPO (/ (EXPT 2 i)))
         (if (integerp i)
             (- i)
           0))
  :hints (("Goal" :in-theory (disable EXPO-expt2-i)
           :use (:instance EXPO-expt2-i (i (- i)))))
)


#| true only for powers of 2
(defthm expo-/
  (equal (expo (/ x))
         (- (expo x)))
  :hints (("Goal" :in-theory (enable expo)))
)
|#

(defthm power2p-shift-special
  (equal (power2p (* (expt 2 i) x))
         (power2p x))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '(a15)))))

(defthm expo-/-power2p-1
  (implies (power2p x)
           (equal (expo (/ (expt 2 i)))
                  (- (expo (expt 2 i)))))

)

(defthm expo-/-power2p
  (implies (power2p x)
           (equal (expo (/ x))
                  (- (expo x))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable power2p)
                              '( expo-/-power2p-1 power2p-shift EXPO-EXPT2-I
                                                  EXPO-EXPT2-I-INVERSE
                                                  ;; added for v2-8 ordinals changes
                                                  LESS-THAN-MULTIPLY-THROUGH-BY-FRACCOEFF-FROM-RIGHT-HAND-SIDE))
           :use (:instance  expo-/-power2p-1 (i (expo x))))))

;restrict to only x's which look like powers of 2
(defthm expo-/-power2p-alt
  (implies (and (syntaxp (power2-syntaxp x))
                (power2p x))
           (equal (expo (/ x))
                  (- (expo x))))
  :hints (("Goal" :in-theory (disable expo-/-power2p-1 EXPO-EXPT2-I  EXPO-EXPT2-I-INVERSE)
           :use (:instance  expo-/-power2p-1 (i (expo x))))))

(in-theory (disable expo-/-power2p-1 expo-/-power2p))


#| these might be nice:
(defthm expo-/-notpower2p
  (implies (and (not (equal x 0))
                (rationalp x)
                (not (power2p x)))
           (equal (expo (/ x))
                  (+ -1 (- (expo x)))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expo expt-split  expo-equality-reduce-to-bounds)
                              '(a15))))
)

(defthm expo-shift-nicest
  (IMPLIES (AND (syntaxp (power2-syntaxp y)) 
                (case-split (RATIONALP X)) ;if not, we want to know about it
                (case-split (NOT (= X 0))) ;if x=0 we can simplify further
;                (case-split (INTEGERP i)) ;if not, (expt 2 n) is 1
                )
           (= (EXPO (* y X))
              (+ (expo y) (EXPO X))))
  :HINTS (("Goal" :USE (:instance expo-shift-nice (i (expo y))))))

|#




  
(defthm power2p-expt2-i
  (power2p (expt 2 i)))

(defthm expo-of-not-rationalp
  (implies (not (rationalp x))
           (equal (expo x) 0))
  :hints (("Goal" :in-theory (enable expo)))
)

(defthm expo-bound-eric
  (implies (case-split (rationalp x))
           (and (equal (< (* 2 (EXPT 2 (EXPO X))) X)
                       nil)
                (equal (< X (* 2 (EXPT 2 (EXPO X))))
                       t)
                (equal (< (EXPT 2 (+ 1 (EXPO X))) X)
                       nil)
                (equal (< X (EXPT 2 (+ 1 (EXPO X))))
                       t)
                ))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '(a15))
           :use expo-upper-bound)))



;if this loops, disable all the expo-shift rules!
(defthm expo-/-notpower2p
  (implies (and (not (power2p x))
                (case-split (not (equal x 0)))
                (<= 0 x)
                (case-split (rationalp x))
                )
           (equal (expo (/ x))
                  (+ -1 (- (expo x)))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable power2p; expo
                                      expt-split expo-equality-reduce-to-bounds)
                              '(a15 power2p-shift expo-shift-alt expo-shift-1 EXPO-SHIFT-1-2)))))

(in-theory (disable expo-/-notpower2p))

(local 
 (defthm power2p-/-bk
  (implies (power2p x)
           (power2p (/ x)))
  :otf-flg t
  :hints (("Goal"
           :in-theory (set-difference-theories
                       (enable expt-split power2p expo-/-power2p)
                       '(a15))))))

(defthm power2p-/
  (equal (power2p (/ x))
         (power2p x))
  :otf-flg t
  :hints (("Goal" :in-theory (disable  power2p-/-bk)
           :use (power2p-/-bk
                 (:instance  power2p-/-bk (x (/ x)))))))




(encapsulate 
 ()
 (local (defthm power2p-prod-1
          (power2p (* (expt 2 i1) (expt 2 i2)))))

 (local (defthm hack
          (implies (power2p x)
                   (equal (expt 2 (expo x))
                          x))
          :hints (("Goal" :in-theory (enable power2p-rewrite)))
          
          ))
          
 (defthm power2p-prod
   (implies (and (power2p x)
                 (power2p y))
            (power2p (* x y)))
   :hints (("Goal" :in-theory (set-difference-theories
                               (enable expt-split)
                               '(a15 power2p power2p-prod-1 POWER2P-SHIFT-special POWER2P-EXPT2-I  EXPT2-1-TO-1))
            :use (:instance  power2p-prod-1 (i1 (expo x)) (i2 (expo y)))))))

(in-theory (disable power2p-prod))

(defthm power2p-prod-not
  (implies (and (not (power2p x))
                (power2p y))
           (not (power2p (* x y))))
   :hints (("Goal" :in-theory (disable  power2p-prod)
            :use (:instance  power2p-prod (x (* x y)) (y (/ y))))))

(in-theory (disable power2p-prod-not))

#|
(defthm power2p-shift
  (implies (and (syntaxp (power2-syntaxp y))
                (case-split (power2p y)) ;this should be true if the syntaxp hyp is satisfied
                )
           (equal (power2p (* y x))
                  (power2p x)))
  :hints (("Goal" :in-theory (disable power2p)
           :use (power2p-prod-not  power2p-prod))))

(defthm power2p-shift-2
  (implies (and (syntaxp (power2-syntaxp y))
                (case-split (power2p y)) ;this should be true if the syntaxp hyp is satisfied
                )
           (equal (power2p (* x y))
                  (power2p x)))
  :hints (("Goal" :in-theory (disable power2p)
           :use ( power2p-prod-not power2p-prod))))
|#

(in-theory (disable power2p-shift-special))

(defthm power2p-means-positive-rationalp
  (implies (power2p x)
           (and (< 0 x)
                (rationalp x)))
  :hints (("Goal" :in-theory (enable power2p))))

#|
(defthm power2p-quotient
  (implies (and (syntaxp (power2-syntaxp y))
                (case-split (power2p y)) ;this should be true if the syntaxp hyp is satisfied
                )
           (equal (power2p (/ y x))
                  (power2p x)))
  :hints (("Goal" :in-theory (disable power2p)
           :use (:instance power2p-shift (x (/ x))))))

(defthm power2p-quotient-2
  (implies (and (syntaxp (power2-syntaxp y))
                (case-split (power2p y)) ;this should be true if the syntaxp hyp is satisfied
                )
           (equal (power2p (/ x y))
                  (power2p x)))
  :hints (("Goal" :in-theory (disable power2p POWER2P-/)
           :use (:instance power2p-shift (y (/ y))))))
|#

#|
(include-book
 "abs")

(defthm expo-of-x-minus-1-nopower2-case
  (implies (and (integerp x)
                (not (power2p x))
                (<= 0 x) ;gen and add abs phrasing?
                )
           (equal (expo (+ -1 x))
                  (expo x)))
  :hints (("Goal" :use (:instance expo-unique
                                 (x (+ -1 x))
                                 (n (expo x)))
           :in-theory (enable power2p))))




(defthm expo-of-x-minus-1-power2-case
  (implies (and (integerp x) ;drop?
                (power2p x)
                (case-split (< 1 x)) ;gen?
                )
           (equal (expo (+ -1 x))
                  (+ -1 (expo x))))
  :hints (("Goal" :use (:instance expo-unique
                                  (x (+ -1 x))
                                  (n (+ -1 (expo x))))
           :in-theory (enable power2p expt-split))))


;add more conclusions.  is (expt 2...) < or <= n?
(defthm expt-expo-bound-1
  (implies (and (integerp n)
                (case-split (< 0 n))
                )
           (equal (< N (EXPT 2 (EXPO (+ -1 N))))
                  nil))
  :otf-flg t
  :hints (("Goal" :cases ((power2p n))
           :in-theory (enable expt-split)))
  )

|#
