// file      : CCF/IDL2/SemanticGraph/Member.cpp
// author    : Boris Kolpackov <boris@dre.vanderbilt.edu>
// cvs-id    : Member.cpp,v 1.2 2004/01/01 00:12:30 boris Exp

#include "CCF/IDL2/SemanticGraph/Member.hpp"

namespace CCF
{
  namespace IDL2
  {
    namespace SemanticGraph
    {
      using Introspection::TypeInfo;
      using Introspection::Access;
      
      namespace
      {
        TypeInfo
        member_init_ ()
        {
          TypeInfo ti (typeid (Member));
          ti.add_base (Access::PUBLIC, true, Nameable::static_type_info ());
          ti.add_base (Access::PUBLIC, true, Instance::static_type_info ());
          return ti;
        }

        TypeInfo member_ (member_init_ ());
      }

      TypeInfo const& Member::
      static_type_info () { return member_; }
    }
  }
}
