/* 
 * USRP - Universal Software Radio Peripheral
 *
 * Copyright (C) 2003 Free Software Foundation, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "usrp_common.h"

void
init_usrp ()
{
  CPUCS = bmCLKSPD1;					SYNCDELAY;	// CPU runs @ 48 MHz

  // USRP_FPGA_CTRL_BUS_OE = bmFCB_OUTPUTS;		// Port A direction register
  // USRP_FPGA_CTRL_BUS    = bmFCB_INITIAL;		// initial state

  USRP_ALTERA_CONFIG_OE = bmALTERA_OUTPUTS;		// Port C direction register
  USRP_ALTERA_CONFIG    = bmALTERA_INITIAL;		// initial state

  USRP_MISC_OE          = bmMISC_LED1 | bmMISC_LED0;	// Port E direction register
  USRP_MISC             = 0;
}


void 
set_led_0 (unsigned char on)
{
  if (on)
    USRP_MISC |= bmMISC_LED0;
  else
    USRP_MISC &= ~bmMISC_LED0;
}

void 
set_led_1 (unsigned char on)
{
  if (on)
    USRP_MISC |= bmMISC_LED1;
  else
    USRP_MISC &= ~bmMISC_LED1;
}


void
main (void)
{
  unsigned int	counter = 0;

  init_usrp ();

  while (1){
    unsigned char counter_high = counter >> 8;
    set_led_0 (counter_high & 0x40);
    set_led_1 (counter_high & 0x80);
    counter++;
  }
}
