/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.vise;

/**
 * DatabaseModel specifically for PostgreSQL databases. The
 * driver, driver class, and port are set to PostgreSQL specific
 * values (postgresql, org.postgresql.Driver, and 5432 respectively).
 *
 * @author <a href="mailto:liam@ualberta.ca">Liam Stewart</a>
 * @version 0.0
 */
public class PostgreSQLDatabaseModel extends DatabaseModel {
	/**
	 * Creates a new <code>PostgreSQLDatabaseModel</code> instance.
	 */
	public PostgreSQLDatabaseModel()
	{
		setDriver("postgresql");
		setDriverClass("org.postgresql.Driver");
		setPort("5432");
	}

	// inherits doc comment
	public String getURL()
	{
		String proto = "jdbc";
		String hostport;
		String host = getHost().trim();
		String port = getPort().trim();
		String db = getDatabase().trim();
		
		if (host.length() == 0 && port.length() == 0)
		{
			hostport = "";
		}
		else if (host.length() == 0 && port.length() != 0)
		{
			hostport = "//localhost:" + port + "/";
		}
		else if (host.length() != 0 && port.length() == 0)
		{
			hostport = "//" + host + "/";
		}
		else
		{
			hostport = "//" + host + ":" + port + "/";
		}

		return "jdbc:" + getDriver().trim() + ":" + hostport + db;
	}

	// inherits doc comment
	public Object clone()
	{
		PostgreSQLDatabaseModel d = new PostgreSQLDatabaseModel();

		d.setName(getName());
		d.setDatabase(getDatabase());
		d.setHost(getHost());
		d.setPort(getPort());
		d.setUser(getUser());
		d.setPassword(getPassword());
		d.setDriver(getDriver());
		d.setSavePassword(isSavePassword());

		return d;
	}	
}// PostgreSQLDatabaseModel
