/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.treedisplay;

/**
 * Represents a (directed) edge in the layout of a tree. The edge is
 * between a parent node and a child.
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */
public interface TreeLayoutEdge {
	/**
	 * Get the parent node.
	 *
	 * @return a <code>TreeLayoutNode</code> value
	 */
	public TreeLayoutNode getParent();

	/**
	 * Get the child node.
	 *
	 * @return a <code>TreeLayoutNode</code> value
	 */
	public TreeLayoutNode getChild();

	/**
	 * The offset from centre of the parent that an arrow/line should
	 * be placed so as not to overlap other arrows or lines.
	 *
	 * @return an <code>int</code> value
	 */
	public int getParentOffset();

	/**
	 * Get the TreeLayoutModel that this edge belongs to.
	 *
	 * @return a <code>TreeLayoutModel</code> value
	 */
	public TreeLayoutModel getTreeLayoutModel();

	/**
	 * Set the TreeLayoutModel that this edge belongs to.
	 *
	 * @param m a <code>TreeLayoutModel</code> value
	 */
	public void setTreeLayoutModel(TreeLayoutModel m);
}// TreeLayoutEdge
