/*
 * $Id: Chap1014.java,v 1.3 2003/06/25 07:36:34 blowagie Exp $
 * $Name:  $
 *
 * This code is free software. It may only be copied or modified
 * if you include the following copyright notice:
 *
 * --> Copyright 2002 by Phillip@formstar.com and Paulo Soares <--
 *
 * This code is part of the 'iText Tutorial'.
 * You can find the complete tutorial at the following address:
 * http://www.lowagie.com/iText/tutorial/
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * itext-questions@lists.sourceforge.net
 */

import java.awt.Color;
import java.io.*;

import com.lowagie.text.*;
import com.lowagie.text.pdf.*;

public class Chap1014 {
    
    
    public static void main(String[] args) {
        
        System.out.println("Chapter 10 Example 14: colored patterns");
        
        // step 1: creation of a document-object
        Document document = new Document(PageSize.A4, 50, 50, 50, 50);
        try {
            
            // step 2:
            // we create a writer that listens to the document
            // and directs a PDF-stream to a file
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream("Chap1014.pdf"));
            
            // step 3: we open the document
            document.open();
            
            // step 4: we add some content
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate(400, 300);
            PdfPatternPainter pat = cb.createPattern(15, 15, null);
            pat.rectangle(5, 5, 5, 5);
            pat.fill();
            PdfSpotColor spc_cmyk = new PdfSpotColor("PANTONE 280 CV", 0.25f, new CMYKColor(0.9f, .2f, .3f, .1f));
            SpotColor spot = new SpotColor(spc_cmyk);
            tp.setPatternFill(pat, spot, .9f);
            tp.rectangle(0, 0, 400, 300);
            tp.fill();
            cb.addTemplate(tp, 50, 50);
            PdfPatternPainter pat2 = cb.createPattern(10, 10, null);
            pat2.setLineWidth(2);
            pat2.moveTo(-5, 0);
            pat2.lineTo(10, 15);
            pat2.stroke();
            pat2.moveTo(0, -5);
            pat2.lineTo(15, 10);
            pat2.stroke();
            cb.setLineWidth(1);
            cb.setColorStroke(Color.black);
            cb.setPatternFill(pat2, Color.red);
            cb.rectangle(100, 400, 30, 210);
            cb.fillStroke();
            cb.setPatternFill(pat2, Color.green);
            cb.rectangle(150, 400, 30, 100);
            cb.fillStroke();
            cb.setPatternFill(pat2, Color.blue);
            cb.rectangle(200, 400, 30, 130);
            cb.fillStroke();
            cb.setPatternFill(pat2, new GrayColor(0.5f));
            cb.rectangle(250, 400, 30, 80);
            cb.fillStroke();
            cb.setPatternFill(pat2, new GrayColor(0.7f));
            cb.rectangle(300, 400, 30, 170);
            cb.fillStroke();
            cb.setPatternFill(pat2, new GrayColor(0.9f));
            cb.rectangle(350, 400, 30, 40);
            cb.fillStroke();
        }
        catch (Exception de) {
            de.printStackTrace();
        }
        // step 5: we close the document
        document.close();
    }
}