/* Playlist manager */

/* Hopefully this will make the playlist management a little better */

#include "liveice.h"
#include "mixer.h"
#include "url.h"

tptr add_track_data(tptr *t_list){
	tptr new;
	/* Insert into linked list */
	if((new=(tptr)(malloc(sizeof(track))))==NULL)
		return NULL;
	if(*t_list==NULL){
		/* this is the first mp3 - so it's a closed loop */
		*t_list=new;
		new->next=new;
		new->prev=new;
	} else {
		/* there are already some here... add it at the end */
		new->next=*t_list;
		new->prev=(*t_list)->prev;
		(*t_list)->prev=new;
		new->prev->next=new;
	} 
	return new;
}

int remove_track_data(tptr *t_list,tptr old){
	int i;
	/* free the filename */
	free(old->filename);
	/* free the formvars */
	free(old->formvars);
	if(*t_list == old){		
		if(old->prev==old)
			*t_list=NULL;
		else
			*t_list=old->next;
	}
	old->next->prev=old->prev;
	old->prev->next=old->next;
	free(old);
	return 0;
}


/*Attempt to register an mp3 file int he tracklisting */
int add_mp3_track(tptr *t_list,char *filename,char *formvars){
	tptr new;

	new=add_track_data(t_list);
	/* Allocate memory for the filename */
	if(new!=NULL){
	        new->filename=strdup(filename);
		new->formvars=strdup(formvars);
		new->t_type=MPEG;
		new->fmt.sample_format=SIGNED_16;
		new->fmt.rate=0;
		new->fmt.channels=0;
		new->fmt.speed=1.0;
		new->active=1;
		
		return 0;
	} else {
		return -1;
	}
}

/* add a file in an unkown format and ask sox to do the conversion */
int add_sox_track(tptr *t_list,char *filename,char *formvars){
	tptr new;

	new=add_track_data(t_list);
	/* Allocate memory for the filename */
	if(new!=NULL){
	        new->filename=strdup(filename);
		new->formvars=strdup(formvars);
		new->t_type=MISC_AUDIO;
		new->fmt.sample_format=SIGNED_16;
		new->fmt.rate=g_conf.sample_rate;
		new->fmt.channels=g_conf.stereo+1;
		new->fmt.speed=1.0;
		new->active=1;
		return 0;
	} else {
		return -1;
	}
}


int add_raw_track(tptr *t_list,char *filename,char *formvars,int rate, int channels){
	tptr new;
	new=add_track_data(t_list);
	/* Allocate memory for the filename */
	if(new!=NULL){
	        new->filename=strdup(filename);
		new->formvars=strdup(formvars);
		new->t_type=RAW_AUDIO;
		new->fmt.sample_format=SIGNED_16;
		new->fmt.rate=rate;
		new->fmt.channels=channels;
		new->fmt.speed=1.0;
		new->active=1;
		return 0;
	} else {
		return -1;
	}


}


/*
char *my_basename(char *wholefilename)
{
return strrchr (wholefilename, '/');
}
*/

void empty_playlist(tptr *t_list){
	while(*t_list != NULL)	
		remove_track_data(t_list,*t_list);	
	write_message("Tracklist emptied",0);
}

/* this is of course just a guess based on file extension */
int get_file_type(char *trackname){
	char *extn,*lcext;
	int i,r_type=MISC_AUDIO;
	
	extn=strrchr(trackname,'.');
	lcext=malloc(strlen(extn)+2);
	i=0;
	while(extn[i]!=0){
		lcext[i]=tolower(extn[i]);
		i++;
	}
	lcext[i]=0;
	if(!strcmp(lcext,".mp3")){
		r_type=MPEG;
	} else if(!strcmp(lcext,".mp2")){
		r_type=MPEG;
	} else if(!strcmp(lcext,".mpg")){
		r_type=MPEG;
	} else if(!strcmp(lcext,".mpv")){
		r_type=MPEG;
	} else if(!strcmp(lcext,".mpg")){
		r_type=MPEG;
	} else  if(!strcmp(lcext,".mpeg")){
		r_type=MPEG;
	} else if(!strcmp(lcext,".wav")){
		r_type=WAV_AUDIO;
	} else if(!strcmp(lcext,".au")){
		r_type=MISC_AUDIO;
	} else if(!strcmp(lcext,".raw")){
		r_type=RAW_AUDIO;
	} else if(!strcmp(lcext,".voc")){
		r_type=MISC_AUDIO;
	} else if(!strcmp(lcext,".sf")){
		r_type=MISC_AUDIO;
	} else if(!strcmp(lcext,".pipe")){
		r_type=RAW_AUDIO;
	} else if(!strcmp(lcext,".aiff")){
		r_type=MISC_AUDIO;
	} else if(!strcmp(lcext,".cdr")){
		r_type=MISC_AUDIO;
	} 
	free(lcext);
	return r_type;
}

int load_playlist(tptr *t_list,char *filename){
	FILE *in;
	char trackname[4096];
	int i=0,type;
	char *ptr;
	if((in=fopen(g_conf.playlist,"r"))==NULL){
		fatal("opening playlist file");
	}
	while(!feof(in)){
		fscanf(in,"%[^\n]c",trackname);
		fgetc(in);
		/* new stuff - take the line and do the url decode crap */
		ptr=trackname;
		while((*ptr!='?')&&(*ptr!=0)){
		  ptr++;
		}
		if(*ptr=='?'){
		  *ptr=0;
		  ptr++;
		} 
		plustospace(trackname);
		unescape_url(trackname);

		type=get_file_type(trackname);
		if(type==MPEG) 
			add_mp3_track(t_list,trackname,ptr);
		else if(type==RAW_AUDIO)
			add_raw_track(t_list,trackname,ptr,g_conf.sample_rate,g_conf.stereo+1);
		else if(type==WAV_AUDIO)
			add_sox_track(t_list,trackname,ptr);
		else
			add_sox_track(t_list,trackname,ptr);
		
		fprintf(stderr,"adding %s\n",trackname);
		i++;
	}
	fclose(in);
	write_message(trackname,0);
	return i;
}



int reread_playlist(tptr *t_list){
	int num;

        empty_playlist(t_list);	
	write_message("Re-Reading Tracklist",0);
	num=load_playlist(t_list,g_conf.playlist);
	return num;
}


/* get a track structure relative to a named track */
tptr get_relative_track(tptr curnt,int inc){
	int change=0; 
	tptr track;
	track=curnt;
	while(change!=inc){
		if(inc>0){
			track=track->next;
			change++;
		} else if(inc<0) {
			track=track->prev;
			change--;
		}
	}
	return track;
}


int count_tracks(tptr t_list){
	int i;
	tptr curnt;
	curnt=t_list->next;
	i=1;
	while(curnt!=t_list){
		curnt = curnt->next;
		i++;
	}
	return i++;
}

int reset_tracklist(tptr t_list){
	int i;
	tptr curnt;
	curnt=t_list;
	i=0;
	while(!(curnt->active)) {
		curnt->active=1;
		curnt=curnt->next;
		i++;
	}
	return i;
}

tptr shuffle_play(tptr *t_list,int number){
	long change;
	tptr stt,track;
	change=random_number(&(g_conf.random_seed))*number;
	stt=track=get_relative_track(*t_list,change);
	if(!(track->active))
		track=get_relative_track(track,1);
	while(!(track->active)){
		track=get_relative_track(track,1);
		if(track==stt){
			reset_tracklist(track);
		}
	}
	track->active=0;
	return track;
}




