/*  timedlg
 *  Copyright (C) 2000 FURUKAWA Yo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/* $Id: timedlg.c,v 1.1.1.1 2000/05/07 06:46:46 furukawa Exp $ */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <time.h>

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "gtktrain.h"
#include "libtrain.h"

/* -- callbacks */

void
TimeDialog_Prepare(GtkWidget *TimeDialog)
{
    GtkWidget *dept_hour_spin = get_widget(TimeDialog, "SpinDeptHour");
    GtkWidget *dept_min_spin = get_widget(TimeDialog, "SpinDeptMin");
    GtkWidget *arriv_hour_spin = get_widget(TimeDialog, "SpinArrivHour");
    GtkWidget *arriv_min_spin = get_widget(TimeDialog, "SpinArrivMin");
    
    int dept_time, arriv_time;
    
    dept_time = Train_GetDepartureTime();
    arriv_time = dept_time + Train_GetTotalTime();
    arriv_time = arriv_time % (24 * 60);

    gtk_spin_button_set_value(GTK_SPIN_BUTTON(dept_hour_spin), dept_time/60);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(dept_min_spin), dept_time%60);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(arriv_hour_spin), arriv_time/60);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(arriv_min_spin), arriv_time%60);
}

void
on_Time_ButtonOK_clicked(GtkButton *button, gpointer user_data)
{
    GtkWidget *TimeDialog = gtk_widget_get_toplevel(GTK_WIDGET(button));
    GtkWidget *dept_hour_spin = get_widget(TimeDialog, "SpinDeptHour");
    GtkWidget *dept_min_spin = get_widget(TimeDialog, "SpinDeptMin");

    int dept_time;

    dept_time = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dept_hour_spin)) * 60;
    dept_time += gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dept_min_spin));
    Train_SetDepartureTime(dept_time);

    gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(button)));
}

void
on_Time_ButtonCancel_clicked(GtkButton *button, gpointer user_data)
{
    gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(button)));
}

void
on_Time_ButtonCurrent_clicked(GtkButton *button, gpointer user_data)
{
    GtkWidget *TimeDialog = gtk_widget_get_toplevel(GTK_WIDGET(button));
    GtkWidget *dept_hour_spin = get_widget(TimeDialog, "SpinDeptHour");
    GtkWidget *dept_min_spin = get_widget(TimeDialog, "SpinDeptMin");
    GtkWidget *arriv_hour_spin = get_widget(TimeDialog, "SpinArrivHour");
    GtkWidget *arriv_min_spin = get_widget(TimeDialog, "SpinArrivMin");
    
    int dept_time, arriv_time;
    time_t t;
    struct tm *cur;

    t = time(NULL);
    cur = localtime(&t);

    dept_time = cur->tm_hour * 60 + cur->tm_min;
    arriv_time = dept_time + Train_GetTotalTime();
    arriv_time = arriv_time % (24 * 60);

    gtk_spin_button_set_value(GTK_SPIN_BUTTON(dept_hour_spin), dept_time/60);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(dept_min_spin), dept_time%60);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(arriv_hour_spin), arriv_time/60);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(arriv_min_spin), arriv_time%60);
}

void
on_Time_SpinDeptHour_changed(GtkEditable *editable, gpointer user_data)
{
    GtkWidget *TimeDialog = gtk_widget_get_toplevel(GTK_WIDGET(editable));
    GtkWidget *dept_hour_spin = get_widget(TimeDialog, "SpinDeptHour");
    GtkWidget *dept_min_spin = get_widget(TimeDialog, "SpinDeptMin");
    GtkWidget *arriv_hour_spin = get_widget(TimeDialog, "SpinArrivHour");
    GtkWidget *arriv_min_spin = get_widget(TimeDialog, "SpinArrivMin");
    
    int dept_time, arriv_time;

    dept_time = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dept_hour_spin)) * 60;
    dept_time += gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dept_min_spin));
    arriv_time = dept_time + Train_GetTotalTime();
    arriv_time = arriv_time % (24 * 60);

    gtk_spin_button_set_value(GTK_SPIN_BUTTON(arriv_hour_spin), arriv_time/60);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(arriv_min_spin), arriv_time%60);
}

void
on_Time_SpinDeptMin_changed(GtkEditable *editable, gpointer user_data)
{
    GtkWidget *TimeDialog = gtk_widget_get_toplevel(GTK_WIDGET(editable));
    GtkWidget *dept_hour_spin = get_widget(TimeDialog, "SpinDeptHour");
    GtkWidget *dept_min_spin = get_widget(TimeDialog, "SpinDeptMin");
    GtkWidget *arriv_hour_spin = get_widget(TimeDialog, "SpinArrivHour");
    GtkWidget *arriv_min_spin = get_widget(TimeDialog, "SpinArrivMin");
    
    int dept_time, arriv_time;

    dept_time = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dept_hour_spin)) * 60;
    dept_time += gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dept_min_spin));
    arriv_time = dept_time + Train_GetTotalTime();
    arriv_time = arriv_time % (24 * 60);

    gtk_spin_button_set_value(GTK_SPIN_BUTTON(arriv_hour_spin), arriv_time/60);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(arriv_min_spin), arriv_time%60);
}

void
on_Time_SpinArrivHour_changed(GtkEditable *editable, gpointer user_data)
{
    GtkWidget *TimeDialog = gtk_widget_get_toplevel(GTK_WIDGET(editable));
    GtkWidget *dept_hour_spin = get_widget(TimeDialog, "SpinDeptHour");
    GtkWidget *dept_min_spin = get_widget(TimeDialog, "SpinDeptMin");
    GtkWidget *arriv_hour_spin = get_widget(TimeDialog, "SpinArrivHour");
    GtkWidget *arriv_min_spin = get_widget(TimeDialog, "SpinArrivMin");
    
    int dept_time, arriv_time;

    arriv_time = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(arriv_hour_spin)) * 60;
    arriv_time += gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(arriv_min_spin));
    dept_time = arriv_time - Train_GetTotalTime();
    if (dept_time < 0){
	dept_time += (24 * 60);
    }

    gtk_spin_button_set_value(GTK_SPIN_BUTTON(dept_hour_spin), dept_time/60);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(dept_min_spin), dept_time%60);
}

void
on_Time_SpinArrivMin_changed(GtkEditable *editable, gpointer user_data)
{
    GtkWidget *TimeDialog = gtk_widget_get_toplevel(GTK_WIDGET(editable));
    GtkWidget *dept_hour_spin = get_widget(TimeDialog, "SpinDeptHour");
    GtkWidget *dept_min_spin = get_widget(TimeDialog, "SpinDeptMin");
    GtkWidget *arriv_hour_spin = get_widget(TimeDialog, "SpinArrivHour");
    GtkWidget *arriv_min_spin = get_widget(TimeDialog, "SpinArrivMin");
    
    int dept_time, arriv_time;

    arriv_time = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(arriv_hour_spin)) * 60;
    arriv_time += gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(arriv_min_spin));
    dept_time = arriv_time - Train_GetTotalTime();
    if (dept_time < 0){
	dept_time += (24 * 60);
    }

    gtk_spin_button_set_value(GTK_SPIN_BUTTON(dept_hour_spin), dept_time/60);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(dept_min_spin), dept_time%60);
}

