# -*- encoding: utf-8 -*-
##############################################################################
#
# Copyright (c) 2004-2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: account.py 1005 2005-07-25 08:41:42Z nicoe $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

from osv import fields, osv
import ir

class followup(osv.osv):
	_name = 'account_followup.followup'
	_description = 'Follow-Ups'
	_columns = {
		'name': fields.char('Name', size=64, required=True),
		'description': fields.text('Description'),
		'followup_line': fields.one2many('account_followup.followup.line', 'followup_id', 'Follow-Up'),
		'company_id': fields.many2one('res.company', 'Company'),
	}
followup()

class followup_line(osv.osv):
	_name = 'account_followup.followup.line'
	_description = 'Follow-Ups Criteria'
	_columns = {
		'name': fields.char('Name', size=64, required=True),
		'sequence': fields.integer('Sequence'),
		'delay': fields.integer('Days of delay'),
		'start': fields.selection([('days','Net Days'),('end_of_month','End of Month')], 'Type of Term', size=64),
		'followup_id': fields.many2one('account_followup.followup', 'Follow Ups', required=True, ondelete="cascade"),
		'description': fields.text('Description'),
		#'prints': fields.one2many('account_followup.followup.print', 'line_id'),
	}
followup_line()

class account_move_line(osv.osv):
	_name = 'account.move.line'
	_inherit = 'account.move.line'
	_columns = {
		'followup_line_id': fields.many2one('account_followup.followup.line', 'Latest follow-up done'),
		'followup_date': fields.date('Latest follow-up date'),
	}
account_move_line()

